/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.IntelliJPluginExtension;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.jbr.Jbr;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadata;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadataVersioning;
import org.jetbrains.intellij.model.XmlExtractor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Incubating
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 U2\u00020\u0001:\u0002UVB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u0019H\u0002J\u000e\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00190GH\u0002J\u0010\u0010H\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u0019H\u0002J\u0006\u0010I\u001a\u00020JJ\u0010\u0010K\u001a\u00020\u00192\u0006\u0010L\u001a\u00020\u0019H\u0002J \u0010M\u001a\u00020\u00192\u0006\u0010C\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00192\u0006\u0010E\u001a\u00020\u0019H\u0002J\b\u0010N\u001a\u00020\u0019H\u0002J\b\u0010O\u001a\u00020\u0019H\u0002J\b\u0010P\u001a\u00020\u0019H\u0002J\b\u0010Q\u001a\u00020RH\u0007J\b\u0010S\u001a\u00020JH\u0002J\u0010\u0010T\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \r*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\u00020&8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010!R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001bR\u0016\u0010/\u001a\u0002008\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\n \r*\u0004\u0018\u00010404X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u001bR\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u001bR\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020,0\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u001bR\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u001bR\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u001bR\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u001b\u00a8\u0006W"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "execOperations", "Lorg/gradle/process/ExecOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ArchiveOperations;Lorg/gradle/process/ExecOperations;Lorg/gradle/api/file/FileSystemOperations;)V", "configurationContainer", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "kotlin.jvm.PlatformType", "context", "getContext$annotations", "()V", "dependencyHandler", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "distributionFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDistributionFile", "()Lorg/gradle/api/file/RegularFileProperty;", "downloadDir", "Lorg/gradle/api/provider/Property;", "", "getDownloadDir", "()Lorg/gradle/api/provider/Property;", "extension", "Lorg/jetbrains/intellij/IntelliJPluginExtension;", "externalPrefixes", "Lorg/gradle/api/provider/ListProperty;", "getExternalPrefixes", "()Lorg/gradle/api/provider/ListProperty;", "failureLevel", "Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "getFailureLevel", "ideDir", "Lorg/gradle/api/file/DirectoryProperty;", "getIdeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "ideVersions", "getIdeVersions", "isOffline", "", "jbrVersion", "getJbrVersion", "localPaths", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLocalPaths", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "repositoryHandler", "Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "runtimeDir", "getRuntimeDir", "subsystemsToCheck", "getSubsystemsToCheck", "teamCityOutputFormat", "getTeamCityOutputFormat", "verificationReportsDir", "getVerificationReportsDir", "verifierPath", "getVerifierPath", "verifierVersion", "getVerifierVersion", "downloadIde", "Ljava/io/File;", "type", "version", "buildType", "getOptions", "", "getPluginVerifierRepository", "ideDownloadDir", "Ljava/nio/file/Path;", "resolveIdePath", "ideVersion", "resolveIdeUrl", "resolveRuntimeDir", "resolveVerifierPath", "resolveVerifierVersion", "runPluginVerifier", "", "verifierHomeDir", "versionParameterName", "Companion", "FailureLevel", "gradle-intellij-plugin"})
public class RunPluginVerifierTask
extends ConventionTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ArchiveOperations archiveOperations;
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final FileSystemOperations fileSystemOperations;
    @Input
    @NotNull
    private final ListProperty<FailureLevel> failureLevel;
    @Input
    @NotNull
    private final ListProperty<String> ideVersions;
    @InputFiles
    @NotNull
    private final ConfigurableFileCollection localPaths;
    @Input
    @Optional
    @NotNull
    private final Property<String> verifierVersion;
    @Input
    @Optional
    @NotNull
    private final Property<String> verifierPath;
    @InputFile
    @SkipWhenEmpty
    @NotNull
    private final RegularFileProperty distributionFile;
    @OutputDirectory
    @Optional
    @NotNull
    private final Property<String> verificationReportsDir;
    @Input
    @Optional
    @NotNull
    private final Property<String> downloadDir;
    @Input
    @Optional
    @NotNull
    private final Property<String> jbrVersion;
    @Input
    @Optional
    @NotNull
    private final Property<String> runtimeDir;
    @Input
    @Optional
    @NotNull
    private final ListProperty<String> externalPrefixes;
    @Input
    @Optional
    @NotNull
    private final Property<Boolean> teamCityOutputFormat;
    @Input
    @Optional
    @NotNull
    private final Property<String> subsystemsToCheck;
    @Internal
    @NotNull
    private final DirectoryProperty ideDir;
    private final boolean isOffline;
    @NotNull
    private final IntelliJPluginExtension extension;
    private final transient DependencyHandler dependencyHandler;
    private final transient RepositoryHandler repositoryHandler;
    private final transient ConfigurationContainer configurationContainer;
    @NotNull
    private final transient RunPluginVerifierTask context;
    @NotNull
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/packages.jetbrains.team/maven/p/intellij-plugin-verifier/intellij-plugin-verifier/org/jetbrains/intellij/plugins/verifier-cli/maven-metadata.xml";
    @NotNull
    private static final String IDE_DOWNLOAD_URL = "https://data.services.jetbrains.com/products/download";

    @Inject
    public RunPluginVerifierTask(@NotNull ObjectFactory objectFactory, @NotNull ArchiveOperations archiveOperations, @NotNull ExecOperations execOperations, @NotNull FileSystemOperations fileSystemOperations) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)archiveOperations, (String)"archiveOperations");
        Intrinsics.checkParameterIsNotNull((Object)execOperations, (String)"execOperations");
        Intrinsics.checkParameterIsNotNull((Object)fileSystemOperations, (String)"fileSystemOperations");
        this.objectFactory = objectFactory;
        this.archiveOperations = archiveOperations;
        this.execOperations = execOperations;
        this.fileSystemOperations = fileSystemOperations;
        Object object = this.objectFactory.listProperty(FailureLevel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.listProperty(FailureLevel::class.java)");
        this.failureLevel = object;
        object = this.objectFactory.listProperty(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.listProperty(String::class.java)");
        this.ideVersions = object;
        object = this.objectFactory.fileCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.fileCollection()");
        this.localPaths = object;
        object = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.property(String::class.java)");
        this.verifierVersion = object;
        object = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.property(String::class.java)");
        this.verifierPath = object;
        object = this.objectFactory.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.fileProperty()");
        this.distributionFile = object;
        object = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.property(String::class.java)");
        this.verificationReportsDir = object;
        object = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.property(String::class.java)");
        this.downloadDir = object;
        object = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.property(String::class.java)");
        this.jbrVersion = object;
        object = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.property(String::class.java)");
        this.runtimeDir = object;
        object = this.objectFactory.listProperty(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.listProperty(String::class.java)");
        this.externalPrefixes = object;
        object = this.objectFactory.property(Boolean.TYPE);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.property(Boolean::class.java)");
        this.teamCityOutputFormat = object;
        object = this.objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.property(String::class.java)");
        this.subsystemsToCheck = object;
        object = this.objectFactory.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"objectFactory.directoryProperty()");
        this.ideDir = object;
        this.isOffline = this.getProject().getGradle().getStartParameter().isOffline();
        IntelliJPluginExtension intelliJPluginExtension = (IntelliJPluginExtension)this.getProject().getExtensions().findByType(IntelliJPluginExtension.class);
        if (intelliJPluginExtension == null) {
            throw new GradleException("Cannot access IntelliJPluginExtension");
        }
        object = intelliJPluginExtension;
        this.extension = object;
        this.dependencyHandler = this.getProject().getDependencies();
        this.repositoryHandler = this.getProject().getRepositories();
        this.configurationContainer = this.getProject().getConfigurations();
        this.context = this;
    }

    @NotNull
    public final ListProperty<FailureLevel> getFailureLevel() {
        return this.failureLevel;
    }

    @NotNull
    public final ListProperty<String> getIdeVersions() {
        return this.ideVersions;
    }

    @NotNull
    public final ConfigurableFileCollection getLocalPaths() {
        return this.localPaths;
    }

    @NotNull
    public final Property<String> getVerifierVersion() {
        return this.verifierVersion;
    }

    @NotNull
    public final Property<String> getVerifierPath() {
        return this.verifierPath;
    }

    @NotNull
    public final RegularFileProperty getDistributionFile() {
        return this.distributionFile;
    }

    @NotNull
    public final Property<String> getVerificationReportsDir() {
        return this.verificationReportsDir;
    }

    @NotNull
    public final Property<String> getDownloadDir() {
        return this.downloadDir;
    }

    @NotNull
    public final Property<String> getJbrVersion() {
        return this.jbrVersion;
    }

    @NotNull
    public final Property<String> getRuntimeDir() {
        return this.runtimeDir;
    }

    @NotNull
    public final ListProperty<String> getExternalPrefixes() {
        return this.externalPrefixes;
    }

    @NotNull
    public final Property<Boolean> getTeamCityOutputFormat() {
        return this.teamCityOutputFormat;
    }

    @NotNull
    public final Property<String> getSubsystemsToCheck() {
        return this.subsystemsToCheck;
    }

    @NotNull
    public final DirectoryProperty getIdeDir() {
        return this.ideDir;
    }

    private static /* synthetic */ void getContext$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void runPluginVerifier() {
        FailureLevel[] failureLevelArray;
        void $this$mapTo$iv$iv;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv2;
        RegularFile file = (RegularFile)this.distributionFile.getOrNull();
        if (file == null || !file.getAsFile().exists()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Plugin file does not exist: ", (Object)file));
        }
        Object object = this.ideVersions.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ideVersions.get()");
        Object[] $this$map$iv = (Object[])CollectionsKt.toSet((Iterable)((Iterable)object));
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Object destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            string = this.resolveIdePath((String)it);
            collection.add(string);
        }
        List ides = (List)destination$iv$iv22;
        if (ides.isEmpty() && this.localPaths.isEmpty()) {
            throw new GradleException("`ideVersions` and `localPaths` properties should not be empty");
        }
        String verifierPath = this.resolveVerifierPath();
        object2 = new String[]{"check-plugin"};
        List verifierArgs = CollectionsKt.mutableListOf((Object[])object2);
        object2 = verifierArgs;
        destination$iv$iv22 = this.getOptions();
        $i$f$mapTo = false;
        CollectionsKt.addAll((Collection)object2, (Iterable)destination$iv$iv22);
        object2 = verifierArgs;
        destination$iv$iv22 = file.getAsFile().getCanonicalPath();
        $i$f$mapTo = false;
        object2.add(destination$iv$iv22);
        object2 = verifierArgs;
        boolean destination$iv$iv22 = false;
        CollectionsKt.addAll((Collection)object2, (Iterable)ides);
        object2 = verifierArgs;
        Iterable $this$map$iv2 = CollectionsKt.toList((Iterable)((Iterable)this.localPaths));
        boolean $i$f$map2 = false;
        Object object3 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo222 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            failureLevelArray = (FailureLevel[])item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = it.getCanonicalPath();
            collection.add(string);
        }
        Iterable iterable = (List)destination$iv$iv;
        boolean bl = false;
        CollectionsKt.addAll((Collection)object2, (Iterable)iterable);
        Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Distribution file: ", (Object)file.getAsFile().getCanonicalPath()), null, 4, null);
        Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Verifier path: ", (Object)verifierPath), null, 4, null);
        object2 = new ByteArrayOutputStream();
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream os = (ByteArrayOutputStream)object2;
            boolean bl3 = false;
            this.execOperations.javaexec(arg_0 -> RunPluginVerifierTask.runPluginVerifier$lambda-4$lambda-2(this, verifierPath, verifierArgs, os, arg_0));
            String $i$f$mapTo222 = os.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)$i$f$mapTo222, (String)"os.toString()");
            String output = $i$f$mapTo222;
            boolean $i$f$mapTo222 = false;
            System.out.println((Object)output);
            Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Current failure levels: ", (Object)ArraysKt.joinToString$default((Object[])FailureLevel.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)), null, 4, null);
            FailureLevel[] $this$forEach$iv = FailureLevel.values();
            boolean $i$f$forEach = false;
            failureLevelArray = $this$forEach$iv;
            int n = failureLevelArray.length;
            for (int i = 0; i < n; ++i) {
                FailureLevel element$iv;
                FailureLevel level = element$iv = failureLevelArray[i];
                boolean bl4 = false;
                if (!((List)this.getFailureLevel().get()).contains((Object)level) || !StringsKt.contains$default((CharSequence)output, (CharSequence)level.getTestValue(), (boolean)false, (int)2, null)) continue;
                Utils.debug$default((Object)this.context, "Failing task on " + this.getFailureLevel() + " failure level", null, 4, null);
                throw new GradleException(level.toString());
            }
            object3 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resolveVerifierPath() {
        String path = (String)this.verifierPath.getOrNull();
        if (path != null) {
            CharSequence charSequence = path;
            boolean bl = false;
            if (charSequence.length() > 0) {
                File verifier = new File(path);
                if (verifier.exists()) {
                    return path;
                }
                Utils.warn$default((Object)this.context, "Provided Plugin Verifier path doesn't exist: '" + path + "'. Downloading Plugin Verifier: " + this.verifierVersion, null, 4, null);
            }
        }
        if (this.isOffline) {
            throw new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot resolve Plugin Verifier in offline mode. Provide pre-downloaded Plugin Verifier jar file with `verifierPath` property. "));
        }
        String resolvedVerifierVersion = this.resolveVerifierVersion();
        MavenArtifactRepository repository = this.repositoryHandler.maven(arg_0 -> RunPluginVerifierTask.resolveVerifierPath$lambda-5(this, resolvedVerifierVersion, arg_0));
        try {
            Utils.debug$default((Object)this.context, "Using Verifier in " + resolvedVerifierVersion + " version", null, 4, null);
            DependencyHandler dependencyHandler = this.dependencyHandler;
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"dependencyHandler");
            Dependency dependency = Utils.create$default(dependencyHandler, "org.jetbrains.intellij.plugins", "verifier-cli", resolvedVerifierVersion, "all", "jar", null, 32, null);
            Object object = new Dependency[]{dependency};
            Configuration configuration = this.configurationContainer.detachedConfiguration(object);
            object = configuration.getSingleFile().getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"configuration.singleFile.absolutePath");
            return object;
        }
        catch (Exception e) {
            Utils.error((Object)this.context, "Error when resolving Plugin Verifier path", e);
            throw e;
        }
        finally {
            this.repositoryHandler.remove((Object)repository);
        }
    }

    private final String resolveIdePath(String ideVersion) {
        Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Resolving IDE path for ", (Object)ideVersion), null, 4, null);
        Object object = ideVersion;
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        object = new char[1];
        object[0] = 45;
        Object[] objectArray = CollectionsKt.plus((Collection)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (char[])object, (boolean)false, (int)2, (int)2, null), null);
        String type = null;
        Object[] objectArray2 = objectArray;
        boolean bl2 = false;
        type = (String)objectArray2.get(0);
        String version = null;
        Object[] objectArray3 = objectArray;
        boolean bl3 = false;
        version = (String)objectArray3.get(1);
        if (version == null) {
            Utils.debug$default((Object)this.context, "IDE type not specified, setting type to IC", null, 4, null);
            version = type;
            type = "IC";
        }
        objectArray3 = new String[]{"release", "rc", "eap", "beta"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray3);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String buildType = (String)element$iv;
            boolean bl4 = false;
            Utils.debug$default((Object)this.context, "Downloading IDE '" + type + '-' + version + "' from " + buildType + " channel to " + this.getDownloadDir().get(), null, 4, null);
            try {
                String string2 = type;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = version;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                File dir = this.downloadIde(string2, string3, buildType);
                Utils.debug$default((Object)this.context, "Resolved IDE '" + type + '-' + version + "' path: " + dir.getAbsolutePath(), null, 4, null);
                String string4 = dir.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"dir.absolutePath");
                return string4;
            }
            catch (IOException e) {
                Utils.debug((Object)this.context, "Cannot download IDE '" + type + '-' + version + "' from " + buildType + " channel. Trying another channel...", e);
            }
        }
        throw new TaskExecutionException((Task)this, (Throwable)new GradleException("IDE '" + ideVersion + "' cannot be downloaded. Please verify the specified IDE version against the products available for testing: https://jb.gg/intellij-platform-builds-list"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final File downloadIde(String type, String version, String buildType) {
        String name = type + '-' + version;
        File ideDir = new File((String)this.downloadDir.get(), name);
        Utils.info$default((Object)this.context, Intrinsics.stringPlus((String)"Downloading IDE: ", (Object)name), null, 4, null);
        if (ideDir.exists()) {
            Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"IDE already available in ", (Object)ideDir), null, 4, null);
        } else {
            if (this.isOffline) {
                throw new TaskExecutionException((Task)this, (Throwable)new GradleException("Cannot download IDE: " + name + ". Gradle runs in offline mode. Provide pre-downloaded IDEs stored in `downloadDir` or use `localPaths` instead."));
            }
            String url = this.resolveIdeUrl(type, version, buildType);
            Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Downloading IDE from ", (Object)url), null, 4, null);
            IvyArtifactRepository repository = this.repositoryHandler.ivy(arg_0 -> RunPluginVerifierTask.downloadIde$lambda-9(url, arg_0));
            DependencyHandler dependencyHandler = this.dependencyHandler;
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"dependencyHandler");
            Dependency dependency = Utils.create$default(dependencyHandler, "com.jetbrains", "ides", type + '-' + version + '-' + buildType, null, "tar.gz", null, 40, null);
            try {
                Object[] objectArray = new Dependency[]{dependency};
                File ideArchive = this.configurationContainer.detachedConfiguration(objectArray).getSingleFile();
                Utils.debug$default((Object)this.context, "IDE downloaded, extracting...", null, 4, null);
                Intrinsics.checkExpressionValueIsNotNull((Object)ideArchive, (String)"ideArchive");
                Utils.extractArchive$default(ideArchive, ideDir, this.archiveOperations, this.execOperations, this.fileSystemOperations, (Object)this.context, null, null, 192, null);
                objectArray = ideDir.listFiles();
                if (objectArray == null) {
                } else {
                    void $this$forEach$iv;
                    void $this$filterTo$iv$iv;
                    Object[] objectArray2 = objectArray;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object[] it = objectArray2;
                    boolean bl3 = false;
                    Object $this$filter$iv = it;
                    boolean $i$f$filter = false;
                    Dependency[] dependencyArray = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    void var21_24 = $this$filterTo$iv$iv;
                    int n = ((void)var21_24).length;
                    for (int i = 0; i < n; ++i) {
                        void element$iv$iv;
                        void p0 = element$iv$iv = var21_24[i];
                        boolean bl4 = false;
                        if (!p0.isDirectory()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        File container = (File)element$iv;
                        boolean bl5 = false;
                        File[] fileArray = container.listFiles();
                        if (fileArray != null) {
                            File[] $this$forEach$iv2 = fileArray;
                            boolean $i$f$forEach2 = false;
                            File[] fileArray2 = $this$forEach$iv2;
                            int n2 = fileArray2.length;
                            for (int i = 0; i < n2; ++i) {
                                File element$iv2;
                                File file = element$iv2 = fileArray2[i];
                                boolean bl6 = false;
                                file.renameTo(new File(ideDir, file.getName()));
                            }
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)container, (String)"container");
                        FilesKt.deleteRecursively((File)container);
                    }
                }
            }
            catch (Exception e) {
                Utils.warn((Object)this.context, "Cannot download " + type + '-' + version + " from " + buildType + " channel: " + url, e);
            }
            finally {
                this.repositoryHandler.remove((Object)repository);
            }
            Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"IDE extracted to ", (Object)ideDir), null, 4, null);
        }
        return ideDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resolveIdeUrl(String type, String version, String buildType) {
        Object redirectUrl;
        HttpURLConnection connection;
        String url;
        block7: {
            url = "https://data.services.jetbrains.com/products/download?code=" + type + "&platform=linux&type=" + buildType + '&' + this.versionParameterName(version) + '=' + version;
            Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Resolving direct IDE download URL for: ", (Object)url), null, 4, null);
            connection = null;
            URLConnection uRLConnection = new URL(url).openConnection();
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            connection = (HttpURLConnection)uRLConnection;
            connection.setInstanceFollowRedirects(false);
            connection.getInputStream();
            if (connection.getResponseCode() != 301 && connection.getResponseCode() != 302) break block7;
            redirectUrl = new URL(connection.getHeaderField("Location"));
            connection.disconnect();
            Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Resolved IDE download URL: ", (Object)url), null, 4, null);
            String string = "https://cache-redirector.jetbrains.com/" + ((URL)redirectUrl).getHost() + ((URL)redirectUrl).getFile();
            HttpURLConnection httpURLConnection = connection;
            httpURLConnection.disconnect();
            return string;
        }
        try {
            Utils.debug$default((Object)this.context, "IDE download URL has no redirection provided. Skipping", null, 4, null);
            redirectUrl = connection;
            ((HttpURLConnection)redirectUrl).disconnect();
        }
        catch (Exception e) {
            try {
                Utils.info$default((Object)this.context, Intrinsics.stringPlus((String)"Cannot resolve direct download URL for: ", (Object)url), null, 4, null);
                Utils.debug((Object)this.context, "Download exception stacktrace:", e);
                throw e;
            }
            catch (Throwable throwable) {
                HttpURLConnection httpURLConnection = connection;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
        return url;
    }

    private final String resolveVerifierVersion() {
        String string;
        String string2 = (String)this.verifierVersion.getOrNull();
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string = !Intrinsics.areEqual((Object)it, (Object)"latest") ? string3 : null;
        }
        String string4 = string;
        String string5 = string4 == null ? Companion.resolveLatestVersion() : string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"verifierVersion.orNull?.takeIf { it != VERSION_LATEST } ?: resolveLatestVersion()");
        return string5;
    }

    private final String resolveRuntimeDir() {
        String string;
        boolean bl;
        String string2 = (String)this.runtimeDir.getOrNull();
        if (string2 != null) {
            String string3 = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string3;
            boolean bl4 = false;
            Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Runtime specified with properties: ", (Object)it), null, 4, null);
            return it;
        }
        Object object = new Object[3];
        Object object2 = this.extension.getJreRepository().getOrNull();
        object[0] = object2 == null ? "" : object2;
        object[1] = this.isOffline;
        object[2] = this;
        JbrResolver jbrResolver = (JbrResolver)this.objectFactory.newInstance(JbrResolver.class, object);
        object = (String)this.jbrVersion.getOrNull();
        if (object != null) {
            object2 = object;
            boolean bl5 = false;
            bl = false;
            Object it = object2;
            boolean bl6 = false;
            Jbr jbr = jbrResolver.resolve((String)this.getJbrVersion().getOrNull());
            if (jbr != null) {
                Jbr jbr2 = jbr;
                boolean bl7 = false;
                boolean bl8 = false;
                Jbr jbr3 = jbr2;
                boolean bl9 = false;
                Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Runtime specified with JBR Version property: ", (Object)it), null, 4, null);
                String string4 = jbr3.getJavaHome().getCanonicalPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"jbr.javaHome.canonicalPath");
                return string4;
            }
            Utils.warn$default((Object)this.context, "Cannot resolve JBR " + (String)it + ". Falling back to built-in JBR.", null, 4, null);
        }
        boolean bl10 = OperatingSystem.current().isMacOsX();
        if (bl10) {
            string = "jbr/Contents/Home";
        } else if (!bl10) {
            string = "jbr";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String jbrPath = string;
        Object object3 = ((Directory)this.ideDir.get()).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"ideDir.get().asFile");
        String string5 = Utils.getBuiltinJbrVersion((File)object3);
        if (string5 != null) {
            object3 = string5;
            bl = false;
            boolean bl11 = false;
            Object builtinJbrVersion = object3;
            boolean bl12 = false;
            Jbr jbr = jbrResolver.resolve((String)builtinJbrVersion);
            if (jbr != null) {
                Jbr jbr4 = jbr;
                boolean bl13 = false;
                boolean bl14 = false;
                Jbr builtinJbr = jbr4;
                boolean bl15 = false;
                File javaHome = new File(builtinJbr.getJavaHome(), jbrPath);
                if (javaHome.exists()) {
                    Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Using built-in JBR: ", (Object)javaHome), null, 4, null);
                    String string6 = javaHome.getCanonicalPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"javaHome.canonicalPath");
                    return string6;
                }
            }
            Utils.warn$default((Object)this.context, "Cannot resolve builtin JBR " + (String)builtinJbrVersion + ". Falling back to local Java.", null, 4, null);
        }
        Utils.debug$default((Object)this.context, Intrinsics.stringPlus((String)"Using current JVM: ", (Object)Jvm.current().getJavaHome()), null, 4, null);
        string5 = Jvm.current().getJavaHome().getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"current().javaHome.canonicalPath");
        return string5;
    }

    private final List<String> getOptions() {
        Object object = new String[]{"-verification-reports-dir", (String)this.verificationReportsDir.get(), "-runtime-dir", this.resolveRuntimeDir()};
        List args = CollectionsKt.mutableListOf((Object[])object);
        Object object2 = this.externalPrefixes.get();
        boolean bl = false;
        boolean bl2 = false;
        Object it = object2;
        boolean bl3 = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
        Collection collection = (Collection)it;
        boolean bl4 = false;
        object = (List)(!collection.isEmpty() ? object2 : null);
        if (object != null) {
            object2 = object;
            bl = false;
            bl2 = false;
            it = object2;
            boolean bl5 = false;
            args.add("-external-prefixes");
            args.add(CollectionsKt.joinToString$default((Iterable)((Iterable)it), (CharSequence)":", null, null, (int)0, null, null, (int)62, null));
        }
        object = this.teamCityOutputFormat.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"teamCityOutputFormat.get()");
        if (((Boolean)object).booleanValue()) {
            args.add("-team-city");
        }
        if (this.subsystemsToCheck.getOrNull() != null) {
            args.add("-subsystems-to-check");
            args.add(this.subsystemsToCheck.get());
        }
        if (this.isOffline) {
            args.add("-offline");
        }
        return args;
    }

    private final Path verifierHomeDir() {
        Object object = System.getProperty("plugin.verifier.home.dir");
        if (object != null) {
            String string = object;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            Path path = Paths.get(it, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"get(it)");
            return path;
        }
        object = System.getProperty("user.home");
        if (object != null) {
            String string = object;
            boolean bl = false;
            boolean bl4 = false;
            String it = string;
            boolean bl5 = false;
            String[] stringArray = new String[]{".pluginVerifier"};
            Path path = Paths.get(it, stringArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"get(it, \".pluginVerifier\")");
            return path;
        }
        object = FileUtils.getTempDirectory().toPath().resolve(".pluginVerifier");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getTempDirectory().toPath().resolve(\".pluginVerifier\")");
        return object;
    }

    @NotNull
    public final Path ideDownloadDir() {
        Path path = this.verifierHomeDir().resolve("ides");
        boolean bl = false;
        boolean bl2 = false;
        Path it = path;
        boolean bl3 = false;
        Files.createDirectories(it, new FileAttribute[0]);
        Path path2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"verifierHomeDir().resolve(\"ides\").also {\n        Files.createDirectories(it)\n    }");
        return path2;
    }

    private final String versionParameterName(String version) {
        CharSequence charSequence = version;
        String string = "\\d{3}(\\.\\d+)+";
        boolean bl = false;
        string = new Regex(string);
        bl = false;
        return string.matches(charSequence) ? "build" : "version";
    }

    private final String getPluginVerifierRepository(String version) {
        return GradleVersion.version((String)version).compareTo(GradleVersion.version((String)"1.255")) >= 0 ? "https://cache-redirector.jetbrains.com/packages.jetbrains.team/maven/p/intellij-plugin-verifier/intellij-plugin-verifier" : "https://cache-redirector.jetbrains.com/jetbrains.bintray.com/intellij-plugin-service";
    }

    private static final void runPluginVerifier$lambda-4$lambda-2(RunPluginVerifierTask this$0, String $verifierPath, List $verifierArgs, ByteArrayOutputStream $os, JavaExecSpec it) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$verifierPath, (String)"$verifierPath");
        Intrinsics.checkParameterIsNotNull((Object)$verifierArgs, (String)"$verifierArgs");
        Intrinsics.checkParameterIsNotNull((Object)$os, (String)"$os");
        Object[] objectArray = new Object[]{$verifierPath};
        it.setClasspath((FileCollection)this$0.objectFactory.fileCollection().from(objectArray));
        it.getMainClass().set((Object)"com.jetbrains.pluginverifier.PluginVerifierMain");
        it.setArgs($verifierArgs);
        it.setStandardOutput((OutputStream)$os);
    }

    private static final void resolveVerifierPath$lambda-5(RunPluginVerifierTask this$0, String $resolvedVerifierVersion, MavenArtifactRepository it) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$resolvedVerifierVersion, (String)"$resolvedVerifierVersion");
        it.setUrl(new URI(this$0.getPluginVerifierRepository($resolvedVerifierVersion)));
    }

    private static final void downloadIde$lambda-9$lambda-7(IvyPatternRepositoryLayout it) {
        it.artifact("");
    }

    private static final void downloadIde$lambda-9$lambda-8(IvyArtifactRepository.MetadataSources it) {
        it.artifact();
    }

    private static final void downloadIde$lambda-9(String $url, IvyArtifactRepository ivy) {
        Intrinsics.checkParameterIsNotNull((Object)$url, (String)"$url");
        ivy.setUrl(new URI($url));
        ivy.patternLayout(RunPluginVerifierTask::downloadIde$lambda-9$lambda-7);
        ivy.metadataSources(RunPluginVerifierTask::downloadIde$lambda-9$lambda-8);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$Companion;", "", "()V", "IDE_DOWNLOAD_URL", "", "METADATA_URL", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String resolveLatestVersion() {
            String string;
            Utils.debug$default(null, "Resolving latest Plugin Verifier version", null, 5, null);
            URL url = new URL(RunPluginVerifierTask.METADATA_URL);
            XmlExtractor xmlExtractor = new XmlExtractor();
            InputStream inputStream = url.openStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"url.openStream()");
            SpacePackagesMavenMetadataVersioning spacePackagesMavenMetadataVersioning = ((SpacePackagesMavenMetadata)xmlExtractor.unmarshal(inputStream)).getVersioning();
            String string2 = string = spacePackagesMavenMetadataVersioning == null ? null : spacePackagesMavenMetadataVersioning.getLatest();
            if (string == null) {
                throw new GradleException("Cannot resolve the latest Plugin Verifier version");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "", "testValue", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getTestValue", "()Ljava/lang/String;", "COMPATIBILITY_WARNINGS", "COMPATIBILITY_PROBLEMS", "DEPRECATED_API_USAGES", "EXPERIMENTAL_API_USAGES", "INTERNAL_API_USAGES", "OVERRIDE_ONLY_API_USAGES", "NON_EXTENDABLE_API_USAGES", "PLUGIN_STRUCTURE_WARNINGS", "MISSING_DEPENDENCIES", "INVALID_PLUGIN", "NOT_DYNAMIC", "Companion", "gradle-intellij-plugin"})
    public static final class FailureLevel
    extends Enum<FailureLevel> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String testValue;
        @NotNull
        private static final EnumSet<FailureLevel> ALL;
        @NotNull
        private static final EnumSet<FailureLevel> NONE;
        public static final /* enum */ FailureLevel COMPATIBILITY_WARNINGS;
        public static final /* enum */ FailureLevel COMPATIBILITY_PROBLEMS;
        public static final /* enum */ FailureLevel DEPRECATED_API_USAGES;
        public static final /* enum */ FailureLevel EXPERIMENTAL_API_USAGES;
        public static final /* enum */ FailureLevel INTERNAL_API_USAGES;
        public static final /* enum */ FailureLevel OVERRIDE_ONLY_API_USAGES;
        public static final /* enum */ FailureLevel NON_EXTENDABLE_API_USAGES;
        public static final /* enum */ FailureLevel PLUGIN_STRUCTURE_WARNINGS;
        public static final /* enum */ FailureLevel MISSING_DEPENDENCIES;
        public static final /* enum */ FailureLevel INVALID_PLUGIN;
        public static final /* enum */ FailureLevel NOT_DYNAMIC;
        private static final /* synthetic */ FailureLevel[] $VALUES;

        private FailureLevel(String testValue) {
            this.testValue = testValue;
        }

        @NotNull
        public final String getTestValue() {
            return this.testValue;
        }

        public static FailureLevel[] values() {
            return (FailureLevel[])$VALUES.clone();
        }

        public static FailureLevel valueOf(String value) {
            return Enum.valueOf(FailureLevel.class, value);
        }

        static {
            COMPATIBILITY_WARNINGS = new FailureLevel("Compatibility warnings");
            COMPATIBILITY_PROBLEMS = new FailureLevel("Compatibility problems");
            DEPRECATED_API_USAGES = new FailureLevel("Deprecated API usages");
            EXPERIMENTAL_API_USAGES = new FailureLevel("Experimental API usages");
            INTERNAL_API_USAGES = new FailureLevel("Internal API usages");
            OVERRIDE_ONLY_API_USAGES = new FailureLevel("Override-only API usages");
            NON_EXTENDABLE_API_USAGES = new FailureLevel("Non-extendable API usages");
            PLUGIN_STRUCTURE_WARNINGS = new FailureLevel("Plugin structure warnings");
            MISSING_DEPENDENCIES = new FailureLevel("Missing dependencies");
            INVALID_PLUGIN = new FailureLevel("The following files specified for the verification are not valid plugins");
            NOT_DYNAMIC = new FailureLevel("Plugin cannot be loaded/unloaded without IDE restart");
            $VALUES = failureLevelArray = new FailureLevel[]{FailureLevel.COMPATIBILITY_WARNINGS, FailureLevel.COMPATIBILITY_PROBLEMS, FailureLevel.DEPRECATED_API_USAGES, FailureLevel.EXPERIMENTAL_API_USAGES, FailureLevel.INTERNAL_API_USAGES, FailureLevel.OVERRIDE_ONLY_API_USAGES, FailureLevel.NON_EXTENDABLE_API_USAGES, FailureLevel.PLUGIN_STRUCTURE_WARNINGS, FailureLevel.MISSING_DEPENDENCIES, FailureLevel.INVALID_PLUGIN, FailureLevel.NOT_DYNAMIC};
            Companion = new Companion(null);
            EnumSet<FailureLevel> enumSet = EnumSet.allOf(FailureLevel.class);
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"allOf(FailureLevel::class.java)");
            ALL = enumSet;
            enumSet = EnumSet.noneOf(FailureLevel.class);
            Intrinsics.checkExpressionValueIsNotNull(enumSet, (String)"noneOf(FailureLevel::class.java)");
            NONE = enumSet;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel$Companion;", "", "()V", "ALL", "Ljava/util/EnumSet;", "Lorg/jetbrains/intellij/tasks/RunPluginVerifierTask$FailureLevel;", "getALL", "()Ljava/util/EnumSet;", "NONE", "getNONE", "gradle-intellij-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final EnumSet<FailureLevel> getALL() {
                return ALL;
            }

            @NotNull
            public final EnumSet<FailureLevel> getNONE() {
                return NONE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

