/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.dependency.CustomPluginsRepository;
import org.jetbrains.intellij.dependency.MavenRepositoryPlugin;
import org.jetbrains.intellij.dependency.MavenRepositoryPluginByAction;
import org.jetbrains.intellij.dependency.PluginsRepository;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bJ\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\r\u001a\u00020\u00072\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/intellij/dependency/PluginsRepositoryConfiguration;", "", "()V", "pluginsRepositories", "", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "custom", "", "url", "", "getRepositories", "", "marketplace", "maven", "action", "Lorg/gradle/api/Action;", "Lorg/gradle/api/artifacts/repositories/MavenArtifactRepository;", "gradle-intellij-plugin"})
public abstract class PluginsRepositoryConfiguration {
    @NotNull
    private final List<PluginsRepository> pluginsRepositories;

    public PluginsRepositoryConfiguration() {
        boolean bl = false;
        this.pluginsRepositories = new ArrayList();
    }

    public final void marketplace() {
        this.pluginsRepositories.add(new MavenRepositoryPlugin("https://cache-redirector.jetbrains.com/plugins.jetbrains.com/maven"));
    }

    public final void maven(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.pluginsRepositories.add(new MavenRepositoryPlugin(url));
    }

    public final void maven(@NotNull Action<? super MavenArtifactRepository> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        this.pluginsRepositories.add(new MavenRepositoryPluginByAction(action));
    }

    public final void custom(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.pluginsRepositories.add(new CustomPluginsRepository(url));
    }

    @NotNull
    public final List<PluginsRepository> getRepositories() {
        return CollectionsKt.toList((Iterable)this.pluginsRepositories);
    }
}

