/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.model.PluginsCache;
import org.jetbrains.intellij.model.PluginsCachePlugin;
import org.jetbrains.intellij.model.XmlExtractor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0003H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0014J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;", "Ljava/io/Serializable;", "pluginsDirectory", "Ljava/io/File;", "context", "", "(Ljava/io/File;Ljava/lang/Object;)V", "directoryNameMapping", "", "", "extractor", "Lorg/jetbrains/intellij/model/XmlExtractor;", "Lorg/jetbrains/intellij/model/PluginsCache;", "plugins", "Lorg/jetbrains/intellij/model/PluginsCachePlugin;", "add", "", "artifact", "cacheFile", "collectBuiltinDependencies", "", "pluginIds", "dumpToCache", "equals", "", "other", "fillFromCache", "fillFromDirectory", "findPlugin", "name", "hashCode", "", "Companion", "gradle-intellij-plugin"})
public final class BuiltinPluginsRegistry
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File pluginsDirectory;
    @NotNull
    private final transient Object context;
    @NotNull
    private final Map<String, PluginsCachePlugin> plugins;
    @NotNull
    private final Map<String, String> directoryNameMapping;
    @NotNull
    private final transient XmlExtractor<PluginsCache> extractor;

    public BuiltinPluginsRegistry(@NotNull File pluginsDirectory, @NotNull Object context) {
        Intrinsics.checkParameterIsNotNull((Object)pluginsDirectory, (String)"pluginsDirectory");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.pluginsDirectory = pluginsDirectory;
        this.context = context;
        boolean bl = false;
        this.plugins = new LinkedHashMap();
        bl = false;
        this.directoryNameMapping = new LinkedHashMap();
        this.extractor = new XmlExtractor();
    }

    private final boolean fillFromCache() {
        boolean bl;
        File file;
        File file2 = this.cacheFile();
        boolean bl2 = false;
        boolean bl3 = false;
        Serializable it = file2;
        boolean bl4 = false;
        File file3 = file = ((File)it).exists() ? file2 : null;
        if (file == null) {
            return false;
        }
        File cache = file;
        Utils.debug$default(this.context, Intrinsics.stringPlus((String)"Builtin registry cache is found. Loading from ", (Object)cache), null, 4, null);
        try {
            Iterable $this$forEach$iv = this.extractor.unmarshal(cache).getPlugins();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PluginsCachePlugin)element$iv;
                boolean bl5 = false;
                Map<String, Object> map = this.plugins;
                String string = ((PluginsCachePlugin)it).getId();
                boolean bl6 = false;
                map.put(string, (PluginsCachePlugin)it);
                map = this.directoryNameMapping;
                string = ((PluginsCachePlugin)it).getDirectoryName();
                String string2 = ((PluginsCachePlugin)it).getId();
                boolean bl7 = false;
                map.put(string, (PluginsCachePlugin)((Object)string2));
            }
            bl = true;
        }
        catch (Throwable t) {
            Utils.warn(this.context, "Cannot read builtin registry cache", t);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillFromDirectory() {
        Object[] objectArray = this.pluginsDirectory.listFiles();
        if (objectArray != null) {
            void $this$forEach$iv;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            boolean bl2 = false;
            Object[] $this$fillFromDirectory_u24lambda_u2d3 = objectArray2;
            boolean bl3 = false;
            Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])$this$fillFromDirectory_u24lambda_u2d3), (Function1)fillFromDirectory.1.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl4 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                this.add(it);
            }
        }
        Utils.debug$default(this.context, "Builtin registry populated with " + this.plugins.size() + " plugins", null, 4, null);
    }

    private final void dumpToCache() {
        Utils.debug$default(this.context, "Dumping cache for builtin plugin", null, 4, null);
        try {
            this.extractor.marshal(new PluginsCache(CollectionsKt.toList((Iterable)this.plugins.values())), this.cacheFile());
        }
        catch (Throwable t) {
            Utils.warn(this.context, "Failed to dump cache for builtin plugin", t);
        }
    }

    private final File cacheFile() {
        return new File(this.pluginsDirectory, "builtinRegistry.xml");
    }

    @Nullable
    public final File findPlugin(@NotNull String name) {
        PluginsCachePlugin pluginsCachePlugin;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        PluginsCachePlugin pluginsCachePlugin2 = this.plugins.get(name);
        if (pluginsCachePlugin2 == null) {
            Map<String, PluginsCachePlugin> map = this.plugins;
            String string = this.directoryNameMapping.get(name);
            boolean bl = false;
            PluginsCachePlugin pluginsCachePlugin3 = map.get(string);
            if (pluginsCachePlugin3 == null) {
                return null;
            }
            pluginsCachePlugin = pluginsCachePlugin3;
        } else {
            pluginsCachePlugin = pluginsCachePlugin2;
        }
        PluginsCachePlugin plugin = pluginsCachePlugin;
        File result = new File(this.pluginsDirectory, plugin.getDirectoryName());
        return result.exists() && result.isDirectory() ? result : null;
    }

    @NotNull
    public final Collection<String> collectBuiltinDependencies(@NotNull Collection<String> pluginIds) {
        Intrinsics.checkParameterIsNotNull(pluginIds, (String)"pluginIds");
        List idsToProcess = CollectionsKt.toMutableList(pluginIds);
        boolean bl = false;
        Set result = new LinkedHashSet();
        while (true) {
            PluginsCachePlugin plugin;
            PluginsCachePlugin pluginsCachePlugin;
            Collection collection = idsToProcess;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) break;
            String id = (String)idsToProcess.remove(0);
            PluginsCachePlugin pluginsCachePlugin2 = this.plugins.get(id);
            if (pluginsCachePlugin2 == null) {
                Map<String, PluginsCachePlugin> map = this.plugins;
                String string = this.directoryNameMapping.get(id);
                boolean bl3 = false;
                PluginsCachePlugin pluginsCachePlugin3 = map.get(string);
                if (pluginsCachePlugin3 == null) continue;
                pluginsCachePlugin = pluginsCachePlugin3;
            } else {
                pluginsCachePlugin = plugin = pluginsCachePlugin2;
            }
            if (!result.add(id)) continue;
            idsToProcess.addAll(CollectionsKt.minus((Iterable)plugin.getDependencies(), (Iterable)result));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull File artifact) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PluginDependency it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        Utils.debug$default(this.context, "Adding directory to plugins index: " + artifact + ')', null, 4, null);
        IdePlugin idePlugin = Utils.createPlugin(artifact, false, this.context);
        if (idePlugin == null) {
            return;
        }
        IdePlugin intellijPlugin = idePlugin;
        String string = intellijPlugin.getPluginId();
        if (string == null) {
            return;
        }
        String id = string;
        Iterable $this$filter$iv = intellijPlugin.getDependencies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PluginDependency)element$iv$iv;
            boolean bl = false;
            if (!(!it.isOptional())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (PluginDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getId();
            collection.add(string2);
        }
        List dependencies = (List)destination$iv$iv;
        Map<String, String> map = artifact.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"artifact.name");
        PluginsCachePlugin plugin = new PluginsCachePlugin(id, (String)((Object)map), dependencies);
        map = this.plugins;
        boolean bl = false;
        map.put(id, (String)((Object)plugin));
        if (!Intrinsics.areEqual((Object)plugin.getDirectoryName(), (Object)id)) {
            map = this.directoryNameMapping;
            String string3 = plugin.getDirectoryName();
            boolean bl2 = false;
            map.put(string3, id);
        }
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.dependency.BuiltinPluginsRegistry");
        }
        BuiltinPluginsRegistry cfr_ignored_0 = (BuiltinPluginsRegistry)other;
        if (!Intrinsics.areEqual((Object)this.pluginsDirectory, (Object)((BuiltinPluginsRegistry)other).pluginsDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.plugins, ((BuiltinPluginsRegistry)other).plugins)) {
            return false;
        }
        return Intrinsics.areEqual(this.directoryNameMapping, ((BuiltinPluginsRegistry)other).directoryNameMapping);
    }

    public int hashCode() {
        int result = this.pluginsDirectory.hashCode();
        result = 31 * result + ((Object)this.plugins).hashCode();
        result = 31 * result + ((Object)this.directoryNameMapping).hashCode();
        return result;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\b"}, d2={"Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry$Companion;", "", "()V", "fromDirectory", "Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;", "pluginsDirectory", "Ljava/io/File;", "context", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BuiltinPluginsRegistry fromDirectory(@NotNull File pluginsDirectory, @NotNull Object context) {
            Intrinsics.checkParameterIsNotNull((Object)pluginsDirectory, (String)"pluginsDirectory");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            BuiltinPluginsRegistry builtinPluginsRegistry = new BuiltinPluginsRegistry(pluginsDirectory, context);
            boolean bl = false;
            boolean bl2 = false;
            BuiltinPluginsRegistry $this$fromDirectory_u24lambda_u2d0 = builtinPluginsRegistry;
            boolean bl3 = false;
            if (!$this$fromDirectory_u24lambda_u2d0.fillFromCache()) {
                Utils.debug$default(context, "Builtin registry cache is missing", null, 4, null);
                $this$fromDirectory_u24lambda_u2d0.fillFromDirectory();
                $this$fromDirectory_u24lambda_u2d0.dumpToCache();
            }
            return builtinPluginsRegistry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

