/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.inject.Inject;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.signer.CertificateUtils;
import org.jetbrains.zip.signer.signer.PrivateKeyUtils;
import org.jetbrains.zip.signer.signer.PublicKeyUtils;
import org.jetbrains.zip.signer.signing.DefaultSignatureProvider;
import org.jetbrains.zip.signer.signing.SignatureProvider;
import org.jetbrains.zip.signer.signing.ZipSigner;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0007R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/intellij/tasks/SignPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "certificateChain", "Lorg/gradle/api/provider/Property;", "", "getCertificateChain", "()Lorg/gradle/api/provider/Property;", "inputArchiveFile", "Lorg/gradle/api/file/RegularFileProperty;", "getInputArchiveFile", "()Lorg/gradle/api/file/RegularFileProperty;", "outputArchiveFile", "getOutputArchiveFile", "password", "getPassword", "privateKey", "getPrivateKey", "signPlugin", "", "gradle-intellij-plugin"})
public class SignPluginTask
extends ConventionTask {
    @InputFile
    @NotNull
    private final RegularFileProperty inputArchiveFile;
    @OutputFile
    @NotNull
    private final RegularFileProperty outputArchiveFile;
    @Input
    @NotNull
    private final Property<String> privateKey;
    @Input
    @NotNull
    private final Property<String> certificateChain;
    @Input
    @Optional
    @NotNull
    private final Property<String> password;

    @Inject
    public SignPluginTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        RegularFileProperty regularFileProperty = objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.inputArchiveFile = regularFileProperty;
        regularFileProperty = objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.outputArchiveFile = regularFileProperty;
        regularFileProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.property(String::class.java)");
        this.privateKey = regularFileProperty;
        regularFileProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.property(String::class.java)");
        this.certificateChain = regularFileProperty;
        regularFileProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.property(String::class.java)");
        this.password = regularFileProperty;
    }

    @NotNull
    public final RegularFileProperty getInputArchiveFile() {
        return this.inputArchiveFile;
    }

    @NotNull
    public final RegularFileProperty getOutputArchiveFile() {
        return this.outputArchiveFile;
    }

    @NotNull
    public final Property<String> getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final Property<String> getCertificateChain() {
        return this.certificateChain;
    }

    @NotNull
    public final Property<String> getPassword() {
        return this.password;
    }

    @TaskAction
    @ExperimentalUnsignedTypes
    public final void signPlugin() {
        char[] cArray;
        Security.addProvider((Provider)new BouncyCastleProvider());
        Object object = this.certificateChain.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.certificateChain.get()");
        List certificateChain = CertificateUtils.loadCertificates((String)((String)object));
        Object object2 = this.privateKey.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.privateKey.get()");
        String string = (String)object2;
        object2 = (String)this.password.getOrNull();
        if (object2 == null) {
            cArray = null;
        } else {
            Object object3 = object2;
            boolean bl = false;
            char[] cArray2 = ((String)object3).toCharArray();
            cArray = cArray2;
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
        }
        PrivateKey privateKey = PrivateKeyUtils.loadPrivateKey((String)string, cArray);
        object2 = ((RegularFile)this.inputArchiveFile.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inputArchiveFile.get().asFile");
        Object object4 = object2;
        object2 = ((RegularFile)this.outputArchiveFile.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outputArchiveFile.get().asFile");
        Object object5 = object2;
        object2 = ((X509Certificate)certificateChain.get(0)).getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"certificateChain[0].publicKey");
        ZipSigner.sign((File)object4, (File)object5, (List)certificateChain, (SignatureProvider)((SignatureProvider)new DefaultSignatureProvider(PublicKeyUtils.INSTANCE.getSuggestedSignatureAlgorithm((PublicKey)object2), privateKey)));
    }
}

