/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\b\u0010%\u001a\u00020\u001fH\u0007J \u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\tR\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\tR\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\t\u00a8\u0006)"}, d2={"Lorg/jetbrains/intellij/tasks/PatchPluginXmlTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "changeNotes", "Lorg/gradle/api/provider/Property;", "", "getChangeNotes", "()Lorg/gradle/api/provider/Property;", "context", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "pluginDescription", "getPluginDescription", "pluginId", "getPluginId", "pluginXmlFiles", "Lorg/gradle/api/provider/ListProperty;", "Ljava/io/File;", "getPluginXmlFiles", "()Lorg/gradle/api/provider/ListProperty;", "sinceBuild", "getSinceBuild", "untilBuild", "getUntilBuild", "version", "getVersion", "patchAttribute", "", "document", "Lorg/jdom2/Document;", "tagName", "attributeName", "attributeValue", "patchPluginXmlFiles", "patchTag", "name", "content", "gradle-intellij-plugin"})
public class PatchPluginXmlTask
extends ConventionTask {
    @OutputDirectory
    @NotNull
    private final DirectoryProperty destinationDir;
    @SkipWhenEmpty
    @InputFiles
    @NotNull
    private final ListProperty<File> pluginXmlFiles;
    @Input
    @Optional
    @NotNull
    private final Property<String> pluginDescription;
    @Input
    @Optional
    @NotNull
    private final Property<String> sinceBuild;
    @Input
    @Optional
    @NotNull
    private final Property<String> untilBuild;
    @Input
    @Optional
    @NotNull
    private final Property<String> version;
    @Input
    @Optional
    @NotNull
    private final Property<String> changeNotes;
    @Input
    @Optional
    @NotNull
    private final Property<String> pluginId;
    @NotNull
    private final String context;

    @Inject
    public PatchPluginXmlTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.destinationDir = directoryProperty;
        directoryProperty = objectFactory.listProperty(File.class);
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.listProperty(File::class.java)");
        this.pluginXmlFiles = directoryProperty;
        directoryProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.property(String::class.java)");
        this.pluginDescription = directoryProperty;
        directoryProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.property(String::class.java)");
        this.sinceBuild = directoryProperty;
        directoryProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.property(String::class.java)");
        this.untilBuild = directoryProperty;
        directoryProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.property(String::class.java)");
        this.version = directoryProperty;
        directoryProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.property(String::class.java)");
        this.changeNotes = directoryProperty;
        directoryProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.property(String::class.java)");
        this.pluginId = directoryProperty;
        this.context = Utils.logCategory((Task)this);
    }

    @NotNull
    public final DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @NotNull
    public final ListProperty<File> getPluginXmlFiles() {
        return this.pluginXmlFiles;
    }

    @NotNull
    public final Property<String> getPluginDescription() {
        return this.pluginDescription;
    }

    @NotNull
    public final Property<String> getSinceBuild() {
        return this.sinceBuild;
    }

    @NotNull
    public final Property<String> getUntilBuild() {
        return this.untilBuild;
    }

    @NotNull
    public final Property<String> getVersion() {
        return this.version;
    }

    @NotNull
    public final Property<String> getChangeNotes() {
        return this.changeNotes;
    }

    @NotNull
    public final Property<String> getPluginId() {
        return this.pluginId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void patchPluginXmlFiles() {
        Object object = this.pluginXmlFiles.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginXmlFiles.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            Object object2 = file;
            boolean bl2 = false;
            object2 = new FileInputStream((File)object2);
            bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                Object it;
                boolean bl4;
                boolean bl5;
                Object object3;
                FileInputStream inputStream = (FileInputStream)object2;
                boolean bl6 = false;
                Object object4 = JDOMUtil.loadDocument((InputStream)inputStream);
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"loadDocument(inputStream)");
                Document document = object4;
                object4 = (String)this.getSinceBuild().getOrNull();
                if (object4 != null) {
                    object3 = object4;
                    bl5 = false;
                    bl4 = false;
                    it = object3;
                    boolean bl7 = false;
                    this.patchAttribute(document, "idea-version", "since-build", (String)it);
                }
                object4 = (String)this.getUntilBuild().getOrNull();
                if (object4 != null) {
                    object3 = object4;
                    bl5 = false;
                    bl4 = false;
                    it = object3;
                    boolean bl8 = false;
                    this.patchAttribute(document, "idea-version", "until-build", (String)it);
                }
                object4 = (String)this.getPluginDescription().getOrNull();
                if (object4 != null) {
                    object3 = object4;
                    bl5 = false;
                    bl4 = false;
                    it = object3;
                    boolean bl9 = false;
                    this.patchTag(document, "description", (String)it);
                }
                object4 = (String)this.getChangeNotes().getOrNull();
                if (object4 != null) {
                    object3 = object4;
                    bl5 = false;
                    bl4 = false;
                    it = object3;
                    boolean bl10 = false;
                    this.patchTag(document, "change-notes", (String)it);
                }
                object3 = this.getVersion().getOrNull();
                bl5 = false;
                bl4 = false;
                it = (String)object3;
                boolean bl11 = false;
                object4 = (String)(!Intrinsics.areEqual((Object)it, (Object)"unspecified") ? object3 : null);
                if (object4 != null) {
                    object3 = object4;
                    bl5 = false;
                    bl4 = false;
                    it = object3;
                    boolean bl12 = false;
                    this.patchTag(document, "version", (String)it);
                }
                object4 = (String)this.getPluginId().getOrNull();
                if (object4 != null) {
                    object3 = object4;
                    bl5 = false;
                    bl4 = false;
                    it = object3;
                    boolean bl13 = false;
                    this.patchTag(document, "id", (String)it);
                }
                File destination = new File(((Directory)this.getDestinationDir().get()).getAsFile(), file.getName());
                Utils.transformXml(document, destination);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void patchTag(Document document, String name, String content) {
        Element element;
        CharSequence charSequence = content;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        Element element2 = document.getRootElement();
        boolean bl2 = false;
        boolean bl3 = false;
        Element it = element2;
        boolean bl4 = false;
        Object object = element = Intrinsics.areEqual((Object)it.getName(), (Object)"idea-plugin") ? element2 : null;
        if (element == null) {
            return;
        }
        Element pluginXml = element;
        Element tag = pluginXml.getChild(name);
        if (tag != null) {
            String existingValue = tag.getText();
            Intrinsics.checkNotNullExpressionValue((Object)existingValue, (String)"existingValue");
            CharSequence charSequence2 = existingValue;
            bl3 = false;
            if (charSequence2.length() > 0) {
                Utils.warn$default(this.context, "Patching plugin.xml: value of '" + name + '[' + existingValue + "]' tag will be set to '" + content + '\'', null, 4, null);
            }
            tag.setText(content);
        } else {
            void $this$patchTag_u24lambda_u2d10;
            element2 = new Element(name);
            bl2 = false;
            bl3 = false;
            it = element2;
            int n = 0;
            Element element3 = pluginXml;
            boolean bl5 = false;
            $this$patchTag_u24lambda_u2d10.setText(content);
            Unit unit = Unit.INSTANCE;
            element3.addContent(n, (Content)element2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void patchAttribute(Document document, String tagName, String attributeName, String attributeValue) {
        Element element;
        CharSequence charSequence = attributeValue;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        Element element2 = document.getRootElement();
        boolean bl2 = false;
        boolean bl3 = false;
        Element it2 = element2;
        boolean bl4 = false;
        Object object = element = Intrinsics.areEqual((Object)it2.getName(), (Object)"idea-plugin") ? element2 : null;
        if (element == null) {
            return;
        }
        Element pluginXml = element;
        Element tag = pluginXml.getChild(tagName);
        if (tag != null) {
            Object object2 = tag.getAttribute(attributeName);
            String existingValue = object2 == null ? null : object2.getValue();
            object2 = existingValue;
            bl3 = false;
            boolean it2 = false;
            if (!(object2 == null || object2.length() == 0)) {
                Utils.warn$default(this.context, "Patching plugin.xml: attribute '" + attributeName + "=[" + existingValue + "]' of '" + tagName + "' tag will be set to '" + attributeValue + '\'', null, 4, null);
            }
            tag.setAttribute(attributeName, attributeValue);
        } else {
            void $this$patchAttribute_u24lambda_u2d12;
            element2 = new Element(tagName);
            bl2 = false;
            bl3 = false;
            it2 = element2;
            int n = 0;
            Element element3 = pluginXml;
            boolean bl5 = false;
            $this$patchAttribute_u24lambda_u2d12.setAttribute(attributeName, attributeValue);
            Unit unit = Unit.INSTANCE;
            element3.addContent(n, (Content)element2);
        }
    }
}

