/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginsRepository;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J4\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0016R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/intellij/dependency/MavenRepository;", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "resolvedDependency", "", "getResolvedDependency", "()Z", "setResolvedDependency", "(Z)V", "getPluginFile", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "dependency", "Lorg/gradle/api/artifacts/Dependency;", "repository", "Lorg/gradle/api/artifacts/repositories/MavenArtifactRepository;", "url", "", "context", "postResolve", "", "func", "Lkotlin/Function0;", "gradle-intellij-plugin"})
public interface MavenRepository
extends PluginsRepository {
    public boolean getResolvedDependency();

    public void setResolvedDependency(boolean var1);

    @Nullable
    public File getPluginFile(@NotNull Project var1, @NotNull Dependency var2, @NotNull MavenArtifactRepository var3, @NotNull String var4, @Nullable String var5);

    public void postResolve(@NotNull Project var1, @NotNull Function0<Unit> var2);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static File getPluginFile(@NotNull MavenRepository this_, @NotNull Project project, @NotNull Dependency dependency, @NotNull MavenArtifactRepository repository, @NotNull String url, @Nullable String context) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Utils.debug$default(context, "Adding Maven repository to download '" + dependency + "' from '" + url + '\'', null, 4, null);
            File pluginFile = null;
            try {
                Dependency[] dependencyArray = new Dependency[]{dependency};
                Configuration configuration = project.getConfigurations().detachedConfiguration(dependencyArray);
                pluginFile = configuration.getSingleFile();
                this_.setResolvedDependency(true);
            }
            catch (Exception e) {
                Utils.debug(context, "Couldn't find '" + dependency + "' in '" + url + '\'', e);
            }
            Utils.debug$default(context, Intrinsics.stringPlus((String)"Removing Maven repository: ", (Object)url), null, 4, null);
            project.getRepositories().remove((Object)repository);
            return pluginFile;
        }

        public static void postResolve(@NotNull MavenRepository this_, @NotNull Project project, @NotNull Function0<Unit> func) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(func, (String)"func");
            if (this_.getResolvedDependency()) {
                func.invoke();
                return;
            }
        }
    }
}

