/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IdeaExtraDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.JpsIdeaDependency;
import org.jetbrains.intellij.dependency.LocalIdeaDependency;
import org.jetbrains.intellij.utils.ArchiveUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJR\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J(\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\fH\u0002J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\"\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020!H\u0002J\u001e\u0010%\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J,\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J \u0010-\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00032\b\u0010/\u001a\u0004\u0018\u00010\u0003J4\u00100\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u00101\u001a\u00020!2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\nJ\"\u00102\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\"\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0012H\u0002J(\u00108\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u00109\u001a\u00020!H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependencyManager;", "", "repositoryUrl", "", "ideaDependencyCachePath", "archiveUtils", "Lorg/jetbrains/intellij/utils/ArchiveUtils;", "context", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/intellij/utils/ArchiveUtils;Ljava/lang/String;)V", "mainDependencies", "", "createDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "name", "type", "version", "buildNumber", "classesDirectory", "Ljava/io/File;", "sourcesDirectory", "project", "Lorg/gradle/api/Project;", "extraDependencies", "", "Lorg/jetbrains/intellij/dependency/IdeaExtraDependency;", "extractClassesFromRemoteDependency", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getOrCreateIvyXml", "dependency", "getZipCacheDirectory", "zipFile", "hasKotlinDependency", "", "isCacheUpToDate", "markerFile", "checkVersion", "register", "", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "resetExecutablePermissions", "cacheDirectory", "resolveExtraDependencies", "resolveExtraDependency", "resolveLocal", "localPath", "localPathSources", "resolveRemote", "sources", "resolveSources", "setExecutable", "parent", "child", "storeCache", "directoryToCache", "unzipDependencyFile", "checkVersionChange", "gradle-intellij-plugin"})
public class IdeaDependencyManager {
    @NotNull
    private final String repositoryUrl;
    @NotNull
    private final String ideaDependencyCachePath;
    @NotNull
    private final ArchiveUtils archiveUtils;
    @Nullable
    private final String context;
    @NotNull
    private final List<String> mainDependencies;

    public IdeaDependencyManager(@NotNull String repositoryUrl, @NotNull String ideaDependencyCachePath, @NotNull ArchiveUtils archiveUtils, @Nullable String context) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Intrinsics.checkNotNullParameter((Object)ideaDependencyCachePath, (String)"ideaDependencyCachePath");
        Intrinsics.checkNotNullParameter((Object)archiveUtils, (String)"archiveUtils");
        this.repositoryUrl = repositoryUrl;
        this.ideaDependencyCachePath = ideaDependencyCachePath;
        this.archiveUtils = archiveUtils;
        this.context = context;
        Object[] objectArray = new String[]{"ideaIC", "ideaIU", "riderRD", "riderRS"};
        this.mainDependencies = CollectionsKt.listOf((Object[])objectArray);
    }

    public final void register(@NotNull Project project, @NotNull IdeaDependency dependency, @NotNull DependencySet dependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        File ivyFile = this.getOrCreateIvyXml(dependency);
        String string = ivyFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ivyFile.name");
        int n = (dependency.getName() + '-' + dependency.getVersion()).length();
        boolean bl = false;
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String ivyFileSuffix = StringsKt.removeSuffix((String)string2, (CharSequence)".xml");
        project.getRepositories().ivy(arg_0 -> IdeaDependencyManager.register$lambda-0(dependency, ivyFile, ivyFileSuffix, arg_0));
        string = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.dependencies");
        dependencies.add((Object)Utils.create$default((DependencyHandler)string, "com.jetbrains", dependency.getName(), dependency.getVersion(), null, null, "compile", 24, null));
    }

    private final IdeaDependency createDependency(String name, String type, String version, String buildNumber, File classesDirectory, File sourcesDirectory, Project project, Collection<IdeaExtraDependency> extraDependencies) {
        IdeaDependency ideaDependency;
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"JPS")) {
            ideaDependency = new JpsIdeaDependency(version, buildNumber, classesDirectory, sourcesDirectory, !this.hasKotlinDependency(project), this.context);
        } else {
            BuiltinPluginsRegistry pluginsRegistry = BuiltinPluginsRegistry.Companion.fromDirectory(new File(classesDirectory, "plugins"), this.context);
            String string2 = type;
            ideaDependency = string2 == null ? (IdeaDependency)new LocalIdeaDependency(name, version, buildNumber, classesDirectory, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies) : new IdeaDependency(name, version, buildNumber, classesDirectory, sourcesDirectory, !this.hasKotlinDependency(project), pluginsRegistry, extraDependencies);
        }
        return ideaDependency;
    }

    private final File resolveSources(Project project, String version, String type) {
        Utils.info$default(this.context, "Adding IDE sources repository", null, 4, null);
        try {
            boolean forPyCharm = Utils.isPyCharmType(type);
            DependencyHandler dependencyHandler = project.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
            Dependency dependency = Utils.create$default(dependencyHandler, forPyCharm ? "com.jetbrains.intellij.pycharm" : "com.jetbrains.intellij.idea", forPyCharm ? "pycharmPC" : "ideaIC", version, "sources", "jar", null, 32, null);
            Dependency[] dependencyArray = new Dependency[]{dependency};
            Configuration sourcesConfiguration = project.getConfigurations().detachedConfiguration(dependencyArray);
            Set sourcesFiles = sourcesConfiguration.getFiles();
            if (sourcesFiles.size() == 1) {
                Intrinsics.checkNotNullExpressionValue((Object)sourcesFiles, (String)"sourcesFiles");
                File sourcesDirectory = (File)CollectionsKt.first((Iterable)sourcesFiles);
                Utils.debug$default(this.context, Intrinsics.stringPlus((String)"IDE sources jar: ", (Object)sourcesDirectory.getPath()), null, 4, null);
                return sourcesDirectory;
            }
            Utils.warn$default(this.context, Intrinsics.stringPlus((String)"Cannot attach IDE sources. Found files: ", (Object)sourcesFiles), null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE sources dependency", e);
        }
        return null;
    }

    private final File unzipDependencyFile(File cacheDirectory, File zipFile, String type, boolean checkVersionChange) {
        String string = zipFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"zipFile.name");
        return this.archiveUtils.extract(zipFile, FilesKt.resolve((File)cacheDirectory, (String)StringsKt.removeSuffix((String)string, (CharSequence)".zip")), this.context, arg_0 -> IdeaDependencyManager.unzipDependencyFile$lambda-1(this, zipFile, checkVersionChange, arg_0), (arg_0, arg_1) -> IdeaDependencyManager.unzipDependencyFile$lambda-2(this, type, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isCacheUpToDate(File zipFile, File markerFile, boolean checkVersion) {
        if (!checkVersion) {
            return markerFile.exists();
        }
        if (!markerFile.exists()) {
            return false;
        }
        Closeable closeable = new ZipFile(zipFile);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipFile zip = (ZipFile)closeable;
            boolean bl3 = false;
            ZipEntry entry = zip.getEntry("build.txt");
            if (entry != null) {
                Closeable closeable2 = zip.getInputStream(entry);
                Intrinsics.checkNotNullExpressionValue((Object)closeable2, (String)"zip.getInputStream(entry)");
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                Object object = closeable2;
                int n = 0;
                object = new InputStreamReader((InputStream)object, charset);
                n = 8192;
                boolean bl5 = false;
                closeable2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                boolean bl6 = false;
                bl4 = false;
                Throwable throwable2 = null;
                try {
                    BufferedReader it = (BufferedReader)closeable2;
                    boolean bl7 = false;
                    object = TextStreamsKt.readText((Reader)it);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                if (!Intrinsics.areEqual((Object)object, (Object)FilesKt.readText$default((File)markerFile, null, (int)1, null))) {
                    boolean bl8 = false;
                    return bl8;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    private final void storeCache(File directoryToCache, File markerFile) {
        File file;
        File file2 = new File(directoryToCache, "build.txt");
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        File file3 = file = it.exists() ? file2 : null;
        if (file != null) {
            file2 = file;
            bl = false;
            bl2 = false;
            it = file2;
            boolean bl4 = false;
            String string = FilesKt.readText$default((File)it, null, (int)1, null);
            boolean bl5 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            FilesKt.writeText$default((File)markerFile, (String)((Object)StringsKt.trim((CharSequence)string2)).toString(), null, (int)2, null);
        }
    }

    private final void resetExecutablePermissions(File cacheDirectory, String type) {
        if (Intrinsics.areEqual((Object)type, (Object)"RD") && !OperatingSystem.current().isWindows()) {
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/dupfinder.sh", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/inspectcode.sh", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/JetBrains.ReSharper.Host.sh", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/runtime.sh", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/env-wrapper", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/mono-sgen", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/macos-x64/mono/bin/mono-sgen-gdb.py", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/linux-x64/mono/bin/mono-sgen", this.context);
            this.setExecutable(cacheDirectory, "lib/ReSharperHost/linux-x64/mono/bin/mono-sgen-gdb.py", this.context);
        }
    }

    private final void setExecutable(File parent, String child, String context) {
        File file = new File(parent, child);
        boolean bl = false;
        boolean bl2 = false;
        File $this$setExecutable_u24lambda_u2d7 = file;
        boolean bl3 = false;
        Utils.debug$default(context, Intrinsics.stringPlus((String)"Resetting executable permissions for: ", (Object)$this$setExecutable_u24lambda_u2d7.getPath()), null, 4, null);
        $this$setExecutable_u24lambda_u2d7.setExecutable(true, true);
    }

    private final File getOrCreateIvyXml(IdeaDependency dependency) {
        File ivyFile;
        File directory = dependency.getIvyRepositoryDirectory();
        File file = ivyFile = directory != null ? new File(directory, Intrinsics.stringPlus((String)dependency.getFqn(), (Object)".xml")) : File.createTempFile(dependency.getFqn(), ".xml");
        if (directory == null || !ivyFile.exists()) {
            DefaultIvyPublicationIdentity identity = new DefaultIvyPublicationIdentity("com.jetbrains", dependency.getName(), dependency.getVersion());
            IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator((IvyPublicationIdentity)identity);
            boolean bl = false;
            boolean bl2 = false;
            IntelliJIvyDescriptorFileGenerator $this$getOrCreateIvyXml_u24lambda_u2d9 = intelliJIvyDescriptorFileGenerator;
            boolean bl3 = false;
            $this$getOrCreateIvyXml_u24lambda_u2d9.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
            $this$getOrCreateIvyXml_u24lambda_u2d9.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("compile"));
            $this$getOrCreateIvyXml_u24lambda_u2d9.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("sources"));
            Iterable $this$forEach$iv = dependency.getJarFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl4 = false;
                $this$getOrCreateIvyXml_u24lambda_u2d9.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it, "compile", dependency.getClasses(), null));
            }
            if (dependency.getSources() != null) {
                String name = Utils.isDependencyOnPyCharm(dependency) ? "pycharmPC" : "ideaIC";
                IntellijIvyArtifact artifact = new IntellijIvyArtifact(dependency.getSources(), name, "jar", "sources", "sources");
                artifact.setConf("sources");
                $this$getOrCreateIvyXml_u24lambda_u2d9.addArtifact(artifact);
            }
            Intrinsics.checkNotNullExpressionValue((Object)ivyFile, (String)"ivyFile");
            $this$getOrCreateIvyXml_u24lambda_u2d9.writeTo(ivyFile);
        }
        Intrinsics.checkNotNullExpressionValue((Object)ivyFile, (String)"ivyFile");
        return ivyFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasKotlinDependency(Project project) {
        boolean bl;
        DependencySet dependencySet = project.getConfigurations().getByName("runtimeClasspath").getAllDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"project.configurations.getByName(JavaPlugin.RUNTIME_CLASSPATH_CONFIGURATION_NAME).allDependencies");
        Iterable $this$any$iv = (Iterable)dependencySet;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Dependency it = (Dependency)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)"org.jetbrains.kotlin", (Object)it.getGroup())) {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (Utils.isKotlinRuntime(string)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public final IdeaDependency resolveRemote(@NotNull Project project, @NotNull String version, @NotNull String type, boolean sources, @NotNull List<String> extraDependencies) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(extraDependencies, (String)"extraDependencies");
        String releaseType = Utils.releaseType(version);
        Utils.debug$default(this.context, "Adding IDE repository: " + this.repositoryUrl + '/' + releaseType, null, 4, null);
        project.getRepositories().maven(arg_0 -> IdeaDependencyManager.resolveRemote$lambda-11(this, releaseType, arg_0));
        Utils.debug$default(this.context, "Adding IDE dependency", null, 4, null);
        String dependencyGroup = "com.jetbrains.intellij.idea";
        String dependencyName = "ideaIC";
        boolean hasSources = sources;
        if (Intrinsics.areEqual((Object)type, (Object)"IU")) {
            dependencyName = "ideaIU";
        } else if (Intrinsics.areEqual((Object)type, (Object)"CL")) {
            dependencyGroup = "com.jetbrains.intellij.clion";
            dependencyName = "clion";
        } else if (Utils.isPyCharmType(type)) {
            dependencyGroup = "com.jetbrains.intellij.pycharm";
            dependencyName = Intrinsics.stringPlus((String)"pycharm", (Object)type);
        } else if (Intrinsics.areEqual((Object)type, (Object)"GO")) {
            dependencyGroup = "com.jetbrains.intellij.goland";
            dependencyName = "goland";
        } else if (Intrinsics.areEqual((Object)type, (Object)"RD")) {
            dependencyGroup = "com.jetbrains.intellij.rider";
            dependencyName = "riderRD";
            if (sources && Intrinsics.areEqual((Object)releaseType, (Object)"snapshots")) {
                Utils.warn$default(this.context, "IDE sources are not available for Rider SNAPSHOTS", null, 4, null);
                hasSources = false;
            }
        } else if (Intrinsics.areEqual((Object)type, (Object)"GW")) {
            dependencyGroup = "com.jetbrains.gateway";
            dependencyName = "JetBrainsGateway";
            hasSources = false;
        }
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
        Dependency dependency = Utils.create$default(dependencyHandler, dependencyGroup, dependencyName, version, null, null, null, 56, null);
        Dependency[] dependencyArray = new Dependency[]{dependency};
        Configuration configuration = project.getConfigurations().detachedConfiguration(dependencyArray);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"configuration");
        File classesDirectory = this.extractClassesFromRemoteDependency(project, configuration, type, version);
        Utils.info$default(this.context, Intrinsics.stringPlus((String)"IDE dependency cache directory: ", (Object)classesDirectory), null, 4, null);
        String buildNumber = Utils.ideBuildNumber(classesDirectory);
        File sourcesDirectory = hasSources ? this.resolveSources(project, version, type) : null;
        Collection<IdeaExtraDependency> resolvedExtraDependencies = this.resolveExtraDependencies(project, version, extraDependencies);
        return this.createDependency(dependencyName, type, version, buildNumber, classesDirectory, sourcesDirectory, project, resolvedExtraDependencies);
    }

    @NotNull
    public final IdeaDependency resolveLocal(@NotNull Project project, @NotNull String localPath, @Nullable String localPathSources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Utils.debug$default(this.context, "Adding local IDE dependency", null, 4, null);
        File ideaDir = Utils.ideaDir(localPath);
        if (!ideaDir.exists() || !ideaDir.isDirectory()) {
            throw new BuildException("Specified localPath '" + localPath + "' doesn't exist or is not a directory", null);
        }
        String buildNumber = Utils.ideBuildNumber(ideaDir);
        CharSequence charSequence = localPathSources;
        boolean bl = false;
        boolean bl2 = false;
        File sources = !(charSequence == null || charSequence.length() == 0) ? new File(localPathSources) : null;
        return this.createDependency("ideaLocal", null, buildNumber, buildNumber, ideaDir, sources, project, CollectionsKt.emptyList());
    }

    private final File extractClassesFromRemoteDependency(Project project, Configuration configuration, String type, String version) {
        File file = configuration.getSingleFile();
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        Utils.debug$default(this.context, Intrinsics.stringPlus((String)"IDE zip: ", (Object)it.getPath()), null, 4, null);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return this.unzipDependencyFile(this.getZipCacheDirectory(it, project, type), it, type, StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
    }

    private final File getZipCacheDirectory(File zipFile, Project project, String type) {
        Object object = this.ideaDependencyCachePath;
        boolean bl = false;
        if (object.length() > 0) {
            File customCacheParent = new File(this.ideaDependencyCachePath);
            if (customCacheParent.exists()) {
                return new File(customCacheParent.getAbsolutePath());
            }
        } else if (Intrinsics.areEqual((Object)type, (Object)"RD") && OperatingSystem.current().isWindows()) {
            object = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.buildDir");
            return object;
        }
        object = zipFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"zipFile.parentFile");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<IdeaExtraDependency> resolveExtraDependencies(Project project, String version, List<String> extraDependencies) {
        List list;
        void $this$filterTo$iv$iv;
        List $this$filter$iv22;
        if (extraDependencies.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Utils.info$default(this.context, Intrinsics.stringPlus((String)"Configuring IDE extra dependencies: ", extraDependencies), null, 4, null);
        Iterable iterable = extraDependencies;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv22;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block9: {
                String dep = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = this.mainDependencies;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)dep)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv22 = (List)destination$iv$iv;
        $i$f$filter = false;
        boolean bl = false;
        List it = $this$filter$iv22;
        boolean bl4 = false;
        Collection collection = it;
        boolean bl5 = false;
        List list2 = list = !collection.isEmpty() ? $this$filter$iv22 : null;
        if (list != null) {
            $this$filter$iv22 = list;
            $i$f$filter = false;
            bl = false;
            it = $this$filter$iv22;
            boolean bl6 = false;
            throw new GradleException("The items '" + it + "' cannot be used as extra dependencies");
        }
        boolean $this$filter$iv22 = false;
        List resolvedExtraDependencies = new ArrayList();
        Iterable $this$forEach$iv = extraDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Boolean bl7;
            Boolean bl8;
            String it2 = (String)element$iv;
            boolean bl9 = false;
            File file = this.resolveExtraDependency(project, version, it2);
            if (file == null) {
                bl8 = null;
            } else {
                File file2 = file;
                boolean bl10 = false;
                boolean bl11 = false;
                File dependencyFile = file2;
                boolean bl12 = false;
                IdeaExtraDependency extraDependency = new IdeaExtraDependency(it2, dependencyFile);
                Utils.debug$default(this.context, "IDE extra dependency '" + it2 + "' in '" + dependencyFile + "' files: " + extraDependency.getJarFiles(), null, 4, null);
                bl8 = resolvedExtraDependencies.add(extraDependency);
            }
            if ((bl7 = bl8) != null) continue;
            Utils.debug$default(this.context, "IDE extra dependency for '" + it2 + "' was resolved as null", null, 4, null);
        }
        return resolvedExtraDependencies;
    }

    private final File resolveExtraDependency(Project project, String version, String name) {
        try {
            DependencyHandler dependencyHandler = project.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencyHandler, (String)"project.dependencies");
            Dependency dependency = Utils.create$default(dependencyHandler, "com.jetbrains.intellij.idea", name, version, null, null, null, 56, null);
            Dependency[] dependencyArray = new Dependency[]{dependency};
            Configuration extraDependencyConfiguration = project.getConfigurations().detachedConfiguration(dependencyArray);
            Set files = extraDependencyConfiguration.getFiles();
            if (files.size() == 1) {
                File file;
                Intrinsics.checkNotNullExpressionValue((Object)files, (String)"files");
                File depFile = (File)CollectionsKt.first((Iterable)files);
                String string = depFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"depFile.name");
                if (StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNullExpressionValue((Object)depFile, (String)"depFile");
                    File cacheDirectory = this.getZipCacheDirectory(depFile, project, "IC");
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + cacheDirectory.getPath(), null, 4, null);
                    file = this.unzipDependencyFile(cacheDirectory, depFile, "IC", StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null));
                } else {
                    Utils.debug$default(this.context, "IDE extra dependency '" + name + "': " + depFile.getPath(), null, 4, null);
                    file = depFile;
                }
                return file;
            }
            Utils.warn$default(this.context, "Cannot attach IDE extra dependency '" + name + "'. Found files: " + files, null, 4, null);
        }
        catch (ResolveException e) {
            Utils.warn(this.context, "Cannot resolve IDE extra dependency '" + name + '\'', e);
        }
        return null;
    }

    private static final void register$lambda-0(IdeaDependency $dependency, File $ivyFile, String $ivyFileSuffix, IvyArtifactRepository it) {
        Intrinsics.checkNotNullParameter((Object)$dependency, (String)"$dependency");
        Intrinsics.checkNotNullParameter((Object)$ivyFile, (String)"$ivyFile");
        Intrinsics.checkNotNullParameter((Object)$ivyFileSuffix, (String)"$ivyFileSuffix");
        it.setUrl($dependency.getClasses().toURI());
        it.ivyPattern($ivyFile.getParent() + "/[module]-[revision]" + $ivyFileSuffix + ".[ext]");
        it.artifactPattern(Intrinsics.stringPlus((String)$dependency.getClasses().getPath(), (Object)"/[artifact].[ext]"));
        if ($dependency.getSources() != null) {
            it.artifactPattern(Intrinsics.stringPlus((String)$dependency.getSources().getParent(), (Object)"/[artifact]-[revision]-[classifier].[ext]"));
        }
    }

    private static final boolean unzipDependencyFile$lambda-1(IdeaDependencyManager this$0, File $zipFile, boolean $checkVersionChange, File markerFile) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$zipFile, (String)"$zipFile");
        Intrinsics.checkNotNullParameter((Object)markerFile, (String)"markerFile");
        return this$0.isCacheUpToDate($zipFile, markerFile, $checkVersionChange);
    }

    private static final void unzipDependencyFile$lambda-2(IdeaDependencyManager this$0, String $type, File unzippedDirectory, File markerFile) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)unzippedDirectory, (String)"unzippedDirectory");
        Intrinsics.checkNotNullParameter((Object)markerFile, (String)"markerFile");
        this$0.resetExecutablePermissions(unzippedDirectory, $type);
        this$0.storeCache(unzippedDirectory, markerFile);
    }

    private static final void resolveRemote$lambda-11(IdeaDependencyManager this$0, String $releaseType, MavenArtifactRepository it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$releaseType, (String)"$releaseType");
        it.setUrl(URI.create(this$0.repositoryUrl + '/' + $releaseType));
    }
}

