/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.BuiltinPluginsRegistry;
import org.jetbrains.intellij.dependency.IdeaExtraDependency;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eH\u0014J\u0013\u0010#\u001a\u00020\n2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\u0006\u0010&\u001a\u00020\u0003J\n\u0010'\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010(\u001a\u00020\u0018H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082D\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lorg/jetbrains/intellij/dependency/IdeaDependency;", "Ljava/io/Serializable;", "name", "", "version", "buildNumber", "classes", "Ljava/io/File;", "sources", "withKotlin", "", "pluginsRegistry", "Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;", "extraDependencies", "", "Lorg/jetbrains/intellij/dependency/IdeaExtraDependency;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/io/File;ZLorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;Ljava/util/Collection;)V", "getBuildNumber", "()Ljava/lang/String;", "getClasses", "()Ljava/io/File;", "getExtraDependencies", "()Ljava/util/Collection;", "formatVersion", "", "jarFiles", "getJarFiles", "getName", "getPluginsRegistry", "()Lorg/jetbrains/intellij/dependency/BuiltinPluginsRegistry;", "getSources", "getVersion", "getWithKotlin", "()Z", "collectJarFiles", "equals", "other", "", "getFqn", "getIvyRepositoryDirectory", "hashCode", "gradle-intellij-plugin"})
public class IdeaDependency
implements Serializable {
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @NotNull
    private final String buildNumber;
    @NotNull
    private final File classes;
    @Nullable
    private final File sources;
    private final boolean withKotlin;
    @NotNull
    private final BuiltinPluginsRegistry pluginsRegistry;
    @NotNull
    private final Collection<IdeaExtraDependency> extraDependencies;
    private final int formatVersion;
    @NotNull
    private final Collection<File> jarFiles;

    public IdeaDependency(@NotNull String name, @NotNull String version, @NotNull String buildNumber, @NotNull File classes, @Nullable File sources, boolean withKotlin, @NotNull BuiltinPluginsRegistry pluginsRegistry, @NotNull Collection<IdeaExtraDependency> extraDependencies) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)buildNumber, (String)"buildNumber");
        Intrinsics.checkNotNullParameter((Object)classes, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)pluginsRegistry, (String)"pluginsRegistry");
        Intrinsics.checkNotNullParameter(extraDependencies, (String)"extraDependencies");
        this.name = name;
        this.version = version;
        this.buildNumber = buildNumber;
        this.classes = classes;
        this.sources = sources;
        this.withKotlin = withKotlin;
        this.pluginsRegistry = pluginsRegistry;
        this.extraDependencies = extraDependencies;
        this.formatVersion = 2;
        this.jarFiles = this.collectJarFiles();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getBuildNumber() {
        return this.buildNumber;
    }

    @NotNull
    public final File getClasses() {
        return this.classes;
    }

    @Nullable
    public final File getSources() {
        return this.sources;
    }

    public final boolean getWithKotlin() {
        return this.withKotlin;
    }

    @NotNull
    public final BuiltinPluginsRegistry getPluginsRegistry() {
        return this.pluginsRegistry;
    }

    @NotNull
    public final Collection<IdeaExtraDependency> getExtraDependencies() {
        return this.extraDependencies;
    }

    @NotNull
    public final Collection<File> getJarFiles() {
        return this.jarFiles;
    }

    @NotNull
    protected Collection<File> collectJarFiles() {
        File lib;
        if (this.classes.isDirectory() && (lib = new File(this.classes, "lib")).isDirectory()) {
            List baseFiles = CollectionsKt.sorted((Iterable)Utils.collectJars(lib, arg_0 -> IdeaDependency.collectJarFiles$lambda-0(this, arg_0)));
            List antFiles = CollectionsKt.sorted((Iterable)Utils.collectJars(new File(lib, "ant/lib"), IdeaDependency::collectJarFiles$lambda-1));
            return CollectionsKt.plus((Collection)baseFiles, (Iterable)antFiles);
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public File getIvyRepositoryDirectory() {
        return this.classes;
    }

    @NotNull
    public final String getFqn() {
        String fqn = this.name + '-' + this.version + '-' + this.formatVersion;
        if (this.withKotlin) {
            fqn = Intrinsics.stringPlus((String)fqn, (Object)"-withKotlin");
        }
        if (this.sources != null) {
            fqn = Intrinsics.stringPlus((String)fqn, (Object)"-withSources");
        }
        return fqn;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.intellij.dependency.IdeaDependency");
        }
        IdeaDependency cfr_ignored_0 = (IdeaDependency)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)((IdeaDependency)other).name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)((IdeaDependency)other).version)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildNumber, (Object)((IdeaDependency)other).buildNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.classes, (Object)((IdeaDependency)other).classes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sources, (Object)((IdeaDependency)other).sources)) {
            return false;
        }
        if (this.withKotlin != ((IdeaDependency)other).withKotlin) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pluginsRegistry, (Object)((IdeaDependency)other).pluginsRegistry)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.extraDependencies, ((IdeaDependency)other).extraDependencies)) {
            return false;
        }
        return Intrinsics.areEqual(this.jarFiles, ((IdeaDependency)other).jarFiles);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.buildNumber.hashCode();
        result = 31 * result + this.classes.hashCode();
        File file = this.sources;
        boolean bl = false;
        File file2 = file;
        result = 31 * result + (file2 != null ? ((Object)file2).hashCode() : 0);
        result = 31 * result + Boolean.hashCode(this.withKotlin);
        result = 31 * result + this.pluginsRegistry.hashCode();
        result = 31 * result + ((Object)this.extraDependencies).hashCode();
        result = 31 * result + ((Object)this.jarFiles).hashCode();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collectJarFiles$lambda-0(IdeaDependency this$0, File file) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this$0.getWithKotlin()) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (Utils.isKotlinRuntime(StringsKt.removeSuffix((String)string, (CharSequence)".jar"))) return false;
        }
        if (Intrinsics.areEqual((Object)file.getName(), (Object)"junit.jar")) return false;
        if (Intrinsics.areEqual((Object)file.getName(), (Object)"annotations.jar")) return false;
        return true;
    }

    private static final boolean collectJarFiles$lambda-1(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

