/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import groovy.transform.ToString;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyImpl;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.tasks.PrepareSandboxTask;

@ToString(includeNames=true, includeFields=true, ignoreNulls=true)
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u00102\u001a\u00020\f2\u0006\u00103\u001a\u000204H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001d\u0010#\u001a\u0004\u0018\u00010$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u001b\u0010)\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010(\u001a\u0004\b*\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0016\u0010.\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\nR\u0014\u00100\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011\u00a8\u00065"}, d2={"Lorg/jetbrains/intellij/dependency/PluginProjectDependency;", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "project", "Lorg/gradle/api/Project;", "context", "", "(Lorg/gradle/api/Project;Ljava/lang/String;)V", "artifact", "Ljava/io/File;", "getArtifact", "()Ljava/io/File;", "builtin", "", "getBuiltin", "()Z", "channel", "getChannel", "()Ljava/lang/String;", "classesDirectory", "getClassesDirectory", "getContext", "id", "getId", "jarFiles", "", "getJarFiles", "()Ljava/util/Collection;", "maven", "getMaven", "metaInfDirectory", "getMetaInfDirectory", "notation", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "getNotation", "()Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "pluginDependency", "Lorg/jetbrains/intellij/dependency/PluginDependencyImpl;", "getPluginDependency", "()Lorg/jetbrains/intellij/dependency/PluginDependencyImpl;", "pluginDependency$delegate", "Lkotlin/Lazy;", "pluginDirectory", "getPluginDirectory", "pluginDirectory$delegate", "getProject", "()Lorg/gradle/api/Project;", "sourcesDirectory", "getSourcesDirectory", "version", "getVersion", "isCompatible", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "gradle-intellij-plugin"})
public final class PluginProjectDependency
implements PluginDependency {
    @NotNull
    private final transient Project project;
    @Nullable
    private final String context;
    @NotNull
    private final Lazy pluginDirectory$delegate;
    @NotNull
    private final Lazy pluginDependency$delegate;

    public PluginProjectDependency(@NotNull Project project, @Nullable String context) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.context = context;
        this.pluginDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ PluginProjectDependency this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                Task prepareSandboxTask = (Task)this.this$0.getProject().getTasks().findByName("prepareSandbox");
                if (!(prepareSandboxTask instanceof PrepareSandboxTask)) {
                    throw new GradleException("Error accessing PrepareSandboxTask");
                }
                return new File(((PrepareSandboxTask)prepareSandboxTask).getDestinationDir(), (String)((PrepareSandboxTask)prepareSandboxTask).getPluginName().get());
            }
        }));
        this.pluginDependency$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PluginDependencyImpl>(this){
            final /* synthetic */ PluginProjectDependency this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final PluginDependencyImpl invoke() {
                PluginDependencyImpl pluginDependencyImpl;
                File file;
                File file2 = PluginProjectDependency.access$getPluginDirectory(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                File it = file2;
                boolean bl3 = false;
                File file3 = file = it.exists() ? file2 : null;
                if (file == null) {
                    pluginDependencyImpl = null;
                } else {
                    file2 = file;
                    PluginProjectDependency pluginProjectDependency = this.this$0;
                    bl2 = false;
                    boolean bl4 = false;
                    File it2 = file2;
                    boolean bl5 = false;
                    IdePluginManager idePluginManager = IdePluginManager.Companion.createManager();
                    Path path = it2.toPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it.toPath()");
                    PluginCreationResult creationResult = idePluginManager.createPlugin(path);
                    if (creationResult instanceof PluginCreationSuccess) {
                        IdePlugin intellijPlugin = (IdePlugin)((PluginCreationSuccess)creationResult).getPlugin();
                        String string = intellijPlugin.getPluginId();
                        if (string == null) {
                            pluginDependencyImpl = null;
                        } else {
                            String pluginId = string;
                            String string2 = intellijPlugin.getPluginVersion();
                            if (string2 == null) {
                                pluginDependencyImpl = null;
                            } else {
                                String pluginVersion = string2;
                                PluginDependencyImpl pluginDependency2 = new PluginDependencyImpl(pluginId, pluginVersion, it2, false, false);
                                IdeVersion ideVersion = intellijPlugin.getSinceBuild();
                                pluginDependency2.setSinceBuild(ideVersion == null ? null : ideVersion.asStringWithoutProductCode());
                                ideVersion = intellijPlugin.getUntilBuild();
                                pluginDependency2.setUntilBuild(ideVersion == null ? null : ideVersion.asStringWithoutProductCode());
                                pluginDependencyImpl = pluginDependency2;
                            }
                        }
                    } else {
                        Utils.error$default(pluginProjectDependency.getContext(), "Cannot use '" + PluginProjectDependency.access$getPluginDirectory(pluginProjectDependency) + "' as a plugin dependency: " + creationResult, null, 4, null);
                        pluginDependencyImpl = null;
                    }
                }
                return pluginDependencyImpl;
            }
        }));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final String getContext() {
        return this.context;
    }

    private final File getPluginDirectory() {
        Lazy lazy = this.pluginDirectory$delegate;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    private final PluginDependencyImpl getPluginDependency() {
        Lazy lazy = this.pluginDependency$delegate;
        boolean bl = false;
        return (PluginDependencyImpl)lazy.getValue();
    }

    @Override
    @NotNull
    public String getId() {
        String string;
        PluginDependencyImpl pluginDependencyImpl = this.getPluginDependency();
        return pluginDependencyImpl == null ? "<unknown plugin id>" : ((string = pluginDependencyImpl.getId()) == null ? "<unknown plugin id>" : string);
    }

    @Override
    @NotNull
    public String getVersion() {
        String string;
        PluginDependencyImpl pluginDependencyImpl = this.getPluginDependency();
        return pluginDependencyImpl == null ? "<unknown plugin version>" : ((string = pluginDependencyImpl.getVersion()) == null ? "<unknown plugin version>" : string);
    }

    @Override
    @Nullable
    public String getChannel() {
        PluginDependencyImpl pluginDependencyImpl = this.getPluginDependency();
        return pluginDependencyImpl == null ? null : pluginDependencyImpl.getChannel();
    }

    @Override
    @NotNull
    public File getArtifact() {
        return this.getPluginDirectory();
    }

    @Override
    @NotNull
    public Collection<File> getJarFiles() {
        PluginDependencyImpl pluginDependencyImpl = this.getPluginDependency();
        Collection collection = pluginDependencyImpl == null ? null : pluginDependencyImpl.getJarFiles();
        return collection == null ? (Collection)CollectionsKt.emptyList() : collection;
    }

    @Override
    @Nullable
    public File getClassesDirectory() {
        PluginDependencyImpl pluginDependencyImpl = this.getPluginDependency();
        return pluginDependencyImpl == null ? null : pluginDependencyImpl.getClassesDirectory();
    }

    @Override
    @Nullable
    public File getMetaInfDirectory() {
        PluginDependencyImpl pluginDependencyImpl = this.getPluginDependency();
        return pluginDependencyImpl == null ? null : pluginDependencyImpl.getMetaInfDirectory();
    }

    @Override
    @Nullable
    public File getSourcesDirectory() {
        PluginDependencyImpl pluginDependencyImpl = this.getPluginDependency();
        return pluginDependencyImpl == null ? null : pluginDependencyImpl.getSourcesDirectory();
    }

    @Override
    public boolean getBuiltin() {
        return false;
    }

    @Override
    public boolean getMaven() {
        return false;
    }

    @Override
    @NotNull
    public PluginDependencyNotation getNotation() {
        return new PluginDependencyNotation(this.getId(), null, null);
    }

    @Override
    public boolean isCompatible(@NotNull IdeVersion ideVersion) {
        Intrinsics.checkParameterIsNotNull((Object)ideVersion, (String)"ideVersion");
        return true;
    }

    @Override
    @NotNull
    public String getFqn() {
        return PluginDependency.DefaultImpls.getFqn(this);
    }

    public static final /* synthetic */ File access$getPluginDirectory(PluginProjectDependency $this) {
        return $this.getPluginDirectory();
    }
}

