/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfiguration;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.process.ExecOperations;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJIvyDescriptorFileGenerator;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IntellijIvyArtifact;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyImpl;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Incubating
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001BI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\u0012\u0010#\u001a\u00020\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u0002J\u001e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(J\u0018\u0010)\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020\u0018H\u0002J\u0018\u0010*\u001a\u0004\u0018\u00010\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010+\u001a\u00020,J\u001a\u0010-\u001a\u0004\u0018\u00010\u00182\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/intellij/dependency/PluginDependencyManager;", "", "gradleHomePath", "", "ideaDependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "pluginsRepositories", "", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "context", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "execOperations", "Lorg/gradle/process/ExecOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Ljava/lang/String;Lorg/jetbrains/intellij/dependency/IdeaDependency;Ljava/util/List;Ljava/lang/String;Lorg/gradle/api/file/ArchiveOperations;Lorg/gradle/process/ExecOperations;Lorg/gradle/api/file/FileSystemOperations;)V", "cacheDirectoryPath", "ivyArtifactRepository", "Lorg/gradle/api/artifacts/repositories/IvyArtifactRepository;", "mavenCacheDirectoryPath", "pluginSources", "", "externalPluginDependency", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "artifact", "Ljava/io/File;", "channel", "maven", "", "findSingleDirectory", "dir", "generateIvyFile", "", "plugin", "groupId", "register", "project", "Lorg/gradle/api/Project;", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "registerRepositoryIfNeeded", "resolve", "dependency", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "zippedPluginDependency", "pluginFile", "gradle-intellij-plugin"})
public class PluginDependencyManager {
    @Nullable
    private final IdeaDependency ideaDependency;
    @NotNull
    private final List<PluginsRepository> pluginsRepositories;
    @Nullable
    private final String context;
    @NotNull
    private final ArchiveOperations archiveOperations;
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final FileSystemOperations fileSystemOperations;
    @NotNull
    private final String mavenCacheDirectoryPath;
    @NotNull
    private final String cacheDirectoryPath;
    @NotNull
    private final Set<String> pluginSources;
    @Nullable
    private IvyArtifactRepository ivyArtifactRepository;

    @Inject
    public PluginDependencyManager(@NotNull String gradleHomePath, @Nullable IdeaDependency ideaDependency, @NotNull List<? extends PluginsRepository> pluginsRepositories, @Nullable String context, @NotNull ArchiveOperations archiveOperations, @NotNull ExecOperations execOperations, @NotNull FileSystemOperations fileSystemOperations) {
        Intrinsics.checkParameterIsNotNull((Object)gradleHomePath, (String)"gradleHomePath");
        Intrinsics.checkParameterIsNotNull(pluginsRepositories, (String)"pluginsRepositories");
        Intrinsics.checkParameterIsNotNull((Object)archiveOperations, (String)"archiveOperations");
        Intrinsics.checkParameterIsNotNull((Object)execOperations, (String)"execOperations");
        Intrinsics.checkParameterIsNotNull((Object)fileSystemOperations, (String)"fileSystemOperations");
        this.ideaDependency = ideaDependency;
        this.pluginsRepositories = pluginsRepositories;
        this.context = context;
        this.archiveOperations = archiveOperations;
        this.execOperations = execOperations;
        this.fileSystemOperations = fileSystemOperations;
        String[] stringArray = new String[]{"caches/modules-2/files-2.1"};
        this.mavenCacheDirectoryPath = ((Object)Paths.get(gradleHomePath, stringArray)).toString();
        stringArray = new String[]{"com.jetbrains.intellij.idea"};
        this.cacheDirectoryPath = ((Object)Paths.get(this.mavenCacheDirectoryPath, stringArray)).toString();
        boolean bl = false;
        this.pluginSources = new LinkedHashSet();
    }

    @Nullable
    public final PluginDependency resolve(@NotNull Project project, @NotNull PluginDependencyNotation dependency) {
        Object repository;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        Object object = dependency.getVersion();
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || object.length() == 0) {
            object = dependency.getChannel();
            bl = false;
            bl2 = false;
            if (object == null || object.length() == 0) {
                File file;
                if (Paths.get(dependency.getId(), new String[0]).isAbsolute()) {
                    return PluginDependencyManager.externalPluginDependency$default(this, new File(dependency.getId()), null, false, 6, null);
                }
                if (this.ideaDependency != null) {
                    Utils.info$default(this.context, "Looking for builtin '" + dependency.getId() + "' in: " + this.ideaDependency.getClasses().getAbsolutePath(), null, 4, null);
                    object = this.ideaDependency.getPluginsRegistry().findPlugin(dependency.getId());
                    if (object != null) {
                        Object object2 = object;
                        bl2 = false;
                        boolean bl3 = false;
                        Object it = object2;
                        boolean bl4 = false;
                        String string = "-withSources";
                        boolean bl5 = false;
                        boolean bl6 = false;
                        String string2 = string;
                        StringBuilder stringBuilder = new StringBuilder().append(this.ideaDependency.getName()).append('-').append(this.ideaDependency.getBuildNumber());
                        boolean bl7 = false;
                        boolean bl8 = this.ideaDependency.getSources() != null;
                        String string3 = bl8 ? string : null;
                        String builtinPluginVersion = stringBuilder.append(string3 == null ? "" : string3).toString();
                        string3 = ((File)it).getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.name");
                        return new PluginDependencyImpl(string3, builtinPluginVersion, (File)it, true, false, 16, null);
                    }
                }
                throw new BuildException("Cannot find builtin plugin '" + dependency.getId() + "' for IDE: " + ((object = this.ideaDependency) == null ? null : ((file = ((IdeaDependency)object).getClasses()) == null ? null : file.getAbsolutePath())), null);
            }
        }
        Iterable $this$forEach$iv = this.pluginsRepositories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginDependency pluginDependency2;
            repository = (PluginsRepository)element$iv;
            boolean bl9 = false;
            File file = repository.resolve(project, dependency, this.context);
            if (file == null) continue;
            File file2 = file;
            boolean bl10 = false;
            boolean bl11 = false;
            File it = file2;
            boolean bl12 = false;
            if (Utils.isZip(it)) {
                pluginDependency2 = this.zippedPluginDependency(it, dependency);
            } else if (Utils.isJar(it)) {
                pluginDependency2 = this.externalPluginDependency(it, dependency.getChannel(), true);
            } else {
                throw new BuildException(Intrinsics.stringPlus((String)"Invalid type of downloaded plugin: ", (Object)it.getName()), null);
            }
            return pluginDependency2;
        }
        String string = " from channel '" + dependency.getChannel() + '\'';
        boolean bl13 = false;
        boolean bl14 = false;
        repository = string;
        StringBuilder stringBuilder = new StringBuilder().append("Cannot resolve plugin '").append(dependency.getId()).append("' in version '").append((Object)dependency.getVersion()).append('\'');
        boolean bl15 = false;
        boolean bl16 = dependency.getChannel() != null;
        object = bl16 ? string : null;
        Throwable throwable = null;
        String string4 = stringBuilder.append((String)(object == null ? "" : object)).toString();
        throw new BuildException(string4, throwable);
    }

    public final void register(@NotNull Project project, @NotNull PluginDependency plugin, @NotNull DependencySet dependencies) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
        if (plugin.getMaven() && Utils.isJar(plugin.getArtifact())) {
            dependencies.add((Object)plugin.getNotation().toDependency(project));
            return;
        }
        this.registerRepositoryIfNeeded(project, plugin);
        this.generateIvyFile(plugin);
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"project.dependencies");
        dependencies.add((Object)Utils.create$default(dependencyHandler, this.groupId(plugin.getChannel()), plugin.getId(), plugin.getVersion(), null, null, "compile", 24, null));
    }

    private final PluginDependency zippedPluginDependency(File pluginFile, PluginDependencyNotation dependency) {
        File pluginDir = this.findSingleDirectory(Utils.extractArchive$default(pluginFile, FilesKt.resolve((File)new File(this.cacheDirectoryPath, this.groupId(dependency.getChannel())), (String)(dependency.getId() + '-' + dependency.getVersion())), this.archiveOperations, this.execOperations, this.fileSystemOperations, this.context, null, null, 192, null));
        return this.externalPluginDependency(pluginDir, dependency.getChannel(), true);
    }

    private final String groupId(String channel) {
        CharSequence charSequence = channel;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || charSequence.length() == 0 ? "unzipped.com.jetbrains.plugins" : "unzipped." + channel + ".com.jetbrains.plugins";
    }

    private final File findSingleDirectory(File dir) {
        File file;
        block5: {
            File file2;
            File[] fileArray = dir.listFiles();
            if (fileArray == null) {
                file2 = null;
            } else {
                File[] $this$singleOrNull$iv = fileArray;
                boolean $i$f$singleOrNull = false;
                File single$iv = null;
                boolean found$iv = false;
                File[] fileArray2 = $this$singleOrNull$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    if (!it.isDirectory()) continue;
                    if (found$iv) {
                        file2 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                file2 = file = !found$iv ? null : single$iv;
            }
        }
        if (file == null) {
            throw new BuildException(Intrinsics.stringPlus((String)"Single directory expected in: ", (Object)dir), null);
        }
        return file;
    }

    private final void registerRepositoryIfNeeded(Project project, PluginDependency plugin) {
        if (this.ivyArtifactRepository == null) {
            this.ivyArtifactRepository = project.getRepositories().ivy(arg_0 -> PluginDependencyManager.registerRepositoryIfNeeded$lambda-6(plugin, this, arg_0));
        }
        if (!plugin.getBuiltin() && !plugin.getMaven()) {
            File artifactParent = plugin.getArtifact().getParentFile();
            String pluginSource = artifactParent.getAbsolutePath();
            if (!Intrinsics.areEqual((Object)artifactParent.getParentFile().getAbsolutePath(), (Object)this.cacheDirectoryPath)) {
                IvyArtifactRepository ivyArtifactRepository;
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginSource, (String)"pluginSource");
                if (this.pluginSources.add(pluginSource) && (ivyArtifactRepository = this.ivyArtifactRepository) != null) {
                    ivyArtifactRepository.artifactPattern(Intrinsics.stringPlus((String)pluginSource, (Object)"/[artifact](.[ext])"));
                }
            }
        }
    }

    private final void generateIvyFile(PluginDependency plugin) {
        File file;
        String string;
        File it;
        File file2;
        File baseDir = plugin.getBuiltin() ? plugin.getArtifact() : plugin.getArtifact().getParentFile();
        String pluginFqn = plugin.getFqn();
        String groupId = this.groupId(plugin.getChannel());
        File file3 = new File(new File(this.cacheDirectoryPath, groupId), Intrinsics.stringPlus((String)pluginFqn, (Object)".xml"));
        boolean bl = false;
        boolean bl2 = false;
        File it2 = file3;
        boolean bl3 = false;
        File file4 = file2 = !it2.exists() ? file3 : null;
        if (file2 == null) {
            return;
        }
        File ivyFile = file2;
        DefaultIvyPublicationIdentity identity = new DefaultIvyPublicationIdentity(groupId, plugin.getId(), plugin.getVersion());
        DefaultIvyConfiguration configuration = new DefaultIvyConfiguration("compile");
        IntelliJIvyDescriptorFileGenerator intelliJIvyDescriptorFileGenerator = new IntelliJIvyDescriptorFileGenerator((IvyPublicationIdentity)identity);
        bl2 = false;
        boolean bl4 = false;
        IntelliJIvyDescriptorFileGenerator $this$generateIvyFile_u24lambda_u2d13 = intelliJIvyDescriptorFileGenerator;
        boolean bl5 = false;
        $this$generateIvyFile_u24lambda_u2d13.addConfiguration((IvyConfiguration)configuration);
        $this$generateIvyFile_u24lambda_u2d13.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("sources"));
        $this$generateIvyFile_u24lambda_u2d13.addConfiguration((IvyConfiguration)new DefaultIvyConfiguration("default"));
        Iterable $this$forEach$iv = plugin.getJarFiles();
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            it = (File)element$iv;
            boolean bl6 = false;
            string = configuration.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
            Intrinsics.checkExpressionValueIsNotNull((Object)baseDir, (String)"baseDir");
            $this$generateIvyFile_u24lambda_u2d13.addArtifact(IntellijIvyArtifact.Companion.createJarDependency(it, string, baseDir, groupId));
        }
        Serializable serializable = plugin.getClassesDirectory();
        if (serializable != null) {
            File file5 = serializable;
            boolean bl7 = false;
            boolean bl8 = false;
            it = file5;
            boolean bl9 = false;
            string = configuration.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
            Intrinsics.checkExpressionValueIsNotNull((Object)baseDir, (String)"baseDir");
            $this$generateIvyFile_u24lambda_u2d13.addArtifact(IntellijIvyArtifact.Companion.createDirectoryDependency(it, string, baseDir, groupId));
        }
        serializable = plugin.getMetaInfDirectory();
        if (serializable != null) {
            File file6 = serializable;
            boolean bl10 = false;
            boolean bl11 = false;
            it = file6;
            boolean bl12 = false;
            string = configuration.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
            Intrinsics.checkExpressionValueIsNotNull((Object)baseDir, (String)"baseDir");
            $this$generateIvyFile_u24lambda_u2d13.addArtifact(IntellijIvyArtifact.Companion.createDirectoryDependency(it, string, baseDir, groupId));
        }
        serializable = this.ideaDependency;
        if (serializable != null && (file = ((IdeaDependency)serializable).getSources()) != null) {
            Object object2 = file;
            boolean bl13 = false;
            boolean bl14 = false;
            Object it3 = object2;
            boolean bl15 = false;
            Object object3 = object = plugin.getBuiltin() ? object2 : null;
            if (object != null) {
                object2 = object;
                bl13 = false;
                bl14 = false;
                it3 = object2;
                boolean bl16 = false;
                String name = Utils.isDependencyOnPyCharm(this.ideaDependency) ? "pycharmPC" : "ideaIC";
                IntellijIvyArtifact artifact = new IntellijIvyArtifact((File)it3, name, "jar", "sources", "sources");
                artifact.setConf("sources");
                $this$generateIvyFile_u24lambda_u2d13.addArtifact(artifact);
            }
        }
        $this$generateIvyFile_u24lambda_u2d13.writeTo(ivyFile);
    }

    private final PluginDependency externalPluginDependency(File artifact, String channel, boolean maven) {
        IdePlugin idePlugin;
        if (!Utils.isJar(artifact) && !artifact.isDirectory()) {
            Utils.warn$default(this.context, "Cannot create plugin from file '" + artifact + "' - only directories or jars are supported", null, 4, null);
        }
        if ((idePlugin = Utils.createPlugin(artifact, true, this.context)) != null) {
            IdePlugin idePlugin2 = idePlugin;
            boolean bl = false;
            boolean bl2 = false;
            IdePlugin it = idePlugin2;
            boolean bl3 = false;
            String string = it.getPluginId();
            if (string == null) {
                return null;
            }
            String pluginId = string;
            Object object = it.getPluginVersion();
            if (object == null) {
                return null;
            }
            String pluginVersion = object;
            object = new PluginDependencyImpl(pluginId, pluginVersion, artifact, false, maven);
            boolean bl4 = false;
            boolean bl5 = false;
            Object $this$externalPluginDependency_u24lambda_u2d15_u24lambda_u2d14 = object;
            boolean bl6 = false;
            ((PluginDependencyImpl)$this$externalPluginDependency_u24lambda_u2d15_u24lambda_u2d14).setChannel(channel);
            IdeVersion ideVersion = it.getSinceBuild();
            ((PluginDependencyImpl)$this$externalPluginDependency_u24lambda_u2d15_u24lambda_u2d14).setSinceBuild(ideVersion == null ? null : ideVersion.asStringWithoutProductCode());
            ideVersion = it.getUntilBuild();
            ((PluginDependencyImpl)$this$externalPluginDependency_u24lambda_u2d15_u24lambda_u2d14).setUntilBuild(ideVersion == null ? null : ideVersion.asStringWithoutProductCode());
            return (PluginDependency)object;
        }
        return null;
    }

    static /* synthetic */ PluginDependency externalPluginDependency$default(PluginDependencyManager pluginDependencyManager, File file, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: externalPluginDependency");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pluginDependencyManager.externalPluginDependency(file, string, bl);
    }

    private static final void registerRepositoryIfNeeded$lambda-6(PluginDependency $plugin, PluginDependencyManager this$0, IvyArtifactRepository it) {
        Intrinsics.checkParameterIsNotNull((Object)$plugin, (String)"$plugin");
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Object object = $plugin.getFqn();
        int n = ($plugin.getId() + '-' + $plugin.getVersion()).length();
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String ivyFileSuffix = string2;
        it.ivyPattern(this$0.cacheDirectoryPath + "/[organisation]/[module]-[revision]" + ivyFileSuffix + ".[ext]");
        object = this$0.ideaDependency;
        it.artifactPattern((object == null ? null : ((IdeaDependency)object).getClasses()) + "/plugins/[module]/[artifact](.[ext])");
        it.artifactPattern(Intrinsics.stringPlus((String)this$0.cacheDirectoryPath, (Object)"(/[classifier])/[module]-[revision]/[artifact](.[ext])"));
        object = this$0.ideaDependency;
        if ((object == null ? null : ((IdeaDependency)object).getSources()) != null) {
            it.artifactPattern(this$0.ideaDependency.getSources().getParent() + "/[artifact]-" + this$0.ideaDependency.getVersion() + "(-[classifier]).[ext]");
        }
    }
}

