/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij;

import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.beans.PluginDependencyBean;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.jvm.Jvm;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.process.JavaForkOptions;
import org.gradle.tooling.BuildException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.IntelliJPlugin;
import org.jetbrains.intellij.IntelliJPluginExtension;
import org.jetbrains.intellij.IntelliJPluginLibrary;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.jetbrains.intellij.dependency.IdeaDependencyManager;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyManager;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginProjectDependency;
import org.jetbrains.intellij.dependency.PluginsRepository;
import org.jetbrains.intellij.jbr.Jbr;
import org.jetbrains.intellij.jbr.JbrResolver;
import org.jetbrains.intellij.tasks.BuildSearchableOptionsTask;
import org.jetbrains.intellij.tasks.DownloadRobotServerPluginTask;
import org.jetbrains.intellij.tasks.IntelliJInstrumentCodeTask;
import org.jetbrains.intellij.tasks.JarSearchableOptionsTask;
import org.jetbrains.intellij.tasks.PatchPluginXmlTask;
import org.jetbrains.intellij.tasks.PrepareSandboxTask;
import org.jetbrains.intellij.tasks.PublishPluginTask;
import org.jetbrains.intellij.tasks.RunIdeBase;
import org.jetbrains.intellij.tasks.RunIdeForUiTestTask;
import org.jetbrains.intellij.tasks.RunIdeTask;
import org.jetbrains.intellij.tasks.RunPluginVerifierTask;
import org.jetbrains.intellij.tasks.SignPluginTask;
import org.jetbrains.intellij.tasks.VerifyPluginTask;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J(\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002JO\u0010\u001f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052%\b\u0002\u0010\"\u001a\u001f\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u0007\u0018\u00010#H\u0002J\u0018\u0010(\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010+\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0002H\u0002J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010/\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u00100\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u00101\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u00102\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u00103\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u00104\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u00105\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u00106\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0005H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010<\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/intellij/IntelliJPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "context", "", "apply", "", "project", "checkGradleVersion", "configureBuildPluginTask", "configureBuildSearchableOptionsTask", "configureBuiltinPluginsDependencies", "dependencies", "Lorg/gradle/api/artifacts/DependencySet;", "resolver", "Lorg/jetbrains/intellij/dependency/PluginDependencyManager;", "extension", "Lorg/jetbrains/intellij/IntelliJPluginExtension;", "configureConfigurations", "configureInstrumentation", "configureIntellijDependency", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "configureJarSearchableOptionsTask", "configurePatchPluginXmlTask", "configurePluginDependencies", "configurePluginDependency", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependency;", "configurePluginVerificationTask", "configurePrepareSandboxTask", "taskName", "testSuffix", "configure", "Lkotlin/Function1;", "Lorg/jetbrains/intellij/tasks/PrepareSandboxTask;", "Lkotlin/ParameterName;", "name", "it", "configurePrepareSandboxTasks", "configureProcessResources", "configureProjectAfterEvaluate", "configureProjectPluginDependency", "dependency", "configureProjectPluginTasksDependency", "configurePublishPluginTask", "configureRobotServerDownloadTask", "configureRunIdeaForUiTestsTask", "configureRunIdeaTask", "configureRunPluginVerifierTask", "configureSignPluginTask", "configureTasks", "configureTestTasks", "prepareConventionMappingsForRunIdeTask", "task", "Lorg/jetbrains/intellij/tasks/RunIdeBase;", "prepareSandBoxTaskName", "resolveBuildTaskOutput", "Ljava/io/File;", "verifyJavaPluginDependency", "gradle-intellij-plugin"})
public class IntelliJPlugin
implements Plugin<Project> {
    private String context;

    public void apply(@NotNull Project project) {
        IntelliJPluginExtension intellijExtension;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.context = Utils.logCategory(project);
        this.checkGradleVersion(project);
        project.getPlugins().apply(JavaPlugin.class);
        IntelliJPluginExtension intelliJPluginExtension = intellijExtension = (IntelliJPluginExtension)project.getExtensions().create("intellij", IntelliJPluginExtension.class, new Object[0]);
        boolean bl = false;
        boolean bl2 = false;
        IntelliJPluginExtension $this$apply_u24lambda_u2d2 = intelliJPluginExtension;
        boolean bl3 = false;
        $this$apply_u24lambda_u2d2.getPluginName().convention(project.provider(() -> IntelliJPlugin.apply$lambda-2$lambda-0(project)));
        $this$apply_u24lambda_u2d2.getUpdateSinceUntilBuild().convention((Object)true);
        $this$apply_u24lambda_u2d2.getSameSinceUntilBuild().convention((Object)false);
        $this$apply_u24lambda_u2d2.getInstrumentCode().convention((Object)true);
        $this$apply_u24lambda_u2d2.getSandboxDir().convention(project.provider(() -> IntelliJPlugin.apply$lambda-2$lambda-1(project)));
        $this$apply_u24lambda_u2d2.getIntellijRepository().convention((Object)"https://cache-redirector.jetbrains.com/www.jetbrains.com/intellij-repository");
        $this$apply_u24lambda_u2d2.getDownloadSources().convention((Object)(!System.getenv().containsKey("CI") ? 1 : 0));
        $this$apply_u24lambda_u2d2.getConfigureDefaultDependencies().convention((Object)true);
        $this$apply_u24lambda_u2d2.getType().convention((Object)"IC");
        Intrinsics.checkExpressionValueIsNotNull((Object)intellijExtension, (String)"intellijExtension");
        this.configureConfigurations(project, intellijExtension);
        this.configureTasks(project, intellijExtension);
    }

    private final void checkGradleVersion(Project project) {
        String string = project.getGradle().getGradleVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.gradle.gradleVersion");
        if (Version.Companion.parse(string).compareTo(Version.Companion.parse("6.6")) < 0) {
            throw new PluginInstantiationException("gradle-intellij-plugin requires Gradle 6.6 and higher");
        }
    }

    private final void configureConfigurations(Project project, IntelliJPluginExtension extension) {
        Configuration idea = ((Configuration)project.getConfigurations().create("idea")).setVisible(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)idea, (String)"idea");
        this.configureIntellijDependency(project, extension, idea);
        Configuration ideaPlugins = ((Configuration)project.getConfigurations().create("ideaPlugins")).setVisible(false);
        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPlugins, (String)"ideaPlugins");
        this.configurePluginDependencies(project, extension, ideaPlugins);
        Configuration defaultDependencies = ((Configuration)project.getConfigurations().create("intellijDefaultDependencies")).setVisible(false);
        defaultDependencies.defaultDependencies(arg_0 -> IntelliJPlugin.configureConfigurations$lambda-3(project, arg_0));
        Configuration[] configurationArray = new Configuration[]{defaultDependencies, idea, ideaPlugins};
        project.getConfigurations().getByName("compileOnly").extendsFrom(configurationArray);
        configurationArray = new Configuration[]{defaultDependencies, idea, ideaPlugins};
        project.getConfigurations().getByName("testImplementation").extendsFrom(configurationArray);
    }

    private final void configureTasks(Project project, IntelliJPluginExtension extension) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring plugin", null, 4, null);
        project.getTasks().whenTaskAdded(arg_0 -> IntelliJPlugin.configureTasks$lambda-4(this, project, extension, arg_0));
        this.configurePatchPluginXmlTask(project, extension);
        this.configureRobotServerDownloadTask(project);
        this.configurePrepareSandboxTasks(project, extension);
        this.configureRunPluginVerifierTask(project);
        this.configurePluginVerificationTask(project);
        this.configureRunIdeaTask(project);
        this.configureRunIdeaForUiTestsTask(project);
        this.configureBuildSearchableOptionsTask(project);
        this.configureJarSearchableOptionsTask(project);
        this.configureBuildPluginTask(project);
        this.configureSignPluginTask(project);
        this.configurePublishPluginTask(project);
        this.configureProcessResources(project);
        this.configureInstrumentation(project, extension);
        boolean bl = !project.getState().getExecuted();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "afterEvaluate is a no-op for an executed project";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        project.afterEvaluate(arg_0 -> IntelliJPlugin.configureTasks$lambda-6(this, extension, arg_0));
    }

    private final void configureProjectAfterEvaluate(Project project, IntelliJPluginExtension extension) {
        Set set = project.getSubprojects();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"project.subprojects");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IntelliJPluginExtension intelliJPluginExtension;
            Project subproject = (Project)element$iv;
            boolean bl = false;
            if (subproject.getPlugins().findPlugin(IntelliJPlugin.class) != null || (intelliJPluginExtension = (IntelliJPluginExtension)subproject.getExtensions().findByType(IntelliJPluginExtension.class)) == null) continue;
            IntelliJPluginExtension intelliJPluginExtension2 = intelliJPluginExtension;
            boolean bl2 = false;
            boolean bl3 = false;
            IntelliJPluginExtension it = intelliJPluginExtension2;
            boolean bl4 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)subproject, (String)"subproject");
            this.configureProjectAfterEvaluate(subproject, it);
        }
        this.configureTestTasks(project, extension);
    }

    private final void configureIntellijDependency(Project project, IntelliJPluginExtension extension, Configuration configuration) {
        configuration.withDependencies(arg_0 -> IntelliJPlugin.configureIntellijDependency$lambda-9(this, project, extension, arg_0));
        File file = Jvm.current().getToolsJar();
        if (file != null) {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File toolsJar = file2;
            boolean bl3 = false;
            Object[] objectArray = new Object[]{toolsJar};
            project.getDependencies().add("runtimeOnly", (Object)project.files(objectArray));
        }
    }

    private final void configurePluginDependencies(Project project, IntelliJPluginExtension extension, Configuration configuration) {
        configuration.withDependencies(arg_0 -> IntelliJPlugin.configurePluginDependencies$lambda-13(this, extension, project, arg_0));
        project.afterEvaluate(arg_0 -> IntelliJPlugin.configurePluginDependencies$lambda-16(extension, this, project, arg_0));
    }

    private final void verifyJavaPluginDependency(IntelliJPluginExtension extension, Project project) {
        boolean hasJavaPluginDependency;
        List plugins = (List)extension.getPlugins().get();
        boolean bl = hasJavaPluginDependency = plugins.contains("java") || plugins.contains("com.intellij.java");
        if (!hasJavaPluginDependency && new File(extension.getIdeaDependency(project).getClasses(), "plugins/java").exists()) {
            Iterable $this$forEach$iv = Utils.sourcePluginXmlFiles(project);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl2 = false;
                Object object = this.context;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                    throw null;
                }
                PluginBean pluginBean = Utils.parsePluginXml(file, (String)object);
                if (pluginBean == null || (object = pluginBean.dependencies) == null) continue;
                Iterable $this$forEach$iv2 = (Iterable)object;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    PluginDependencyBean it = (PluginDependencyBean)element$iv2;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.dependencyId, (Object)"com.intellij.modules.java")) continue;
                    throw new BuildException("The project depends on 'com.intellij.modules.java' module but doesn't declare a compile dependency on it.\nPlease delete 'depends' tag from '" + file.getAbsolutePath() + "' or add 'java' plugin to Gradle dependencies (e.g. intellij { plugins = ['java'] })", null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureBuiltinPluginsDependencies(Project project, DependencySet dependencies, PluginDependencyManager resolver, IntelliJPluginExtension extension) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        PluginDependency p0;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = extension.getUnresolvedPluginDependencies();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (PluginDependency)element$iv$iv;
            boolean bl = false;
            if (!p0.getBuiltin()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (PluginDependency)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = p0.getId();
            collection.add(string);
        }
        List configuredPlugins = (List)destination$iv$iv;
        Iterable $this$forEach$iv = ((IdeaDependency)extension.getIdeaDependency().get()).getPluginsRegistry().collectBuiltinDependencies(configuredPlugins);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            PluginDependency pluginDependency2 = resolver.resolve(project, new PluginDependencyNotation(it, null, null));
            if (pluginDependency2 == null) {
                return;
            }
            PluginDependency plugin = pluginDependency2;
            this.configurePluginDependency(project, plugin, extension, dependencies, resolver);
        }
    }

    private final void configurePluginDependency(Project project, PluginDependency plugin, IntelliJPluginExtension extension, DependencySet dependencies, PluginDependencyManager resolver) {
        Object object = extension.getConfigureDefaultDependencies().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extension.configureDefaultDependencies.get()");
        if (((Boolean)object).booleanValue()) {
            resolver.register(project, plugin, dependencies);
        }
        extension.addPluginDependency(plugin);
        project.getTasks().withType(PrepareSandboxTask.class).configureEach(arg_0 -> IntelliJPlugin.configurePluginDependency$lambda-21(plugin, arg_0));
    }

    private final void configureProjectPluginTasksDependency(Project project, Project dependency) {
        if (dependency.getPlugins().findPlugin(IntelliJPlugin.class) == null) {
            throw new BuildException("Cannot use '" + dependency + "' as a plugin dependency. IntelliJ Plugin is not found." + dependency.getPlugins(), null);
        }
        dependency.getTasks().named("prepareSandbox", arg_0 -> IntelliJPlugin.configureProjectPluginTasksDependency$lambda-23(project, arg_0));
    }

    private final void configureProjectPluginDependency(Project project, Project dependency, DependencySet dependencies, IntelliJPluginExtension extension) {
        if (dependency.getPlugins().findPlugin(IntelliJPlugin.class) == null) {
            throw new BuildException("Cannot use '" + dependency + "' as a plugin dependency. IntelliJ Plugin is not found." + dependency.getPlugins(), null);
        }
        dependencies.add((Object)project.getDependencies().create((Object)dependency));
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        PluginProjectDependency pluginDependency2 = new PluginProjectDependency(dependency, string);
        extension.addPluginDependency(pluginDependency2);
        string = project.getTasks().withType(PrepareSandboxTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.tasks.withType(PrepareSandboxTask::class.java)");
        Iterable $this$forEach$iv = (Iterable)((Object)string);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrepareSandboxTask it = (PrepareSandboxTask)((Object)element$iv);
            boolean bl = false;
            it.configureCompositePlugin(pluginDependency2);
        }
    }

    private final void configurePatchPluginXmlTask(Project project, IntelliJPluginExtension extension) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring patch plugin.xml task", null, 4, null);
        project.getTasks().register("patchPluginXml", PatchPluginXmlTask.class, arg_0 -> IntelliJPlugin.configurePatchPluginXmlTask$lambda-30(project, extension, arg_0));
    }

    private final void configurePrepareSandboxTasks(Project project, IntelliJPluginExtension extension) {
        TaskProvider downloadPluginTaskProvider = project.getTasks().named("downloadRobotServerPlugin");
        IntelliJPlugin.configurePrepareSandboxTask$default(this, project, extension, "prepareSandbox", "", null, 16, null);
        IntelliJPlugin.configurePrepareSandboxTask$default(this, project, extension, "prepareTestingSandbox", "-test", null, 16, null);
        this.configurePrepareSandboxTask(project, extension, "prepareUiTestingSandbox", "-uiTest", (Function1<? super PrepareSandboxTask, Unit>)((Function1)new Function1<PrepareSandboxTask, Unit>((TaskProvider<Task>)downloadPluginTaskProvider){
            final /* synthetic */ TaskProvider<Task> $downloadPluginTaskProvider;
            {
                this.$downloadPluginTaskProvider = $downloadPluginTaskProvider;
                super(1);
            }

            public final void invoke(@NotNull PrepareSandboxTask it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                Object[] objectArray = this.$downloadPluginTaskProvider.get();
                if (objectArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.DownloadRobotServerPluginTask");
                }
                DownloadRobotServerPluginTask downloadPluginTask = (DownloadRobotServerPluginTask)objectArray;
                objectArray = new Object[]{downloadPluginTask.getOutputDir().get()};
                it.from(objectArray);
                objectArray = new Object[]{downloadPluginTask};
                it.dependsOn(objectArray);
            }
        }));
    }

    private final void configureRobotServerDownloadTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring robot-server download Task", null, 4, null);
        project.getTasks().register("downloadRobotServerPlugin", DownloadRobotServerPluginTask.class, arg_0 -> IntelliJPlugin.configureRobotServerDownloadTask$lambda-31(project, arg_0));
    }

    private final void configurePrepareSandboxTask(Project project, IntelliJPluginExtension extension, String taskName, String testSuffix, Function1<? super PrepareSandboxTask, Unit> configure) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring " + taskName + " task", null, 4, null);
        project.getTasks().register(taskName, PrepareSandboxTask.class, arg_0 -> IntelliJPlugin.configurePrepareSandboxTask$lambda-38(project, configure, extension, testSuffix, arg_0));
    }

    static /* synthetic */ void configurePrepareSandboxTask$default(IntelliJPlugin intelliJPlugin, Project project, IntelliJPluginExtension intelliJPluginExtension, String string, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configurePrepareSandboxTask");
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        intelliJPlugin.configurePrepareSandboxTask(project, intelliJPluginExtension, string, string2, (Function1<? super PrepareSandboxTask, Unit>)function1);
    }

    private final void configureRunPluginVerifierTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring run plugin verifier task", null, 4, null);
        project.getTasks().register("runPluginVerifier", RunPluginVerifierTask.class, arg_0 -> IntelliJPlugin.configureRunPluginVerifierTask$lambda-44(project, this, arg_0));
    }

    private final void configurePluginVerificationTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring plugin verification task", null, 4, null);
        project.getTasks().register("verifyPlugin", VerifyPluginTask.class, arg_0 -> IntelliJPlugin.configurePluginVerificationTask$lambda-46(project, arg_0));
    }

    private final void configureRunIdeaTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring run IDE task", null, 4, null);
        project.getTasks().register("runIde", RunIdeTask.class, IntelliJPlugin::configureRunIdeaTask$lambda-47);
    }

    private final void configureRunIdeaForUiTestsTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring run IDE for ui tests task", null, 4, null);
        project.getTasks().register("runIdeForUiTests", RunIdeForUiTestTask.class, IntelliJPlugin::configureRunIdeaForUiTestsTask$lambda-48);
    }

    private final void configureBuildSearchableOptionsTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring build searchable options task", null, 4, null);
        project.getTasks().register("buildSearchableOptions", BuildSearchableOptionsTask.class, arg_0 -> IntelliJPlugin.configureBuildSearchableOptionsTask$lambda-50(project, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareConventionMappingsForRunIdeTask(Project project, IntelliJPluginExtension extension, RunIdeBase task, String prepareSandBoxTaskName) {
        void $this$mapNotNullTo$iv$iv;
        TaskProvider prepareSandboxTaskProvider = project.getTasks().named(prepareSandBoxTaskName);
        Object object = prepareSandboxTaskProvider.get();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.PrepareSandboxTask");
        }
        PrepareSandboxTask prepareSandboxTask = (PrepareSandboxTask)((Object)object);
        String taskContext = Utils.logCategory((Task)task);
        Iterable $this$mapNotNull$iv = Utils.sourcePluginXmlFiles(project);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            PluginBean pluginBean = Utils.parsePluginXml(it, taskContext);
            if ((pluginBean == null ? null : pluginBean.id) == null) continue;
            string = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pluginIds = (List)destination$iv$iv;
        task.getIdeDir().convention(project.provider(() -> IntelliJPlugin.prepareConventionMappingsForRunIdeTask$lambda-52(extension, project)));
        task.getRequiredPluginIds().convention(project.provider(() -> IntelliJPlugin.prepareConventionMappingsForRunIdeTask$lambda-53(pluginIds)));
        task.getConfigDir().convention(project.provider(() -> IntelliJPlugin.prepareConventionMappingsForRunIdeTask$lambda-54(project, prepareSandboxTask)));
        task.getPluginsDir().convention(project.provider(() -> IntelliJPlugin.prepareConventionMappingsForRunIdeTask$lambda-55(prepareSandboxTask, project)));
        task.getSystemDir().convention(project.provider(() -> IntelliJPlugin.prepareConventionMappingsForRunIdeTask$lambda-56(project, extension)));
        task.getAutoReloadPlugins().convention(project.provider(() -> IntelliJPlugin.prepareConventionMappingsForRunIdeTask$lambda-57(task)));
        task.getProjectWorkingDir().convention(project.provider(() -> IntelliJPlugin.prepareConventionMappingsForRunIdeTask$lambda-58(project, task)));
        task.getProjectExecutable().convention(project.provider(() -> IntelliJPlugin.prepareConventionMappingsForRunIdeTask$lambda-63(project, extension, taskContext, task)));
    }

    private final void configureJarSearchableOptionsTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring jar searchable options task", null, 4, null);
        File buildDir = project.getBuildDir();
        project.getTasks().register("jarSearchableOptions", JarSearchableOptionsTask.class, arg_0 -> IntelliJPlugin.configureJarSearchableOptionsTask$lambda-65(project, buildDir, arg_0));
    }

    private final void configureInstrumentation(Project project, IntelliJPluginExtension extension) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring compile tasks", null, 4, null);
        Object object = project.getExtensions().findByName("sourceSets");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.SourceSetContainer");
        }
        SourceSetContainer sourceSets = (SourceSetContainer)object;
        Provider instrumentCode2 = project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-66(extension));
        Iterable $this$forEach$iv = (Iterable)sourceSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SourceSet sourceSet = (SourceSet)element$iv;
            boolean bl = false;
            TaskProvider instrumentTask = project.getTasks().register(sourceSet.getTaskName("instrument", "code"), IntelliJInstrumentCodeTask.class, arg_0 -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77(project, sourceSet, extension, instrumentCode2, arg_0));
            TaskContainer taskContainer = project.getTasks();
            Object[] objectArray = instrumentTask.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"instrumentTask.name");
            TaskProvider updateTask = taskContainer.register(Intrinsics.stringPlus((String)"post", (Object)StringsKt.capitalize((String)objectArray)), arg_0 -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-80(sourceSet, instrumentTask, instrumentCode2, arg_0));
            objectArray = new Object[]{updateTask};
            sourceSet.compiledBy(objectArray);
        }
    }

    private final void configureTestTasks(Project project, IntelliJPluginExtension extension) {
        Object[] it;
        File $this$mapNotNullTo$iv$iv;
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring tests tasks", null, 4, null);
        TaskCollection taskCollection = project.getTasks().withType(Test.class);
        if (taskCollection == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.TaskCollection<@[FlexibleNullability] org.gradle.api.tasks.testing.Test?>");
        }
        TaskCollection testTasks = taskCollection;
        TaskProvider prepareTestingSandboxTaskProvider = project.getTasks().named("prepareTestingSandbox");
        TaskProvider runIdeTaskProvider = project.getTasks().named("runIde");
        Object object = runIdeTaskProvider.get();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.RunIdeTask");
        }
        RunIdeTask runIdeTask = (RunIdeTask)((Object)object);
        Iterable $this$mapNotNull$iv = Utils.sourcePluginXmlFiles(project);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv322 = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl10 = false;
            it = (Object[])element$iv$iv;
            boolean bl2 = false;
            String string3 = this.context;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                throw null;
            }
            PluginBean pluginBean = Utils.parsePluginXml((File)it, string3);
            if ((pluginBean == null ? null : pluginBean.id) == null) continue;
            string2 = string2;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv322.add(it$iv$iv);
        }
        List pluginIds = (List)destination$iv$iv322;
        String sandboxDir = (String)extension.getSandboxDir().get();
        $this$mapNotNullTo$iv$iv = project.file((Object)Intrinsics.stringPlus((String)sandboxDir, (Object)"/config-test"));
        boolean destination$iv$iv322 = false;
        $i$f$mapNotNullTo22 = false;
        File $this$configureTestTasks_u24lambda_u2d862 = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        $this$configureTestTasks_u24lambda_u2d862.mkdirs();
        File configDirectory = $this$mapNotNullTo$iv$iv;
        File destination$iv$iv322 = project.file((Object)Intrinsics.stringPlus((String)sandboxDir, (Object)"/system-test"));
        $i$f$mapNotNullTo22 = false;
        boolean $this$configureTestTasks_u24lambda_u2d862 = false;
        File $this$configureTestTasks_u24lambda_u2d84 = destination$iv$iv322;
        boolean bl6 = false;
        $this$configureTestTasks_u24lambda_u2d84.mkdirs();
        File systemDirectory = destination$iv$iv322;
        File $i$f$mapNotNullTo22 = project.file((Object)Intrinsics.stringPlus((String)sandboxDir, (Object)"/plugins-test"));
        $this$configureTestTasks_u24lambda_u2d862 = false;
        boolean bl7 = false;
        File $this$configureTestTasks_u24lambda_u2d85 = $i$f$mapNotNullTo22;
        boolean bl8 = false;
        $this$configureTestTasks_u24lambda_u2d85.mkdirs();
        File pluginsDirectory = $i$f$mapNotNullTo22;
        Iterable $this$forEach$iv = (Iterable)testTasks;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Test task = (Test)element$iv;
            boolean bl9 = false;
            task.setEnableAssertions(true);
            task.systemProperty("idea.use.core.classloader.for.plugin.path", (Object)"true");
            task.systemProperty("idea.use.core.classloader.for", (Object)CollectionsKt.joinToString$default((Iterable)pluginIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            task.getOutputs().dir((Object)project.provider(() -> IntelliJPlugin.configureTestTasks$lambda-91$lambda-87(systemDirectory))).withPropertyName("System directory");
            task.getInputs().dir((Object)project.provider(() -> IntelliJPlugin.configureTestTasks$lambda-91$lambda-89(configDirectory))).withPropertyName("Config Directory").withPathSensitivity(PathSensitivity.RELATIVE);
            Object[] bl10 = new Object[]{((Task)prepareTestingSandboxTaskProvider.get()).getInputs().getFiles()};
            task.getInputs().files(bl10).withPropertyName("Plugins directory").withPathSensitivity(PathSensitivity.RELATIVE).withNormalizer(ClasspathNormalizer.class);
            IdeaDependency ideaDependency = extension.getIdeaDependency(project);
            it = new Object[]{ideaDependency.getClasses() + "/lib/resources.jar", ideaDependency.getClasses() + "/lib/idea.jar"};
            ConfigurableFileCollection ideaDependencyLibraries = project.files(it);
            Provider ideDirectory = project.provider(() -> IntelliJPlugin.configureTestTasks$lambda-91$lambda-90(runIdeTask));
            task.doFirst((Action)new Action<Task>(task, (Provider<File>)ideDirectory, ideaDependencyLibraries, configDirectory, systemDirectory, pluginsDirectory, (List<String>)pluginIds, ideaDependency){
                final /* synthetic */ Test $task;
                final /* synthetic */ Provider<File> $ideDirectory;
                final /* synthetic */ ConfigurableFileCollection $ideaDependencyLibraries;
                final /* synthetic */ File $configDirectory;
                final /* synthetic */ File $systemDirectory;
                final /* synthetic */ File $pluginsDirectory;
                final /* synthetic */ List<String> $pluginIds;
                final /* synthetic */ IdeaDependency $ideaDependency;
                {
                    this.$task = $task;
                    this.$ideDirectory = $ideDirectory;
                    this.$ideaDependencyLibraries = $ideaDependencyLibraries;
                    this.$configDirectory = $configDirectory;
                    this.$systemDirectory = $systemDirectory;
                    this.$pluginsDirectory = $pluginsDirectory;
                    this.$pluginIds = $pluginIds;
                    this.$ideaDependency = $ideaDependency;
                }

                public void execute(@NotNull Task t) {
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    Object object = this.$task;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task");
                    JavaForkOptions javaForkOptions = (JavaForkOptions)object;
                    object = this.$task.getJvmArgs();
                    this.$task.setJvmArgs(Utils.getIdeJvmArgs(javaForkOptions, (List<String>)(object == null ? CollectionsKt.emptyList() : object), (File)this.$ideDirectory.get()));
                    object = this.$task;
                    object.setClasspath(object.getClasspath().plus((FileCollection)this.$ideaDependencyLibraries));
                    object = this.$configDirectory;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"configDirectory");
                    Object object2 = object;
                    object = this.$systemDirectory;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"systemDirectory");
                    Object object3 = object;
                    object = this.$pluginsDirectory;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pluginsDirectory");
                    this.$task.systemProperties(Utils.getIdeaSystemProperties((File)object2, (File)object3, (File)object, this.$pluginIds));
                    Object[] objectArray = IdeVersion.createIdeVersion((String)this.$ideaDependency.getBuildNumber());
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"createIdeVersion(ideaDependency.buildNumber)");
                    Object[] ideVersion = objectArray;
                    if (ideVersion.getBaselineVersion() >= 193) {
                        String string;
                        objectArray = this.$pluginsDirectory.listFiles();
                        this.$task.systemProperty("plugin.path", (Object)(objectArray == null ? "" : ((string = ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)Intrinsics.stringPlus((String)File.pathSeparator, (Object)","), null, null, (int)0, null, (Function1)configureTestTasks.1.execute.1.INSTANCE, (int)30, null)) == null ? "" : string)));
                    }
                }
            });
        }
    }

    private final void configureBuildPluginTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring building plugin task", null, 4, null);
        TaskProvider prepareSandboxTaskProvider = project.getTasks().named("prepareSandbox");
        Object object = prepareSandboxTaskProvider.get();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.PrepareSandboxTask");
        }
        PrepareSandboxTask prepareSandboxTask = (PrepareSandboxTask)((Object)object);
        TaskProvider jarSearchableOptionsTaskProvider = project.getTasks().named("jarSearchableOptions");
        Object object2 = jarSearchableOptionsTaskProvider.get();
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.JarSearchableOptionsTask");
        }
        JarSearchableOptionsTask jarSearchableOptionsTask = (JarSearchableOptionsTask)((Object)object2);
        project.getTasks().register("buildPlugin", Zip.class, arg_0 -> IntelliJPlugin.configureBuildPluginTask$lambda-97(project, jarSearchableOptionsTask, prepareSandboxTask, arg_0));
    }

    private final void configureSignPluginTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring sign plugin task", null, 4, null);
        TaskProvider buildPluginTaskProvider = project.getTasks().named("buildPlugin");
        Object object = buildPluginTaskProvider.get();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.bundling.Zip");
        }
        Zip buildPluginTask = (Zip)object;
        File inputFile = ((RegularFile)buildPluginTask.getArchiveFile().get()).getAsFile();
        String string2 = inputFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"inputFile.path");
        String string3 = inputFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"inputFile.path");
        int n = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'.', (int)0, (boolean)false, (int)6, null);
        int n2 = 0;
        String string4 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String inputFileExtension = string4;
        String string5 = inputFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"inputFile.path");
        n2 = 0;
        String string6 = inputFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"inputFile.path");
        int n3 = StringsKt.lastIndexOf$default((CharSequence)string6, (char)'.', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        String string7 = string5.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String inputFileWithoutExtension = string7;
        String outputFilePath = inputFileWithoutExtension + "-signed" + inputFileExtension;
        project.getTasks().register("signPlugin", SignPluginTask.class, arg_0 -> IntelliJPlugin.configureSignPluginTask$lambda-101(project, this, outputFilePath, arg_0));
    }

    private final void configurePublishPluginTask(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring publish plugin task", null, 4, null);
        TaskProvider buildPluginTaskProvider = project.getTasks().named("buildPlugin");
        TaskProvider verifyPluginTaskProvider = project.getTasks().named("verifyPlugin");
        TaskProvider signPluginTaskProvider = project.getTasks().named("signPlugin");
        project.getTasks().register("publishPlugin", PublishPluginTask.class, arg_0 -> IntelliJPlugin.configurePublishPluginTask$lambda-105(project, buildPluginTaskProvider, verifyPluginTaskProvider, signPluginTaskProvider, this, arg_0));
    }

    private final void configureProcessResources(Project project) {
        String string = this.context;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string, "Configuring resources task", null, 4, null);
        TaskProvider patchPluginXmlTaskProvider = project.getTasks().named("patchPluginXml");
        project.getTasks().named("processResources", arg_0 -> IntelliJPlugin.configureProcessResources$lambda-107(patchPluginXmlTaskProvider, arg_0));
    }

    private final File resolveBuildTaskOutput(Project project) {
        File file;
        TaskProvider buildPluginTaskProvider = project.getTasks().named("buildPlugin");
        Object object = buildPluginTaskProvider.get();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.bundling.Zip");
        }
        Zip buildPluginTask = (Zip)object;
        if ((object = (RegularFile)buildPluginTask.getArchiveFile().getOrNull()) == null) {
            file = null;
        } else {
            File file2 = object.getAsFile();
            if (file2 == null) {
                file = null;
            } else {
                File file3 = file2;
                boolean bl = false;
                boolean bl2 = false;
                File it = file3;
                boolean bl3 = false;
                file = it.exists() ? file3 : null;
            }
        }
        return file;
    }

    private static final String apply$lambda-2$lambda-0(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return $project.getName();
    }

    private static final String apply$lambda-2$lambda-1(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return new File($project.getBuildDir(), "idea-sandbox").getAbsolutePath();
    }

    private static final void configureConfigurations$lambda-3(Project $project, DependencySet it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        DependencyHandler dependencyHandler = $project.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"project.dependencies");
        it.add((Object)Utils.create$default(dependencyHandler, "org.jetbrains", "annotations", "21.0.0", null, null, null, 56, null));
    }

    private static final void configureTasks$lambda-4(IntelliJPlugin this$0, Project $project, IntelliJPluginExtension $extension, Task it) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        if (it instanceof RunIdeBase) {
            this$0.prepareConventionMappingsForRunIdeTask($project, $extension, (RunIdeBase)it, "prepareSandbox");
        }
        if (it instanceof RunIdeForUiTestTask) {
            this$0.prepareConventionMappingsForRunIdeTask($project, $extension, (RunIdeBase)it, "prepareUiTestingSandbox");
        }
    }

    private static final void configureTasks$lambda-6(IntelliJPlugin this$0, IntelliJPluginExtension $extension, Project it) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
        this$0.configureProjectAfterEvaluate(it, $extension);
    }

    private static final void configureIntellijDependency$lambda-9(IntelliJPlugin this$0, Project $project, IntelliJPluginExtension $extension, DependencySet dependencies) {
        IdeaDependency ideaDependency;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        String string2 = this$0.context;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string2, "Configuring IDE dependency", null, 4, null);
        Object[] objectArray = new Object[3];
        objectArray[0] = $extension.getIntellijRepository().get();
        Object object = (String)$extension.getIdeaDependencyCachePath().getOrNull();
        objectArray[1] = object == null ? "" : object;
        object = this$0.context;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        objectArray[2] = object;
        IdeaDependencyManager resolver = (IdeaDependencyManager)$project.getObjects().newInstance(IdeaDependencyManager.class, objectArray);
        String localPath = (String)$extension.getLocalPath().getOrNull();
        if (localPath == null) {
            string = this$0.context;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                throw null;
            }
            Utils.info$default(string, "Using IDE from remote repository", null, 4, null);
            String string3 = $extension.getVersionNumber();
            String version = string3 == null ? "LATEST-EAP-SNAPSHOT" : string3;
            List extraDependencies = (List)$extension.getExtraDependencies().get();
            String string4 = $extension.getVersionType();
            Object object2 = $extension.getDownloadSources().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"extension.downloadSources.get()");
            boolean bl = (Boolean)object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)extraDependencies, (String)"extraDependencies");
            ideaDependency = resolver.resolveRemote($project, version, string4, bl, extraDependencies);
        } else {
            if ($extension.getVersion().getOrNull() != null) {
                string = this$0.context;
                if (string == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                    throw null;
                }
                Utils.warn$default(string, "Both 'localPath' and 'version' specified, second would be ignored", null, 4, null);
            }
            if ((string = this$0.context) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                throw null;
            }
            Utils.info$default(string, Intrinsics.stringPlus((String)"Using path to locally installed IDE: ", (Object)localPath), null, 4, null);
            ideaDependency = resolver.resolveLocal($project, localPath, (String)$extension.getLocalSourcesPath().getOrNull());
        }
        IdeaDependency ideaDependency2 = ideaDependency;
        $extension.getIdeaDependency().set((Object)ideaDependency2);
        object = $extension.getConfigureDefaultDependencies().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extension.configureDefaultDependencies.get()");
        if (((Boolean)object).booleanValue()) {
            object = this$0.context;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                throw null;
            }
            Utils.info$default((String)object, Intrinsics.stringPlus((String)ideaDependency2.getBuildNumber(), (Object)" is used for building"), null, 4, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencies, (String)"dependencies");
            resolver.register($project, ideaDependency2, dependencies);
            if (!ideaDependency2.getExtraDependencies().isEmpty()) {
                object = this$0.context;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                    throw null;
                }
                Utils.info$default((String)object, "Note: " + ideaDependency2.getBuildNumber() + " extra dependencies (" + ideaDependency2.getExtraDependencies() + ") should be applied manually", null, 4, null);
            }
        } else {
            object = this$0.context;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                throw null;
            }
            Utils.info$default((String)object, "IDE " + ideaDependency2.getBuildNumber() + " dependencies are applied manually", null, 4, null);
        }
    }

    private static final void configurePluginDependencies$lambda-13(IntelliJPlugin this$0, IntelliJPluginExtension $extension, Project $project, DependencySet dependencies) {
        String string;
        Object it;
        Object element$iv;
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        String string2 = this$0.context;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        Utils.info$default(string2, "Configuring plugin dependencies", null, 4, null);
        IdeVersion ideVersion = IdeVersion.createIdeVersion((String)$extension.getIdeaDependency($project).getBuildNumber());
        Intrinsics.checkExpressionValueIsNotNull((Object)ideVersion, (String)"createIdeVersion(extension.getIdeaDependency(project).buildNumber)");
        IdeVersion ideVersion2 = ideVersion;
        Object object = new Object[4];
        object[0] = $project.getGradle().getGradleUserHomeDir().getAbsolutePath();
        object[1] = $extension.getIdeaDependency($project);
        object[2] = $extension.getPluginsRepositories();
        String string3 = this$0.context;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            throw null;
        }
        object[3] = string3;
        PluginDependencyManager resolver = (PluginDependencyManager)$project.getObjects().newInstance(PluginDependencyManager.class, object);
        object = $extension.getPlugins().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extension.plugins.get()");
        Object $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = element$iv;
            boolean bl = false;
            string = this$0.context;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                throw null;
            }
            Utils.info$default(string, Intrinsics.stringPlus((String)"Configuring plugin: ", it), null, 4, null);
            if (it instanceof Project) {
                Project project = (Project)it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dependencies, (String)"dependencies");
                this$0.configureProjectPluginDependency($project, project, dependencies, $extension);
                continue;
            }
            PluginDependencyNotation pluginDependency2 = PluginDependencyNotation.Companion.parsePluginDependencyString(it.toString());
            CharSequence charSequence = pluginDependency2.getId();
            boolean bl2 = false;
            if (charSequence.length() == 0) {
                throw new BuildException(Intrinsics.stringPlus((String)"Failed to resolve plugin: ", it), null);
            }
            PluginDependency pluginDependency3 = resolver.resolve($project, pluginDependency2);
            if (pluginDependency3 == null) {
                throw new BuildException(Intrinsics.stringPlus((String)"Failed to resolve plugin ", (Object)it), null);
            }
            PluginDependency plugin = pluginDependency3;
            if (!plugin.isCompatible(ideVersion2)) {
                throw new BuildException("Plugin '" + it + "' is not compatible to: " + ideVersion2.asString(), null);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencies, (String)"dependencies");
            Intrinsics.checkExpressionValueIsNotNull((Object)resolver, (String)"resolver");
            this$0.configurePluginDependency($project, plugin, $extension, dependencies, resolver);
        }
        $this$forEach$iv = $extension.getConfigureDefaultDependencies().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv, (String)"extension.configureDefaultDependencies.get()");
        if (((Boolean)$this$forEach$iv).booleanValue()) {
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencies, (String)"dependencies");
            Intrinsics.checkExpressionValueIsNotNull((Object)resolver, (String)"resolver");
            this$0.configureBuiltinPluginsDependencies($project, dependencies, resolver, $extension);
        }
        this$0.verifyJavaPluginDependency($extension, $project);
        $this$forEach$iv = $extension.getPluginsRepositories();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            it = (PluginsRepository)element$iv;
            boolean bl = false;
            string = this$0.context;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                throw null;
            }
            it.postResolve($project, string);
        }
    }

    private static final void configurePluginDependencies$lambda-16$lambda-15$lambda-14(IntelliJPlugin this$0, Project $project, Project $dependency, Project it) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$dependency, (String)"$dependency");
        this$0.configureProjectPluginTasksDependency($project, $dependency);
    }

    /*
     * WARNING - void declaration
     */
    private static final void configurePluginDependencies$lambda-16(IntelliJPluginExtension $extension, IntelliJPlugin this$0, Project $project, Project it) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Object object = $extension.getPlugins().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extension.plugins.get()");
        Iterable $this$filterIsInstance$iv = (Iterable)object;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project dependency = (Project)element$iv;
            boolean bl = false;
            if (dependency.getState().getExecuted()) {
                this$0.configureProjectPluginTasksDependency($project, dependency);
                continue;
            }
            dependency.afterEvaluate(arg_0 -> IntelliJPlugin.configurePluginDependencies$lambda-16$lambda-15$lambda-14(this$0, $project, dependency, arg_0));
        }
    }

    private static final void configurePluginDependency$lambda-21(PluginDependency $plugin, PrepareSandboxTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$plugin, (String)"$plugin");
        it.configureExternalPlugin($plugin);
    }

    private static final void configureProjectPluginTasksDependency$lambda-23(Project $project, Task dependencySandboxTask) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        TaskCollection taskCollection = $project.getTasks().withType(PrepareSandboxTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)taskCollection, (String)"project.tasks.withType(PrepareSandboxTask::class.java)");
        Iterable $this$forEach$iv = (Iterable)taskCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PrepareSandboxTask it = (PrepareSandboxTask)((Object)element$iv);
            boolean bl = false;
            Object[] objectArray = new Object[]{dependencySandboxTask};
            it.dependsOn(objectArray);
        }
    }

    private static final String configurePatchPluginXmlTask$lambda-30$lambda-25(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return $project.getVersion().toString();
    }

    private static final List configurePatchPluginXmlTask$lambda-30$lambda-26(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return Utils.sourcePluginXmlFiles($project);
    }

    private static final File configurePatchPluginXmlTask$lambda-30$lambda-27(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return new File($project.getBuildDir(), "patchedPluginXmlFiles");
    }

    private static final String configurePatchPluginXmlTask$lambda-30$lambda-28(IntelliJPluginExtension $extension, Project $project) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Object object = $extension.getUpdateSinceUntilBuild().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extension.updateSinceUntilBuild.get()");
        if (((Boolean)object).booleanValue()) {
            IdeVersion ideVersion = IdeVersion.createIdeVersion((String)$extension.getIdeaDependency($project).getBuildNumber());
            Intrinsics.checkExpressionValueIsNotNull((Object)ideVersion, (String)"createIdeVersion(extension.getIdeaDependency(project).buildNumber)");
            IdeVersion ideVersion2 = ideVersion;
            string = "" + ideVersion2.getBaselineVersion() + '.' + ideVersion2.getBuild();
        } else {
            string = null;
        }
        return string;
    }

    private static final String configurePatchPluginXmlTask$lambda-30$lambda-29(IntelliJPluginExtension $extension, PatchPluginXmlTask $it, Project $project) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Object object = $extension.getUpdateSinceUntilBuild().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extension.updateSinceUntilBuild.get()");
        if (((Boolean)object).booleanValue()) {
            object = $extension.getSameSinceUntilBuild().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extension.sameSinceUntilBuild.get()");
            if (((Boolean)object).booleanValue()) {
                string = Intrinsics.stringPlus((String)((String)$it.getSinceBuild().get()), (Object)".*");
            } else {
                IdeVersion ideVersion = IdeVersion.createIdeVersion((String)$extension.getIdeaDependency($project).getBuildNumber());
                Intrinsics.checkExpressionValueIsNotNull((Object)ideVersion, (String)"createIdeVersion(extension.getIdeaDependency(project).buildNumber)");
                IdeVersion ideVersion2 = ideVersion;
                string = ideVersion2.getBaselineVersion() + ".*";
            }
        } else {
            string = null;
        }
        return string;
    }

    private static final void configurePatchPluginXmlTask$lambda-30(Project $project, IntelliJPluginExtension $extension, PatchPluginXmlTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        it.setGroup("intellij");
        it.setDescription("Patch plugin xml files with corresponding since/until build numbers and version attributes");
        it.getVersion().convention($project.provider(() -> IntelliJPlugin.configurePatchPluginXmlTask$lambda-30$lambda-25($project)));
        it.getPluginXmlFiles().convention($project.provider(() -> IntelliJPlugin.configurePatchPluginXmlTask$lambda-30$lambda-26($project)));
        it.getDestinationDir().convention($project.getLayout().dir($project.provider(() -> IntelliJPlugin.configurePatchPluginXmlTask$lambda-30$lambda-27($project))));
        it.getSinceBuild().convention($project.provider(() -> IntelliJPlugin.configurePatchPluginXmlTask$lambda-30$lambda-28($extension, $project)));
        it.getUntilBuild().convention($project.provider(() -> IntelliJPlugin.configurePatchPluginXmlTask$lambda-30$lambda-29($extension, it, $project)));
    }

    private static final void configureRobotServerDownloadTask$lambda-31(Project $project, DownloadRobotServerPluginTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        it.setGroup("intellij");
        it.setDescription("Download robot-server plugin.");
        it.getVersion().convention((Object)"latest");
        it.getOutputDir().convention($project.getLayout().getProjectDirectory().dir($project.getBuildDir() + "/robotServerPlugin"));
    }

    private static final String configurePrepareSandboxTask$lambda-38$lambda-32(IntelliJPluginExtension $extension) {
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        return (String)$extension.getPluginName().get();
    }

    private static final File configurePrepareSandboxTask$lambda-38$lambda-33(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        TaskProvider jarTaskProvider = $project.getTasks().named("jar");
        Object object = jarTaskProvider.get();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.tasks.bundling.Zip");
        }
        Zip jarTask = (Zip)object;
        return (object = (RegularFile)jarTask.getArchiveFile().getOrNull()) == null ? null : object.getAsFile();
    }

    private static final File configurePrepareSandboxTask$lambda-38$lambda-34(Project $project, IntelliJPluginExtension $extension, String $testSuffix) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$testSuffix, (String)"$testSuffix");
        return $project.file((Object)($extension.getSandboxDir().get() + "/plugins" + $testSuffix));
    }

    private static final String configurePrepareSandboxTask$lambda-38$lambda-35(IntelliJPluginExtension $extension, String $testSuffix) {
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$testSuffix, (String)"$testSuffix");
        return $extension.getSandboxDir().get() + "/config" + $testSuffix;
    }

    private static final ConfigurableFileCollection configurePrepareSandboxTask$lambda-38$lambda-36(Project $project, IntelliJPluginExtension $extension) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Object[] objectArray = new Object[]{$extension.getIdeaDependency($project).getJarFiles()};
        return $project.files(objectArray);
    }

    private static final Set configurePrepareSandboxTask$lambda-38$lambda-37(IntelliJPluginExtension $extension, Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return $extension.getPluginDependenciesList($project);
    }

    private static final void configurePrepareSandboxTask$lambda-38(Project $project, Function1 $configure, IntelliJPluginExtension $extension, String $testSuffix, PrepareSandboxTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$testSuffix, (String)"$testSuffix");
        it.setGroup("intellij");
        it.setDescription("Prepare sandbox directory with installed plugin and its dependencies.");
        it.getPluginName().convention($project.provider(() -> IntelliJPlugin.configurePrepareSandboxTask$lambda-38$lambda-32($extension)));
        it.getPluginJar().convention($project.getLayout().file($project.provider(() -> IntelliJPlugin.configurePrepareSandboxTask$lambda-38$lambda-33($project))));
        it.getDefaultDestinationDir().convention($project.provider(() -> IntelliJPlugin.configurePrepareSandboxTask$lambda-38$lambda-34($project, $extension, $testSuffix)));
        it.getConfigDir().convention($project.provider(() -> IntelliJPlugin.configurePrepareSandboxTask$lambda-38$lambda-35($extension, $testSuffix)));
        it.getLibrariesToIgnore().convention($project.provider(() -> IntelliJPlugin.configurePrepareSandboxTask$lambda-38$lambda-36($project, $extension)));
        it.getPluginDependencies().convention($project.provider(() -> IntelliJPlugin.configurePrepareSandboxTask$lambda-38$lambda-37($extension, $project)));
        Object[] objectArray = new Object[]{"jar"};
        it.dependsOn(objectArray);
        objectArray = new Object[]{$project.getConfigurations().getByName("runtimeClasspath")};
        it.dependsOn(objectArray);
        objectArray = $configure;
        if (objectArray != null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)it), (String)"it");
            objectArray.invoke((Object)it);
        }
    }

    private static final File configureRunPluginVerifierTask$lambda-44$lambda-39(IntelliJPlugin this$0, Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return this$0.resolveBuildTaskOutput($project);
    }

    private static final String configureRunPluginVerifierTask$lambda-44$lambda-40(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return $project.getBuildDir() + "/reports/pluginVerifier";
    }

    private static final String configureRunPluginVerifierTask$lambda-44$lambda-41(RunPluginVerifierTask $it) {
        return ((Object)$it.ideDownloadDir()).toString();
    }

    private static final Directory configureRunPluginVerifierTask$lambda-44$lambda-42(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        TaskProvider runIdeTaskProvider = $project.getTasks().named("runIde");
        Object object = runIdeTaskProvider.get();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.RunIdeTask");
        }
        RunIdeTask runIdeTask = (RunIdeTask)((Object)object);
        return (Directory)runIdeTask.getIdeDir().get();
    }

    private static final boolean configureRunPluginVerifierTask$lambda-44$lambda-43(Task it) {
        return false;
    }

    private static final void configureRunPluginVerifierTask$lambda-44(Project $project, IntelliJPlugin this$0, RunPluginVerifierTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        it.setGroup("intellij");
        it.setDescription("Runs the IntelliJ Plugin Verifier tool to check the binary compatibility with specified IntelliJ IDE builds.");
        it.getFailureLevel().convention((Iterable)EnumSet.of((Enum)RunPluginVerifierTask.FailureLevel.INVALID_PLUGIN));
        it.getVerifierVersion().convention((Object)"latest");
        it.getDistributionFile().convention($project.getLayout().file($project.provider(() -> IntelliJPlugin.configureRunPluginVerifierTask$lambda-44$lambda-39(this$0, $project))));
        it.getVerificationReportsDir().convention($project.provider(() -> IntelliJPlugin.configureRunPluginVerifierTask$lambda-44$lambda-40($project)));
        it.getDownloadDir().convention($project.provider(() -> IntelliJPlugin.configureRunPluginVerifierTask$lambda-44$lambda-41(it)));
        it.getTeamCityOutputFormat().convention((Object)false);
        it.getSubsystemsToCheck().convention((Object)"all");
        it.getIdeDir().convention($project.provider(() -> IntelliJPlugin.configureRunPluginVerifierTask$lambda-44$lambda-42($project)));
        Object[] objectArray = new Object[]{"buildPlugin"};
        it.dependsOn(objectArray);
        objectArray = new Object[]{"verifyPlugin"};
        it.dependsOn(objectArray);
        it.getOutputs().upToDateWhen(IntelliJPlugin::configureRunPluginVerifierTask$lambda-44$lambda-43);
    }

    private static final Directory configurePluginVerificationTask$lambda-46$lambda-45(Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        TaskProvider prepareSandboxTaskProvider = $project.getTasks().named("prepareSandbox");
        Object object = prepareSandboxTaskProvider.get();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.PrepareSandboxTask");
        }
        PrepareSandboxTask prepareSandboxTask = (PrepareSandboxTask)((Object)object);
        String path = new File(prepareSandboxTask.getDestinationDir(), (String)prepareSandboxTask.getPluginName().get()).getPath();
        return $project.getLayout().getProjectDirectory().dir(path);
    }

    private static final void configurePluginVerificationTask$lambda-46(Project $project, VerifyPluginTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        it.setGroup("intellij");
        it.setDescription("Validates completeness and contents of plugin.xml descriptors as well as plugin\u2019s archive structure.");
        it.getPluginDir().convention($project.provider(() -> IntelliJPlugin.configurePluginVerificationTask$lambda-46$lambda-45($project)));
        Object[] objectArray = new Object[]{"prepareSandbox"};
        it.dependsOn(objectArray);
    }

    private static final void configureRunIdeaTask$lambda-47(RunIdeTask it) {
        it.setGroup("intellij");
        it.setDescription("Runs Intellij IDEA with installed plugin.");
        Object[] objectArray = new Object[]{"prepareSandbox"};
        it.dependsOn(objectArray);
    }

    private static final void configureRunIdeaForUiTestsTask$lambda-48(RunIdeForUiTestTask it) {
        it.setGroup("intellij");
        it.setDescription("Runs Intellij IDEA with installed plugin and robot-server plugin for ui tests.");
        Object[] objectArray = new Object[]{"prepareUiTestingSandbox"};
        it.dependsOn(objectArray);
    }

    private static final boolean configureBuildSearchableOptionsTask$lambda-50$lambda-49(BuildSearchableOptionsTask $it, Task $noName_0) {
        Object object = ((Directory)$it.getIdeDir().get()).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.ideDir.get().asFile");
        String number = Utils.ideBuildNumber((File)object);
        object = new char[1];
        object[0] = 45;
        return Version.Companion.parse((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)number, (char[])object, (boolean)false, (int)0, (int)6, null))).compareTo(Version.Companion.parse("191.2752")) >= 0;
    }

    private static final void configureBuildSearchableOptionsTask$lambda-50(Project $project, BuildSearchableOptionsTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        it.setGroup("intellij");
        it.setDescription("Builds searchable options for plugin.");
        Object[] objectArray = new String[]{$project.getBuildDir() + "/searchableOptions", "true"};
        it.setArgs((List<String>)CollectionsKt.listOf((Object[])objectArray));
        it.getOutputs().dir((Object)($project.getBuildDir() + "/searchableOptions"));
        objectArray = new Object[]{"prepareSandbox"};
        it.dependsOn(objectArray);
        it.onlyIf(arg_0 -> IntelliJPlugin.configureBuildSearchableOptionsTask$lambda-50$lambda-49(it, arg_0));
    }

    private static final Directory prepareConventionMappingsForRunIdeTask$lambda-52(IntelliJPluginExtension $extension, Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        String path = $extension.getIdeaDependency($project).getClasses().getPath();
        return $project.getLayout().getProjectDirectory().dir(path);
    }

    private static final List prepareConventionMappingsForRunIdeTask$lambda-53(List $pluginIds) {
        Intrinsics.checkParameterIsNotNull((Object)$pluginIds, (String)"$pluginIds");
        return $pluginIds;
    }

    private static final File prepareConventionMappingsForRunIdeTask$lambda-54(Project $project, PrepareSandboxTask $prepareSandboxTask) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)$prepareSandboxTask), (String)"$prepareSandboxTask");
        return $project.file($prepareSandboxTask.getConfigDir().get());
    }

    private static final Directory prepareConventionMappingsForRunIdeTask$lambda-55(PrepareSandboxTask $prepareSandboxTask, Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$prepareSandboxTask), (String)"$prepareSandboxTask");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        String path = $prepareSandboxTask.getDestinationDir().getPath();
        return $project.getLayout().getProjectDirectory().dir(path);
    }

    private static final File prepareConventionMappingsForRunIdeTask$lambda-56(Project $project, IntelliJPluginExtension $extension) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        return $project.file((Object)Intrinsics.stringPlus((String)((String)$extension.getSandboxDir().get()), (Object)"/system"));
    }

    private static final Boolean prepareConventionMappingsForRunIdeTask$lambda-57(RunIdeBase $task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$task), (String)"$task");
        Object object = ((Directory)$task.getIdeDir().get()).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"task.ideDir.get().asFile");
        String number = Utils.ideBuildNumber((File)object);
        object = new char[1];
        object[0] = 45;
        return Version.Companion.parse((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)number, (char[])object, (boolean)false, (int)0, (int)6, null))).compareTo(Version.Companion.parse("202.0")) >= 0;
    }

    private static final File prepareConventionMappingsForRunIdeTask$lambda-58(Project $project, RunIdeBase $task) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)$task), (String)"$task");
        return $project.file((Object)(((Directory)$task.getIdeDir().get()).getAsFile() + "/bin/"));
    }

    private static final String prepareConventionMappingsForRunIdeTask$lambda-63(Project $project, IntelliJPluginExtension $extension, String $taskContext, RunIdeBase $task) {
        Object object;
        boolean bl;
        Object object2;
        boolean bl2;
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$taskContext, (String)"$taskContext");
        Intrinsics.checkParameterIsNotNull((Object)((Object)$task), (String)"$task");
        Object[] objectArray = new Object[3];
        String string3 = (String)$extension.getJreRepository().getOrNull();
        objectArray[0] = string3 == null ? "" : string3;
        objectArray[1] = $project.getGradle().getStartParameter().isOffline();
        objectArray[2] = $taskContext;
        JbrResolver jbrResolver = (JbrResolver)$project.getObjects().newInstance(JbrResolver.class, objectArray);
        string3 = (String)$task.getJbrVersion().getOrNull();
        if (string3 == null) {
            string2 = null;
        } else {
            string = string3;
            boolean bl3 = false;
            bl2 = false;
            String it = string;
            boolean bl4 = false;
            Jbr jbr = jbrResolver.resolve(it);
            Object object3 = object2 = jbr == null ? null : jbr.getJavaExecutable();
            if (object2 == null) {
                jbr = null;
                boolean bl5 = false;
                bl = false;
                Void $this$prepareConventionMappingsForRunIdeTask_u24lambda_u2d63_u24lambda_u2d60_u24lambda_u2d59 = (Void)((Object)jbr);
                boolean bl6 = false;
                Utils.warn$default((String)((Object)$this$prepareConventionMappingsForRunIdeTask_u24lambda_u2d63_u24lambda_u2d60_u24lambda_u2d59), "Cannot resolve JetBrains Runtime '" + it + "'. Falling back to builtin JetBrains Runtime.", null, 4, null);
                string2 = (String)((Object)jbr);
            } else {
                string2 = object2;
            }
        }
        objectArray = string2;
        if (objectArray == null) {
            String string4;
            Object object4 = ((Directory)$task.getIdeDir().get()).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"task.ideDir.get().asFile");
            string = Utils.getBuiltinJbrVersion((File)object4);
            if (string == null) {
                string4 = null;
            } else {
                String string5;
                object4 = string;
                bl2 = false;
                boolean bl7 = false;
                Object it = object4;
                boolean bl8 = false;
                object2 = jbrResolver.resolve((String)it);
                String string6 = string5 = object2 == null ? null : ((Jbr)object2).getJavaExecutable();
                if (string5 == null) {
                    object2 = null;
                    bl = false;
                    boolean bl9 = false;
                    Void $this$prepareConventionMappingsForRunIdeTask_u24lambda_u2d63_u24lambda_u2d62_u24lambda_u2d61 = (Void)object2;
                    boolean bl10 = false;
                    Utils.warn$default((String)((Object)$this$prepareConventionMappingsForRunIdeTask_u24lambda_u2d63_u24lambda_u2d62_u24lambda_u2d61), "Cannot resolve builtin JetBrains Runtime '" + (String)it + "'. Falling local Java Runtime.", null, 4, null);
                    string4 = (String)object2;
                } else {
                    string4 = string5;
                }
            }
            string3 = string4;
            object = string3 == null ? Jvm.current().getJavaExecutable().getAbsolutePath() : string3;
        } else {
            object = objectArray;
        }
        return object;
    }

    private static final boolean configureJarSearchableOptionsTask$lambda-65$lambda-64(File $buildDir, Task it) {
        return new File($buildDir, "searchableOptions").isDirectory();
    }

    private static final void configureJarSearchableOptionsTask$lambda-65(Project $project, File $buildDir, JarSearchableOptionsTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        it.setGroup("intellij");
        it.setDescription("Jars searchable options.");
        it.getArchiveBaseName().convention((Object)"lib/searchableOptions");
        it.getDestinationDirectory().convention($project.getLayout().getBuildDirectory().dir("libsSearchableOptions"));
        Object[] objectArray = new Object[]{"buildSearchableOptions"};
        it.dependsOn(objectArray);
        it.onlyIf(arg_0 -> IntelliJPlugin.configureJarSearchableOptionsTask$lambda-65$lambda-64($buildDir, arg_0));
    }

    private static final Boolean configureInstrumentation$lambda-66(IntelliJPluginExtension $extension) {
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        return (Boolean)$extension.getInstrumentCode().get();
    }

    private static final Set configureInstrumentation$lambda-81$lambda-77$lambda-67(SourceSet $sourceSet) {
        return $sourceSet.getOutput().getClassesDirs().getFiles();
    }

    private static final Set configureInstrumentation$lambda-81$lambda-77$lambda-68(SourceSet $sourceSet) {
        return $sourceSet.getAllSource().getSrcDirs();
    }

    private static final String configureInstrumentation$lambda-81$lambda-77$lambda-69(IntelliJPluginExtension $extension) {
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        return (String)$extension.getIntellijRepository().get();
    }

    private static final Set configureInstrumentation$lambda-81$lambda-77$lambda-70(SourceSet $sourceSet) {
        return $sourceSet.getResources().getFiles();
    }

    private static final FileCollection configureInstrumentation$lambda-81$lambda-77$lambda-71(SourceSet $sourceSet) {
        return $sourceSet.getCompileClasspath();
    }

    private static final String configureInstrumentation$lambda-81$lambda-77$lambda-72(IntelliJPluginExtension $extension, Project $project) {
        String string;
        block15: {
            block13: {
                Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
                Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
                CharSequence charSequence = $extension.getVersionNumber();
                String version = charSequence == null ? "LATEST-EAP-SNAPSHOT" : charSequence;
                charSequence = (CharSequence)$extension.getLocalPath().getOrNull();
                boolean bl = false;
                boolean bl2 = false;
                if (!(charSequence == null || charSequence.length() == 0) || !StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) break block13;
                switch ($extension.getVersionType()) {
                    case "CL": {
                        string = Intrinsics.stringPlus((String)"CLION-", (Object)version);
                        break;
                    }
                    case "RD": {
                        string = Intrinsics.stringPlus((String)"RIDER-", (Object)version);
                        break;
                    }
                    case "PY": {
                        string = Intrinsics.stringPlus((String)"PYCHARM-", (Object)version);
                        break;
                    }
                    default: {
                        string = version;
                        break;
                    }
                }
                break block15;
            }
            string = IdeVersion.createIdeVersion((String)$extension.getIdeaDependency($project).getBuildNumber()).asStringWithoutProductCode();
        }
        return string;
    }

    private static final IdeaDependency configureInstrumentation$lambda-81$lambda-77$lambda-73(IntelliJPluginExtension $extension, Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return $extension.getIdeaDependency($project);
    }

    private static final File configureInstrumentation$lambda-81$lambda-77$lambda-75(Project $project, IntelliJPluginExtension $extension) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        File file = $project.file((Object)($extension.getIdeaDependency($project).getClasses() + "/lib/javac2.jar"));
        boolean bl = false;
        boolean bl2 = false;
        File p0 = file;
        boolean bl3 = false;
        return p0.exists() ? file : null;
    }

    private static final boolean configureInstrumentation$lambda-81$lambda-77$lambda-76(Provider $instrumentCode, Task it) {
        Object object = $instrumentCode.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"instrumentCode.get()");
        return (Boolean)object;
    }

    private static final void configureInstrumentation$lambda-81$lambda-77(Project $project, SourceSet $sourceSet, IntelliJPluginExtension $extension, Provider $instrumentCode, IntelliJInstrumentCodeTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)$extension, (String)"$extension");
        it.getSourceSetOutputClassesDirs().convention($project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-67($sourceSet)));
        it.getSourceSetAllDirs().convention($project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-68($sourceSet)));
        it.getIntellijRepository().convention($project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-69($extension)));
        it.getSourceSetResources().convention($project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-70($sourceSet)));
        it.getSourceSetCompileClasspath().convention($project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-71($sourceSet)));
        it.getCompilerVersion().convention($project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-72($extension, $project)));
        it.getIdeaDependency().convention($project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-73($extension, $project)));
        it.getJavac2().convention($project.getLayout().file($project.provider(() -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-75($project, $extension))));
        FileCollection fileCollection = $sourceSet.getOutput().getClassesDirs();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"sourceSet.output.classesDirs");
        File classesDir = (File)CollectionsKt.first((Iterable)((Iterable)fileCollection));
        File outputDir = new File(classesDir.getParentFile(), Intrinsics.stringPlus((String)$sourceSet.getName(), (Object)"-instrumented"));
        it.getOutputDir().convention($project.getLayout().getProjectDirectory().dir(outputDir.getPath()));
        Object[] objectArray = new Object[]{$sourceSet.getClassesTaskName()};
        it.dependsOn(objectArray);
        it.onlyIf(arg_0 -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-77$lambda-76($instrumentCode, arg_0));
    }

    private static final boolean configureInstrumentation$lambda-81$lambda-80$lambda-78(Provider $instrumentCode, Task it) {
        Object object = $instrumentCode.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"instrumentCode.get()");
        return (Boolean)object;
    }

    private static final void configureInstrumentation$lambda-81$lambda-80$lambda-79(ConfigurableFileCollection $classesDirs, DirectoryProperty $outputDir, Task it) {
        Intrinsics.checkParameterIsNotNull((Object)$classesDirs, (String)"$classesDirs");
        Intrinsics.checkParameterIsNotNull((Object)$outputDir, (String)"$outputDir");
        Object[] objectArray = new Object[]{$outputDir};
        $classesDirs.setFrom(objectArray);
    }

    private static final void configureInstrumentation$lambda-81$lambda-80(SourceSet $sourceSet, TaskProvider $instrumentTask, Provider $instrumentCode, Task it) {
        FileCollection fileCollection = $sourceSet.getOutput().getClassesDirs();
        if (fileCollection == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.file.ConfigurableFileCollection");
        }
        ConfigurableFileCollection classesDirs = (ConfigurableFileCollection)fileCollection;
        DirectoryProperty outputDir = ((IntelliJInstrumentCodeTask)((Object)$instrumentTask.get())).getOutputDir();
        Object[] objectArray = new Object[]{$instrumentTask};
        it.dependsOn(objectArray);
        it.onlyIf(arg_0 -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-80$lambda-78($instrumentCode, arg_0));
        it.doLast(arg_0 -> IntelliJPlugin.configureInstrumentation$lambda-81$lambda-80$lambda-79(classesDirs, outputDir, arg_0));
    }

    private static final File configureTestTasks$lambda-91$lambda-87(File $systemDirectory) {
        File file = $systemDirectory;
        boolean bl = false;
        boolean bl2 = false;
        File $this$configureTestTasks_u24lambda_u2d91_u24lambda_u2d87_u24lambda_u2d86 = file;
        boolean bl3 = false;
        $this$configureTestTasks_u24lambda_u2d91_u24lambda_u2d87_u24lambda_u2d86.mkdirs();
        return file;
    }

    private static final File configureTestTasks$lambda-91$lambda-89(File $configDirectory) {
        File file = $configDirectory;
        boolean bl = false;
        boolean bl2 = false;
        File $this$configureTestTasks_u24lambda_u2d91_u24lambda_u2d89_u24lambda_u2d88 = file;
        boolean bl3 = false;
        $this$configureTestTasks_u24lambda_u2d91_u24lambda_u2d89_u24lambda_u2d88.mkdirs();
        return file;
    }

    private static final File configureTestTasks$lambda-91$lambda-90(RunIdeTask $runIdeTask) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$runIdeTask), (String)"$runIdeTask");
        return ((Directory)$runIdeTask.getIdeDir().get()).getAsFile();
    }

    private static final String configureBuildPluginTask$lambda-97$lambda-92(PrepareSandboxTask $prepareSandboxTask) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$prepareSandboxTask), (String)"$prepareSandboxTask");
        return (String)$prepareSandboxTask.getPluginName().get();
    }

    private static final String configureBuildPluginTask$lambda-97$lambda-93(PrepareSandboxTask $prepareSandboxTask) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$prepareSandboxTask), (String)"$prepareSandboxTask");
        return "" + $prepareSandboxTask.getDestinationDir() + '/' + $prepareSandboxTask.getPluginName().get();
    }

    private static final String configureBuildPluginTask$lambda-97$lambda-94(PrepareSandboxTask $prepareSandboxTask) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$prepareSandboxTask), (String)"$prepareSandboxTask");
        return (String)$prepareSandboxTask.getPluginName().get();
    }

    private static final void configureBuildPluginTask$lambda-97$lambda-95(CopySpec copy) {
        copy.into((Object)"lib");
    }

    private static final void configureBuildPluginTask$lambda-97(Project $project, JarSearchableOptionsTask $jarSearchableOptionsTask, PrepareSandboxTask $prepareSandboxTask, Zip it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)$jarSearchableOptionsTask), (String)"$jarSearchableOptionsTask");
        Intrinsics.checkParameterIsNotNull((Object)((Object)$prepareSandboxTask), (String)"$prepareSandboxTask");
        it.setDescription("Bundles the project as a distribution.");
        it.setGroup("intellij");
        it.getArchiveBaseName().convention($project.provider(() -> IntelliJPlugin.configureBuildPluginTask$lambda-97$lambda-92($prepareSandboxTask)));
        Object[] objectArray = new Object[]{$project.provider(() -> IntelliJPlugin.configureBuildPluginTask$lambda-97$lambda-93($prepareSandboxTask))};
        it.from(objectArray);
        it.into((Object)$project.provider(() -> IntelliJPlugin.configureBuildPluginTask$lambda-97$lambda-94($prepareSandboxTask)));
        it.from((Object)$jarSearchableOptionsTask.getArchiveFile(), IntelliJPlugin::configureBuildPluginTask$lambda-97$lambda-95);
        objectArray = new Object[]{"jarSearchableOptions"};
        it.dependsOn(objectArray);
        Configuration archivesConfiguration = $project.getConfigurations().getByName("archives");
        ArchivePublishArtifact archivePublishArtifact = new ArchivePublishArtifact((AbstractArchiveTask)it);
        boolean bl = false;
        boolean bl2 = false;
        ArchivePublishArtifact zipArtifact = archivePublishArtifact;
        boolean bl3 = false;
        archivesConfiguration.getArtifacts().add((Object)zipArtifact);
        ((DefaultArtifactPublicationSet)$project.getExtensions().getByType(DefaultArtifactPublicationSet.class)).addCandidate((PublishArtifact)zipArtifact);
        $project.getComponents().add((Object)new IntelliJPluginLibrary());
    }

    private static final File configureSignPluginTask$lambda-101$lambda-98(IntelliJPlugin this$0, Project $project) {
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        return this$0.resolveBuildTaskOutput($project);
    }

    private static final File configureSignPluginTask$lambda-101$lambda-99(String $outputFilePath) {
        Intrinsics.checkParameterIsNotNull((Object)$outputFilePath, (String)"$outputFilePath");
        return new File($outputFilePath);
    }

    private static final boolean configureSignPluginTask$lambda-101$lambda-100(SignPluginTask $it, Task $noName_0) {
        if ($it == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.SignPluginTask");
        }
        return $it.getPrivateKey().isPresent() && $it.getCertificateChain().isPresent();
    }

    private static final void configureSignPluginTask$lambda-101(Project $project, IntelliJPlugin this$0, String $outputFilePath, SignPluginTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$outputFilePath, (String)"$outputFilePath");
        it.setGroup("intellij");
        it.setDescription("Sign plugin with your private key and certificate chain.");
        it.getInputArchiveFile().convention($project.getLayout().file($project.provider(() -> IntelliJPlugin.configureSignPluginTask$lambda-101$lambda-98(this$0, $project))));
        it.getOutputArchiveFile().convention($project.getLayout().file($project.provider(() -> IntelliJPlugin.configureSignPluginTask$lambda-101$lambda-99($outputFilePath))));
        it.onlyIf(arg_0 -> IntelliJPlugin.configureSignPluginTask$lambda-101$lambda-100(it, arg_0));
        Object[] objectArray = new Object[]{"buildPlugin"};
        it.dependsOn(objectArray);
    }

    private static final File configurePublishPluginTask$lambda-105$lambda-104(TaskProvider $signPluginTaskProvider, IntelliJPlugin this$0, Project $project) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Object object2 = $signPluginTaskProvider.get();
        boolean bl = false;
        boolean bl2 = false;
        Task signPluginTask = (Task)object2;
        boolean bl3 = false;
        if (signPluginTask == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.intellij.tasks.SignPluginTask");
        }
        SignPluginTask cfr_ignored_0 = (SignPluginTask)signPluginTask;
        Object object3 = (RegularFile)((SignPluginTask)signPluginTask).getOutputArchiveFile().getOrNull();
        object3 = object3 == null ? null : object3.getAsFile();
        boolean bl4 = false;
        boolean bl5 = false;
        Object it = object3;
        boolean bl6 = false;
        Object object4 = object = ((SignPluginTask)signPluginTask).getDidWork() ? object3 : null;
        return object == null ? this$0.resolveBuildTaskOutput($project) : object;
    }

    private static final void configurePublishPluginTask$lambda-105(Project $project, TaskProvider $buildPluginTaskProvider, TaskProvider $verifyPluginTaskProvider, TaskProvider $signPluginTaskProvider, IntelliJPlugin this$0, PublishPluginTask it) {
        Intrinsics.checkParameterIsNotNull((Object)$project, (String)"$project");
        Intrinsics.checkParameterIsNotNull((Object)this$0, (String)"this$0");
        it.setGroup("intellij");
        it.setDescription("Publish plugin distribution on plugins.jetbrains.com.");
        it.getHost().convention((Object)"https://plugins.jetbrains.com");
        it.getChannels().convention((Iterable)CollectionsKt.listOf((Object)"default"));
        it.getDistributionFile().convention($project.getLayout().file($project.provider(() -> IntelliJPlugin.configurePublishPluginTask$lambda-105$lambda-104($signPluginTaskProvider, this$0, $project))));
        Object[] objectArray = new Object[]{$buildPluginTaskProvider};
        it.dependsOn(objectArray);
        objectArray = new Object[]{$verifyPluginTaskProvider};
        it.dependsOn(objectArray);
        objectArray = new Object[]{$signPluginTaskProvider};
        it.dependsOn(objectArray);
    }

    private static final void configureProcessResources$lambda-107$lambda-106(CopySpec copy) {
        copy.setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
        copy.into((Object)"META-INF");
    }

    private static final void configureProcessResources$lambda-107(TaskProvider $patchPluginXmlTaskProvider, Task processResourcesTask) {
        if (processResourcesTask == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.language.jvm.tasks.ProcessResources");
        }
        ProcessResources cfr_ignored_0 = (ProcessResources)processResourcesTask;
        ((ProcessResources)processResourcesTask).from((Object)$patchPluginXmlTaskProvider, IntelliJPlugin::configureProcessResources$lambda-107$lambda-106);
    }
}

