/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import java.nio.file.Path;
import java.util.Collection;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0007R\u0014\u0010\u0006\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/intellij/tasks/VerifyPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "Lorg/gradle/api/tasks/VerificationTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "context", "getContext$annotations", "()V", "ignoreFailures", "Lorg/gradle/api/provider/Property;", "", "getIgnoreFailures", "()Lorg/gradle/api/provider/Property;", "ignoreWarnings", "getIgnoreWarnings", "pluginDir", "Lorg/gradle/api/file/DirectoryProperty;", "getPluginDir", "()Lorg/gradle/api/file/DirectoryProperty;", "setIgnoreFailures", "", "verifyPlugin", "gradle-intellij-plugin"})
public class VerifyPluginTask
extends ConventionTask
implements VerificationTask {
    @Input
    @NotNull
    private final Property<Boolean> ignoreFailures;
    @NotNull
    private final transient VerifyPluginTask context;
    @Input
    @NotNull
    private final Property<Boolean> ignoreWarnings;
    @InputDirectory
    @NotNull
    private final DirectoryProperty pluginDir;

    @Inject
    public VerifyPluginTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Property property = objectFactory.property(Boolean.TYPE).convention((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.property(Boolean::class.java).convention(false)");
        this.ignoreFailures = property;
        this.context = this;
        property = objectFactory.property(Boolean.TYPE).convention((Object)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.property(Boolean::class.java).convention(true)");
        this.ignoreWarnings = property;
        property = objectFactory.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.directoryProperty()");
        this.pluginDir = property;
    }

    @NotNull
    public final Property<Boolean> getIgnoreFailures() {
        return this.ignoreFailures;
    }

    private static /* synthetic */ void getContext$annotations() {
    }

    public boolean getIgnoreFailures() {
        Object object = this.ignoreFailures.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ignoreFailures.get()");
        return (Boolean)object;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures.set((Object)ignoreFailures);
    }

    @NotNull
    public final Property<Boolean> getIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    @NotNull
    public final DirectoryProperty getPluginDir() {
        return this.pluginDir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public final void verifyPlugin() {
        PluginProblem it;
        boolean $i$f$forEach;
        Object object = this.pluginDir.get();
        boolean bl = false;
        boolean bl2 = false;
        Directory it2 = (Directory)object;
        boolean bl3 = false;
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager();
        Path path = it2.getAsFile().toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it.asFile.toPath()");
        PluginCreationResult creationResult = idePluginManager.createPlugin(path);
        object = creationResult;
        if (object instanceof PluginCreationSuccess) {
            Iterable $this$forEach$iv = ((PluginCreationSuccess)creationResult).getWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PluginProblem)element$iv;
                boolean bl4 = false;
                Utils.warn$default((Object)this.context, it.getMessage(), null, 4, null);
            }
        } else if (object instanceof PluginCreationFail) {
            Iterable $this$forEach$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PluginProblem)element$iv;
                boolean bl5 = false;
                if (it.getLevel() == PluginProblem.Level.ERROR) {
                    Utils.error$default((Object)this.context, it.getMessage(), null, 4, null);
                    continue;
                }
                Utils.warn$default((Object)this.context, it.getMessage(), null, 4, null);
            }
        } else {
            Utils.error$default((Object)this.context, creationResult.toString(), null, 4, null);
        }
        if (creationResult instanceof PluginCreationSuccess) {
            if ((Boolean)this.ignoreWarnings.get() != false) return;
            Collection collection = ((PluginCreationSuccess)creationResult).getWarnings();
            bl2 = false;
            if (collection.isEmpty()) return;
            boolean bl6 = true;
            if (!bl6) return;
        }
        boolean bl7 = true;
        boolean failBuild = bl7;
        if (!failBuild) return;
        if ((Boolean)this.ignoreFailures.get() != false) return;
        throw new GradleException("Plugin verification failed.");
    }
}

