/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.Version;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadata;
import org.jetbrains.intellij.model.SpacePackagesMavenMetadataVersioning;
import org.jetbrains.intellij.model.XmlExtractor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u001bH\u0002J\b\u0010!\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \r*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \r*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "execOperations", "Lorg/gradle/process/ExecOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ArchiveOperations;Lorg/gradle/process/ExecOperations;Lorg/gradle/api/file/FileSystemOperations;)V", "configurationContainer", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "kotlin.jvm.PlatformType", "context", "getContext$annotations", "()V", "dependencyHandler", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "repositoryHandler", "Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "version", "Lorg/gradle/api/provider/Property;", "", "getVersion", "()Lorg/gradle/api/provider/Property;", "downloadPlugin", "", "getDependency", "resolveVersion", "Companion", "gradle-intellij-plugin"})
public class DownloadRobotServerPluginTask
extends ConventionTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArchiveOperations archiveOperations;
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final FileSystemOperations fileSystemOperations;
    @Input
    @NotNull
    private final Property<String> version;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDir;
    private final transient DependencyHandler dependencyHandler;
    private final transient RepositoryHandler repositoryHandler;
    private final transient ConfigurationContainer configurationContainer;
    @NotNull
    private final transient DownloadRobotServerPluginTask context;
    @NotNull
    private static final String METADATA_URL = "https://cache-redirector.jetbrains.com/intellij-dependencies/com/intellij/remoterobot/robot-server-plugin/maven-metadata.xml";
    @NotNull
    public static final String OLD_ROBOT_SERVER_DEPENDENCY = "org.jetbrains.test:robot-server-plugin";
    @NotNull
    public static final String NEW_ROBOT_SERVER_DEPENDENCY = "com.intellij.remoterobot:robot-server-plugin";

    @Inject
    public DownloadRobotServerPluginTask(@NotNull ObjectFactory objectFactory, @NotNull ArchiveOperations archiveOperations, @NotNull ExecOperations execOperations, @NotNull FileSystemOperations fileSystemOperations) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)archiveOperations, (String)"archiveOperations");
        Intrinsics.checkParameterIsNotNull((Object)execOperations, (String)"execOperations");
        Intrinsics.checkParameterIsNotNull((Object)fileSystemOperations, (String)"fileSystemOperations");
        this.archiveOperations = archiveOperations;
        this.execOperations = execOperations;
        this.fileSystemOperations = fileSystemOperations;
        Property property = objectFactory.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.property(String::class.java)");
        this.version = property;
        property = objectFactory.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"objectFactory.directoryProperty()");
        this.outputDir = property;
        this.dependencyHandler = this.getProject().getDependencies();
        this.repositoryHandler = this.getProject().getRepositories();
        this.configurationContainer = this.getProject().getConfigurations();
        this.context = this;
    }

    @NotNull
    public final Property<String> getVersion() {
        return this.version;
    }

    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    private static /* synthetic */ void getContext$annotations() {
    }

    private final String resolveVersion() {
        String string;
        String string2 = (String)this.version.getOrNull();
        if (string2 == null) {
            string = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string = !Intrinsics.areEqual((Object)it, (Object)"latest") ? string3 : null;
        }
        String string4 = string;
        String string5 = string4 == null ? Companion.resolveLatestVersion() : string4;
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"version.orNull?.takeIf { it != VERSION_LATEST } ?: resolveLatestVersion()");
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void downloadPlugin() {
        List list;
        String resolvedVersion = this.resolveVersion();
        char[] cArray = new char[]{':'};
        List list2 = list = StringsKt.split$default((CharSequence)this.getDependency(resolvedVersion), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        String group = (String)list2.get(0);
        List list3 = list;
        boolean bl2 = false;
        String name = (String)list3.get(1);
        DependencyHandler dependencyHandler = this.dependencyHandler;
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"dependencyHandler");
        Dependency dependency = Utils.create$default(dependencyHandler, group, name, resolvedVersion, null, null, null, 56, null);
        MavenArtifactRepository repository = this.repositoryHandler.maven(DownloadRobotServerPluginTask::downloadPlugin$lambda-1);
        File target = ((Directory)this.outputDir.get()).getAsFile();
        try {
            Dependency[] dependencyArray = new Dependency[]{dependency};
            File zipFile = this.configurationContainer.detachedConfiguration(dependencyArray).getSingleFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)zipFile, (String)"zipFile");
            Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"target");
            Utils.extractArchive$default(zipFile, target, this.archiveOperations, this.execOperations, this.fileSystemOperations, (Object)this.context, null, null, 192, null);
        }
        finally {
            this.repositoryHandler.remove((Object)repository);
        }
    }

    private final String getDependency(String version) {
        return Version.Companion.parse(version).compareTo(Version.Companion.parse("0.11.0")) < 0 ? OLD_ROBOT_SERVER_DEPENDENCY : NEW_ROBOT_SERVER_DEPENDENCY;
    }

    private static final void downloadPlugin$lambda-1(MavenArtifactRepository it) {
        it.setUrl(URI.create("https://cache-redirector.jetbrains.com/intellij-dependencies"));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/intellij/tasks/DownloadRobotServerPluginTask$Companion;", "", "()V", "METADATA_URL", "", "NEW_ROBOT_SERVER_DEPENDENCY", "OLD_ROBOT_SERVER_DEPENDENCY", "resolveLatestVersion", "gradle-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String resolveLatestVersion() {
            String string;
            Utils.debug$default(null, "Resolving latest Robot Server Plugin version", null, 5, null);
            URL url = new URL(DownloadRobotServerPluginTask.METADATA_URL);
            XmlExtractor xmlExtractor = new XmlExtractor();
            InputStream inputStream = url.openStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"url.openStream()");
            SpacePackagesMavenMetadataVersioning spacePackagesMavenMetadataVersioning = ((SpacePackagesMavenMetadata)xmlExtractor.unmarshal(inputStream)).getVersioning();
            String string2 = string = spacePackagesMavenMetadataVersioning == null ? null : spacePackagesMavenMetadataVersioning.getLatest();
            if (string == null) {
                throw new GradleException("Cannot resolve the latest Robot Server Plugin version");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

