/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingParser;
import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/intellij/dependency/CustomPluginsRepository;", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "repositoryUrl", "", "(Ljava/lang/String;)V", "pluginsXmlUri", "Ljava/net/URI;", "downloadZipArtifact", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "url", "Ljava/net/URL;", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "postResolve", "", "resolve", "resolveDownloadUrl", "type", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;", "gradle-intellij-plugin"})
public final class CustomPluginsRepository
implements PluginsRepository {
    @NotNull
    private final URI pluginsXmlUri;
    @NotNull
    private final String repositoryUrl;

    /*
     * WARNING - void declaration
     */
    public CustomPluginsRepository(@NotNull String repositoryUrl) {
        Intrinsics.checkParameterIsNotNull((Object)repositoryUrl, (String)"repositoryUrl");
        URI uri = new URI(repositoryUrl);
        Object object = uri.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"uri.path");
        if (StringsKt.endsWith$default((String)object, (String)".xml", (boolean)false, (int)2, null)) {
            object = repositoryUrl;
            int n = 0;
            int n2 = StringsKt.lastIndexOf$default((CharSequence)repositoryUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string = ((String)object).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.repositoryUrl = string;
            this.pluginsXmlUri = uri;
        } else {
            void $this$_init__u24lambda_u2d0;
            this.repositoryUrl = repositoryUrl;
            URI uRI = uri;
            boolean bl = false;
            boolean bl2 = false;
            URI uRI2 = uRI;
            CustomPluginsRepository customPluginsRepository = this;
            boolean bl3 = false;
            URI uRI3 = new URI($this$_init__u24lambda_u2d0.getScheme(), $this$_init__u24lambda_u2d0.getUserInfo(), $this$_init__u24lambda_u2d0.getHost(), $this$_init__u24lambda_u2d0.getPort(), Intrinsics.stringPlus((String)$this$_init__u24lambda_u2d0.getPath(), (Object)"/"), $this$_init__u24lambda_u2d0.getQuery(), $this$_init__u24lambda_u2d0.getFragment()).resolve("updatePlugins.xml");
            object = uRI3;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"uri.run { URI(scheme, userInfo, host, port, \"$path/\", query, fragment).resolve(\"updatePlugins.xml\") }");
            customPluginsRepository.pluginsXmlUri = object;
        }
    }

    @Override
    @Nullable
    public File resolve(@NotNull Project project, @NotNull PluginDependencyNotation plugin) {
        URL uRL;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)plugin, (String)"plugin");
        Utils.debug$default(project, Intrinsics.stringPlus((String)"Loading list of plugins from: ", (Object)this.pluginsXmlUri), null, 4, null);
        URL url = this.pluginsXmlUri.toURL();
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"url");
        URL uRL2 = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.PLUGIN_REPOSITORY);
        if (uRL2 == null) {
            URL uRL3 = this.resolveDownloadUrl(url, plugin, CustomPluginRepositoryListingType.SIMPLE);
            if (uRL3 == null) {
                return null;
            }
            uRL = uRL3;
        } else {
            uRL = uRL2;
        }
        URL downloadUrl = uRL;
        return this.downloadZipArtifact(project, downloadUrl, plugin);
    }

    private final URL resolveDownloadUrl(URL url, PluginDependencyNotation plugin, CustomPluginRepositoryListingType type) {
        Object v0;
        block1: {
            Object object = url;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)object);
            boolean bl2 = false;
            boolean bl3 = false;
            object = CustomPluginRepositoryListingParser.INSTANCE.parseListOfPlugins(new String(byArray, charset), url, new URL(this.repositoryUrl), type);
            boolean bl4 = false;
            Object object2 = object;
            boolean bl5 = false;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                CustomPluginRepositoryListingParser.PluginInfo it = (CustomPluginRepositoryListingParser.PluginInfo)t;
                boolean bl6 = false;
                if (!(StringsKt.equals((String)it.getPluginId(), (String)plugin.getId(), (boolean)true) && StringsKt.equals((String)it.getVersion(), (String)plugin.getVersion(), (boolean)true))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        CustomPluginRepositoryListingParser.PluginInfo pluginInfo = v0;
        return pluginInfo == null ? null : pluginInfo.getDownloadUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File downloadZipArtifact(Project project, URL url, PluginDependencyNotation plugin) {
        IvyArtifactRepository repository = project.getRepositories().ivy(arg_0 -> CustomPluginsRepository.downloadZipArtifact$lambda-4(url, arg_0));
        Object object = project.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.dependencies");
        Dependency dependency = Utils.create$default((DependencyHandler)object, "com.jetbrains.plugins", plugin.getId(), plugin.getVersion(), null, "zip", null, 40, null);
        try {
            object = new Dependency[]{dependency};
            object = project.getConfigurations().detachedConfiguration(object).getSingleFile();
        }
        catch (Exception e) {
            Utils.warn(project, "Cannot download plugin from custom repository: " + plugin.getId() + ':' + plugin.getVersion(), e);
            object = null;
        }
        finally {
            project.getRepositories().remove((Object)repository);
        }
        return object;
    }

    @Override
    public void postResolve(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
    }

    private static final void downloadZipArtifact$lambda-4$lambda-2(IvyPatternRepositoryLayout it) {
        it.artifact("");
    }

    private static final void downloadZipArtifact$lambda-4$lambda-3(IvyArtifactRepository.MetadataSources it) {
        it.artifact();
    }

    private static final void downloadZipArtifact$lambda-4(URL $url, IvyArtifactRepository ivy) {
        Intrinsics.checkParameterIsNotNull((Object)$url, (String)"$url");
        ivy.setUrl($url.toURI());
        ivy.patternLayout(CustomPluginsRepository::downloadZipArtifact$lambda-4$lambda-2);
        ivy.metadataSources(CustomPluginsRepository::downloadZipArtifact$lambda-4$lambda-3);
    }
}

