/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.extractor.PluginBeanExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.utils.JDOMUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaForkOptions;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.IntelliJPlugin;
import org.jetbrains.intellij.dependency.IdeaDependency;
import org.xml.sax.SAXParseException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u00ac\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u001a \u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a&\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a&\u0010\u0019\u001a\u00020\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001ab\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u00122\u0010\b\u0002\u0010#\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b2\u0016\b\u0002\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010%H\u0007\u001a\u0010\u0010&\u001a\u0004\u0018\u00010\u00162\u0006\u0010'\u001a\u00020\b\u001a,\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00160)2\b\u0010'\u001a\u0004\u0018\u00010\b\u001a8\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160.2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00160)\u001a\u000e\u00103\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\b\u001a\u000e\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0016\u001a&\u00106\u001a\u00020\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001a\u000e\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u000209\u001a\u000e\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0016\u001a\u000e\u0010<\u001a\u00020\u00102\u0006\u0010=\u001a\u00020\u0016\u001a,\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020@2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u001a\u000e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D\u001a\u0018\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010H\u001a\u00020\u00162\u0006\u0010I\u001a\u00020\u0016\u001a\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\b0)2\u0006\u0010C\u001a\u00020D\u001a\u0016\u0010K\u001a\u00020\u00142\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\b\u001a&\u0010O\u001a\u00020\u00142\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u001aH\u0010P\u001a\u00020Q*\u00020R2\u0006\u0010S\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u00162\b\u0010I\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010T\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010U\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010V\u001a\u0004\u0018\u00010\u0016\u001a\n\u0010W\u001a\u00020\u0010*\u00020\b\u001a\n\u0010X\u001a\u00020\u0010*\u00020\b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006Y"}, d2={"MAJOR_VERSION_PATTERN", "Ljava/util/regex/Pattern;", "getMAJOR_VERSION_PATTERN", "()Ljava/util/regex/Pattern;", "VERSION_PATTERN", "getVERSION_PATTERN", "collectJars", "", "Ljava/io/File;", "directory", "filter", "Ljava/util/function/Predicate;", "createPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "artifact", "validatePluginXml", "", "context", "", "debug", "", "message", "", "e", "", "error", "extractArchive", "archiveFile", "targetDirectory", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "execOperations", "Lorg/gradle/process/ExecOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "isUpToDate", "markUpToDate", "Ljava/util/function/BiConsumer;", "getBuiltinJbrVersion", "ideDirectory", "getIdeJvmArgs", "", "options", "Lorg/gradle/process/JavaForkOptions;", "arguments", "getIdeaSystemProperties", "", "configDirectory", "systemDirectory", "pluginsDirectory", "requirePluginIds", "ideBuildNumber", "ideaDir", "path", "info", "isDependencyOnPyCharm", "dependency", "Lorg/jetbrains/intellij/dependency/IdeaDependency;", "isKotlinRuntime", "name", "isPyCharmType", "type", "log", "level", "Lorg/gradle/api/logging/LogLevel;", "mainSourceSet", "Lorg/gradle/api/tasks/SourceSet;", "project", "Lorg/gradle/api/Project;", "parsePluginXml", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "pluginXml", "releaseType", "version", "sourcePluginXmlFiles", "transformXml", "document", "Lorg/jdom2/Document;", "file", "warn", "create", "Lorg/gradle/api/artifacts/Dependency;", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "group", "classifier", "extension", "configuration", "isJar", "isZip", "gradle-intellij-plugin"})
@JvmName(name="Utils")
public final class Utils {
    @NotNull
    private static final Pattern VERSION_PATTERN;
    @NotNull
    private static final Pattern MAJOR_VERSION_PATTERN;

    @NotNull
    public static final Pattern getVERSION_PATTERN() {
        return VERSION_PATTERN;
    }

    @NotNull
    public static final Pattern getMAJOR_VERSION_PATTERN() {
        return MAJOR_VERSION_PATTERN;
    }

    @NotNull
    public static final SourceSet mainSourceSet(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object object = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project\n    .convention.getPlugin(JavaPluginConvention::class.java)\n//    .extensions.getByType(JavaPluginExtension::class.java) // available since Gradle 7.1\n    .sourceSets.getByName(SourceSet.MAIN_SOURCE_SET_NAME)");
        return (SourceSet)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> sourcePluginXmlFiles(@NotNull Project project) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Set set = Utils.mainSourceSet(project).getResources().getSrcDirs();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"mainSourceSet(project).resources.srcDirs");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            File file;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            File file2 = new File(it, "META-INF/plugin.xml");
            boolean bl3 = false;
            boolean bl4 = false;
            File file3 = file2;
            boolean bl5 = false;
            if ((file3.exists() && file3.length() > 0L ? file2 : null) == null) continue;
            file = file;
            boolean bl6 = false;
            boolean bl7 = false;
            File it$iv$iv = file;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final PluginBean parsePluginXml(@NotNull File pluginXml, @NotNull Object context) {
        Intrinsics.checkParameterIsNotNull((Object)pluginXml, (String)"pluginXml");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            File file = pluginXml;
            boolean bl = false;
            Document document = JDOMUtil.loadDocument((InputStream)new FileInputStream(file));
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"loadDocument(pluginXml.inputStream())");
            Document document2 = document;
            return PluginBeanExtractor.INSTANCE.extractPluginBean(document2);
        }
        catch (SAXParseException e) {
            Utils.warn(context, "Cannot read " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        catch (JDOMException e) {
            Utils.warn(context, "Cannot read " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        catch (IOException e) {
            Utils.warn(context, "Cannot read " + pluginXml.getCanonicalPath() + ". Skipping", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void transformXml(@NotNull Document document, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        XMLOutputter xmlOutput = new XMLOutputter();
        Object object = xmlOutput.getFormat();
        boolean bl = false;
        boolean bl2 = false;
        Format $this$transformXml_u24lambda_u2d2 = object;
        boolean bl3 = false;
        $this$transformXml_u24lambda_u2d2.setIndent("  ");
        $this$transformXml_u24lambda_u2d2.setOmitDeclaration(true);
        $this$transformXml_u24lambda_u2d2.setTextMode(Format.TextMode.TRIM);
        object = new StringWriter();
        bl = false;
        bl2 = false;
        Throwable throwable = null;
        try {
            StringWriter it = (StringWriter)object;
            boolean bl4 = false;
            xmlOutput.output(document, (Writer)it);
            String string = it.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public static final Map<String, String> getIdeaSystemProperties(@NotNull File configDirectory, @NotNull File systemDirectory, @NotNull File pluginsDirectory, @NotNull List<String> requirePluginIds) {
        Intrinsics.checkParameterIsNotNull((Object)configDirectory, (String)"configDirectory");
        Intrinsics.checkParameterIsNotNull((Object)systemDirectory, (String)"systemDirectory");
        Intrinsics.checkParameterIsNotNull((Object)pluginsDirectory, (String)"pluginsDirectory");
        Intrinsics.checkParameterIsNotNull(requirePluginIds, (String)"requirePluginIds");
        Object object = new Pair[]{TuplesKt.to((Object)"idea.config.path", (Object)configDirectory.getAbsolutePath()), TuplesKt.to((Object)"idea.system.path", (Object)systemDirectory.getAbsolutePath()), TuplesKt.to((Object)"idea.plugins.path", (Object)pluginsDirectory.getAbsolutePath())};
        Map result = MapsKt.mapOf((Pair[])object);
        object = requirePluginIds;
        boolean bl = false;
        if (!object.isEmpty()) {
            return MapsKt.plus((Map)result, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"idea.required.plugins.id", (Object)CollectionsKt.joinToString$default((Iterable)requirePluginIds, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))));
        }
        return result;
    }

    @NotNull
    public static final List<String> getIdeJvmArgs(@NotNull JavaForkOptions options, @NotNull List<String> arguments, @Nullable File ideDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        Object object = options.getMaxHeapSize();
        options.setMaxHeapSize((String)(object == null ? "512m" : object));
        object = options.getMinHeapSize();
        options.setMinHeapSize((String)(object == null ? "256m" : object));
        object = ideDirectory;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            File bootJar = new File(ideDirectory, "lib/boot.jar");
            if (bootJar.exists()) {
                return CollectionsKt.plus((Collection)arguments, (Object)Intrinsics.stringPlus((String)"-Xbootclasspath/a:", (Object)bootJar.getAbsolutePath()));
            }
        }
        return arguments;
    }

    @NotNull
    public static final String ideBuildNumber(@NotNull File ideDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)ideDirectory, (String)"ideDirectory");
        File file = new File(ideDirectory, "Resources/build.txt");
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        Object object = OperatingSystem.current().isMacOsX() && it.exists() ? file : null;
        object = FilesKt.readText$default((File)(object == null ? new File(ideDirectory, "build.txt") : object), null, (int)1, null);
        boolean bl4 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString();
    }

    @NotNull
    public static final File ideaDir(@NotNull String path) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        File file2 = new File(path);
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        File file3 = it;
        boolean bl4 = false;
        boolean bl5 = false;
        File it2 = file3;
        boolean bl6 = false;
        String string = it2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
        File file4 = file = !StringsKt.endsWith$default((String)string, (String)".app", (boolean)false, (int)2, null) ? file3 : null;
        return file == null ? new File(it, "Contents") : file;
    }

    public static final boolean isJar(@NotNull File $this$isJar) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isJar, (String)"<this>");
        Path path = $this$isJar.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"toPath()");
        return FileUtilKt.isJar((Path)path);
    }

    public static final boolean isZip(@NotNull File $this$isZip) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isZip, (String)"<this>");
        Path path = $this$isZip.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"toPath()");
        return FileUtilKt.isZip((Path)path);
    }

    @NotNull
    public static final Collection<File> collectJars(@NotNull File directory, @NotNull Predicate<File> filter) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        if (!directory.isDirectory()) {
            collection = CollectionsKt.emptyList();
        } else {
            Collection collection2 = FileUtils.listFiles((File)directory, (IOFileFilter)((IOFileFilter)new AbstractFileFilter(filter){
                final /* synthetic */ Predicate<File> $filter;
                {
                    this.$filter = $filter;
                }

                public boolean accept(@NotNull File file) {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    return Utils.isJar(file) && this.$filter.test(file);
                }
            }), (IOFileFilter)FalseFileFilter.FALSE);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"filter: Predicate<File>): Collection<File> = when {\n    !directory.isDirectory -> emptyList()\n    else -> FileUtils.listFiles(directory, object : AbstractFileFilter() {\n        override fun accept(file: File) = file.isJar() && filter.test(file)\n    }, FalseFileFilter.FALSE)");
            collection = collection2;
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String getBuiltinJbrVersion(@NotNull File ideDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)ideDirectory, (String)"ideDirectory");
        File dependenciesFile = new File(ideDirectory, "dependencies.txt");
        if (dependenciesFile.exists()) {
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(dependenciesFile);){
                properties.load(reader);
                String string = properties.getProperty("jdkBuild");
                return string;
            }
        }
        return null;
    }

    @Incubating
    @NotNull
    public static final File extractArchive(@NotNull File archiveFile, @NotNull File targetDirectory, @NotNull ArchiveOperations archiveOperations, @NotNull ExecOperations execOperations, @NotNull FileSystemOperations fileSystemOperations, @NotNull Object context, @Nullable Predicate<File> isUpToDate, @Nullable BiConsumer<File, File> markUpToDate) {
        Intrinsics.checkParameterIsNotNull((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkParameterIsNotNull((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkParameterIsNotNull((Object)archiveOperations, (String)"archiveOperations");
        Intrinsics.checkParameterIsNotNull((Object)execOperations, (String)"execOperations");
        Intrinsics.checkParameterIsNotNull((Object)fileSystemOperations, (String)"fileSystemOperations");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String name = archiveFile.getName();
        File markerFile = new File(targetDirectory, "markerFile");
        if (markerFile.exists() && (isUpToDate == null || isUpToDate.test(markerFile))) {
            return targetDirectory;
        }
        FilesKt.deleteRecursively((File)targetDirectory);
        targetDirectory.mkdirs();
        Utils.debug$default(context, Intrinsics.stringPlus((String)"Extracting ", (Object)name), null, 4, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
        if (StringsKt.endsWith$default((String)name, (String)".tar.gz", (boolean)false, (int)2, null) && OperatingSystem.current().isWindows()) {
            execOperations.exec(arg_0 -> Utils.extractArchive$lambda-8(archiveFile, targetDirectory, arg_0));
        } else {
            KFunction kFunction;
            if (StringsKt.endsWith$default((String)name, (String)".zip", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)".sit", (boolean)false, (int)2, null)) {
                kFunction = (KFunction)new Function1<Object, FileTree>(archiveOperations){

                    public final FileTree invoke(Object p0) {
                        return ((ArchiveOperations)this.receiver).zipTree(p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "zipTree(Ljava/lang/Object;)Lorg/gradle/api/file/FileTree;";
                    }

                    @NotNull
                    public final String getName() {
                        return "zipTree";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ArchiveOperations.class);
                    }
                };
            } else if (StringsKt.endsWith$default((String)name, (String)".tar.gz", (boolean)false, (int)2, null)) {
                kFunction = (KFunction)new Function1<Object, FileTree>(archiveOperations){

                    public final FileTree invoke(Object p0) {
                        return ((ArchiveOperations)this.receiver).tarTree(p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "tarTree(Ljava/lang/Object;)Lorg/gradle/api/file/FileTree;";
                    }

                    @NotNull
                    public final String getName() {
                        return "tarTree";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(ArchiveOperations.class);
                    }
                };
            } else {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown type archive type: ", (Object)name));
            }
            KFunction decompressor2 = kFunction;
            fileSystemOperations.copy(arg_0 -> Utils.extractArchive$lambda-9(decompressor2, archiveFile, targetDirectory, arg_0));
        }
        Utils.debug$default(context, Intrinsics.stringPlus((String)"Extracted ", (Object)name), null, 4, null);
        markerFile.createNewFile();
        BiConsumer<File, File> biConsumer = markUpToDate;
        if (biConsumer != null) {
            biConsumer.accept(targetDirectory, markerFile);
        }
        return targetDirectory;
    }

    public static /* synthetic */ File extractArchive$default(File file, File file2, ArchiveOperations archiveOperations, ExecOperations execOperations, FileSystemOperations fileSystemOperations, Object object, Predicate predicate, BiConsumer biConsumer, int n, Object object2) {
        if ((n & 0x40) != 0) {
            predicate = null;
        }
        if ((n & 0x80) != 0) {
            biConsumer = null;
        }
        return Utils.extractArchive(file, file2, archiveOperations, execOperations, fileSystemOperations, object, predicate, biConsumer);
    }

    @NotNull
    public static final String releaseType(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.endsWith$default((String)version, (String)"-EAP-SNAPSHOT", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)version, (String)"-EAP-CANDIDATE-SNAPSHOT", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)version, (String)"-CUSTOM-SNAPSHOT", (boolean)false, (int)2, null) || MAJOR_VERSION_PATTERN.matcher(version).matches() ? "snapshots" : (StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null) ? "nightly" : "releases");
    }

    public static final void error(@Nullable Object context, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Utils.log(LogLevel.ERROR, context, message, e);
    }

    public static /* synthetic */ void error$default(Object object, String string, Throwable throwable, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.error(object, string, throwable);
    }

    public static final void warn(@Nullable Object context, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Utils.log(LogLevel.WARN, context, message, e);
    }

    public static /* synthetic */ void warn$default(Object object, String string, Throwable throwable, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.warn(object, string, throwable);
    }

    public static final void info(@Nullable Object context, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Utils.log(LogLevel.INFO, context, message, e);
    }

    public static /* synthetic */ void info$default(Object object, String string, Throwable throwable, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.info(object, string, throwable);
    }

    public static final void debug(@Nullable Object context, @NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Utils.log(LogLevel.DEBUG, context, message, e);
    }

    public static /* synthetic */ void debug$default(Object object, String string, Throwable throwable, int n, Object object2) {
        if ((n & 1) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        Utils.debug(object, string, throwable);
    }

    private static final void log(LogLevel level, Object context, String message, Throwable e) {
        Object object = context;
        String category = object instanceof Project ? "gradle-intellij-plugin " + ((Project)context).getPath() + ((Project)context).getName() : (object instanceof Task ? Intrinsics.stringPlus((String)"gradle-intellij-plugin ", (Object)((Task)context).getPath()) : "gradle-intellij-plugin");
        Logger logger = Logging.getLogger(IntelliJPlugin.class);
        if (e != null && level != LogLevel.ERROR && !logger.isDebugEnabled()) {
            logger.log(level, '[' + category + "] " + message + ". Run with --debug option to get more log output.");
        } else {
            logger.log(level, '[' + category + "] " + message, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IdePlugin createPlugin(@NotNull File artifact, boolean validatePluginXml, @NotNull Object context) {
        IdePlugin idePlugin;
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Path extractDirectory = Files.createTempDirectory("tmp", new FileAttribute[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)extractDirectory, (String)"extractDirectory");
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager(extractDirectory);
        Path path = artifact.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"artifact.toPath()");
        PluginCreationResult creationResult = idePluginManager.createPlugin(path, validatePluginXml, "plugin.xml");
        path = creationResult;
        if (path instanceof PluginCreationSuccess) {
            idePlugin = (IdePlugin)((PluginCreationSuccess)creationResult).getPlugin();
        } else if (path instanceof PluginCreationFail) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PluginProblem it = (PluginProblem)element$iv$iv;
                boolean bl = false;
                if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String problems = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
            Utils.warn$default(context, "Cannot create plugin from file (" + artifact + "): " + problems, null, 4, null);
            idePlugin = null;
        } else {
            Utils.warn$default(context, "Cannot create plugin from file (" + artifact + "). " + creationResult, null, 4, null);
            idePlugin = null;
        }
        return idePlugin;
    }

    public static final boolean isKotlinRuntime(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)name, (Object)"kotlin-runtime") || Intrinsics.areEqual((Object)name, (Object)"kotlin-reflect") || StringsKt.startsWith$default((String)name, (String)"kotlin-reflect-", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"kotlin-stdlib") || StringsKt.startsWith$default((String)name, (String)"kotlin-stdlib-", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"kotlin-test") || StringsKt.startsWith$default((String)name, (String)"kotlin-test-", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final Dependency create(@NotNull DependencyHandler $this$create, @NotNull String group, @NotNull String name, @Nullable String version, @Nullable String classifier, @Nullable String extension, @Nullable String configuration) {
        Intrinsics.checkParameterIsNotNull((Object)$this$create, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)group), TuplesKt.to((Object)"name", (Object)name), TuplesKt.to((Object)"version", (Object)version), TuplesKt.to((Object)"classifier", (Object)classifier), TuplesKt.to((Object)"ext", (Object)extension), TuplesKt.to((Object)"configuration", (Object)configuration)};
        Dependency dependency = $this$create.create((Object)MapsKt.mapOf((Pair[])pairArray));
        Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"create(mapOf(\n    \"group\" to group,\n    \"name\" to name,\n    \"version\" to version,\n    \"classifier\" to classifier,\n    \"ext\" to extension,\n    \"configuration\" to configuration,\n))");
        return dependency;
    }

    public static /* synthetic */ Dependency create$default(DependencyHandler dependencyHandler, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        return Utils.create(dependencyHandler, string, string2, string3, string4, string5, string6);
    }

    public static final boolean isDependencyOnPyCharm(@NotNull IdeaDependency dependency) {
        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
        return Intrinsics.areEqual((Object)dependency.getName(), (Object)"pycharmPY") || Intrinsics.areEqual((Object)dependency.getName(), (Object)"pycharmPC");
    }

    public static final boolean isPyCharmType(@NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"PY") || Intrinsics.areEqual((Object)type, (Object)"PC");
    }

    private static final void extractArchive$lambda-8(File $archiveFile, File $targetDirectory, ExecSpec it) {
        Intrinsics.checkParameterIsNotNull((Object)$archiveFile, (String)"$archiveFile");
        Intrinsics.checkParameterIsNotNull((Object)$targetDirectory, (String)"$targetDirectory");
        Object[] objectArray = new Object[]{"tar", "-xpf", $archiveFile.getAbsolutePath(), "--directory", $targetDirectory.getAbsolutePath()};
        it.commandLine(objectArray);
    }

    private static final void extractArchive$lambda-9(KFunction $decompressor, File $archiveFile, File $targetDirectory, CopySpec it) {
        Intrinsics.checkParameterIsNotNull((Object)$decompressor, (String)"$decompressor");
        Intrinsics.checkParameterIsNotNull((Object)$archiveFile, (String)"$archiveFile");
        Intrinsics.checkParameterIsNotNull((Object)$targetDirectory, (String)"$targetDirectory");
        Object[] objectArray = new Object[]{((Function1)$decompressor).invoke((Object)$archiveFile)};
        it.from(objectArray);
        it.into((Object)$targetDirectory);
    }

    static {
        String string = "^([A-Z]+)-([0-9.A-z]+)\\s*$";
        int n = 0;
        boolean bl = false;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"java.util.regex.Pattern.compile(this, flags)");
        VERSION_PATTERN = pattern;
        string = "(RIDER-|GO-)?\\d{4}\\.\\d-SNAPSHOT";
        n = 0;
        bl = false;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"java.util.regex.Pattern.compile(this, flags)");
        MAJOR_VERSION_PATTERN = pattern2;
    }
}

