/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.tasks;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.plugin.PluginProblem;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.pluginRepository.PluginRepository;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryFactory;
import org.jetbrains.intellij.pluginRepository.PluginUploader;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u0018H\u0002R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/intellij/tasks/PublishPluginTask;", "Lorg/gradle/api/internal/ConventionTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "channels", "Lorg/gradle/api/provider/ListProperty;", "", "getChannels", "()Lorg/gradle/api/provider/ListProperty;", "context", "getContext$annotations", "()V", "distributionFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDistributionFile", "()Lorg/gradle/api/file/RegularFileProperty;", "host", "Lorg/gradle/api/provider/Property;", "getHost", "()Lorg/gradle/api/provider/Property;", "token", "getToken", "publishPlugin", "", "validateInput", "gradle-intellij-plugin"})
public class PublishPluginTask
extends ConventionTask {
    @InputFile
    @NotNull
    private final RegularFileProperty distributionFile;
    @Input
    @NotNull
    private final Property<String> host;
    @Input
    @Optional
    @NotNull
    private final Property<String> token;
    @Input
    @Optional
    @NotNull
    private final ListProperty<String> channels;
    @NotNull
    private final transient PublishPluginTask context;

    @Inject
    public PublishPluginTask(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        RegularFileProperty regularFileProperty = objectFactory.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.fileProperty()");
        this.distributionFile = regularFileProperty;
        regularFileProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.property(String::class.java)");
        this.host = regularFileProperty;
        regularFileProperty = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.property(String::class.java)");
        this.token = regularFileProperty;
        regularFileProperty = objectFactory.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.listProperty(String::class.java)");
        this.channels = regularFileProperty;
        this.context = this;
        this.setEnabled(!this.getProject().getGradle().getStartParameter().isOffline());
    }

    @NotNull
    public final RegularFileProperty getDistributionFile() {
        return this.distributionFile;
    }

    @NotNull
    public final Property<String> getHost() {
        return this.host;
    }

    @NotNull
    public final Property<String> getToken() {
        return this.token;
    }

    @NotNull
    public final ListProperty<String> getChannels() {
        return this.channels;
    }

    private static /* synthetic */ void getContext$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void publishPlugin() {
        this.validateInput();
        File file = ((RegularFile)this.distributionFile.get()).getAsFile();
        IdePluginManager idePluginManager = IdePluginManager.Companion.createManager();
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
        PluginCreationResult creationResult = idePluginManager.createPlugin(path);
        if (creationResult instanceof PluginCreationSuccess) {
            String pluginId = ((IdePlugin)((PluginCreationSuccess)creationResult).getPlugin()).getPluginId();
            Object object = this.channels.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"channels.get()");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String channel = (String)element$iv;
                boolean bl = false;
                Utils.info$default((Object)this.context, "Uploading plugin " + pluginId + " from " + file.getAbsolutePath() + " to " + this.getHost().get() + ", channel: " + channel, null, 4, null);
                try {
                    void it;
                    Object object2 = this.getHost().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"host.get()");
                    PluginRepository repositoryClient = PluginRepositoryFactory.create((String)((String)object2), (String)((String)this.getToken().get()));
                    PluginUploader pluginUploader = repositoryClient.getUploader();
                    if (pluginId == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String{ org.jetbrains.intellij.pluginRepository.model.TypeAliasesKt.PluginXmlId }");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    object2 = channel;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object object3 = object2;
                    File file2 = file;
                    String string = pluginId;
                    PluginUploader pluginUploader2 = pluginUploader;
                    boolean bl4 = false;
                    boolean bl5 = !Intrinsics.areEqual((Object)it, (Object)"default");
                    pluginUploader2.uploadPlugin(string, file2, (String)(bl5 ? object2 : null), null);
                    Utils.info$default((Object)this.context, "Uploaded successfully", null, 4, null);
                }
                catch (Exception exception) {
                    throw new TaskExecutionException((Task)this, (Throwable)new GradleException("Failed to upload plugin. " + exception + ".message", (Throwable)exception));
                }
            }
        } else {
            if (creationResult instanceof PluginCreationFail) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = ((PluginCreationFail)creationResult).getErrorsAndWarnings();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginProblem it = (PluginProblem)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getLevel() == PluginProblem.Level.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                String problems = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
                throw new TaskExecutionException((Task)this, (Throwable)new GradleException(Intrinsics.stringPlus((String)"Cannot upload plugin. ", (Object)problems)));
            }
            throw new TaskExecutionException((Task)this, (Throwable)new GradleException(Intrinsics.stringPlus((String)"Cannot upload plugin. ", (Object)creationResult)));
        }
    }

    private final void validateInput() {
        CharSequence charSequence = (CharSequence)this.token.getOrNull();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            throw new TaskExecutionException((Task)this, (Throwable)new GradleException("token property must be specified for plugin publishing"));
        }
    }
}

