/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.jbr;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecOperations;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.jbr.Jbr;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Incubating
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001 B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver;", "", "jreRepository", "", "isOffline", "", "context", "repositoryHandler", "Lorg/gradle/api/artifacts/dsl/RepositoryHandler;", "dependencyHandler", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "configurationContainer", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Ljava/lang/String;ZLjava/lang/Object;Lorg/gradle/api/artifacts/dsl/RepositoryHandler;Lorg/gradle/api/artifacts/dsl/DependencyHandler;Lorg/gradle/api/artifacts/ConfigurationContainer;Lorg/gradle/process/ExecOperations;)V", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "kotlin.jvm.PlatformType", "findJavaExecutable", "Ljava/nio/file/Path;", "javaHome", "Ljava/io/File;", "fromDir", "Lorg/jetbrains/intellij/jbr/Jbr;", "javaDir", "version", "getJavaArchive", "jbrArtifact", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "getJbrRoot", "resolve", "JbrArtifact", "gradle-intellij-plugin"})
public class JbrResolver {
    @NotNull
    private final String jreRepository;
    private final boolean isOffline;
    @NotNull
    private final Object context;
    @NotNull
    private final RepositoryHandler repositoryHandler;
    @NotNull
    private final DependencyHandler dependencyHandler;
    @NotNull
    private final ConfigurationContainer configurationContainer;
    @NotNull
    private final ExecOperations execOperations;
    private final OperatingSystem operatingSystem;

    @Inject
    public JbrResolver(@NotNull String jreRepository, boolean isOffline, @NotNull Object context, @NotNull RepositoryHandler repositoryHandler, @NotNull DependencyHandler dependencyHandler, @NotNull ConfigurationContainer configurationContainer, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)jreRepository, (String)"jreRepository");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)repositoryHandler, (String)"repositoryHandler");
        Intrinsics.checkNotNullParameter((Object)dependencyHandler, (String)"dependencyHandler");
        Intrinsics.checkNotNullParameter((Object)configurationContainer, (String)"configurationContainer");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.jreRepository = jreRepository;
        this.isOffline = isOffline;
        this.context = context;
        this.repositoryHandler = repositoryHandler;
        this.dependencyHandler = dependencyHandler;
        this.configurationContainer = configurationContainer;
        this.execOperations = execOperations;
        this.operatingSystem = OperatingSystem.current();
    }

    @Nullable
    public final Jbr resolve(@Nullable String version) {
        Jbr jbr;
        CharSequence charSequence = version;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        Object object = "8";
        boolean bl3 = false;
        boolean bl4 = false;
        String string = object;
        JbrArtifact.Companion companion = JbrArtifact.Companion;
        boolean bl5 = false;
        boolean bl6 = StringsKt.startsWith$default((CharSequence)version, (char)'u', (boolean)false, (int)2, null);
        Object object2 = bl6 ? object : null;
        String string2 = Intrinsics.stringPlus((String)(object2 == null ? "" : object2), (Object)version);
        object2 = this.operatingSystem;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"operatingSystem");
        JbrArtifact jbrArtifact = companion.from(string2, (OperatingSystem)object2);
        object2 = this.getJavaArchive(jbrArtifact);
        if (object2 == null) {
            jbr = null;
        } else {
            object = object2;
            bl3 = false;
            bl4 = false;
            Object it = object;
            boolean bl7 = false;
            String string3 = ((File)it).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.path");
            File javaDir = FilesKt.resolve((File)new File(StringsKt.replaceAfter$default((String)string3, (String)jbrArtifact.getName(), (String)"", null, (int)4, null)), (String)"extracted");
            Utils.extractArchive$default((File)it, javaDir, this.execOperations, this.context, null, null, 48, null);
            jbr = this.fromDir(javaDir, version);
        }
        return jbr;
    }

    private final Jbr fromDir(File javaDir, String version) {
        Path javaExecutable = this.findJavaExecutable(javaDir);
        if (javaExecutable == null) {
            Utils.warn$default(this.context, Intrinsics.stringPlus((String)"Cannot find java executable in ", (Object)javaDir), null, 4, null);
            return null;
        }
        return new Jbr(version, javaDir, javaExecutable.toFile().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File getJavaArchive(JbrArtifact jbrArtifact) {
        Object object;
        if (this.isOffline) {
            Utils.warn$default(this.context, "Cannot download JetBrains Java Runtime " + jbrArtifact.getName() + ". Gradle runs in offline mode.", null, 4, null);
            return null;
        }
        String string = this.jreRepository;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        String string2 = charSequence.length() > 0 ? string : null;
        String url = string2 == null ? jbrArtifact.getRepositoryUrl() : string2;
        IvyArtifactRepository repository = this.repositoryHandler.ivy(arg_0 -> JbrResolver.getJavaArchive$lambda-5(url, arg_0));
        Dependency dependency = Utils.create$default(this.dependencyHandler, "com.jetbrains", "jbre", jbrArtifact.getName(), null, "tar.gz", null, 40, null);
        try {
            object = new Dependency[]{dependency};
            object = this.configurationContainer.detachedConfiguration(object).getSingleFile();
        }
        catch (Exception e) {
            Utils.warn(this.context, Intrinsics.stringPlus((String)"Cannot download JetBrains Java Runtime ", (Object)jbrArtifact.getName()), e);
            object = null;
        }
        finally {
            this.repositoryHandler.remove((Object)repository);
        }
        return object;
    }

    private final Path findJavaExecutable(File javaHome) {
        File root = this.getJbrRoot(javaHome);
        File jre = new File(root, "jre");
        Object object = jre;
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        boolean bl4 = ((File)it).exists();
        Object object2 = bl4 ? object : null;
        object = ".exe";
        bl = false;
        bl2 = false;
        it = object;
        String string = "bin/java";
        File file = object2 == null ? root : object2;
        boolean bl5 = false;
        boolean bl6 = this.operatingSystem.isWindows();
        object2 = bl6 ? object : null;
        String string2 = Intrinsics.stringPlus((String)string, (Object)(object2 == null ? "" : object2));
        File file2 = file;
        File java = new File(file2, string2);
        object2 = java.toPath();
        boolean bl7 = false;
        bl = false;
        Object it2 = object2;
        boolean bl8 = false;
        return java.exists() ? object2 : null;
    }

    private final File getJbrRoot(File javaHome) {
        String string;
        File file;
        block12: {
            File[] fileArray = javaHome.listFiles();
            if (fileArray == null) {
                file = null;
            } else {
                File[] $this$first$iv = fileArray;
                boolean $i$f$first = false;
                File[] fileArray2 = $this$first$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"jbr") || Intrinsics.areEqual((Object)it.getName(), (Object)"jbrsdk"))) continue;
                    file = element$iv;
                    break block12;
                }
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
        }
        File jbr = file;
        if (jbr != null && jbr.exists()) {
            File file2;
            boolean bl = this.operatingSystem.isMacOsX();
            if (bl) {
                file2 = new File(jbr, "Contents/Home");
            } else if (!bl) {
                file2 = jbr;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return file2;
        }
        boolean bl = this.operatingSystem.isMacOsX();
        if (bl) {
            string = "jdk/Contents/Home";
        } else if (!bl) {
            string = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return new File(javaHome, string);
    }

    private static final void getJavaArchive$lambda-5$lambda-3(IvyPatternRepositoryLayout it) {
        it.artifact("[revision].tar.gz");
    }

    private static final void getJavaArchive$lambda-5$lambda-4(IvyArtifactRepository.MetadataSources it) {
        it.artifact();
    }

    private static final void getJavaArchive$lambda-5(String $url, IvyArtifactRepository ivy) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        ivy.setUrl(new URI($url));
        ivy.patternLayout(JbrResolver::getJavaArchive$lambda-5$lambda-3);
        ivy.metadataSources(JbrResolver::getJavaArchive$lambda-5$lambda-4);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "", "name", "", "repositoryUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getRepositoryUrl", "Companion", "gradle-intellij-plugin"})
    private static final class JbrArtifact {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final String repositoryUrl;

        public JbrArtifact(@NotNull String name, @NotNull String repositoryUrl) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
            this.name = name;
            this.repositoryUrl = repositoryUrl;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact$Companion;", "", "()V", "arch", "", "newFormat", "", "from", "Lorg/jetbrains/intellij/jbr/JbrResolver$JbrArtifact;", "version", "operatingSystem", "Lorg/gradle/internal/os/OperatingSystem;", "getPrefix", "platform", "gradle-intellij-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final JbrArtifact from(@NotNull String version, @NotNull OperatingSystem operatingSystem) {
                boolean oldFormat;
                String string;
                boolean bl;
                String string2;
                int n;
                int n2;
                String string3;
                boolean bl2;
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)operatingSystem, (String)"operatingSystem");
                String prefix = this.getPrefix(version);
                int lastIndexOfB = StringsKt.lastIndexOf$default((CharSequence)version, (char)'b', (int)0, (boolean)false, (int)6, null);
                boolean bl3 = bl2 = lastIndexOfB > -1;
                if (bl2) {
                    string3 = version;
                    n2 = prefix.length();
                    n = 0;
                    String string4 = string3.substring(n2, lastIndexOfB);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                } else if (!bl2) {
                    string3 = version;
                    n2 = prefix.length();
                    n = 0;
                    String string5 = string3.substring(n2);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String majorVersion = string2;
                boolean bl4 = bl = lastIndexOfB > -1;
                if (bl) {
                    String string6 = version;
                    n = lastIndexOfB + 1;
                    boolean bl5 = false;
                    String string7 = string6.substring(n);
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                } else {
                    string = "";
                }
                String buildNumberString = string;
                VersionNumber buildNumber = VersionNumber.parse((String)buildNumberString);
                boolean isJava8 = StringsKt.startsWith$default((CharSequence)majorVersion, (char)'8', (boolean)false, (int)2, null);
                String repositoryUrl = "https://cache-redirector.jetbrains.com/intellij-jbr";
                boolean bl6 = oldFormat = Intrinsics.areEqual((Object)prefix, (Object)"jbrex") || isJava8 && buildNumber.compareTo(VersionNumber.parse((String)"1483.24")) < 0;
                if (oldFormat) {
                    return new JbrArtifact("jbrex" + majorVersion + 'b' + buildNumberString + '_' + this.platform(operatingSystem) + '_' + this.arch(false), repositoryUrl);
                }
                CharSequence charSequence = prefix;
                boolean bl7 = false;
                if (charSequence.length() == 0) {
                    prefix = isJava8 ? "jbrx-" : (buildNumber.compareTo(VersionNumber.parse((String)"1319.6")) < 0 ? "jbr-" : "jbr_jcef-");
                }
                return new JbrArtifact(prefix + majorVersion + '-' + this.platform(operatingSystem) + '-' + this.arch(isJava8) + "-b" + buildNumberString, repositoryUrl);
            }

            private final String getPrefix(String version) {
                return StringsKt.startsWith$default((String)version, (String)"jbrsdk-", (boolean)false, (int)2, null) ? "jbrsdk-" : (StringsKt.startsWith$default((String)version, (String)"jbr_jcef-", (boolean)false, (int)2, null) ? "jbr_jcef-" : (StringsKt.startsWith$default((String)version, (String)"jbr-", (boolean)false, (int)2, null) ? "jbr-" : (StringsKt.startsWith$default((String)version, (String)"jbrx-", (boolean)false, (int)2, null) ? "jbrx-" : (StringsKt.startsWith$default((String)version, (String)"jbrex8", (boolean)false, (int)2, null) ? "jbrex" : ""))));
            }

            private final String platform(OperatingSystem operatingSystem) {
                return operatingSystem.isWindows() ? "windows" : (operatingSystem.isMacOsX() ? "osx" : "linux");
            }

            private final String arch(boolean newFormat) {
                String string;
                String arch = System.getProperty("os.arch");
                if (Intrinsics.areEqual((Object)"aarch64", (Object)arch) || Intrinsics.areEqual((Object)"arm64", (Object)arch)) {
                    return "aarch64";
                }
                if (Intrinsics.areEqual((Object)"x86_64", (Object)arch) || Intrinsics.areEqual((Object)"amd64", (Object)arch)) {
                    return "x64";
                }
                String name = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (StringsKt.contains$default((CharSequence)name, (CharSequence)"Windows", (boolean)false, (int)2, null) && System.getenv("ProgramFiles(x86)") != null) {
                    return "x64";
                }
                boolean bl = newFormat;
                if (bl) {
                    string = "i586";
                } else if (!bl) {
                    string = "x86";
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

