/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/intellij/dependency/MavenPluginsRepository;", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "repositoryUrl", "", "(Ljava/lang/String;)V", "resolvedDependency", "", "postResolve", "", "project", "Lorg/gradle/api/Project;", "resolve", "Ljava/io/File;", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "gradle-intellij-plugin"})
public final class MavenPluginsRepository
implements PluginsRepository {
    @NotNull
    private final String repositoryUrl;
    private boolean resolvedDependency;

    public MavenPluginsRepository(@NotNull String repositoryUrl) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        this.repositoryUrl = repositoryUrl;
    }

    @Override
    @Nullable
    public File resolve(@NotNull Project project, @NotNull PluginDependencyNotation plugin) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Dependency dependency = plugin.toDependency(project);
        Utils.debug$default(project, "Adding Maven repository to download " + dependency + " - " + this.repositoryUrl, null, 4, null);
        MavenArtifactRepository mavenRepository = project.getRepositories().maven(arg_0 -> MavenPluginsRepository.resolve$lambda-0(this, arg_0));
        File pluginFile = null;
        try {
            Dependency[] dependencyArray = new Dependency[]{dependency};
            Configuration configuration = project.getConfigurations().detachedConfiguration(dependencyArray);
            pluginFile = configuration.getSingleFile();
            this.resolvedDependency = true;
        }
        catch (Exception e) {
            Utils.debug(project, "Couldn't find " + dependency + " in " + this.repositoryUrl, e);
        }
        Utils.debug$default(project, Intrinsics.stringPlus((String)"Removing Maven repository ", (Object)this.repositoryUrl), null, 4, null);
        project.getRepositories().remove((Object)mavenRepository);
        return pluginFile;
    }

    @Override
    public void postResolve(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.resolvedDependency) {
            Utils.debug$default(project, Intrinsics.stringPlus((String)"Adding Maven plugins repository ", (Object)this.repositoryUrl), null, 4, null);
            project.getRepositories().maven(arg_0 -> MavenPluginsRepository.postResolve$lambda-1(this, arg_0));
        }
    }

    private static final void resolve$lambda-0(MavenPluginsRepository this$0, MavenArtifactRepository it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setUrl(URI.create(this$0.repositoryUrl));
    }

    private static final void postResolve$lambda-1(MavenPluginsRepository this$0, MavenArtifactRepository it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setUrl(URI.create(this$0.repositoryUrl));
    }
}

