/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingParser;
import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;
import org.jetbrains.intellij.dependency.PluginsRepository;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/intellij/dependency/CustomPluginsRepository;", "Lorg/jetbrains/intellij/dependency/PluginsRepository;", "repositoryUrl", "", "(Ljava/lang/String;)V", "pluginsXmlUri", "Ljava/net/URI;", "downloadZipArtifact", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "url", "plugin", "Lorg/jetbrains/intellij/dependency/PluginDependencyNotation;", "postResolve", "", "resolve", "gradle-intellij-plugin"})
public final class CustomPluginsRepository
implements PluginsRepository {
    @NotNull
    private final URI pluginsXmlUri;
    @NotNull
    private final String repositoryUrl;

    public CustomPluginsRepository(@NotNull String repositoryUrl) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        URI uri = new URI(repositoryUrl);
        Object object = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uri.path");
        if (StringsKt.endsWith$default((String)object, (String)".xml", (boolean)false, (int)2, null)) {
            object = repositoryUrl;
            int n = 0;
            int n2 = StringsKt.lastIndexOf$default((CharSequence)repositoryUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string = ((String)object).substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            this.repositoryUrl = string;
            this.pluginsXmlUri = uri;
        } else {
            this.repositoryUrl = repositoryUrl;
            object = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), Intrinsics.stringPlus((String)uri.getPath(), (Object)"/"), uri.getQuery(), uri.getFragment()).resolve("updatePlugins.xml");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"URI(uri.scheme, uri.userInfo, uri.host, uri.port, \"${uri.path}/\", uri.query, uri.fragment)\n                .resolve(\"updatePlugins.xml\")");
            this.pluginsXmlUri = object;
        }
    }

    @Override
    @Nullable
    public File resolve(@NotNull Project project, @NotNull PluginDependencyNotation plugin) {
        String string;
        Object v0;
        boolean bl;
        Object object;
        URL uRL;
        String downloadUrl;
        URL url;
        block8: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Utils.debug$default(project, Intrinsics.stringPlus((String)"Loading list of plugins from: ", (Object)this.pluginsXmlUri), null, 4, null);
            url = this.pluginsXmlUri.toURL();
            downloadUrl = null;
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
            uRL = url;
            object = Charsets.UTF_8;
            bl = false;
            Object object2 = TextStreamsKt.readBytes((URL)uRL);
            boolean bl2 = false;
            boolean bl3 = false;
            List pluginRepository = CustomPluginRepositoryListingParser.INSTANCE.parseListOfPlugins(new String((byte[])object2, (Charset)object), url, new URL(this.repositoryUrl), CustomPluginRepositoryListingType.PLUGIN_REPOSITORY);
            object = pluginRepository;
            bl = false;
            object2 = object;
            bl2 = false;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                CustomPluginRepositoryListingParser.PluginInfo it = (CustomPluginRepositoryListingParser.PluginInfo)t;
                boolean bl4 = false;
                if (!(StringsKt.equals((String)it.getPluginId(), (String)plugin.getId(), (boolean)true) && StringsKt.equals((String)it.getVersion(), (String)plugin.getVersion(), (boolean)true))) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        uRL = v0;
        if (uRL == null) {
            string = null;
        } else {
            object = uRL;
            bl = false;
            boolean bl5 = false;
            Object it = object;
            boolean bl6 = false;
            string = this.repositoryUrl + '/' + it.getDownloadUrl();
        }
        downloadUrl = string;
        if (downloadUrl == null) {
            String string2;
            Object v2;
            boolean bl7;
            Object object3;
            block9: {
                object = url;
                object3 = Charsets.UTF_8;
                bl7 = false;
                Object object4 = TextStreamsKt.readBytes((URL)object);
                boolean bl6 = false;
                boolean bl8 = false;
                List plugins = CustomPluginRepositoryListingParser.INSTANCE.parseListOfPlugins(new String((byte[])object4, (Charset)object3), url, new URL(this.repositoryUrl), CustomPluginRepositoryListingType.SIMPLE);
                object3 = plugins;
                bl7 = false;
                object4 = object3;
                bl6 = false;
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    CustomPluginRepositoryListingParser.PluginInfo it = (CustomPluginRepositoryListingParser.PluginInfo)t;
                    boolean bl9 = false;
                    if (!(StringsKt.equals((String)it.getPluginId(), (String)plugin.getId(), (boolean)true) && StringsKt.equals((String)it.getVersion(), (String)plugin.getVersion(), (boolean)true))) continue;
                    v2 = t;
                    break block9;
                }
                v2 = null;
            }
            object = v2;
            if (object == null) {
                string2 = null;
            } else {
                object3 = object;
                bl7 = false;
                boolean bl10 = false;
                Object it = object3;
                boolean bl11 = false;
                string2 = String.valueOf(it.getDownloadUrl());
            }
            downloadUrl = string2;
        }
        if (downloadUrl == null) {
            return null;
        }
        return this.downloadZipArtifact(project, downloadUrl, plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File downloadZipArtifact(Project project, String url, PluginDependencyNotation plugin) {
        IvyArtifactRepository repository = project.getRepositories().ivy(arg_0 -> CustomPluginsRepository.downloadZipArtifact$lambda-6(url, arg_0));
        Object object = project.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.dependencies");
        Dependency dependency = Utils.create$default((DependencyHandler)object, "com.jetbrains.plugins", plugin.getId(), plugin.getVersion(), null, "zip", null, 40, null);
        try {
            object = new Dependency[]{dependency};
            object = project.getConfigurations().detachedConfiguration(object).getSingleFile();
        }
        catch (Exception e) {
            Utils.warn(project, "Cannot download plugin from custom repository: " + plugin.getId() + ':' + plugin.getVersion(), e);
            object = null;
        }
        finally {
            project.getRepositories().remove((Object)repository);
        }
        return object;
    }

    @Override
    public void postResolve(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
    }

    private static final void downloadZipArtifact$lambda-6$lambda-4(IvyPatternRepositoryLayout it) {
        it.artifact("");
    }

    private static final void downloadZipArtifact$lambda-6$lambda-5(IvyArtifactRepository.MetadataSources it) {
        it.artifact();
    }

    private static final void downloadZipArtifact$lambda-6(String $url, IvyArtifactRepository ivy) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        ivy.setUrl(new URI($url));
        ivy.patternLayout(CustomPluginsRepository::downloadZipArtifact$lambda-6$lambda-4);
        ivy.metadataSources(CustomPluginsRepository::downloadZipArtifact$lambda-6$lambda-5);
    }
}

