/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.dependency;

import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.Utils;
import org.jetbrains.intellij.dependency.PluginDependency;
import org.jetbrains.intellij.dependency.PluginDependencyNotation;

@ToString(includeNames=true, includeFields=true, ignoreNulls=true)
public class PluginDependencyImpl
implements PluginDependency,
GroovyObject {
    @NotNull
    private String id;
    @NotNull
    private String version;
    @Nullable
    private String channel;
    @Nullable
    private String sinceBuild;
    @Nullable
    private String untilBuild;
    @Nullable
    private File classesDirectory;
    @Nullable
    private File metaInfDirectory;
    @Nullable
    private File sourcesDirectory;
    @NotNull
    private File artifact;
    @NotNull
    private Collection<File> jarFiles;
    private boolean builtin;
    private boolean maven;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public PluginDependencyImpl(@NotNull String id, @NotNull String version, @NotNull File artifact, boolean builtin, boolean maven) {
        boolean bl;
        boolean bl2;
        File file;
        File file2;
        String string;
        String string2;
        MetaClass metaClass;
        Set set = Collections.emptySet();
        this.jarFiles = set;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.id = string2 = id;
        this.version = string = version;
        this.artifact = file2 = artifact;
        this.sourcesDirectory = file = this.sourcesDirectory;
        this.builtin = bl2 = builtin;
        this.maven = bl = maven;
        this.initFiles();
    }

    @Generated
    public PluginDependencyImpl(@NotNull String id, @NotNull String version, @NotNull File artifact, boolean builtin) {
        this(id, version, artifact, builtin, false);
    }

    @Generated
    public PluginDependencyImpl(@NotNull String id, @NotNull String version, @NotNull File artifact) {
        this(id, version, artifact, false, false);
    }

    private Object initFiles() {
        if (Utils.isJarFile(this.artifact)) {
            List<File> list = Collections.singletonList(this.artifact);
            this.jarFiles = list;
        }
        if (this.artifact.isDirectory()) {
            File lib = new File(this.artifact, "lib");
            if (lib.isDirectory()) {
                public final class _initFiles_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _initFiles_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object file) {
                        return true;
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _initFiles_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Collection<File> collection = Utils.collectJars(lib, (Predicate)ScriptBytecodeAdapter.castToType((Object)((Object)new _initFiles_closure1(this, this)), Predicate.class));
                this.jarFiles = collection;
            }
            File classes = new File(this.artifact, "classes");
            if (classes.isDirectory()) {
                File file;
                this.classesDirectory = file = classes;
            }
            File metaInf = new File(this.artifact, "META-INF");
            if (metaInf.isDirectory()) {
                File file;
                this.metaInfDirectory = file = metaInf;
                return file;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isCompatible(@NotNull IdeVersion ideVersion) {
        return this.sinceBuild == null || ScriptBytecodeAdapter.compareLessThanEqual((Object)IdeVersion.createIdeVersion((String)this.sinceBuild), (Object)ideVersion) && (this.untilBuild == null || ScriptBytecodeAdapter.compareLessThanEqual((Object)ideVersion, (Object)IdeVersion.createIdeVersion((String)this.untilBuild)));
    }

    @Override
    public PluginDependencyNotation getNotation() {
        return new PluginDependencyNotation(this.id, this.version, this.channel);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        String string;
        this.id = string = id;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        String string;
        this.version = string = version;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        String string;
        this.channel = string = channel;
    }

    public String getSinceBuild() {
        return this.sinceBuild;
    }

    public void setSinceBuild(String sinceBuild) {
        String string;
        this.sinceBuild = string = sinceBuild;
    }

    public String getUntilBuild() {
        return this.untilBuild;
    }

    public void setUntilBuild(String untilBuild) {
        String string;
        this.untilBuild = string = untilBuild;
    }

    @Override
    public File getArtifact() {
        return this.artifact;
    }

    public void setArtifact(File artifact) {
        File file;
        this.artifact = file = artifact;
    }

    @Override
    public Collection<File> getJarFiles() {
        return this.jarFiles;
    }

    public void setJarFiles(Collection<File> jarFiles) {
        Collection<File> collection = jarFiles;
        this.jarFiles = collection;
    }

    @Override
    @Nullable
    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(@Nullable File classesDirectory) {
        File file;
        this.classesDirectory = file = classesDirectory;
    }

    @Override
    @Nullable
    public File getMetaInfDirectory() {
        return this.metaInfDirectory;
    }

    public void setMetaInfDirectory(@Nullable File metaInfDirectory) {
        File file;
        this.metaInfDirectory = file = metaInfDirectory;
    }

    @Override
    @Nullable
    public File getSourcesDirectory() {
        return this.sourcesDirectory;
    }

    public void setSourcesDirectory(@Nullable File sourcesDirectory) {
        File file;
        this.sourcesDirectory = file = sourcesDirectory;
    }

    @Override
    public boolean isMaven() {
        return this.maven;
    }

    public boolean setMaven(boolean maven) {
        boolean bl;
        this.maven = bl = maven;
        return bl;
    }

    @Override
    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setBuiltin(boolean builtin) {
        boolean bl;
        this.builtin = bl = builtin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginDependencyImpl)) {
            return false;
        }
        PluginDependencyImpl that = (PluginDependencyImpl)ScriptBytecodeAdapter.castToType((Object)o, PluginDependencyImpl.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.builtin, (Object)that.isBuiltin())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.artifact, (Object)that.getArtifact())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.channel, (Object)that.getChannel())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.classesDirectory, (Object)that.getClassesDirectory())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.sourcesDirectory, (Object)that.getSourcesDirectory())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.id, (Object)that.getId())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual(this.jarFiles, that.getJarFiles())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.metaInfDirectory, (Object)that.getMetaInfDirectory())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.sinceBuild, (Object)that.getSinceBuild())) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.untilBuild, (Object)that.getUntilBuild())) {
            return false;
        }
        return !ScriptBytecodeAdapter.compareNotEqual((Object)this.version, (Object)that.getVersion());
    }

    public int hashCode() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int result = 0;
        result = n11 = this.id.hashCode();
        result = n10 = 31 * result + this.version.hashCode();
        result = n9 = 31 * result + (this.channel != null ? this.channel.hashCode() : 0);
        result = n8 = 31 * result + (this.sinceBuild != null ? this.sinceBuild.hashCode() : 0);
        result = n7 = 31 * result + (this.untilBuild != null ? this.untilBuild.hashCode() : 0);
        result = n6 = 31 * result + (this.classesDirectory != null ? this.classesDirectory.hashCode() : 0);
        result = n5 = 31 * result + (this.sourcesDirectory != null ? this.sourcesDirectory.hashCode() : 0);
        result = n4 = 31 * result + (this.metaInfDirectory != null ? this.metaInfDirectory.hashCode() : 0);
        result = n3 = 31 * result + this.artifact.hashCode();
        result = n2 = 31 * result + this.jarFiles.hashCode();
        result = n = 31 * result + (this.builtin ? 1 : 0);
        return result;
    }

    @Generated
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("org.jetbrains.intellij.dependency.PluginDependencyImpl(");
        if (this.version != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("version:");
            _result.append(InvokerHelper.toString((Object)this.version));
        }
        if (true) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl3;
                $toStringFirst = bl3 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("builtin:");
            _result.append(InvokerHelper.toString((Object)this.builtin));
        }
        if (this.channel != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl4;
                $toStringFirst = bl4 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("channel:");
            _result.append(InvokerHelper.toString((Object)this.channel));
        }
        if (true) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl5;
                $toStringFirst = bl5 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("maven:");
            _result.append(InvokerHelper.toString((Object)this.maven));
        }
        if (this.artifact != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl6;
                $toStringFirst = bl6 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("artifact:");
            _result.append(InvokerHelper.toString((Object)this.artifact));
        }
        if (this.id != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl7;
                $toStringFirst = bl7 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("id:");
            _result.append(InvokerHelper.toString((Object)this.id));
        }
        if (this.getNotation() != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl8;
                $toStringFirst = bl8 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("notation:");
            _result.append(InvokerHelper.toString((Object)this.getNotation()));
        }
        if (this.untilBuild != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl9;
                $toStringFirst = bl9 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("untilBuild:");
            _result.append(InvokerHelper.toString((Object)this.untilBuild));
        }
        if (this.jarFiles != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl10;
                $toStringFirst = bl10 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("jarFiles:");
            _result.append(InvokerHelper.toString(this.jarFiles));
        }
        if (this.sinceBuild != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl11;
                $toStringFirst = bl11 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("sinceBuild:");
            _result.append(InvokerHelper.toString((Object)this.sinceBuild));
        }
        if (this.sourcesDirectory != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl12;
                $toStringFirst = bl12 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("sourcesDirectory:");
            _result.append(InvokerHelper.toString((Object)this.sourcesDirectory));
        }
        if (this.metaInfDirectory != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl13;
                $toStringFirst = bl13 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("metaInfDirectory:");
            _result.append(InvokerHelper.toString((Object)this.metaInfDirectory));
        }
        if (this.classesDirectory != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl14;
                $toStringFirst = bl14 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            _result.append("classesDirectory:");
            _result.append(InvokerHelper.toString((Object)this.classesDirectory));
        }
        _result.append(")");
        return _result.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PluginDependencyImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

