/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.changelog;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.changelog.Changelog;
import org.jetbrains.changelog.ChangelogPlugin;
import org.jetbrains.changelog.ChangelogPluginConstants;
import org.jetbrains.changelog.ChangelogPluginExtension;
import org.jetbrains.changelog.ChangelogSectionUrlBuilder;
import org.jetbrains.changelog.ExtensionsKt;
import org.jetbrains.changelog.exceptions.VersionNotSpecifiedException;
import org.jetbrains.changelog.tasks.GetChangelogTask;
import org.jetbrains.changelog.tasks.InitializeChangelogTask;
import org.jetbrains.changelog.tasks.PatchChangelogTask;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/changelog/ChangelogPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "checkGradleVersion", "gradle-changelog-plugin"})
@SourceDebugExtension(value={"SMAP\nChangelogPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangelogPlugin.kt\norg/jetbrains/changelog/ChangelogPlugin\n+ 2 ExtensionContainerExtensions.kt\norg/gradle/kotlin/dsl/ExtensionContainerExtensionsKt\n+ 3 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,181:1\n96#2:182\n246#3:183\n246#3:184\n246#3:185\n*S KotlinDebug\n*F\n+ 1 ChangelogPlugin.kt\norg/jetbrains/changelog/ChangelogPlugin\n*L\n35#1:182\n135#1:183\n152#1:184\n166#1:185\n*E\n"})
public final class ChangelogPlugin
implements Plugin<Project> {
    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        String name$iv;
        TaskContainer $this$register$iv;
        void name$iv2;
        Object $this$create$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.checkGradleVersion();
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"getExtensions(...)");
        ExtensionContainer extensionContainer2 = extensionContainer;
        String string = "changelog";
        Object[] constructionArguments$iv = new Object[]{};
        boolean $i$f$create22 = false;
        Object object = $this$create$iv.create((String)name$iv2, ChangelogPluginExtension.class, Arrays.copyOf(constructionArguments$iv, constructionArguments$iv.length));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        $this$create$iv = object;
        ChangelogPluginExtension $this$apply_u24lambda_u240 = (ChangelogPluginExtension)$this$create$iv;
        boolean $i$a$-apply-ChangelogPlugin$apply$extension$22 = false;
        $this$apply_u24lambda_u240.getPath().convention(project.provider(new Callable(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final String call() {
                return this.$project.file((Object)"CHANGELOG.md").getCanonicalPath();
            }
        }).map((Transformer)apply.extension.1.2.INSTANCE));
        $this$apply_u24lambda_u240.getVersionPrefix().convention(project.provider((Callable)apply.extension.1.3.INSTANCE));
        $this$apply_u24lambda_u240.getVersion().convention(project.provider(new Callable(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final String call() {
                String string;
                String it = string = this.$project.getVersion().toString();
                boolean bl = false;
                String string2 = !Intrinsics.areEqual((Object)it, (Object)"unspecified") ? string : null;
                if (string2 == null) {
                    throw new VersionNotSpecifiedException();
                }
                return string2;
            }
        }));
        $this$apply_u24lambda_u240.getHeader().convention(project.provider(new Callable($this$apply_u24lambda_u240){
            final /* synthetic */ ChangelogPluginExtension $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final String call() {
                return this.$this_apply.getVersion().get() + " - " + ExtensionsKt.date$default(null, 1, null);
            }
        }));
        $this$apply_u24lambda_u240.getUnreleasedTerm().convention((Object)"Unreleased");
        $this$apply_u24lambda_u240.getKeepUnreleasedSection().convention((Object)true);
        $this$apply_u24lambda_u240.getPatchEmpty().convention((Object)true);
        $this$apply_u24lambda_u240.getGroups().convention((Iterable)ChangelogPluginConstants.INSTANCE.getGROUPS());
        $this$apply_u24lambda_u240.getItemPrefix().convention((Object)"-");
        $this$apply_u24lambda_u240.getCombinePreReleases().convention((Object)true);
        $this$apply_u24lambda_u240.getLineSeparator().convention($this$apply_u24lambda_u240.getPath().map((Transformer)apply.extension.1.6.INSTANCE));
        $this$apply_u24lambda_u240.getRepositoryUrl().map((Transformer)apply.extension.1.7.INSTANCE);
        $this$apply_u24lambda_u240.getHeaderInlineLink().convention((Object)false);
        $this$apply_u24lambda_u240.getSectionUrlBuilder().convention((Object)new ChangelogSectionUrlBuilder($this$apply_u24lambda_u240){
            final /* synthetic */ ChangelogPluginExtension $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final String build(String repositoryUrl, String currentVersion, String previousVersion, boolean isUnreleased) {
                Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
                Object object = this.$this_apply.getVersionPrefix().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                String prefix = (String)object;
                return repositoryUrl + (String)(isUnreleased ? (previousVersion == null ? "/commits" : "/compare/" + prefix + previousVersion + "...HEAD") : (previousVersion == null ? "/commits/" + prefix + currentVersion : "/compare/" + prefix + previousVersion + "..." + prefix + currentVersion));
            }
        });
        $this$apply_u24lambda_u240.getInstance().convention(project.provider(new Callable($this$apply_u24lambda_u240){
            final /* synthetic */ ChangelogPluginExtension $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final Changelog call() {
                Object object = this.$this_apply.getPath().map((Transformer)apply.extension.1.1.INSTANCE).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                String string = (String)object;
                String string2 = (String)this.$this_apply.getPreTitle().getOrNull();
                String string3 = (String)this.$this_apply.getTitle().getOrNull();
                String string4 = (String)this.$this_apply.getIntroduction().getOrNull();
                Object object2 = this.$this_apply.getUnreleasedTerm().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                String string5 = (String)object2;
                Object object3 = this.$this_apply.getGroups().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                List list = (List)object3;
                Object object4 = this.$this_apply.getGetHeaderParserRegex().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                Regex regex = (Regex)object4;
                Object object5 = this.$this_apply.getItemPrefix().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
                String string6 = (String)object5;
                String string7 = (String)this.$this_apply.getRepositoryUrl().getOrNull();
                Object object6 = this.$this_apply.getSectionUrlBuilder().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
                ChangelogSectionUrlBuilder changelogSectionUrlBuilder = (ChangelogSectionUrlBuilder)object6;
                Object object7 = this.$this_apply.getLineSeparator().get();
                Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
                String string8 = (String)object7;
                Object object8 = this.$this_apply.getHeaderInlineLink().get();
                Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
                return new Changelog(string, string2, string3, string4, string5, list, regex, string6, string7, changelogSectionUrlBuilder, string8, (Boolean)object8);
            }
        }));
        ChangelogPluginExtension extension2 = (ChangelogPluginExtension)$this$create$iv;
        Provider provider = project.getLayout().file(extension2.getPath().map((Transformer)apply.pathProvider.1.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"file(...)");
        Provider pathProvider2 = provider;
        Provider provider2 = project.getLayout().file(extension2.getOutputFile().getAsFile());
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"file(...)");
        Provider outputProvider = provider2;
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskContainer $i$a$-apply-ChangelogPlugin$apply$extension$22 = taskContainer;
        String $i$f$create22 = "getChangelog";
        Function1 configuration$iv = arg_0 -> ChangelogPlugin.apply$lambda$1(extension2, pathProvider2, project, outputProvider, arg_0);
        boolean $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, GetChangelogTask.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object t) {
                this.function.invoke(t);
            }
        }), (String)"register(...)");
        TaskContainer taskContainer2 = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"getTasks(...)");
        $this$register$iv = taskContainer2;
        name$iv = "patchChangelog";
        configuration$iv = arg_0 -> ChangelogPlugin.apply$lambda$2(extension2, pathProvider2, arg_0);
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, PatchChangelogTask.class, new /* invalid duplicate definition of identical inner class */), (String)"register(...)");
        TaskContainer taskContainer3 = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"getTasks(...)");
        $this$register$iv = taskContainer3;
        name$iv = "initializeChangelog";
        configuration$iv = arg_0 -> ChangelogPlugin.apply$lambda$3(extension2, pathProvider2, arg_0);
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, InitializeChangelogTask.class, new /* invalid duplicate definition of identical inner class */), (String)"register(...)");
    }

    private final void checkGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.3")) < 0) {
            throw new PluginInstantiationException("Gradle Changelog Plugin requires Gradle 8.3 and higher");
        }
    }

    private static final Unit apply$lambda$1(ChangelogPluginExtension $extension, Provider $pathProvider, Project $project, Provider $outputProvider, GetChangelogTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        $this$register.setGroup("changelog");
        $this$register.getUnreleasedTerm().convention((Provider)$extension.getUnreleasedTerm());
        $this$register.getChangelog().convention((Provider)$extension.getInstance());
        $this$register.getInputFile().convention($pathProvider);
        $this$register.getOutputFile().convention($project.getLayout().file($project.provider(new Callable($this$register){
            final /* synthetic */ GetChangelogTask $this_register;
            {
                this.$this_register = $this_register;
            }

            public final File call() {
                File file;
                String string = this.$this_register.getOutputFilePath();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    file = new File(it);
                } else {
                    file = null;
                }
                return file;
            }
        })).orElse($outputProvider));
        $this$register.getOutputs().upToDateWhen((Spec)apply.1.2.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit apply$lambda$2(ChangelogPluginExtension $extension, Provider $pathProvider, PatchChangelogTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        $this$register.setGroup("changelog");
        $this$register.getVersion().convention((Provider)$extension.getVersion());
        $this$register.getHeader().convention((Provider)$extension.getHeader());
        $this$register.getKeepUnreleasedSection().convention((Provider)$extension.getKeepUnreleasedSection());
        $this$register.getPatchEmpty().convention((Provider)$extension.getPatchEmpty());
        $this$register.getCombinePreReleases().convention((Provider)$extension.getCombinePreReleases());
        $this$register.getUnreleasedTerm().convention((Provider)$extension.getUnreleasedTerm());
        $this$register.getChangelog().convention((Provider)$extension.getInstance());
        $this$register.getInputFile().convention($pathProvider);
        $this$register.getOutputFile().convention($pathProvider);
        return Unit.INSTANCE;
    }

    private static final Unit apply$lambda$3(ChangelogPluginExtension $extension, Provider $pathProvider, InitializeChangelogTask $this$register) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
        $this$register.setGroup("changelog");
        $this$register.getUnreleasedTerm().convention((Provider)$extension.getUnreleasedTerm());
        $this$register.getChangelog().convention((Provider)$extension.getInstance());
        $this$register.getOutputFile().convention($pathProvider);
        return Unit.INSTANCE;
    }
}

