/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.changelog.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.changelog.Changelog;
import org.jetbrains.changelog.exceptions.MissingVersionException;
import org.jetbrains.changelog.tasks.BaseChangelogTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\b8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\b8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001e\u0010\u0010\u001a\u00020\b8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR\u001e\u0010\u0013\u001a\u00020\b8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R \u0010\u0018\u001a\u0004\u0018\u00010\u00198G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u001e\u001a\u0004\u0018\u00010\u00198G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001e\u0010!\u001a\u00020\b8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\f\u00a8\u0006&"}, d2={"Lorg/jetbrains/changelog/tasks/GetChangelogTask;", "Lorg/jetbrains/changelog/tasks/BaseChangelogTask;", "()V", "inputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getInputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "noEmptySections", "", "getNoEmptySections", "()Z", "setNoEmptySections", "(Z)V", "noHeader", "getNoHeader", "setNoHeader", "noLinks", "getNoLinks", "setNoLinks", "noSummary", "getNoSummary", "setNoSummary", "outputFile", "getOutputFile", "outputFilePath", "", "getOutputFilePath", "()Ljava/lang/String;", "setOutputFilePath", "(Ljava/lang/String;)V", "projectVersion", "getProjectVersion", "setProjectVersion", "unreleased", "getUnreleased", "setUnreleased", "run", "", "gradle-changelog-plugin"})
@SourceDebugExtension(value={"SMAP\nGetChangelogTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetChangelogTask.kt\norg/jetbrains/changelog/tasks/GetChangelogTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public abstract class GetChangelogTask
extends BaseChangelogTask {
    @Option(option="no-header", description="Omits the section header in the changelog output.")
    private boolean noHeader;
    @Option(option="no-summary", description="Omits the section summary in the changelog output.")
    private boolean noSummary;
    @Option(option="no-links", description="Omits links in the changelog output.")
    private boolean noLinks;
    @Option(option="no-empty-sections", description="Omits empty sections in the changelog output.")
    private boolean noEmptySections;
    @Option(option="project-version", description="Returns change notes for the specified project version.")
    @Nullable
    private String projectVersion = null;
    @Option(option="unreleased", description="Returns change notes for an unreleased section.")
    private boolean unreleased;
    @Option(option="output-file", description="File to write the changelog content to.")
    @Nullable
    private String outputFilePath = null;

    @Input
    public final boolean getNoHeader() {
        return this.noHeader;
    }

    public final void setNoHeader(boolean bl) {
        this.noHeader = bl;
    }

    @Input
    public final boolean getNoSummary() {
        return this.noSummary;
    }

    public final void setNoSummary(boolean bl) {
        this.noSummary = bl;
    }

    @Input
    public final boolean getNoLinks() {
        return this.noLinks;
    }

    public final void setNoLinks(boolean bl) {
        this.noLinks = bl;
    }

    @Input
    public final boolean getNoEmptySections() {
        return this.noEmptySections;
    }

    public final void setNoEmptySections(boolean bl) {
        this.noEmptySections = bl;
    }

    @Input
    @Optional
    @Nullable
    public final String getProjectVersion() {
        return this.projectVersion;
    }

    public final void setProjectVersion(@Nullable String string) {
        this.projectVersion = string;
    }

    @Input
    public final boolean getUnreleased() {
        return this.unreleased;
    }

    public final void setUnreleased(boolean bl) {
        this.unreleased = bl;
    }

    @InputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getInputFile();

    @OutputFile
    @Optional
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Optional
    @Input
    @Nullable
    public final String getOutputFilePath() {
        return this.outputFilePath;
    }

    public final void setOutputFilePath(@Nullable String string) {
        this.outputFilePath = string;
    }

    @TaskAction
    public final void run() {
        block9: {
            Unit unit;
            Changelog.Item item;
            Changelog $this$run_u24lambda_u241 = (Changelog)this.getChangelog().get();
            boolean bl = false;
            String version = this.projectVersion;
            String string = version;
            if (string != null) {
                item = $this$run_u24lambda_u241.get(string);
            } else if (this.unreleased) {
                item = $this$run_u24lambda_u241.getUnreleasedItem();
                if (item == null) {
                    throw new MissingVersionException((String)this.getUnreleasedTerm().get());
                }
            } else {
                item = (Changelog.Item)CollectionsKt.firstOrNull((Iterable)$this$run_u24lambda_u241.getReleasedItems());
                if (item == null) {
                    throw new MissingVersionException("any");
                }
            }
            Changelog.Item it = item.withHeader(!this.noHeader).withSummary(!this.noSummary).withLinks(!this.noLinks).withLinkedHeader(!this.noLinks).withEmptySections(!this.noEmptySections);
            boolean bl2 = false;
            String content = $this$run_u24lambda_u241.renderItem(it, Changelog.OutputType.MARKDOWN);
            RegularFile regularFile = (RegularFile)this.getOutputFile().getOrNull();
            if (regularFile != null) {
                File file;
                RegularFile it2 = regularFile;
                boolean bl3 = false;
                File $this$run_u24lambda_u243_u24lambda_u242 = file = it2.getAsFile();
                boolean bl4 = false;
                File file2 = $this$run_u24lambda_u243_u24lambda_u242.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$run_u24lambda_u243_u24lambda_u242, (String)"run$lambda$3$lambda$2");
                FilesKt.writeText$default((File)$this$run_u24lambda_u243_u24lambda_u242, (String)content, null, (int)2, null);
                this.getLogger().lifecycle("Changelog written to: " + this.getPath());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block9;
            this.getLogger().quiet(content);
        }
    }
}

