/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.changelog;

import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.changelog.PlainTextTagRenderer;
import org.jetbrains.changelog.flavours.ChangelogFlavourDescriptor;
import org.jetbrains.changelog.flavours.PlainTextFlavourDescriptor;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0001\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u00a8\u0006\t"}, d2={"date", "", "pattern", "markdownToHTML", "input", "lineSeparator", "markdownToPlainText", "normalizeLineSeparator", "reformat", "gradle-changelog-plugin"})
@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\norg/jetbrains/changelog/ExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1797#2,3:54\n*S KotlinDebug\n*F\n+ 1 extensions.kt\norg/jetbrains/changelog/ExtensionsKt\n*L\n38#1:54,3\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final String date(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = new SimpleDateFormat(pattern).format(new Date());
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public static /* synthetic */ String date$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "yyyy-MM-dd";
        }
        return ExtensionsKt.date(string);
    }

    @NotNull
    public static final String markdownToHTML(@NotNull String input, @NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        ChangelogFlavourDescriptor $this$markdownToHTML_u24lambda_u240 = new ChangelogFlavourDescriptor();
        boolean bl = false;
        String lfString = ExtensionsKt.normalizeLineSeparator(input, "\n");
        return ExtensionsKt.normalizeLineSeparator(HtmlGenerator.generateHtml$default((HtmlGenerator)new HtmlGenerator(lfString, new MarkdownParser((MarkdownFlavourDescriptor)$this$markdownToHTML_u24lambda_u240).buildMarkdownTreeFromString(lfString), (MarkdownFlavourDescriptor)$this$markdownToHTML_u24lambda_u240, false), null, (int)1, null), lineSeparator);
    }

    public static /* synthetic */ String markdownToHTML$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "\n";
        }
        return ExtensionsKt.markdownToHTML(string, string2);
    }

    @NotNull
    public static final String markdownToPlainText(@NotNull String input, @NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        PlainTextFlavourDescriptor $this$markdownToPlainText_u24lambda_u241 = new PlainTextFlavourDescriptor(lineSeparator);
        boolean bl = false;
        String lfString = ExtensionsKt.normalizeLineSeparator(input, "\n");
        return new HtmlGenerator(lfString, new MarkdownParser((MarkdownFlavourDescriptor)$this$markdownToPlainText_u24lambda_u241).buildMarkdownTreeFromString(lfString), (MarkdownFlavourDescriptor)$this$markdownToPlainText_u24lambda_u241, false).generateHtml((HtmlGenerator.TagRenderer)new PlainTextTagRenderer());
    }

    @NotNull
    public static final String reformat(@NotNull String $this$reformat, @NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$reformat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)new Regex("(?:^|" + lineSeparator + ")+(#+ [^" + lineSeparator + "]*)(?:" + lineSeparator + ")*"), (Object)(lineSeparator + lineSeparator + "$1" + lineSeparator + lineSeparator)), TuplesKt.to((Object)new Regex("((?:^|" + lineSeparator + ")#+ .*?)" + lineSeparator + "(#+ )"), (Object)("$1" + lineSeparator + lineSeparator + "$2")), TuplesKt.to((Object)new Regex("(?:" + lineSeparator + ")+(\\[.*?]:)"), (Object)(lineSeparator + lineSeparator + "$1")), TuplesKt.to((Object)new Regex("(?<=" + lineSeparator + ")(\\[.*?]:.*?)(?:" + lineSeparator + ")+"), (Object)("$1" + lineSeparator)), TuplesKt.to((Object)new Regex("(#+ .*?)" + lineSeparator), (Object)("$1" + lineSeparator + lineSeparator)), TuplesKt.to((Object)new Regex("(" + lineSeparator + "){3,}"), (Object)(lineSeparator + lineSeparator))};
        Iterable $this$fold$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$fold = false;
        String accumulator$iv = $this$reformat;
        for (Object element$iv : $this$fold$iv) {
            Pair pair = (Pair)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            Regex pattern = (Regex)pair.component1();
            String replacement = (String)pair.component2();
            accumulator$iv = pattern.replace((CharSequence)acc, replacement);
        }
        String result = ((Object)StringsKt.trim((CharSequence)accumulator$iv)).toString() + lineSeparator;
        return Intrinsics.areEqual((Object)result, (Object)$this$reformat) ? result : ExtensionsKt.reformat(result, lineSeparator);
    }

    @NotNull
    public static final String normalizeLineSeparator(@NotNull String $this$normalizeLineSeparator, @NotNull String lineSeparator) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeLineSeparator, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        CharSequence charSequence = $this$normalizeLineSeparator;
        return new Regex("\\R").replace(charSequence, lineSeparator);
    }
}

