/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.changelog;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginInstantiationException;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.changelog.Changelog;
import org.jetbrains.changelog.ChangelogPlugin;
import org.jetbrains.changelog.ChangelogPluginConstants;
import org.jetbrains.changelog.ChangelogPluginExtension;
import org.jetbrains.changelog.ChangelogSectionUrlBuilder;
import org.jetbrains.changelog.ExtensionsKt;
import org.jetbrains.changelog.exceptions.VersionNotSpecifiedException;
import org.jetbrains.changelog.tasks.GetChangelogTask;
import org.jetbrains.changelog.tasks.InitializeChangelogTask;
import org.jetbrains.changelog.tasks.PatchChangelogTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lorg/jetbrains/changelog/ChangelogPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "checkGradleVersion", "gradle-changelog-plugin"})
@SourceDebugExtension(value={"SMAP\nChangelogPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangelogPlugin.kt\norg/jetbrains/changelog/ChangelogPlugin\n+ 2 ExtensionContainerExtensions.kt\norg/gradle/kotlin/dsl/ExtensionContainerExtensionsKt\n+ 3 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,179:1\n96#2:180\n263#3:181\n263#3:182\n263#3:183\n*S KotlinDebug\n*F\n+ 1 ChangelogPlugin.kt\norg/jetbrains/changelog/ChangelogPlugin\n*L\n35#1:180\n133#1:181\n150#1:182\n164#1:183\n*E\n"})
public final class ChangelogPlugin
implements Plugin<Project> {
    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        String name$iv;
        TaskContainer $this$register$iv;
        void name$iv2;
        Object $this$create$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.checkGradleVersion();
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer extensionContainer2 = extensionContainer;
        String string = "changelog";
        Object[] constructionArguments$iv = new Object[]{};
        boolean $i$f$create22 = false;
        Object object = $this$create$iv.create((String)name$iv2, ChangelogPluginExtension.class, Arrays.copyOf(constructionArguments$iv, constructionArguments$iv.length));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(name, T::class.ja\u2026, *constructionArguments)");
        $this$create$iv = object;
        ChangelogPluginExtension $this$apply_u24lambda_u240 = (ChangelogPluginExtension)$this$create$iv;
        boolean $i$a$-apply-ChangelogPlugin$apply$extension$22 = false;
        $this$apply_u24lambda_u240.getPath().convention(project.provider(new Callable(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final String call() {
                return this.$project.file((Object)"CHANGELOG.md").getCanonicalPath();
            }
        }).map((Transformer)apply.extension.1.2.INSTANCE));
        $this$apply_u24lambda_u240.getVersionPrefix().convention(project.provider((Callable)apply.extension.1.3.INSTANCE));
        $this$apply_u24lambda_u240.getVersion().convention(project.provider(new Callable(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final String call() {
                String string;
                String it = string = this.$project.getVersion().toString();
                boolean bl = false;
                String string2 = !Intrinsics.areEqual((Object)it, (Object)"unspecified") ? string : null;
                if (string2 == null) {
                    throw new VersionNotSpecifiedException();
                }
                return string2;
            }
        }));
        $this$apply_u24lambda_u240.getHeader().convention(project.provider(new Callable($this$apply_u24lambda_u240){
            final /* synthetic */ ChangelogPluginExtension $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final String call() {
                return this.$this_apply.getVersion().get() + " - " + ExtensionsKt.date$default(null, 1, null);
            }
        }));
        $this$apply_u24lambda_u240.getUnreleasedTerm().convention((Object)"Unreleased");
        $this$apply_u24lambda_u240.getKeepUnreleasedSection().convention((Object)true);
        $this$apply_u24lambda_u240.getPatchEmpty().convention((Object)true);
        $this$apply_u24lambda_u240.getGroups().convention((Iterable)ChangelogPluginConstants.INSTANCE.getGROUPS());
        $this$apply_u24lambda_u240.getItemPrefix().convention((Object)"-");
        $this$apply_u24lambda_u240.getCombinePreReleases().convention((Object)true);
        $this$apply_u24lambda_u240.getLineSeparator().convention($this$apply_u24lambda_u240.getPath().map((Transformer)apply.extension.1.6.INSTANCE));
        $this$apply_u24lambda_u240.getRepositoryUrl().map((Transformer)apply.extension.1.7.INSTANCE);
        $this$apply_u24lambda_u240.getSectionUrlBuilder().convention((Object)new ChangelogSectionUrlBuilder($this$apply_u24lambda_u240){
            final /* synthetic */ ChangelogPluginExtension $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final String build(String repositoryUrl, String currentVersion, String previousVersion, boolean isUnreleased) {
                Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
                Object object = this.$this_apply.getVersionPrefix().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"versionPrefix.get()");
                String prefix = (String)object;
                return repositoryUrl + (String)(isUnreleased ? (previousVersion == null ? "/commits" : "/compare/" + prefix + previousVersion + "...HEAD") : (previousVersion == null ? "/commits/" + prefix + currentVersion : "/compare/" + prefix + previousVersion + "..." + prefix + currentVersion));
            }
        });
        $this$apply_u24lambda_u240.getInstance().convention(project.provider(new Callable($this$apply_u24lambda_u240){
            final /* synthetic */ ChangelogPluginExtension $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final Changelog call() {
                Object object = this.$this_apply.getPath().map((Transformer)apply.extension.1.1.INSTANCE).get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"path.map {\n             \u2026                  }.get()");
                String string = (String)object;
                String string2 = (String)this.$this_apply.getPreTitle().getOrNull();
                String string3 = (String)this.$this_apply.getTitle().getOrNull();
                String string4 = (String)this.$this_apply.getIntroduction().getOrNull();
                Object object2 = this.$this_apply.getUnreleasedTerm().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"unreleasedTerm.get()");
                String string5 = (String)object2;
                Object object3 = this.$this_apply.getGroups().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"groups.get()");
                List list = (List)object3;
                Object object4 = this.$this_apply.getGetHeaderParserRegex().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"getHeaderParserRegex.get()");
                Regex regex = (Regex)object4;
                Object object5 = this.$this_apply.getItemPrefix().get();
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"itemPrefix.get()");
                String string6 = (String)object5;
                String string7 = (String)this.$this_apply.getRepositoryUrl().getOrNull();
                Object object6 = this.$this_apply.getSectionUrlBuilder().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"sectionUrlBuilder.get()");
                ChangelogSectionUrlBuilder changelogSectionUrlBuilder = (ChangelogSectionUrlBuilder)object6;
                Object object7 = this.$this_apply.getLineSeparator().get();
                Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"lineSeparator.get()");
                return new Changelog(string, string2, string3, string4, string5, list, regex, string6, string7, changelogSectionUrlBuilder, (String)object7);
            }
        }));
        ChangelogPluginExtension extension2 = (ChangelogPluginExtension)$this$create$iv;
        Provider provider = project.getLayout().file(extension2.getPath().map((Transformer)apply.pathProvider.1.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.file(exte\u2026on.path.map { File(it) })");
        Provider pathProvider2 = provider;
        Provider provider2 = project.getLayout().file(extension2.getOutputFile().getAsFile());
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.layout.file(extension.outputFile.asFile)");
        Provider outputProvider = provider2;
        TaskContainer taskContainer = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer $i$a$-apply-ChangelogPlugin$apply$extension$22 = taskContainer;
        String $i$f$create22 = "getChangelog";
        Function1 configuration$iv = (Function1)new Function1<GetChangelogTask, Unit>(extension2, (Provider<RegularFile>)pathProvider2, project, (Provider<RegularFile>)outputProvider){
            final /* synthetic */ ChangelogPluginExtension $extension;
            final /* synthetic */ Provider<RegularFile> $pathProvider;
            final /* synthetic */ Project $project;
            final /* synthetic */ Provider<RegularFile> $outputProvider;
            {
                this.$extension = $extension;
                this.$pathProvider = $pathProvider;
                this.$project = $project;
                this.$outputProvider = $outputProvider;
                super(1);
            }

            public final void invoke(GetChangelogTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.setGroup("changelog");
                $this$register.getUnreleasedTerm().convention((Provider)this.$extension.getUnreleasedTerm());
                $this$register.getChangelog().convention((Provider)this.$extension.getInstance());
                $this$register.getInputFile().convention(this.$pathProvider);
                $this$register.getOutputFile().convention(this.$project.getLayout().file(this.$project.provider(new Callable($this$register){
                    final /* synthetic */ GetChangelogTask $this_register;
                    {
                        this.$this_register = $this_register;
                    }

                    public final File call() {
                        File file;
                        String string = this.$this_register.getOutputFilePath();
                        if (string != null) {
                            String it = string;
                            boolean bl = false;
                            file = new File(it);
                        } else {
                            file = null;
                        }
                        return file;
                    }
                })).orElse(this.$outputProvider));
                $this$register.getOutputs().upToDateWhen((Spec)apply.2.INSTANCE);
            }
        };
        boolean $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, GetChangelogTask.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        }), (String)"register(name, T::class.java, configuration)");
        TaskContainer taskContainer2 = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"project.tasks");
        $this$register$iv = taskContainer2;
        name$iv = "patchChangelog";
        configuration$iv = (Function1)new Function1<PatchChangelogTask, Unit>(extension2, (Provider<RegularFile>)pathProvider2){
            final /* synthetic */ ChangelogPluginExtension $extension;
            final /* synthetic */ Provider<RegularFile> $pathProvider;
            {
                this.$extension = $extension;
                this.$pathProvider = $pathProvider;
                super(1);
            }

            public final void invoke(PatchChangelogTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.setGroup("changelog");
                $this$register.getVersion().convention((Provider)this.$extension.getVersion());
                $this$register.getHeader().convention((Provider)this.$extension.getHeader());
                $this$register.getKeepUnreleasedSection().convention((Provider)this.$extension.getKeepUnreleasedSection());
                $this$register.getPatchEmpty().convention((Provider)this.$extension.getPatchEmpty());
                $this$register.getCombinePreReleases().convention((Provider)this.$extension.getCombinePreReleases());
                $this$register.getUnreleasedTerm().convention((Provider)this.$extension.getUnreleasedTerm());
                $this$register.getChangelog().convention((Provider)this.$extension.getInstance());
                $this$register.getInputFile().convention(this.$pathProvider);
                $this$register.getOutputFile().convention(this.$pathProvider);
            }
        };
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, PatchChangelogTask.class, new /* invalid duplicate definition of identical inner class */), (String)"register(name, T::class.java, configuration)");
        TaskContainer taskContainer3 = project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"project.tasks");
        $this$register$iv = taskContainer3;
        name$iv = "initializeChangelog";
        configuration$iv = (Function1)new Function1<InitializeChangelogTask, Unit>(extension2, (Provider<RegularFile>)pathProvider2){
            final /* synthetic */ ChangelogPluginExtension $extension;
            final /* synthetic */ Provider<RegularFile> $pathProvider;
            {
                this.$extension = $extension;
                this.$pathProvider = $pathProvider;
                super(1);
            }

            public final void invoke(InitializeChangelogTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.setGroup("changelog");
                $this$register.getUnreleasedTerm().convention((Provider)this.$extension.getUnreleasedTerm());
                $this$register.getChangelog().convention((Provider)this.$extension.getInstance());
                $this$register.getOutputFile().convention(this.$pathProvider);
            }
        };
        $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(name$iv, InitializeChangelogTask.class, new /* invalid duplicate definition of identical inner class */), (String)"register(name, T::class.java, configuration)");
    }

    private final void checkGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.8")) < 0) {
            throw new PluginInstantiationException("Gradle Changelog Plugin requires Gradle 6.8 and higher");
        }
    }
}

