/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.anko;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.view.View;
import android.view.ViewGroup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.anko.AnkoContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/anko/AnkoContextImpl;", "T", "Lorg/jetbrains/anko/AnkoContext;", "ctx", "Landroid/content/Context;", "owner", "setContentView", "", "(Landroid/content/Context;Ljava/lang/Object;Z)V", "getCtx", "()Landroid/content/Context;", "myView", "Landroid/view/View;", "getOwner", "()Ljava/lang/Object;", "Ljava/lang/Object;", "view", "getView", "()Landroid/view/View;", "addView", "", "params", "Landroid/view/ViewGroup$LayoutParams;", "alreadyHasView", "doAddView", "context", "common_release"})
public class AnkoContextImpl<T>
implements AnkoContext<T> {
    private View myView;
    @NotNull
    private final Context ctx;
    private final T owner;
    private final boolean setContentView;

    @Override
    @NotNull
    public View getView() {
        View view = this.myView;
        if (view == null) {
            throw (Throwable)new IllegalStateException("View was not set previously");
        }
        return view;
    }

    public void addView(@Nullable View view, @Nullable ViewGroup.LayoutParams params) {
        if (view == null) {
            return;
        }
        if (this.myView != null) {
            this.alreadyHasView();
        }
        this.myView = view;
        if (this.setContentView) {
            this.doAddView(this.getCtx(), view);
        }
    }

    private final void doAddView(Context context, View view) {
        Context context2 = context;
        if (context2 instanceof Activity) {
            ((Activity)context).setContentView(view);
        } else if (context2 instanceof ContextWrapper) {
            Context context3 = ((ContextWrapper)context).getBaseContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context.baseContext");
            this.doAddView(context3, view);
        } else {
            throw (Throwable)new IllegalStateException("Context is not an Activity, can't set content view");
        }
    }

    protected void alreadyHasView() {
        throw (Throwable)new IllegalStateException("View is already set: " + this.myView);
    }

    @Override
    @NotNull
    public Context getCtx() {
        return this.ctx;
    }

    @Override
    public T getOwner() {
        return this.owner;
    }

    public AnkoContextImpl(@NotNull Context ctx, T owner, boolean setContentView) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        this.ctx = ctx;
        this.owner = owner;
        this.setContentView = setContentView;
    }

    @Override
    public void removeView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        AnkoContext.DefaultImpls.removeView(this, view);
    }

    @Override
    public void updateViewLayout(@NotNull View view, @NotNull ViewGroup.LayoutParams params) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        AnkoContext.DefaultImpls.updateViewLayout(this, view, params);
    }
}

