/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMatrix;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTParallel;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStageBase;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStages;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public class ModelASTStage
extends ModelASTStageBase {
    private String name;
    private ModelASTStages stages;
    private List<ModelASTBranch> branches = new ArrayList<ModelASTBranch>();
    private Boolean failFast;
    private ModelASTParallel parallel;
    private ModelASTMatrix matrix;
    @Deprecated
    private transient List<ModelASTStage> parallelContent = new ArrayList<ModelASTStage>();

    public ModelASTStage(Object sourceLocation) {
        super(sourceLocation);
    }

    protected Object readResolve() throws IOException {
        if (this.parallelContent != null && this.parallelContent.size() > 0) {
            if (this.parallel == null) {
                this.parallel = new ModelASTParallel(new ArrayList());
            }
            this.parallel.getStages().addAll(this.parallelContent);
            this.parallelContent = new ArrayList<ModelASTStage>();
        }
        return this;
    }

    @Override
    @NonNull
    public JSONObject toJSON() {
        JSONObject o = super.toJSON().accumulate("name", (Object)this.name).elementOpt("stages", ModelASTStage.toJSON(this.stages)).elementOpt("parallel", ModelASTStage.toJSON(this.parallel)).elementOpt("matrix", ModelASTStage.toJSON(this.matrix)).elementOpt("branches", (Object)ModelASTStage.nullIfEmpty(ModelASTStage.toJSONArray(this.branches))).elementOpt("failFast", (Object)this.failFast);
        return o;
    }

    @Override
    public void validate(@NonNull ModelValidator validator) {
        this.validate(validator, false);
    }

    public void validate(ModelValidator validator, boolean isWithinParallel) {
        super.validate(validator);
        validator.validateElement(this, isWithinParallel);
        ModelASTStage.validate(validator, this.branches, this.parallel, this.matrix);
        if (this.stages != null) {
            this.stages.validate(validator, isWithinParallel);
        }
    }

    @Override
    @NonNull
    public String toGroovy() {
        StringBuilder result = new StringBuilder().append("stage('").append(this.name.replace("'", "\\'")).append("') {\n").append(super.toGroovy());
        result.append(ModelASTStage.toGroovy(this.stages));
        if ((this.parallel != null || this.matrix != null) && this.failFast != null && this.failFast.booleanValue()) {
            result.append("failFast true\n");
        }
        result.append(ModelASTStage.toGroovy(this.parallel)).append(ModelASTStage.toGroovy(this.matrix));
        if (!this.branches.isEmpty()) {
            result.append("steps {\n");
            if (this.branches.size() > 1) {
                result.append("parallel(");
                boolean first = true;
                for (ModelASTBranch branch : this.branches) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(',');
                    }
                    result.append('\n');
                    result.append("\"" + StringEscapeUtils.escapeJava((String)branch.getName()) + "\"").append(": {\n").append(branch.toGroovy()).append("\n}");
                }
                if (this.failFast != null && this.failFast.booleanValue()) {
                    result.append(",\nfailFast: true");
                }
                result.append("\n)\n");
            } else if (this.branches.size() == 1) {
                result.append(this.branches.get(0).toGroovy());
            }
            result.append("}\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        ModelASTStage.removeSourceLocationsFrom(this.branches, this.stages, this.parallel, this.matrix);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelASTStages getStages() {
        return this.stages;
    }

    public void setStages(ModelASTStages stages) {
        this.stages = stages;
    }

    public List<ModelASTBranch> getBranches() {
        return this.branches;
    }

    public void setBranches(List<ModelASTBranch> branches) {
        this.branches = branches;
    }

    public Boolean getFailFast() {
        return this.failFast;
    }

    public void setFailFast(Boolean f) {
        this.failFast = f;
    }

    public ModelASTParallel getParallel() {
        return this.parallel;
    }

    public void setParallel(ModelASTParallel s) {
        this.parallel = s;
    }

    public ModelASTMatrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(ModelASTMatrix s) {
        this.matrix = s;
    }

    @Deprecated
    public List<ModelASTStage> getParallelContent() {
        return this.parallelContent;
    }

    @Deprecated
    public void setParallelContent(List<ModelASTStage> parallelContent) {
        this.parallelContent = parallelContent;
    }

    @Override
    public String toString() {
        return "ModelASTStage{name='" + this.name + "', " + super.toString() + ", stages=" + this.stages + ", branches=" + this.branches + ", failFast=" + this.failFast + ", parallel=" + this.parallel + ", matrix=" + this.matrix + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTStage that = (ModelASTStage)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getStages(), that.getStages()) && Objects.equals(this.getBranches(), that.getBranches()) && Objects.equals(this.getFailFast(), that.getFailFast()) && Objects.equals(this.getParallel(), that.getParallel()) && Objects.equals(this.getMatrix(), that.getMatrix()) && Objects.equals(this.getParallelContent(), that.getParallelContent());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getStages(), this.getBranches(), this.getFailFast(), this.getParallel(), this.getMatrix(), this.getParallelContent());
    }
}

