/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTBranch
extends ModelASTElement {
    private String name;
    private List<ModelASTStep> steps = new ArrayList<ModelASTStep>();

    public ModelASTBranch(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONArray a = new JSONArray();
        for (ModelASTStep step : this.steps) {
            a.add((Object)step.toJSON());
        }
        return new JSONObject().accumulate("name", (Object)this.name).accumulate("steps", (Object)a);
    }

    @Override
    public void validate(@Nonnull ModelValidator validator) {
        validator.validateElement(this);
        for (ModelASTStep step : this.steps) {
            step.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        StringBuilder result = new StringBuilder();
        for (ModelASTStep step : this.steps) {
            result.append(step.toGroovy()).append("\n");
        }
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        for (ModelASTStep step : this.steps) {
            step.removeSourceLocation();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ModelASTStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<ModelASTStep> steps) {
        this.steps = steps;
    }

    @Override
    public String toString() {
        return "ModelASTBranch{name='" + this.name + '\'' + ", steps=" + this.steps + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTBranch that = (ModelASTBranch)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return this.getSteps() != null ? this.getSteps().equals(that.getSteps()) : that.getSteps() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getSteps() != null ? this.getSteps().hashCode() : 0);
        return result;
    }
}

