/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.DescriptorLookupCache;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.Messages;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTNamedArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTSingleArgument;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTTreeStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ModelASTStep
extends ModelASTElement {
    private String name;
    private ModelASTArgumentList args;

    public static Map<String, String> blockedStepsBase() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("stage", Messages.ModelASTStep_BlockedSteps_Stage());
        map.put("properties", Messages.ModelASTStep_BlockedSteps_Properties());
        map.put("parallel", Messages.ModelASTStep_BlockedSteps_Parallel());
        return map;
    }

    public static Map<String, String> getBlockedSteps() {
        return ModelASTStep.blockedStepsBase();
    }

    public ModelASTStep(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        o.accumulate("name", (Object)this.name);
        if (this.args != null) {
            o.accumulate("arguments", this.args.toJSON());
        }
        return o;
    }

    @Override
    public void validate(ModelValidator validator) {
        validator.validateElement(this);
        if (this.args != null) {
            this.args.validate(validator);
        }
    }

    @Override
    public String toGroovy() {
        ModelASTNamedArgumentList namedArgs;
        ModelASTArgumentList argList = this.args;
        if (this.args != null && this.args instanceof ModelASTNamedArgumentList && (namedArgs = (ModelASTNamedArgumentList)this.args).getArguments().size() == 1) {
            DescribableParameter p;
            DescriptorLookupCache lookup = DescriptorLookupCache.getPublicCache();
            Descriptor<? extends Describable> desc = lookup.lookupStepFirstThenFunction(this.name);
            DescribableModel<? extends Describable> model = lookup.modelForStepFirstThenFunction(this.name);
            if (model != null && (p = model.getSoleRequiredParameter()) != null && namedArgs.containsKeyName(p.getName()) && !lookup.stepTakesClosure(desc)) {
                ModelASTValue value = namedArgs.valueForName(p.getName());
                argList = new ModelASTSingleArgument(null);
                ((ModelASTSingleArgument)argList).setValue(value);
            }
        }
        return this.withOrWithoutParens(argList);
    }

    private String withOrWithoutParens(ModelASTArgumentList argList) {
        if (argList == null) {
            return this.name + "()";
        }
        String argGroovy = argList.toGroovy();
        if (!(this instanceof ModelASTTreeStep) && argList instanceof ModelASTSingleArgument && !argGroovy.startsWith("[")) {
            return this.name + " " + argGroovy;
        }
        return this.name + "(" + argGroovy + ")";
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        if (this.args != null) {
            this.args.removeSourceLocation();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModelASTArgumentList getArgs() {
        return this.args;
    }

    public void setArgs(ModelASTArgumentList args) {
        this.args = args;
    }

    @Override
    public String toString() {
        return "ModelASTStep{name='" + this.name + '\'' + ", args=" + this.args + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTStep that = (ModelASTStep)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        return this.getArgs() != null ? this.getArgs().equals(that.getArgs()) : that.getArgs() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getArgs() != null ? this.getArgs().hashCode() : 0);
        return result;
    }
}

