/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import winstone.AbstractSecuredConnectorFactory;
import winstone.ConnectorFactory;
import winstone.ServerConnectorBuilder;
import winstone.cmdline.Option;

public class HttpsConnectorFactory
extends AbstractSecuredConnectorFactory
implements ConnectorFactory {
    @Override
    public Connector start(Map<String, String> args, Server server) throws IOException {
        int listenPort = Option.HTTPS_PORT.get(args);
        if (listenPort < 0) {
            return null;
        }
        if (Option.HTTPS_REDIRECT_HTTP.get(args)) {
            Handler currentHandler = server.getHandler();
            if (currentHandler == null) {
                server.setHandler(new SecuredRedirectHandler());
            } else {
                SecuredRedirectHandler securedRedirectHandler = new SecuredRedirectHandler();
                securedRedirectHandler.setHandler(currentHandler);
                server.setHandler(securedRedirectHandler);
            }
        }
        this.configureSsl(args, server);
        ServerConnectorBuilder scb = new ServerConnectorBuilder().withServer(server).withAcceptors(Option.JETTY_ACCEPTORS.get(args)).withSelectors(Option.JETTY_SELECTORS.get(args)).withListenerPort(listenPort).withListenerAddress(Option.HTTPS_LISTEN_ADDRESS.get(args)).withRequestHeaderSize(Option.REQUEST_HEADER_SIZE.get(args)).withResponseHeaderSize(Option.RESPONSE_HEADER_SIZE.get(args)).withKeepAliveTimeout(Option.HTTPS_KEEP_ALIVE_TIMEOUT.get(args)).withSniHostCheck(Option.HTTPS_SNI_HOST_CHECK.get(args)).withSniRequired(Option.HTTPS_SNI_REQUIRED.get(args)).withSslContext(this.getSSLContext(args));
        Connector c = scb.build();
        server.addConnector(c);
        return c;
    }
}

