/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import winstone.WinstoneResourceBundle;

public class Logger {
    public static final String DEFAULT_STREAM = "Winstone";
    public static final Level MIN = Level.OFF;
    public static final Level ERROR = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level SPEED = Level.FINE;
    public static final Level DEBUG = Level.FINER;
    public static final Level FULL_DEBUG = Level.FINEST;
    public static final Level MAX = Level.ALL;
    protected static final Object semaphore = new Object();
    static boolean initialised = false;
    static Writer defaultStream;
    static Map<String, Writer> namedStreams;
    static boolean showThrowingThread;
    private static final java.util.logging.Logger LOGGER;

    public static void init(Level level) {
        Logger.init(level, System.out, Charset.defaultCharset(), false);
    }

    public static void init(int level) {
        Logger.init(Level.parse(String.valueOf(level)));
    }

    @Deprecated
    public static void init(Level level, OutputStream defaultStream, boolean showThrowingThreadArg) {
        Logger.init(level, defaultStream, Charset.defaultCharset(), showThrowingThreadArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Level level, OutputStream defaultStream, Charset defaultStreamCharset, boolean showThrowingThreadArg) {
        Object object = semaphore;
        synchronized (object) {
            if (!initialised) {
                initialised = false;
                LOGGER.setLevel(level);
                namedStreams = new HashMap<String, Writer>();
                initialised = true;
                Logger.setStream(DEFAULT_STREAM, defaultStream, defaultStreamCharset);
                showThrowingThread = showThrowingThreadArg;
            }
        }
    }

    @Deprecated
    public static void setStream(String name, OutputStream stream) {
        Logger.setStream(name, stream, Charset.defaultCharset());
    }

    public static void setStream(String name, OutputStream stream, Charset charset) {
        Logger.setStream(name, stream != null ? new OutputStreamWriter(stream, charset) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"EI_EXPOSE_STATIC_REP2"}, justification="False positive, this is intended")
    public static void setStream(String name, Writer stream) {
        if (name == null) {
            name = DEFAULT_STREAM;
        }
        if (!initialised) {
            Logger.init(INFO);
        }
        Object object = semaphore;
        synchronized (object) {
            if (name.equals(DEFAULT_STREAM)) {
                defaultStream = stream;
            } else if (stream == null) {
                namedStreams.remove(name);
            } else {
                namedStreams.put(name, stream);
            }
        }
    }

    public static void flush(String name) {
        Writer stream;
        if (!initialised) {
            Logger.init(INFO);
        }
        if ((stream = Logger.getStreamByName(name)) != null) {
            try {
                stream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Writer getStreamByName(String streamName) {
        if (streamName != null && streamName.equals(DEFAULT_STREAM)) {
            Object object = semaphore;
            synchronized (object) {
                Writer stream = namedStreams.get(streamName);
                if (stream == null && !namedStreams.containsKey(streamName)) {
                    stream = defaultStream;
                }
                return stream;
            }
        }
        return defaultStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentDebugLevel(int level) {
        if (!initialised) {
            Logger.init(level);
        } else {
            Object object = semaphore;
            synchronized (object) {
                LOGGER.setLevel(Level.parse(String.valueOf(level)));
            }
        }
    }

    private static void logInternal(Level level, String message, Throwable error) {
        if (!initialised) {
            Logger.init(INFO);
        }
        Object msg = "";
        if (showThrowingThread) {
            msg = "[" + Thread.currentThread().getName() + "] - ";
        }
        msg = (String)msg + message;
        LOGGER.log(level, (String)msg, error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object param) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, param), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object ... params) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object param, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, param), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object[] params, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String streamName, String messageKey, Object[] params, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), error);
    }

    public static void logDirectMessage(Level level, String streamName, String message, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, message, error);
    }

    static {
        LOGGER = java.util.logging.Logger.getLogger("winstone");
    }
}

