/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.SessionTrackingMode;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import winstone.Launcher;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneResourceBundle;
import winstone.WinstoneSession;
import winstone.cmdline.Option;

public class HostConfiguration {
    private final Server server;
    private String hostname;
    private Map<String, String> args;
    private Map<String, WebAppContext> webapps;
    private ClassLoader commonLibCL;
    private MimeTypes mimeTypes = new MimeTypes();
    private final LoginService loginService;

    public HostConfiguration(Server server, String hostname, ClassLoader commonLibCL, @NonNull Map<String, String> args, File webappsDir) throws IOException {
        Handler handler;
        this.server = server;
        this.hostname = hostname;
        this.args = new HashMap<String, String>(args);
        this.webapps = new Hashtable<String, WebAppContext>();
        this.commonLibCL = commonLibCL;
        try {
            Class<LoginService> realmClass = Option.REALM_CLASS_NAME.get(this.args, LoginService.class, commonLibCL);
            Constructor<LoginService> realmConstr = realmClass.getConstructor(Map.class);
            this.loginService = realmConstr.newInstance(this.args);
        }
        catch (Throwable err) {
            throw new IOException("Failed to setup authentication realm", err);
        }
        File warfile = Option.WARFILE.get(this.args);
        File webroot = Option.WEBROOT.get(this.args);
        if (webappsDir == null && (warfile != null || webroot != null)) {
            String prefix = Option.PREFIX.get(this.args);
            if (prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            handler = this.configureAccessLog(this.create(this.getWebRoot(webroot, warfile), prefix), "webapp");
        } else {
            handler = this.initMultiWebappDir(webappsDir);
        }
        this.loadBuiltinMimeTypes();
        String types = Option.MIME_TYPES.get(this.args);
        if (types != null) {
            StringTokenizer mappingST = new StringTokenizer(types, ":", false);
            while (mappingST.hasMoreTokens()) {
                String mapping = mappingST.nextToken();
                int delimPos = mapping.indexOf(61);
                if (delimPos == -1) continue;
                String extension = mapping.substring(0, delimPos);
                String mimeType = mapping.substring(delimPos + 1);
                this.mimeTypes.addMimeMapping(extension.toLowerCase(), mimeType);
            }
        }
        server.setHandler(handler);
        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.InitComplete", "" + this.webapps.size(), "" + this.webapps.keySet());
    }

    private void loadBuiltinMimeTypes() {
        try (InputStream in = this.getClass().getResourceAsStream("mime.properties");){
            Properties props = new Properties();
            props.load(in);
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                this.mimeTypes.addMimeMapping(e.getKey().toString(), e.getValue().toString());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load the built-in MIME types", e);
        }
    }

    private Handler configureAccessLog(Handler handler, String webAppName) {
        try {
            Class<RequestLog> loggerClass = Option.ACCESS_LOGGER_CLASSNAME.get(this.args, RequestLog.class, this.commonLibCL);
            if (loggerClass != null) {
                Constructor<RequestLog> loggerConstr = loggerClass.getConstructor(String.class, Map.class);
                RequestLogHandler rlh = new RequestLogHandler();
                rlh.setHandler(handler);
                rlh.setRequestLog(loggerConstr.newInstance(webAppName, this.args));
                return rlh;
            }
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.LoggerDisabled");
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.LoggerError", (Object)"", err);
        }
        return handler;
    }

    private WebAppContext create(File app, String prefix) {
        WebAppContext wac = new WebAppContext(app.getAbsolutePath(), prefix){

            @Override
            public void preConfigure() throws Exception {
                Thread t = Thread.currentThread();
                ClassLoader ccl = t.getContextClassLoader();
                t.setContextClassLoader(HostConfiguration.this.commonLibCL);
                try {
                    super.preConfigure();
                }
                finally {
                    t.setContextClassLoader(ccl);
                }
                int maxParameterCount = Option.MAX_PARAM_COUNT.get(HostConfiguration.this.args);
                if (maxParameterCount > 0) {
                    this.setMaxFormKeys(maxParameterCount);
                }
                this.setMaxFormContentSize(Option.REQUEST_FORM_CONTENT_SIZE.get(HostConfiguration.this.args));
            }

            @Override
            public void postConfigure() throws Exception {
                super.postConfigure();
                int sessionTimeout = Option.SESSION_TIMEOUT.get(HostConfiguration.this.args);
                if (sessionTimeout > 0) {
                    this.getSessionHandler().setMaxInactiveInterval(sessionTimeout * 60);
                }
                int sessionEviction = Option.SESSION_EVICTION.get(HostConfiguration.this.args);
                this.getSessionHandler().getSessionCache().setEvictionPolicy(sessionEviction);
            }
        };
        JettyWebSocketServletContainerInitializer.configure(wac, null);
        wac.getSecurityHandler().setLoginService(this.loginService);
        wac.setThrowUnavailableOnStartupException(true);
        wac.setMimeTypes(this.mimeTypes);
        wac.getSessionHandler().setSessionTrackingModes(Set.of(SessionTrackingMode.COOKIE));
        wac.getSessionHandler().setSessionCookie(WinstoneSession.SESSION_COOKIE_NAME);
        this.webapps.put(wac.getContextPath(), wac);
        return wac;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void reloadWebApp(String prefix) {
        WebAppContext webApp = this.webapps.get(prefix);
        if (webApp != null) {
            try {
                webApp.stop();
                webApp.start();
            }
            catch (Exception e) {
                throw new WinstoneException("Failed to redeploy " + prefix, e);
            }
        } else {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.PrefixUnknown", prefix));
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="false positive, we're not being called from a webapp")
    protected File getWebRoot(File requestedWebroot, File warfile) throws IOException {
        if (warfile != null) {
            File timestampFile;
            File unzippedDir;
            Logger.log(Logger.INFO, Launcher.RESOURCES, "HostConfig.BeginningWarExtraction");
            if (!warfile.exists() || !warfile.isFile()) {
                throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.WarFileInvalid", warfile));
            }
            if (requestedWebroot != null) {
                unzippedDir = requestedWebroot;
            } else {
                File tempFile = File.createTempFile("dummy", "dummy");
                String userName = System.getProperty("user.name");
                unzippedDir = new File(tempFile.getParent(), (String)(userName != null ? WinstoneResourceBundle.globalReplace(userName, new String[][]{{"/", ""}, {"\\", ""}, {",", ""}}) + "/" : "") + "winstone/" + warfile.getName());
                try {
                    Files.delete(tempFile.toPath());
                }
                catch (Exception ex) {
                    Logger.logDirectMessage(Logger.WARNING, null, "Failed To delete dummy file", ex);
                }
            }
            if (unzippedDir.exists()) {
                if (!unzippedDir.isDirectory()) {
                    throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.WebRootNotDirectory", unzippedDir.getPath()));
                }
                Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.WebRootExists", (Object)unzippedDir.getCanonicalPath());
            }
            if (!(timestampFile = new File(unzippedDir, ".timestamp")).exists() || Math.abs(timestampFile.lastModified() - warfile.lastModified()) > 1000L) {
                this.deleteRecursive(unzippedDir);
                try {
                    Files.createDirectories(unzippedDir.toPath(), new FileAttribute[0]);
                }
                catch (Exception ex) {
                    Logger.logDirectMessage(Logger.WARNING, null, "Failed to recreate dirs " + unzippedDir.getAbsolutePath(), ex);
                }
            } else {
                return unzippedDir;
            }
            byte[] buffer = new byte[8192];
            try (JarFile warArchive = new JarFile(warfile);){
                Enumeration<JarEntry> e = warArchive.entries();
                while (e.hasMoreElements()) {
                    JarEntry element = e.nextElement();
                    if (element.isDirectory()) continue;
                    String elemName = element.getName();
                    File outFile = new File(unzippedDir, elemName);
                    Path outPath = outFile.toPath();
                    if (!outPath.normalize().startsWith(unzippedDir.toPath().normalize())) {
                        throw new IOException("Bad zip entry: " + elemName);
                    }
                    if (outFile.exists() && outFile.lastModified() > warfile.lastModified()) continue;
                    try {
                        Path parent = outPath.getParent();
                        if (parent == null) {
                            Logger.logDirectMessage(Logger.WARNING, null, outPath + "has no parent dir ", null);
                        } else {
                            Files.createDirectories(parent, new FileAttribute[0]);
                        }
                    }
                    catch (IOException | SecurityException | InvalidPathException ex) {
                        Logger.logDirectMessage(Logger.WARNING, null, "Failed to create dirs " + outFile.getParentFile().getAbsolutePath(), null);
                    }
                    InputStream inContent = warArchive.getInputStream(element);
                    try (FileOutputStream outStream = new FileOutputStream(outFile);){
                        int readBytes = inContent.read(buffer);
                        while (readBytes != -1) {
                            ((OutputStream)outStream).write(buffer, 0, readBytes);
                            readBytes = inContent.read(buffer);
                        }
                    }
                    finally {
                        if (inContent == null) continue;
                        inContent.close();
                    }
                }
            }
            new FileOutputStream(timestampFile).close();
            if (!timestampFile.setLastModified(warfile.lastModified())) {
                Logger.logDirectMessage(Logger.WARNING, null, "Failed to set timestamp " + timestampFile.getAbsolutePath(), null);
            }
            return unzippedDir;
        }
        return requestedWebroot;
    }

    private void deleteRecursive(File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                this.deleteRecursive(child);
            }
        }
        try {
            Files.deleteIfExists(dir.toPath());
        }
        catch (Exception ex) {
            Logger.logDirectMessage(Logger.WARNING, null, "Failed to delete dirs " + dir.getAbsolutePath(), ex);
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="false positive, we're not being called from a webapp")
    protected ContextHandlerCollection initMultiWebappDir(File webappsDir) {
        ContextHandlerCollection webApps = new ContextHandlerCollection();
        if (webappsDir == null) {
            webappsDir = new File("webapps");
        }
        if (!webappsDir.exists()) {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.WebAppDirNotFound", webappsDir.getPath()));
        }
        if (!webappsDir.isDirectory()) {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostConfig.WebAppDirIsNotDirectory", webappsDir.getPath()));
        }
        File[] children = webappsDir.listFiles();
        if (children != null) {
            for (File aChildren : children) {
                Object prefix;
                String childName = aChildren.getName();
                if (aChildren.isDirectory()) {
                    File matchingWarFile = new File(webappsDir, aChildren.getName() + ".war");
                    if (matchingWarFile.exists() && matchingWarFile.isFile()) {
                        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostConfig.SkippingWarfileDir", (Object)childName);
                        continue;
                    }
                    Object object = prefix = childName.equalsIgnoreCase("ROOT") ? "" : "/" + childName;
                    if (this.webapps.containsKey(prefix)) continue;
                    try {
                        WebAppContext context = this.create(aChildren, (String)prefix);
                        webApps.addHandler(this.configureAccessLog(context, childName));
                        Logger.log(Logger.INFO, Launcher.RESOURCES, "HostConfig.DeployingWebapp", (Object)childName);
                    }
                    catch (Throwable err) {
                        Logger.log(Logger.ERROR, Launcher.RESOURCES, "HostConfig.WebappInitError", prefix, err);
                    }
                    continue;
                }
                if (!childName.endsWith(".war")) continue;
                String outputName = childName.substring(0, childName.lastIndexOf(".war"));
                Object object = prefix = outputName.equalsIgnoreCase("ROOT") ? "" : "/" + outputName;
                if (this.webapps.containsKey(prefix)) continue;
                File outputDir = new File(webappsDir, outputName);
                try {
                    Files.createDirectories(outputDir.toPath(), new FileAttribute[0]);
                }
                catch (Exception ex) {
                    Logger.logDirectMessage(Logger.WARNING, null, "Failed to mkdirs " + outputDir.getAbsolutePath(), ex);
                }
                try {
                    WebAppContext context = this.create(this.getWebRoot(new File(webappsDir, outputName), aChildren), (String)prefix);
                    webApps.addHandler(this.configureAccessLog(context, outputName));
                    Logger.log(Logger.INFO, Launcher.RESOURCES, "HostConfig.DeployingWebapp", (Object)childName);
                }
                catch (Throwable err) {
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "HostConfig.WebappInitError", prefix, err);
                }
            }
        }
        return webApps;
    }
}

