/*
 * Decompiled with CFR 0.152.
 */
package winstone.realm;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.util.security.Credential;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.Option;

public class FileRealm
extends HashLoginService {
    private static final WinstoneResourceBundle REALM_RESOURCES = new WinstoneResourceBundle("winstone.realm.LocalStrings");
    static final String DEFAULT_FILE_NAME = "users.xml";
    static final String ELEM_USER = "user";
    static final String ATT_USERNAME = "username";
    static final String ATT_PASSWORD = "password";
    static final String ATT_ROLELIST = "roles";

    public FileRealm(Map args) {
        UserStore userStore = new UserStore();
        this.setUserStore(userStore);
        File realmFile = Option.FILEREALM_CONFIGFILE.get(args);
        if (realmFile == null) {
            realmFile = new File(DEFAULT_FILE_NAME);
        }
        if (!realmFile.exists()) {
            throw new WinstoneException(REALM_RESOURCES.getString("FileRealm.FileNotFound", realmFile.getPath()));
        }
        try (FileInputStream inFile = new FileInputStream(realmFile);){
            int count = 0;
            Document doc = this.parseStreamToXML(inFile);
            Element rootElm = doc.getDocumentElement();
            for (int n = 0; n < rootElm.getChildNodes().getLength(); ++n) {
                Node child = rootElm.getChildNodes().item(n);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(ELEM_USER)) continue;
                String userName = null;
                String password = null;
                String roleList = null;
                for (int j = 0; j < child.getAttributes().getLength(); ++j) {
                    Node thisAtt = child.getAttributes().item(j);
                    if (thisAtt.getNodeName().equals(ATT_USERNAME)) {
                        userName = thisAtt.getNodeValue();
                        continue;
                    }
                    if (thisAtt.getNodeName().equals(ATT_PASSWORD)) {
                        password = thisAtt.getNodeValue();
                        continue;
                    }
                    if (!thisAtt.getNodeName().equals(ATT_ROLELIST)) continue;
                    roleList = thisAtt.getNodeValue();
                }
                if (userName == null || password == null || roleList == null) {
                    Logger.log(Logger.FULL_DEBUG, REALM_RESOURCES, "FileRealm.SkippingUser", userName);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(roleList, ",");
                ArrayList<String> rl = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String currentRole = st.nextToken();
                    rl.add(currentRole);
                }
                Object[] roleArray = rl.toArray(new String[rl.size()]);
                Arrays.sort(roleArray);
                userStore.addUser(userName, Credential.getCredential(password), (String[])roleArray);
                ++count;
            }
            Logger.log(Logger.DEBUG, REALM_RESOURCES, "FileRealm.Initialised", (Object)("" + count));
        }
        catch (IOException err) {
            throw new WinstoneException(REALM_RESOURCES.getString("FileRealm.ErrorLoading"), err);
        }
    }

    private Document parseStreamToXML(InputStream in) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            factory.setIgnoringComments(true);
            factory.setCoalescing(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (Throwable errParser) {
            throw new WinstoneException(REALM_RESOURCES.getString("FileRealm.XMLParseError"), errParser);
        }
    }
}

