/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import winstone.AbstractSecuredConnectorFactory;
import winstone.ConnectorFactory;
import winstone.cmdline.Option;

public class HttpsConnectorFactory
extends AbstractSecuredConnectorFactory
implements ConnectorFactory {
    @Override
    public boolean start(Map args, Server server) throws IOException {
        int listenPort = Option.HTTPS_PORT.get(args);
        String listenAddress = Option.HTTPS_LISTEN_ADDRESS.get(args);
        int keepAliveTimeout = Option.HTTPS_KEEP_ALIVE_TIMEOUT.get(args);
        if (listenPort < 0) {
            return false;
        }
        this.configureSsl(args, server);
        ServerConnector connector = this.createConnector(server, args);
        connector.setPort(listenPort);
        connector.setHost(listenAddress);
        connector.setIdleTimeout(keepAliveTimeout);
        HttpConfiguration config = connector.getConnectionFactory(HttpConnectionFactory.class).getHttpConfiguration();
        config.addCustomizer(new ForwardedRequestCustomizer());
        config.setRequestHeaderSize(Option.REQUEST_HEADER_SIZE.get(args));
        server.addConnector(connector);
        return true;
    }

    private ServerConnector createConnector(Server server, Map args) {
        SslContextFactory sslcf = this.getSSLContext(args);
        return new ServerConnector(server, Option.JETTY_ACCEPTORS.get(args), Option.JETTY_SELECTORS.get(args), sslcf);
    }
}

