/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import winstone.WinstoneResourceBundle;

public class Logger {
    public static final String DEFAULT_STREAM = "Winstone";
    public static Level MIN = Level.OFF;
    public static Level ERROR = Level.SEVERE;
    public static Level WARNING = Level.WARNING;
    public static Level INFO = Level.INFO;
    public static Level SPEED = Level.FINE;
    public static Level DEBUG = Level.FINER;
    public static Level FULL_DEBUG = Level.FINEST;
    public static Level MAX = Level.ALL;
    protected static Boolean semaphore = true;
    protected static boolean initialised = false;
    protected static Writer defaultStream;
    protected static Map namedStreams;
    protected static final DateFormat sdfLog;
    protected static boolean showThrowingThread;
    private static final java.util.logging.Logger LOGGER;

    public static void init(Level level) {
        Logger.init(level, System.out, false);
    }

    public static void init(int level) {
        Logger.init(Level.parse(String.valueOf(level)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Level level, OutputStream defaultStream, boolean showThrowingThreadArg) {
        Boolean bl = semaphore;
        synchronized (bl) {
            if (!initialised) {
                initialised = false;
                LOGGER.setLevel(level);
                namedStreams = new HashMap();
                initialised = true;
                Logger.setStream(DEFAULT_STREAM, defaultStream);
                showThrowingThread = showThrowingThreadArg;
            }
        }
    }

    public static void setStream(String name, OutputStream stream) {
        Logger.setStream(name, stream != null ? new OutputStreamWriter(stream) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStream(String name, Writer stream) {
        if (name == null) {
            name = DEFAULT_STREAM;
        }
        if (!initialised) {
            Logger.init(INFO);
        }
        Boolean bl = semaphore;
        synchronized (bl) {
            if (name.equals(DEFAULT_STREAM)) {
                defaultStream = stream;
            } else if (stream == null) {
                namedStreams.remove(name);
            } else {
                namedStreams.put(name, stream);
            }
        }
    }

    public static void flush(String name) {
        Writer stream;
        if (!initialised) {
            Logger.init(INFO);
        }
        if ((stream = Logger.getStreamByName(name)) != null) {
            try {
                stream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Writer getStreamByName(String streamName) {
        if (streamName != null && streamName.equals(DEFAULT_STREAM)) {
            Boolean bl = semaphore;
            synchronized (bl) {
                Writer stream = (Writer)namedStreams.get(streamName);
                if (stream == null && !namedStreams.containsKey(streamName)) {
                    stream = defaultStream;
                }
                return stream;
            }
        }
        return defaultStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentDebugLevel(int level) {
        if (!initialised) {
            Logger.init(level);
        } else {
            Boolean bl = semaphore;
            synchronized (bl) {
                LOGGER.setLevel(Level.parse(String.valueOf(level)));
            }
        }
    }

    private static void logInternal(Level level, String message, Throwable error) {
        if (!initialised) {
            Logger.init(INFO);
        }
        String msg = "";
        if (showThrowingThread) {
            msg = "[" + Thread.currentThread().getName() + "] - ";
        }
        msg = msg + message;
        LOGGER.log(level, msg, error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object param) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, param), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object ... params) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), null);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object param, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, param), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String messageKey, Object[] params, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), error);
    }

    public static void log(Level level, WinstoneResourceBundle resources, String streamName, String messageKey, Object[] params, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, resources.getString(messageKey, params), error);
    }

    public static void logDirectMessage(Level level, String streamName, String message, Throwable error) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        Logger.logInternal(level, message, error);
    }

    static {
        sdfLog = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        LOGGER = java.util.logging.Logger.getLogger("winstone");
    }
}

