/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.NegotiatingClientConnectionFactory;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.client.FlowControlStrategyFactory;
import org.eclipse.jetty.spdy.client.NPNClientConnectionFactory;
import org.eclipse.jetty.spdy.client.SPDYClientConnectionFactory;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class SPDYClient {
    private final short version;
    private final Factory factory;
    private volatile SocketAddress bindAddress;
    private volatile long idleTimeout = -1L;
    private volatile int initialWindowSize;
    private volatile boolean dispatchIO;
    private volatile ClientConnectionFactory connectionFactory;

    protected SPDYClient(short version, Factory factory) {
        this.version = version;
        this.factory = factory;
        this.setInitialWindowSize(65536);
        this.setDispatchIO(true);
    }

    public short getVersion() {
        return this.version;
    }

    public Factory getFactory() {
        return this.factory;
    }

    public Session connect(SocketAddress address, SessionFrameListener listener) throws ExecutionException, InterruptedException {
        FuturePromise<Session> promise = new FuturePromise<Session>();
        this.connect(address, listener, promise);
        return promise.get();
    }

    public void connect(SocketAddress address, SessionFrameListener listener, Promise<Session> promise) {
        this.connect(address, listener, promise, new HashMap<String, Object>());
    }

    public void connect(SocketAddress address, SessionFrameListener listener, Promise<Session> promise, Map<String, Object> context) {
        if (!this.factory.isStarted()) {
            throw new IllegalStateException(Factory.class.getSimpleName() + " is not started");
        }
        try {
            SocketChannel channel = SocketChannel.open();
            if (this.bindAddress != null) {
                channel.bind(this.bindAddress);
            }
            this.configure(channel);
            channel.configureBlocking(false);
            context.put("ssl.peer.host", ((InetSocketAddress)address).getHostString());
            context.put("ssl.peer.port", ((InetSocketAddress)address).getPort());
            context.put("spdy.client", this);
            context.put("spdy.session.listener", listener);
            context.put("spdy.session.promise", promise);
            if (channel.connect(address)) {
                this.factory.selector.accept(channel, context);
            } else {
                this.factory.selector.connect(channel, context);
            }
        }
        catch (IOException x) {
            promise.failed(x);
        }
    }

    protected void configure(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.initialWindowSize = initialWindowSize;
    }

    public boolean isDispatchIO() {
        return this.dispatchIO;
    }

    public void setDispatchIO(boolean dispatchIO) {
        this.dispatchIO = dispatchIO;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    public void setClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    protected FlowControlStrategy newFlowControlStrategy() {
        return FlowControlStrategyFactory.newFlowControlStrategy(this.version);
    }

    public static class Factory
    extends ContainerLifeCycle {
        private final Queue<Session> sessions = new ConcurrentLinkedQueue<Session>();
        private final Scheduler scheduler;
        private final Executor executor;
        private final ByteBufferPool bufferPool;
        private final SslContextFactory sslContextFactory;
        private final SelectorManager selector;
        private final long idleTimeout;
        private long connectTimeout;

        public Factory() {
            this(null, null);
        }

        public Factory(SslContextFactory sslContextFactory) {
            this(null, null, sslContextFactory);
        }

        public Factory(Executor executor) {
            this(executor, null);
        }

        public Factory(Executor executor, Scheduler scheduler) {
            this(executor, scheduler, null);
        }

        public Factory(Executor executor, Scheduler scheduler, SslContextFactory sslContextFactory) {
            this(executor, scheduler, sslContextFactory, 30000L);
        }

        public Factory(Executor executor, Scheduler scheduler, SslContextFactory sslContextFactory, long idleTimeout) {
            this(executor, scheduler, null, sslContextFactory, idleTimeout);
        }

        public Factory(Executor executor, Scheduler scheduler, ByteBufferPool bufferPool, SslContextFactory sslContextFactory, long idleTimeout) {
            this.idleTimeout = idleTimeout;
            this.setConnectTimeout(15000L);
            if (executor == null) {
                executor = new QueuedThreadPool();
            }
            this.executor = executor;
            this.addBean(executor);
            if (scheduler == null) {
                scheduler = new ScheduledExecutorScheduler();
            }
            this.scheduler = scheduler;
            this.addBean(scheduler);
            if (bufferPool == null) {
                bufferPool = new MappedByteBufferPool();
            }
            this.bufferPool = bufferPool;
            this.addBean(bufferPool);
            this.sslContextFactory = sslContextFactory;
            if (sslContextFactory != null) {
                this.addBean(sslContextFactory);
            }
            this.selector = new ClientSelectorManager(executor, scheduler);
            this.selector.setConnectTimeout(this.getConnectTimeout());
            this.addBean(this.selector);
        }

        public ByteBufferPool getByteBufferPool() {
            return this.bufferPool;
        }

        public Scheduler getScheduler() {
            return this.scheduler;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public SslContextFactory getSslContextFactory() {
            return this.sslContextFactory;
        }

        public long getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(long connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public SPDYClient newSPDYClient(short version) {
            return this.newSPDYClient(version, new NPNClientConnectionFactory(this.getExecutor(), new SPDYClientConnectionFactory(), "spdy/" + version));
        }

        public SPDYClient newSPDYClient(short version, NegotiatingClientConnectionFactory negotiatingFactory) {
            SPDYClient client = new SPDYClient(version, this);
            ClientConnectionFactory connectionFactory = negotiatingFactory.getClientConnectionFactory();
            if (this.sslContextFactory != null) {
                connectionFactory = new SslClientConnectionFactory(this.getSslContextFactory(), this.getByteBufferPool(), this.getExecutor(), negotiatingFactory);
            }
            client.setClientConnectionFactory(connectionFactory);
            return client;
        }

        @Override
        protected void doStop() throws Exception {
            this.closeConnections();
            super.doStop();
        }

        boolean sessionOpened(Session session) {
            return this.isRunning() && this.sessions.offer(session);
        }

        boolean sessionClosed(Session session) {
            return this.isRunning() && this.sessions.remove(session);
        }

        private void closeConnections() {
            for (Session session : this.sessions) {
                session.goAway(new GoAwayInfo(), Callback.Adapter.INSTANCE);
            }
            this.sessions.clear();
        }

        public Collection<Session> getSessions() {
            return Collections.unmodifiableCollection(this.sessions);
        }

        @Override
        protected void dumpThis(Appendable out) throws IOException {
            super.dumpThis(out);
            Factory.dump(out, "", this.sessions);
        }

        private class ClientSelectorManager
        extends SelectorManager {
            private ClientSelectorManager(Executor executor, Scheduler scheduler) {
                super(executor, scheduler);
            }

            @Override
            protected EndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selectSet, SelectionKey key) throws IOException {
                Map context = (Map)key.attachment();
                SPDYClient client = (SPDYClient)context.get("spdy.client");
                long clientIdleTimeout = client.getIdleTimeout();
                if (clientIdleTimeout < 0L) {
                    clientIdleTimeout = Factory.this.idleTimeout;
                }
                return new SelectChannelEndPoint(channel, selectSet, key, this.getScheduler(), clientIdleTimeout);
            }

            @Override
            public Connection newConnection(SocketChannel channel, EndPoint endPoint, Object attachment) throws IOException {
                Map context = (Map)attachment;
                try {
                    SPDYClient client = (SPDYClient)context.get("spdy.client");
                    return client.getClientConnectionFactory().newConnection(endPoint, context);
                }
                catch (Throwable x) {
                    Promise promise = (Promise)context.get("spdy.session.promise");
                    promise.failed(x);
                    throw x;
                }
            }
        }
    }
}

