/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.spdy.AsyncConnectionFactory;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.SPDYAsyncConnection;
import org.eclipse.jetty.spdy.SPDYServerConnector;
import org.eclipse.jetty.spdy.StandardCompressionFactory;
import org.eclipse.jetty.spdy.StandardSession;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.generator.Generator;
import org.eclipse.jetty.spdy.parser.Parser;

public class ServerSPDYAsyncConnectionFactory
implements AsyncConnectionFactory {
    private final ByteBufferPool bufferPool;
    private final Executor threadPool;
    private final ScheduledExecutorService scheduler;
    private final short version;
    private final ServerSessionFrameListener listener;

    public ServerSPDYAsyncConnectionFactory(short version, ByteBufferPool bufferPool, Executor threadPool, ScheduledExecutorService scheduler) {
        this(version, bufferPool, threadPool, scheduler, null);
    }

    public ServerSPDYAsyncConnectionFactory(short version, ByteBufferPool bufferPool, Executor threadPool, ScheduledExecutorService scheduler, ServerSessionFrameListener listener) {
        this.version = version;
        this.bufferPool = bufferPool;
        this.threadPool = threadPool;
        this.scheduler = scheduler;
        this.listener = listener;
    }

    public short getVersion() {
        return this.version;
    }

    @Override
    public AsyncConnection newAsyncConnection(SocketChannel channel, AsyncEndPoint endPoint, Object attachment) {
        StandardCompressionFactory compressionFactory = new StandardCompressionFactory();
        Parser parser = new Parser(compressionFactory.newDecompressor());
        Generator generator = new Generator(this.bufferPool, compressionFactory.newCompressor());
        SPDYServerConnector connector = (SPDYServerConnector)attachment;
        ServerSessionFrameListener listener = this.provideServerSessionFrameListener(endPoint, attachment);
        ServerSPDYAsyncConnection connection = new ServerSPDYAsyncConnection(endPoint, this.bufferPool, parser, listener, connector);
        endPoint.setConnection(connection);
        FlowControlStrategy flowControlStrategy = connector.newFlowControlStrategy(this.version);
        StandardSession session = new StandardSession(this.version, this.bufferPool, this.threadPool, this.scheduler, connection, connection, 2, listener, generator, flowControlStrategy);
        session.setAttribute("org.eclipse.jetty.spdy.remoteAddress", endPoint.getRemoteAddr());
        session.setWindowSize(connector.getInitialWindowSize());
        parser.addListener(session);
        connection.setSession(session);
        connector.sessionOpened(session);
        return connection;
    }

    protected ServerSessionFrameListener provideServerSessionFrameListener(AsyncEndPoint endPoint, Object attachment) {
        return this.listener;
    }

    private static class ServerSPDYAsyncConnection
    extends SPDYAsyncConnection {
        private final ServerSessionFrameListener listener;
        private final SPDYServerConnector connector;
        private volatile boolean connected;

        private ServerSPDYAsyncConnection(AsyncEndPoint endPoint, ByteBufferPool bufferPool, Parser parser, ServerSessionFrameListener listener, SPDYServerConnector connector) {
            super(endPoint, bufferPool, parser);
            this.listener = listener;
            this.connector = connector;
        }

        @Override
        public Connection handle() throws IOException {
            if (!this.connected) {
                if (this.listener != null) {
                    this.listener.onConnect(this.getSession());
                }
                this.connected = true;
            }
            return super.handle();
        }

        @Override
        public void onClose() {
            super.onClose();
            this.connector.sessionClosed(this.getSession());
        }
    }
}

