/*
 * Decompiled with CFR 0.152.
 */
package winstone.jndi.resourceFactories;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneResourceBundle;
import winstone.jndi.resourceFactories.WinstoneConnection;

public class WinstoneDataSource
implements DataSource,
Runnable {
    public static final WinstoneResourceBundle DS_RESOURCES = new WinstoneResourceBundle("winstone.jndi.resourceFactories.LocalStrings");
    private String name;
    private String url;
    private Driver driver;
    private Properties connectProps;
    private int maxIdleCount;
    private int maxHeldCount;
    private int retryCount;
    private int retryPeriod;
    private String keepAliveSQL;
    private int keepAlivePeriod;
    private boolean checkBeforeGet;
    private int killInactivePeriod;
    private List usedWrappers;
    private List unusedRealConnections;
    private List usedRealConnections;
    private Thread managementThread;
    private int loginTimeout;
    private PrintWriter logWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WinstoneDataSource(String name, Map args, ClassLoader loader) {
        this.name = name;
        this.usedWrappers = new ArrayList();
        this.usedRealConnections = new ArrayList();
        this.unusedRealConnections = new ArrayList();
        this.connectProps = new Properties();
        this.keepAliveSQL = WebAppConfiguration.stringArg(args, "keepAliveSQL", "");
        this.keepAlivePeriod = WebAppConfiguration.intArg(args, "keepAlivePeriod", -1);
        this.checkBeforeGet = WebAppConfiguration.booleanArg(args, "checkBeforeGet", !this.keepAliveSQL.equals(""));
        this.killInactivePeriod = WebAppConfiguration.intArg(args, "killInactivePeriod", -1);
        this.url = WebAppConfiguration.stringArg(args, "url", null);
        String driverClassName = WebAppConfiguration.stringArg(args, "driverClassName", "");
        if (args.get("username") != null) {
            this.connectProps.put("user", args.get("username"));
        }
        if (args.get("password") != null) {
            this.connectProps.put("password", args.get("password"));
        }
        this.maxHeldCount = WebAppConfiguration.intArg(args, "maxConnections", 20);
        this.maxIdleCount = WebAppConfiguration.intArg(args, "maxIdle", 10);
        int startCount = WebAppConfiguration.intArg(args, "startConnections", 1);
        this.retryCount = WebAppConfiguration.intArg(args, "retryCount", 1);
        this.retryPeriod = WebAppConfiguration.intArg(args, "retryPeriod", 1000);
        this.log(Logger.FULL_DEBUG, "WinstoneDataSource.Init", this.url, null);
        try {
            List list = this.unusedRealConnections;
            synchronized (list) {
                if (!driverClassName.equals("")) {
                    Class<?> driverClass = Class.forName(driverClassName.trim(), true, loader);
                    this.driver = (Driver)driverClass.newInstance();
                    for (int n = 0; n < startCount; ++n) {
                        this.makeNewRealConnection(this.unusedRealConnections);
                    }
                }
            }
        }
        catch (Throwable err) {
            this.log(Logger.ERROR, "WinstoneDataSource.ErrorInCreate", this.name, err);
        }
        this.managementThread = new Thread((Runnable)this, "DBConnectionPool management thread");
        this.managementThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.managementThread != null) {
            this.managementThread.interrupt();
            this.managementThread = null;
        }
        List list = this.unusedRealConnections;
        synchronized (list) {
            this.killPooledConnections(this.unusedRealConnections, 0);
            this.killPooledConnections(this.usedRealConnections, 0);
        }
        this.usedRealConnections.clear();
        this.unusedRealConnections.clear();
        this.usedWrappers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String username, String password) throws SQLException {
        Properties newProps = new Properties();
        newProps.put("user", username);
        newProps.put("password", password);
        Connection conn = this.driver.connect(this.url, newProps);
        WinstoneConnection wrapper = null;
        List list = this.unusedRealConnections;
        synchronized (list) {
            wrapper = new WinstoneConnection(conn, this);
            this.usedWrappers.add(wrapper);
        }
        return wrapper;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.retryCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(int retriesAllowed) throws SQLException {
        Connection realConnection = null;
        List list = this.unusedRealConnections;
        synchronized (list) {
            if (this.unusedRealConnections.size() > 0) {
                realConnection = (Connection)this.unusedRealConnections.get(0);
                this.unusedRealConnections.remove(realConnection);
                this.usedRealConnections.add(realConnection);
                this.log(Logger.FULL_DEBUG, "WinstoneDataSource.UsingPooled", new String[]{"" + this.usedRealConnections.size(), "" + this.unusedRealConnections.size()}, null);
                try {
                    return this.prepareWrapper(realConnection);
                }
                catch (SQLException err) {}
            } else if (this.usedRealConnections.size() < this.maxHeldCount) {
                realConnection = this.makeNewRealConnection(this.usedRealConnections);
                this.log(Logger.FULL_DEBUG, "WinstoneDataSource.UsingNew", new String[]{"" + this.usedRealConnections.size(), "" + this.unusedRealConnections.size()}, null);
                try {
                    return this.prepareWrapper(realConnection);
                }
                catch (SQLException err) {
                    // empty catch block
                }
            }
        }
        if (realConnection != null) {
            realConnection = null;
            return this.getConnection(retriesAllowed);
        }
        if (retriesAllowed <= 0) {
            throw new SQLException(DS_RESOURCES.getString("WinstoneDataSource.Exceeded", "" + this.maxHeldCount));
        }
        this.log(Logger.FULL_DEBUG, "WinstoneDataSource.Retrying", new String[]{"" + this.maxHeldCount, "" + retriesAllowed, "" + this.retryPeriod}, null);
        try {
            Thread.sleep(this.retryPeriod);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getConnection(retriesAllowed - 1);
    }

    private Connection prepareWrapper(Connection realConnection) throws SQLException {
        if (this.checkBeforeGet) {
            try {
                this.executeKeepAlive(realConnection);
            }
            catch (SQLException err) {
                WinstoneDataSource.killConnection(this.usedRealConnections, realConnection);
                throw err;
            }
        }
        realConnection.setAutoCommit(false);
        WinstoneConnection wrapper = new WinstoneConnection(realConnection, this);
        this.usedWrappers.add(wrapper);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(WinstoneConnection wrapper, Connection realConnection) throws SQLException {
        List list = this.unusedRealConnections;
        synchronized (list) {
            if (wrapper != null) {
                this.usedWrappers.remove(wrapper);
            }
            if (realConnection != null) {
                if (this.usedRealConnections.contains(realConnection)) {
                    this.usedRealConnections.remove(realConnection);
                    this.unusedRealConnections.add(realConnection);
                    this.log(Logger.FULL_DEBUG, "WinstoneDataSource.Releasing", new String[]{"" + this.usedRealConnections.size(), "" + this.unusedRealConnections.size()}, null);
                } else {
                    this.log(Logger.WARNING, "WinstoneDataSource.ReleasingUnknown", null);
                    realConnection.close();
                }
            }
        }
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLoginTimeout(int timeout) {
        this.loginTimeout = timeout;
    }

    public void setLogWriter(PrintWriter writer) {
        this.logWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.log(Logger.DEBUG, "WinstoneDataSource.MaintenanceStart", null);
        int keepAliveCounter = -1;
        int killInactiveCounter = -1;
        boolean threadRunning = true;
        while (threadRunning) {
            try {
                List list;
                long startTime = System.currentTimeMillis();
                if (this.keepAlivePeriod != -1 && threadRunning && this.keepAlivePeriod <= ++keepAliveCounter) {
                    list = this.unusedRealConnections;
                    synchronized (list) {
                        this.executeKeepAliveOnUnused();
                    }
                    keepAliveCounter = 0;
                }
                if (Thread.interrupted()) {
                    threadRunning = false;
                }
                if (this.killInactivePeriod != -1 && threadRunning && this.killInactivePeriod <= ++killInactiveCounter) {
                    list = this.unusedRealConnections;
                    synchronized (list) {
                        this.killPooledConnections(this.unusedRealConnections, this.maxIdleCount);
                    }
                    killInactiveCounter = 0;
                }
                if (killInactiveCounter == 0 || keepAliveCounter == 0) {
                    this.log(Logger.FULL_DEBUG, "WinstoneDataSource.MaintenanceTime", "" + (System.currentTimeMillis() - startTime), null);
                }
                if (Thread.interrupted()) {
                    threadRunning = false;
                } else {
                    Thread.sleep(60000L);
                }
                if (!Thread.interrupted()) continue;
                threadRunning = false;
            }
            catch (InterruptedException err) {
                threadRunning = false;
            }
        }
        this.log(Logger.DEBUG, "WinstoneDataSource.MaintenanceFinish", null);
    }

    protected void executeKeepAliveOnUnused() {
        ArrayList<Connection> dead = new ArrayList<Connection>();
        for (Connection conn : this.unusedRealConnections) {
            try {
                this.executeKeepAlive(conn);
            }
            catch (SQLException errSQL) {
                dead.add(conn);
            }
        }
        Iterator i = dead.iterator();
        while (i.hasNext()) {
            WinstoneDataSource.killConnection(this.unusedRealConnections, (Connection)i.next());
        }
        this.log(Logger.FULL_DEBUG, "WinstoneDataSource.KeepAliveFinished", "" + this.unusedRealConnections.size(), null);
    }

    protected void executeKeepAlive(Connection connection) throws SQLException {
        if (!this.keepAliveSQL.equals("")) {
            PreparedStatement qryKeepAlive = null;
            try {
                qryKeepAlive = connection.prepareStatement(this.keepAliveSQL);
                qryKeepAlive.execute();
            }
            catch (SQLException err) {
                this.log(Logger.WARNING, "WinstoneDataSource.KeepAliveFailed", err);
                throw err;
            }
            finally {
                if (qryKeepAlive != null) {
                    qryKeepAlive.close();
                }
            }
        }
    }

    protected Connection makeNewRealConnection(List pool) throws SQLException {
        if (this.url == null) {
            throw new SQLException("No JDBC URL supplied");
        }
        Connection realConnection = this.driver.connect(this.url, this.connectProps);
        pool.add(realConnection);
        this.log(Logger.FULL_DEBUG, "WinstoneDataSource.AddingNew", new String[]{"" + this.usedRealConnections.size(), "" + this.unusedRealConnections.size()}, null);
        return realConnection;
    }

    protected void killPooledConnections(List pool, int maxIdleCount) {
        int killed = 0;
        while (pool.size() > maxIdleCount) {
            ++killed;
            Connection conn = (Connection)pool.get(0);
            WinstoneDataSource.killConnection(pool, conn);
        }
        if (killed > 0) {
            this.log(Logger.FULL_DEBUG, "WinstoneDataSource.Killed", "" + killed, null);
        }
    }

    private static void killConnection(List pool, Connection conn) {
        pool.remove(conn);
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void log(int level, String msgKey, Throwable err) {
        if (this.getLogWriter() != null) {
            this.getLogWriter().println(DS_RESOURCES.getString(msgKey));
            if (err != null) {
                err.printStackTrace(this.getLogWriter());
            }
        } else {
            Logger.log(level, DS_RESOURCES, msgKey, err);
        }
    }

    private void log(int level, String msgKey, String arg, Throwable err) {
        if (this.getLogWriter() != null) {
            this.getLogWriter().println(DS_RESOURCES.getString(msgKey, arg));
            if (err != null) {
                err.printStackTrace(this.getLogWriter());
            }
        } else {
            Logger.log(level, DS_RESOURCES, msgKey, arg, err);
        }
    }

    private void log(int level, String msgKey, String[] arg, Throwable err) {
        if (this.getLogWriter() != null) {
            this.getLogWriter().println(DS_RESOURCES.getString(msgKey, arg));
            if (err != null) {
                err.printStackTrace(this.getLogWriter());
            }
        } else {
            Logger.log(level, DS_RESOURCES, msgKey, arg, err);
        }
    }

    public String toString() {
        return DS_RESOURCES.getString("WinstoneDataSource.StatusMsg", new String[]{this.name, "" + this.usedRealConnections.size(), "" + this.unusedRealConnections.size()});
    }
}

