/*
 * Decompiled with CFR 0.152.
 */
package winstone.jndi;

import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.jndi.ContainerJNDIManager;

public class WebAppJNDIManager
extends ContainerJNDIManager {
    static final String ELEM_ENV_ENTRY = "env-entry";
    static final String ELEM_ENV_ENTRY_NAME = "env-entry-name";
    static final String ELEM_ENV_ENTRY_TYPE = "env-entry-type";
    static final String ELEM_ENV_ENTRY_VALUE = "env-entry-value";

    public WebAppJNDIManager(Map args, List webXMLNodes, ClassLoader loader) {
        super(args, webXMLNodes, loader);
        if (webXMLNodes != null) {
            for (Node node : webXMLNodes) {
                if (node.getNodeType() != 1 || !node.getNodeName().equals(ELEM_ENV_ENTRY)) continue;
                String name = null;
                String type = null;
                String value = null;
                for (int m = 0; m < node.getChildNodes().getLength(); ++m) {
                    Node envNode = node.getChildNodes().item(m);
                    if (envNode.getNodeType() != 1) continue;
                    if (envNode.getNodeName().equals(ELEM_ENV_ENTRY_NAME)) {
                        name = WebAppConfiguration.getTextFromNode(envNode);
                        continue;
                    }
                    if (envNode.getNodeName().equals(ELEM_ENV_ENTRY_TYPE)) {
                        type = WebAppConfiguration.getTextFromNode(envNode);
                        continue;
                    }
                    if (!envNode.getNodeName().equals(ELEM_ENV_ENTRY_VALUE)) continue;
                    value = WebAppConfiguration.getTextFromNode(envNode);
                }
                if (name == null || type == null || value == null) continue;
                Logger.log(Logger.FULL_DEBUG, JNDI_RESOURCES, "WebAppJNDIManager.CreatingResourceWebXML", name);
                Object obj = this.createObject(name, type, value, args, loader);
                if (obj == null) continue;
                this.objectsToCreate.put(name, obj);
            }
        }
    }
}

