/*
 * Decompiled with CFR 0.152.
 */
package winstone.jndi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import winstone.JNDIManager;
import winstone.Logger;
import winstone.WinstoneResourceBundle;
import winstone.jndi.resourceFactories.WinstoneDataSource;

public class ContainerJNDIManager
implements JNDIManager {
    public static final WinstoneResourceBundle JNDI_RESOURCES = new WinstoneResourceBundle("winstone.jndi.LocalStrings");
    protected Map objectsToCreate = new HashMap();

    public ContainerJNDIManager(Map args, List webXmlNodes, ClassLoader loader) {
        ArrayList keys = new ArrayList(args != null ? args.keySet() : new ArrayList());
        for (String key : keys) {
            if (!key.startsWith("jndi.resource.")) continue;
            String resName = key.substring(14);
            String className = (String)args.get(key);
            String value = (String)args.get("jndi.param." + resName + ".value");
            Logger.log(Logger.FULL_DEBUG, JNDI_RESOURCES, "ContainerJNDIManager.CreatingResourceArgs", resName);
            Object obj = this.createObject(resName.trim(), className.trim(), value, args, loader);
            if (obj == null) continue;
            this.objectsToCreate.put(resName, obj);
        }
    }

    public void setup() {
        try {
            InitialContext ic = new InitialContext();
            for (String name : this.objectsToCreate.keySet()) {
                try {
                    Name fullName = new CompositeName(name);
                    Context currentContext = ic;
                    while (fullName.size() > 1) {
                        try {
                            currentContext = currentContext.createSubcontext(fullName.get(0));
                        }
                        catch (NamingException err) {
                            currentContext = (Context)currentContext.lookup(fullName.get(0));
                        }
                        fullName = fullName.getSuffix(1);
                    }
                    ic.bind(name, this.objectsToCreate.get(name));
                    Logger.log(Logger.FULL_DEBUG, JNDI_RESOURCES, "ContainerJNDIManager.BoundResource", name);
                }
                catch (NamingException err) {
                    Logger.log(Logger.ERROR, JNDI_RESOURCES, "ContainerJNDIManager.ErrorBindingResource", name, (Throwable)err);
                }
            }
            Logger.log(Logger.DEBUG, JNDI_RESOURCES, "ContainerJNDIManager.SetupComplete", "" + this.objectsToCreate.size());
        }
        catch (NamingException err) {
            Logger.log(Logger.ERROR, JNDI_RESOURCES, "ContainerJNDIManager.ErrorGettingInitialContext", err);
        }
    }

    public void tearDown() {
        try {
            InitialContext ic = new InitialContext();
            for (String name : this.objectsToCreate.keySet()) {
                try {
                    ic.unbind(name);
                }
                catch (NamingException err) {
                    Logger.log(Logger.ERROR, JNDI_RESOURCES, "ContainerJNDIManager.ErrorUnbindingResource", name, (Throwable)err);
                }
                Object unboundObject = this.objectsToCreate.get(name);
                if (unboundObject instanceof WinstoneDataSource) {
                    ((WinstoneDataSource)unboundObject).destroy();
                }
                Logger.log(Logger.FULL_DEBUG, JNDI_RESOURCES, "ContainerJNDIManager.UnboundResource", name);
            }
            Logger.log(Logger.DEBUG, JNDI_RESOURCES, "ContainerJNDIManager.TeardownComplete", "" + this.objectsToCreate.size());
        }
        catch (NamingException err) {
            Logger.log(Logger.ERROR, JNDI_RESOURCES, "ContainerJNDIManager.ErrorGettingInitialContext", err);
        }
    }

    /*
     * Exception decompiling
     */
    protected Object createObject(String name, String className, String value, Map args, ClassLoader loader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Properties extractRelevantArgs(Map input, String name) {
        Properties relevantArgs = new Properties();
        for (String key : input.keySet()) {
            if (!key.startsWith("jndi.param." + name + ".")) continue;
            relevantArgs.put(key.substring(12 + name.length()), input.get(key));
        }
        return relevantArgs;
    }
}

