/*
 * Decompiled with CFR 0.152.
 */
package winstone.auth;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Node;
import winstone.AuthenticationPrincipal;
import winstone.AuthenticationRealm;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneRequest;
import winstone.auth.BaseAuthenticationHandler;
import winstone.auth.RetryRequestParams;
import winstone.auth.RetryRequestWrapper;

public class FormAuthenticationHandler
extends BaseAuthenticationHandler {
    private static final String ELEM_FORM_LOGIN_CONFIG = "form-login-config";
    private static final String ELEM_FORM_LOGIN_PAGE = "form-login-page";
    private static final String ELEM_FORM_ERROR_PAGE = "form-error-page";
    private static final String FORM_ACTION = "j_security_check";
    private static final String FORM_USER = "j_username";
    private static final String FORM_PASS = "j_password";
    private static final String AUTHENTICATED_USER = "winstone.auth.FormAuthenticationHandler.AUTHENTICATED_USER";
    private static final String CACHED_REQUEST = "winstone.auth.FormAuthenticationHandler.CACHED_REQUEST";
    private String loginPage;
    private String errorPage;

    public FormAuthenticationHandler(Node loginConfigNode, List constraintNodes, Set rolesAllowed, AuthenticationRealm realm) {
        super(loginConfigNode, constraintNodes, rolesAllowed, realm);
        for (int n = 0; n < loginConfigNode.getChildNodes().getLength(); ++n) {
            Node loginElm = loginConfigNode.getChildNodes().item(n);
            if (!loginElm.getNodeName().equals(ELEM_FORM_LOGIN_CONFIG)) continue;
            for (int k = 0; k < loginElm.getChildNodes().getLength(); ++k) {
                Node formElm = loginElm.getChildNodes().item(k);
                if (formElm.getNodeType() != 1) continue;
                if (formElm.getNodeName().equals(ELEM_FORM_LOGIN_PAGE)) {
                    this.loginPage = WebAppConfiguration.getTextFromNode(formElm);
                    continue;
                }
                if (!formElm.getNodeName().equals(ELEM_FORM_ERROR_PAGE)) continue;
                this.errorPage = WebAppConfiguration.getTextFromNode(formElm);
            }
        }
        Logger.log(Logger.DEBUG, AUTH_RESOURCES, "FormAuthenticationHandler.Initialised", this.realmName);
    }

    public boolean processAuthentication(ServletRequest request, ServletResponse response, String pathRequested) throws IOException, ServletException {
        if (pathRequested.equals(this.loginPage) || pathRequested.equals(this.errorPage)) {
            return true;
        }
        return super.processAuthentication(request, response, pathRequested);
    }

    protected void requestAuthentication(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws ServletException, IOException {
        ServletRequest unwrapped = request;
        while (unwrapped instanceof HttpServletRequestWrapper) {
            unwrapped = ((HttpServletRequestWrapper)unwrapped).getRequest();
        }
        HttpSession session = request.getSession(true);
        session.setAttribute(CACHED_REQUEST, new RetryRequestParams(unwrapped));
        Logger.log(Logger.FULL_DEBUG, AUTH_RESOURCES, "FormAuthenticationHandler.GoToLoginPage");
        RequestDispatcher rdLogin = request.getRequestDispatcher(this.loginPage);
        this.setNoCache(response);
        rdLogin.forward(request, response);
    }

    protected boolean validatePossibleAuthenticationResponse(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws ServletException, IOException {
        AuthenticationPrincipal authenticatedUser;
        if (pathRequested.endsWith(FORM_ACTION)) {
            String password;
            String username = request.getParameter(FORM_USER);
            AuthenticationPrincipal principal = this.realm.authenticateByUsernamePassword(username, password = request.getParameter(FORM_PASS));
            if (principal == null) {
                RequestDispatcher rdError = request.getRequestDispatcher(this.errorPage);
                rdError.forward(request, response);
            } else {
                ServletRequest wrapperCheck = request;
                while (wrapperCheck instanceof HttpServletRequestWrapper) {
                    wrapperCheck = ((HttpServletRequestWrapper)wrapperCheck).getRequest();
                }
                WinstoneRequest actualRequest = null;
                if (wrapperCheck instanceof WinstoneRequest) {
                    actualRequest = (WinstoneRequest)wrapperCheck;
                    actualRequest.setRemoteUser(principal);
                } else {
                    Logger.log(Logger.WARNING, AUTH_RESOURCES, "FormAuthenticationHandler.CantSetUser", wrapperCheck.getClass().getName());
                }
                HttpSession session = request.getSession(true);
                String previousLocation = this.loginPage;
                RetryRequestParams cachedRequest = (RetryRequestParams)session.getAttribute(CACHED_REQUEST);
                if (cachedRequest != null && actualRequest != null) {
                    request = new RetryRequestWrapper(request, cachedRequest);
                    previousLocation = (request.getServletPath() == null ? "" : request.getServletPath()) + (request.getPathInfo() == null ? "" : request.getPathInfo());
                } else {
                    Logger.log(Logger.DEBUG, AUTH_RESOURCES, "FormAuthenticationHandler.NoCachedRequest");
                }
                if (this.doRoleCheck(request, response, previousLocation)) {
                    principal.setAuthType("FORM");
                    session.setAttribute(AUTHENTICATED_USER, principal);
                    RequestDispatcher rdPrevious = request.getRequestDispatcher(previousLocation);
                    rdPrevious.forward(request, response);
                } else {
                    RequestDispatcher rdError = request.getRequestDispatcher(this.errorPage);
                    rdError.forward(request, response);
                }
            }
            return false;
        }
        WinstoneRequest actualRequest = null;
        if (request instanceof WinstoneRequest) {
            actualRequest = (WinstoneRequest)request;
        } else if (request instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
            if (wrapper.getRequest() instanceof WinstoneRequest) {
                actualRequest = (WinstoneRequest)wrapper.getRequest();
            } else {
                Logger.log(Logger.WARNING, AUTH_RESOURCES, "FormAuthenticationHandler.CantSetUser", wrapper.getRequest().getClass().getName());
            }
        } else {
            Logger.log(Logger.WARNING, AUTH_RESOURCES, "FormAuthenticationHandler.CantSetUser", request.getClass().getName());
        }
        HttpSession session = actualRequest.getSession(false);
        if (session != null && (authenticatedUser = (AuthenticationPrincipal)session.getAttribute(AUTHENTICATED_USER)) != null) {
            actualRequest.setRemoteUser(authenticatedUser);
            Logger.log(Logger.FULL_DEBUG, AUTH_RESOURCES, "FormAuthenticationHandler.GotUserFromSession");
        }
        return true;
    }
}

