/*
 * Decompiled with CFR 0.152.
 */
package winstone.auth;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Node;
import winstone.AuthenticationPrincipal;
import winstone.AuthenticationRealm;
import winstone.Logger;
import winstone.WinstoneRequest;
import winstone.WinstoneResourceBundle;
import winstone.auth.BaseAuthenticationHandler;

public class DigestAuthenticationHandler
extends BaseAuthenticationHandler {
    private MessageDigest md5Digester = MessageDigest.getInstance("MD5");

    public DigestAuthenticationHandler(Node loginConfigNode, List constraintNodes, Set rolesAllowed, AuthenticationRealm realm) throws NoSuchAlgorithmException {
        super(loginConfigNode, constraintNodes, rolesAllowed, realm);
        Logger.log(Logger.DEBUG, AUTH_RESOURCES, "DigestAuthenticationHandler.Initialised", this.realmName);
    }

    protected void requestAuthentication(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws IOException {
        String oneTimeToken = "WinstoneToken:" + new Random().nextDouble() * (double)System.currentTimeMillis();
        String authHeader = "Digest realm=\"" + this.realmName + "\", qop=\"auth\", " + "nonce=\"" + oneTimeToken + "\", opaque=\"" + this.md5Encode(oneTimeToken) + "\"";
        response.setHeader("WWW-Authenticate", authHeader);
        response.sendError(401, AUTH_RESOURCES.getString("DigestAuthenticationHandler.UnauthorizedMessage"));
    }

    protected boolean validatePossibleAuthenticationResponse(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws IOException {
        String authorization = request.getHeader("Authorization");
        if (authorization == null) {
            return true;
        }
        if (!authorization.startsWith("Digest")) {
            return true;
        }
        String userName = null;
        String realm = null;
        String qop = null;
        String algorithm = null;
        String uri = null;
        String nOnce = null;
        String nc = null;
        String cnOnce = null;
        String clientResponseDigest = null;
        StringTokenizer st = new StringTokenizer(authorization.substring(6).trim(), ",");
        while (st.hasMoreTokens()) {
            int equalPos;
            String token = st.nextToken().trim();
            String paramName = token.substring(0, equalPos = token.indexOf(61));
            if (paramName.equals("username")) {
                userName = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
                continue;
            }
            if (paramName.equals("realm")) {
                realm = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
                continue;
            }
            if (paramName.equals("qop")) {
                qop = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
                continue;
            }
            if (paramName.equals("algorithm")) {
                algorithm = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
                continue;
            }
            if (paramName.equals("uri")) {
                uri = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
                continue;
            }
            if (paramName.equals("nonce")) {
                nOnce = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
                continue;
            }
            if (paramName.equals("nc")) {
                nc = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
                continue;
            }
            if (paramName.equals("cnonce")) {
                cnOnce = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
                continue;
            }
            if (!paramName.equals("response")) continue;
            clientResponseDigest = WinstoneResourceBundle.globalReplace(token.substring(equalPos + 1).trim(), "\"", "");
        }
        if (userName == null || realm == null || qop == null || uri == null || nOnce == null || nc == null || cnOnce == null || clientResponseDigest == null) {
            return true;
        }
        if (algorithm != null && !algorithm.equals("MD5")) {
            return true;
        }
        AuthenticationPrincipal principal = this.realm.retrieveUser(userName);
        if (principal == null) {
            return true;
        }
        String userRealmPasswordDigest = this.md5Encode(userName + ":" + realm + ":" + principal.getPassword());
        String methodURIDigest = this.md5Encode(request.getMethod() + ":" + uri);
        String serverResponseDigest = this.md5Encode(userRealmPasswordDigest + ":" + nOnce + ":" + nc + ":" + cnOnce + ":" + qop + ":" + methodURIDigest);
        if (serverResponseDigest.equals(clientResponseDigest)) {
            principal.setAuthType("DIGEST");
            if (request instanceof WinstoneRequest) {
                ((WinstoneRequest)request).setRemoteUser(principal);
            } else if (request instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                if (wrapper.getRequest() instanceof WinstoneRequest) {
                    ((WinstoneRequest)wrapper.getRequest()).setRemoteUser(principal);
                } else {
                    Logger.log(Logger.WARNING, AUTH_RESOURCES, "DigestAuthenticationHandler.CantSetUser", wrapper.getRequest().getClass().getName());
                }
            } else {
                Logger.log(Logger.WARNING, AUTH_RESOURCES, "DigestAuthenticationHandler.CantSetUser", request.getClass().getName());
            }
        }
        return true;
    }

    public String md5Encode(String input) throws UnsupportedEncodingException {
        byte[] digestBytes = this.md5Digester.digest(input.getBytes("8859_1"));
        char[] outArray = new char[32];
        for (int n = 0; n < digestBytes.length; ++n) {
            int hiNibble = (digestBytes[n] & 0xFF) >> 4;
            int loNibble = digestBytes[n] & 0xF;
            outArray[2 * n] = hiNibble > 9 ? (char)(hiNibble + 87) : (char)(hiNibble + 48);
            outArray[2 * n + 1] = loNibble > 9 ? (char)(loNibble + 87) : (char)(loNibble + 48);
        }
        return new String(outArray);
    }
}

