/*
 * Decompiled with CFR 0.152.
 */
package winstone.auth;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Node;
import winstone.AuthenticationPrincipal;
import winstone.AuthenticationRealm;
import winstone.Logger;
import winstone.WinstoneRequest;
import winstone.auth.BaseAuthenticationHandler;

public class ClientcertAuthenticationHandler
extends BaseAuthenticationHandler {
    public ClientcertAuthenticationHandler(Node loginConfigNode, List constraintNodes, Set rolesAllowed, AuthenticationRealm realm) {
        super(loginConfigNode, constraintNodes, rolesAllowed, realm);
        Logger.log(Logger.DEBUG, AUTH_RESOURCES, "ClientcertAuthenticationHandler.Initialised", this.realmName);
    }

    protected void requestAuthentication(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws IOException {
        response.sendError(401, AUTH_RESOURCES.getString("ClientcertAuthenticationHandler.UnauthorizedMessage"));
    }

    protected boolean validatePossibleAuthenticationResponse(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws IOException {
        X509Certificate[] certificateArray = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certificateArray != null && certificateArray.length > 0) {
            AuthenticationPrincipal principal;
            boolean failed = false;
            for (int n = 0; n < certificateArray.length; ++n) {
                try {
                    certificateArray[n].checkValidity();
                    continue;
                }
                catch (Throwable err) {
                    failed = true;
                }
            }
            if (!failed && (principal = this.realm.retrieveUser(certificateArray[0].getSubjectDN().getName())) != null) {
                principal.setAuthType("CLIENT_CERT");
                if (request instanceof WinstoneRequest) {
                    ((WinstoneRequest)request).setRemoteUser(principal);
                } else if (request instanceof HttpServletRequestWrapper) {
                    HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                    if (wrapper.getRequest() instanceof WinstoneRequest) {
                        ((WinstoneRequest)wrapper.getRequest()).setRemoteUser(principal);
                    } else {
                        Logger.log(Logger.WARNING, AUTH_RESOURCES, "ClientCertAuthenticationHandler.CantSetUser", wrapper.getRequest().getClass().getName());
                    }
                } else {
                    Logger.log(Logger.WARNING, AUTH_RESOURCES, "ClientCertAuthenticationHandler.CantSetUser", request.getClass().getName());
                }
            }
        }
        return true;
    }
}

