/*
 * Decompiled with CFR 0.152.
 */
package winstone.auth;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Node;
import winstone.AuthenticationPrincipal;
import winstone.AuthenticationRealm;
import winstone.Logger;
import winstone.WinstoneRequest;
import winstone.auth.BaseAuthenticationHandler;

public class BasicAuthenticationHandler
extends BaseAuthenticationHandler {
    private static byte[] B64_DECODE_ARRAY = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1};

    public BasicAuthenticationHandler(Node loginConfigNode, List constraintNodes, Set rolesAllowed, AuthenticationRealm realm) {
        super(loginConfigNode, constraintNodes, rolesAllowed, realm);
        Logger.log(Logger.DEBUG, AUTH_RESOURCES, "BasicAuthenticationHandler.Initialised", this.realmName);
    }

    protected void requestAuthentication(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic Realm=\"" + this.realmName + "\"");
        response.sendError(401, AUTH_RESOURCES.getString("BasicAuthenticationHandler.UnauthorizedMessage"));
    }

    protected boolean validatePossibleAuthenticationResponse(HttpServletRequest request, HttpServletResponse response, String pathRequested) throws IOException {
        AuthenticationPrincipal principal;
        int length;
        char[] inBytes;
        byte[] outBytes;
        String decoded;
        int delimPos;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.toLowerCase().startsWith("basic") && (delimPos = (decoded = new String(outBytes = new byte[(int)((float)(inBytes = authorization.substring(5).trim().toCharArray()).length * 0.75f)], 0, length = BasicAuthenticationHandler.decodeBase64(inBytes, outBytes, 0, inBytes.length, 0))).indexOf(58)) != -1 && (principal = this.realm.authenticateByUsernamePassword(decoded.substring(0, delimPos).trim(), decoded.substring(delimPos + 1).trim())) != null) {
            principal.setAuthType("BASIC");
            if (request instanceof WinstoneRequest) {
                ((WinstoneRequest)request).setRemoteUser(principal);
            } else if (request instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                if (wrapper.getRequest() instanceof WinstoneRequest) {
                    ((WinstoneRequest)wrapper.getRequest()).setRemoteUser(principal);
                } else {
                    Logger.log(Logger.WARNING, AUTH_RESOURCES, "BasicAuthenticationHandler.CantSetUser", wrapper.getRequest().getClass().getName());
                }
            } else {
                Logger.log(Logger.WARNING, AUTH_RESOURCES, "BasicAuthenticationHandler.CantSetUser", request.getClass().getName());
            }
        }
        return true;
    }

    public static int decodeBase64(char[] input, byte[] output, int inOffset, int inLength, int outOffset) {
        int thisPassInBytes;
        if (inLength == 0) {
            return 0;
        }
        int outIndex = outOffset;
        for (int inIndex = inOffset; inIndex < inLength; inIndex += thisPassInBytes) {
            int outBuffer;
            for (thisPassInBytes = Math.min(inLength - inIndex, 4); thisPassInBytes > 1 && input[inIndex + thisPassInBytes - 1] == '='; --thisPassInBytes) {
            }
            if (thisPassInBytes == 2) {
                outBuffer = (B64_DECODE_ARRAY[input[inIndex]] & 0xFF) << 18 | (B64_DECODE_ARRAY[input[inIndex + 1]] & 0xFF) << 12;
                output[outIndex] = (byte)(outBuffer >> 16 & 0xFF);
                ++outIndex;
                continue;
            }
            if (thisPassInBytes == 3) {
                outBuffer = (B64_DECODE_ARRAY[input[inIndex]] & 0xFF) << 18 | (B64_DECODE_ARRAY[input[inIndex + 1]] & 0xFF) << 12 | (B64_DECODE_ARRAY[input[inIndex + 2]] & 0xFF) << 6;
                output[outIndex] = (byte)(outBuffer >> 16 & 0xFF);
                output[outIndex + 1] = (byte)(outBuffer >> 8 & 0xFF);
                outIndex += 2;
                continue;
            }
            if (thisPassInBytes != 4) continue;
            outBuffer = (B64_DECODE_ARRAY[input[inIndex]] & 0xFF) << 18 | (B64_DECODE_ARRAY[input[inIndex + 1]] & 0xFF) << 12 | (B64_DECODE_ARRAY[input[inIndex + 2]] & 0xFF) << 6 | B64_DECODE_ARRAY[input[inIndex + 3]] & 0xFF;
            output[outIndex] = (byte)(outBuffer >> 16 & 0xFF);
            output[outIndex + 1] = (byte)(outBuffer >> 8 & 0xFF);
            output[outIndex + 2] = (byte)(outBuffer & 0xFF);
            outIndex += 3;
        }
        return outIndex;
    }
}

