/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import winstone.Launcher;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneRequest;

public class WinstoneSession
implements HttpSession,
Serializable {
    public static final String SESSION_COOKIE_NAME = "JSESSIONID";
    private String sessionId;
    private WebAppConfiguration webAppConfig;
    private Map sessionData;
    private long createTime;
    private long lastAccessedTime;
    private int maxInactivePeriod;
    private boolean isNew;
    private boolean isInvalidated;
    private HttpSessionAttributeListener[] sessionAttributeListeners;
    private HttpSessionListener[] sessionListeners;
    private HttpSessionActivationListener[] sessionActivationListeners;
    private boolean distributable;
    private Object sessionMonitor = new Boolean(true);
    private Set requestsUsingMe;

    public WinstoneSession(String sessionId) {
        this.sessionId = sessionId;
        this.sessionData = new Hashtable();
        this.requestsUsingMe = Collections.synchronizedSet(new HashSet());
        this.createTime = System.currentTimeMillis();
        this.isNew = true;
        this.isInvalidated = false;
    }

    public void setWebAppConfiguration(WebAppConfiguration webAppConfig) {
        this.webAppConfig = webAppConfig;
        this.distributable = webAppConfig.isDistributable();
    }

    public void sendCreatedNotifies() {
        for (int n = 0; n < this.sessionListeners.length; ++n) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            this.sessionListeners[n].sessionCreated(new HttpSessionEvent(this));
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void setSessionActivationListeners(HttpSessionActivationListener[] listeners) {
        this.sessionActivationListeners = listeners;
    }

    public void setSessionAttributeListeners(HttpSessionAttributeListener[] listeners) {
        this.sessionAttributeListeners = listeners;
    }

    public void setSessionListeners(HttpSessionListener[] listeners) {
        this.sessionListeners = listeners;
    }

    public void setLastAccessedDate(long time) {
        this.lastAccessedTime = time;
    }

    public void setIsNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void addUsed(WinstoneRequest request) {
        this.requestsUsingMe.add(request);
    }

    public void removeUsed(WinstoneRequest request) {
        this.requestsUsingMe.remove(request);
    }

    public boolean isUnusedByRequests() {
        return this.requestsUsingMe.isEmpty();
    }

    public boolean isExpired() {
        long nowDate = System.currentTimeMillis();
        long maxInactive = this.getMaxInactiveInterval() * 1000;
        return maxInactive > 0L && nowDate - this.lastAccessedTime > maxInactive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (this.isInvalidated) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneSession.InvalidatedSession"));
        }
        Object att = null;
        Object object = this.sessionMonitor;
        synchronized (object) {
            att = this.sessionData.get(name);
        }
        return att;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (this.isInvalidated) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneSession.InvalidatedSession"));
        }
        Enumeration names = null;
        Object object = this.sessionMonitor;
        synchronized (object) {
            names = Collections.enumeration(this.sessionData.keySet());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        ClassLoader cl;
        Object cl2;
        if (this.isInvalidated) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneSession.InvalidatedSession"));
        }
        if (this.distributable && value != null && !(value instanceof Serializable)) {
            throw new IllegalArgumentException(Launcher.RESOURCES.getString("WinstoneSession.AttributeNotSerializable", new String[]{name, value.getClass().getName()}));
        }
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener hsbl = (HttpSessionBindingListener)value;
            cl2 = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            hsbl.valueBound(new HttpSessionBindingEvent(this, name, value));
            Thread.currentThread().setContextClassLoader((ClassLoader)cl2);
        }
        Object oldValue = null;
        cl2 = this.sessionMonitor;
        synchronized (cl2) {
            oldValue = this.sessionData.get(name);
            if (value == null) {
                this.sessionData.remove(name);
            } else {
                this.sessionData.put(name, value);
            }
        }
        if (oldValue instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener hsbl = oldValue;
            cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            hsbl.valueUnbound(new HttpSessionBindingEvent(this, name, oldValue));
            Thread.currentThread().setContextClassLoader(cl);
        }
        if (oldValue != null) {
            for (int n = 0; n < this.sessionAttributeListeners.length; ++n) {
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
                this.sessionAttributeListeners[n].attributeReplaced(new HttpSessionBindingEvent(this, name, oldValue));
                Thread.currentThread().setContextClassLoader(cl);
            }
        } else {
            for (int n = 0; n < this.sessionAttributeListeners.length; ++n) {
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
                this.sessionAttributeListeners[n].attributeAdded(new HttpSessionBindingEvent(this, name, value));
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        ClassLoader cl;
        if (this.isInvalidated) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneSession.InvalidatedSession"));
        }
        Object value = null;
        Object object = this.sessionMonitor;
        synchronized (object) {
            value = this.sessionData.get(name);
            this.sessionData.remove(name);
        }
        if (value instanceof HttpSessionBindingListener) {
            HttpSessionBindingListener hsbl = value;
            cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            hsbl.valueUnbound(new HttpSessionBindingEvent(this, name));
            Thread.currentThread().setContextClassLoader(cl);
        }
        if (value != null) {
            for (int n = 0; n < this.sessionAttributeListeners.length; ++n) {
                cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
                this.sessionAttributeListeners[n].attributeRemoved(new HttpSessionBindingEvent(this, name, value));
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    public long getCreationTime() {
        if (this.isInvalidated) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneSession.InvalidatedSession"));
        }
        return this.createTime;
    }

    public long getLastAccessedTime() {
        if (this.isInvalidated) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneSession.InvalidatedSession"));
        }
        return this.lastAccessedTime;
    }

    public String getId() {
        return this.sessionId;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactivePeriod;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactivePeriod = interval;
    }

    public boolean isNew() {
        if (this.isInvalidated) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneSession.InvalidatedSession"));
        }
        return this.isNew;
    }

    public ServletContext getServletContext() {
        return this.webAppConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.isInvalidated) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneSession.InvalidatedSession"));
        }
        for (int n = this.sessionListeners.length - 1; n >= 0; --n) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            this.sessionListeners[n].sessionDestroyed(new HttpSessionEvent(this));
            Thread.currentThread().setContextClassLoader(cl);
        }
        ArrayList keys = new ArrayList(this.sessionData.keySet());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            this.removeAttribute((String)i.next());
        }
        Object object = this.sessionMonitor;
        synchronized (object) {
            this.sessionData.clear();
        }
        this.isInvalidated = true;
        this.webAppConfig.removeSessionById(this.sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate() {
        for (int n = 0; n < this.sessionActivationListeners.length; ++n) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            this.sessionActivationListeners[n].sessionWillPassivate(new HttpSessionEvent(this));
            Thread.currentThread().setContextClassLoader(cl);
        }
        Object object = this.sessionMonitor;
        synchronized (object) {
            this.sessionData.clear();
        }
        this.webAppConfig.removeSessionById(this.sessionId);
    }

    public void activate(WebAppConfiguration webAppConfig) {
        this.webAppConfig = webAppConfig;
        webAppConfig.setSessionListeners(this);
        for (int n = 0; n < this.sessionActivationListeners.length; ++n) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.webAppConfig.getLoader());
            this.sessionActivationListeners[n].sessionDidActivate(new HttpSessionEvent(this));
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToTemp() {
        File toDir = WinstoneSession.getSessionTempDir(this.webAppConfig);
        Object object = this.sessionMonitor;
        synchronized (object) {
            OutputStream out = null;
            ObjectOutputStream objOut = null;
            try {
                File toFile = new File(toDir, this.sessionId + ".ser");
                out = new FileOutputStream(toFile, false);
                objOut = new ObjectOutputStream(out);
                objOut.writeObject(this);
            }
            catch (IOException err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WinstoneSession.ErrorSavingSession", err);
            }
            finally {
                if (objOut != null) {
                    try {
                        objOut.close();
                    }
                    catch (IOException err) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException err) {}
                }
            }
        }
    }

    public static File getSessionTempDir(WebAppConfiguration webAppConfig) {
        File tmpDir = (File)webAppConfig.getAttribute("javax.servlet.context.tempdir");
        File sessionsDir = new File(tmpDir, "WEB-INF" + File.separator + "winstoneSessions");
        if (!sessionsDir.exists()) {
            sessionsDir.mkdirs();
        }
        return sessionsDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSessions(WebAppConfiguration webAppConfig) {
        int expiredCount = 0;
        File tempDir = WinstoneSession.getSessionTempDir(webAppConfig);
        File[] possibleSessionFiles = tempDir.listFiles();
        for (int n = 0; n < possibleSessionFiles.length; ++n) {
            if (!possibleSessionFiles[n].getName().endsWith(".ser")) continue;
            FileInputStream in = null;
            ObjectInputStream objIn = null;
            try {
                in = new FileInputStream(possibleSessionFiles[n]);
                objIn = new ObjectInputStream(in);
                WinstoneSession session = (WinstoneSession)objIn.readObject();
                session.setWebAppConfiguration(webAppConfig);
                webAppConfig.setSessionListeners(session);
                if (session.isExpired()) {
                    session.invalidate();
                    ++expiredCount;
                    continue;
                }
                webAppConfig.addSession(session.getId(), session);
                Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneSession.RestoredSession", session.getId());
                continue;
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WinstoneSession.ErrorLoadingSession", err);
                continue;
            }
            finally {
                if (objIn != null) {
                    try {
                        objIn.close();
                    }
                    catch (IOException err) {}
                }
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException err) {}
                }
                possibleSessionFiles[n].delete();
            }
        }
        if (expiredCount > 0) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.InvalidatedSessions", expiredCount + "");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.sessionId);
        out.writeLong(this.createTime);
        out.writeLong(this.lastAccessedTime);
        out.writeInt(this.maxInactivePeriod);
        out.writeBoolean(this.isNew);
        out.writeBoolean(this.distributable);
        HashMap copy = new HashMap(this.sessionData);
        HashSet keys = new HashSet(copy.keySet());
        for (String key : keys) {
            if (!(copy.get(key) instanceof Serializable)) {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneSession.SkippingNonSerializable", new String[]{key, copy.get(key).getClass().getName()});
            }
            copy.remove(key);
        }
        out.writeInt(copy.size());
        for (String key : copy.keySet()) {
            out.writeUTF(key);
            out.writeObject(copy.get(key));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.sessionId = in.readUTF();
        this.createTime = in.readLong();
        this.lastAccessedTime = in.readLong();
        this.maxInactivePeriod = in.readInt();
        this.isNew = in.readBoolean();
        this.distributable = in.readBoolean();
        this.sessionData = new Hashtable();
        this.requestsUsingMe = Collections.synchronizedSet(new HashSet());
        int entryCount = in.readInt();
        for (int n = 0; n < entryCount; ++n) {
            String key = in.readUTF();
            Object variable = in.readObject();
            this.sessionData.put(key, variable);
        }
        this.sessionMonitor = new Boolean(true);
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public String[] getValueNames() {
        return this.sessionData.keySet().toArray(new String[0]);
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }
}

