/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import winstone.ClientOutputStream;
import winstone.Launcher;
import winstone.Logger;
import winstone.WinstoneResponse;

public class WinstoneOutputStream
extends ServletOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final byte[] CR_LF = "\r\n".getBytes();
    protected OutputStream outStream;
    protected int bufferSize;
    protected int bufferPosition;
    protected int bytesCommitted;
    protected ByteArrayOutputStream buffer;
    protected boolean committed;
    protected boolean bodyOnly;
    protected WinstoneResponse owner;
    protected boolean disregardMode = false;
    protected boolean closed = false;
    protected Stack includeByteStreams;

    public WinstoneOutputStream(OutputStream out, boolean bodyOnlyForInclude) {
        this.outStream = new ClientOutputStream(out);
        this.bodyOnly = bodyOnlyForInclude;
        this.bufferSize = 8192;
        this.committed = false;
        this.buffer = new ByteArrayOutputStream();
    }

    public void setResponse(WinstoneResponse response) {
        this.owner = response;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (this.owner.isCommitted()) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneOutputStream.AlreadyCommitted"));
        }
        this.bufferSize = bufferSize;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public int getOutputStreamLength() {
        return this.bytesCommitted + this.bufferPosition;
    }

    public int getBytesCommitted() {
        return this.bytesCommitted;
    }

    public void setDisregardMode(boolean disregard) {
        this.disregardMode = disregard;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void write(int oneChar) throws IOException {
        if (this.disregardMode || this.closed) {
            return;
        }
        String contentLengthHeader = this.owner.getHeader("Content-Length");
        if (contentLengthHeader != null && this.bytesCommitted >= Integer.parseInt(contentLengthHeader)) {
            return;
        }
        this.buffer.write(oneChar);
        this.commit(contentLengthHeader, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.disregardMode || this.closed) {
            return;
        }
        String contentLengthHeader = this.owner.getHeader("Content-Length");
        if (contentLengthHeader != null && this.bytesCommitted + len > Integer.parseInt(contentLengthHeader)) {
            return;
        }
        this.buffer.write(b, off, len);
        this.commit(contentLengthHeader, len);
    }

    private void commit(String contentLengthHeader, int len) throws IOException {
        this.bufferPosition += len;
        if (this.bufferPosition >= this.bufferSize) {
            this.commit();
        } else if (contentLengthHeader != null && this.bufferPosition + this.bytesCommitted >= Integer.parseInt(contentLengthHeader)) {
            this.commit();
        }
    }

    public void commit() throws IOException {
        this.buffer.flush();
        if (!this.committed && !this.bodyOnly) {
            this.owner.validateHeaders();
            this.committed = true;
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WinstoneOutputStream.CommittingOutputStream");
            int statusCode = this.owner.getStatus();
            String reason = Launcher.RESOURCES.getString("WinstoneOutputStream.reasonPhrase." + statusCode);
            String statusLine = this.owner.getProtocol() + " " + statusCode + " " + (reason == null ? "No reason" : reason);
            BufferedOutputStream o = new BufferedOutputStream(this.outStream);
            ((OutputStream)o).write(statusLine.getBytes("8859_1"));
            ((OutputStream)o).write(CR_LF);
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneOutputStream.ResponseStatus", statusLine);
            for (String header : this.owner.getHeaders()) {
                ((OutputStream)o).write(header.getBytes("8859_1"));
                ((OutputStream)o).write(CR_LF);
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneOutputStream.Header", header);
            }
            if (!this.owner.getHeaders().isEmpty()) {
                for (Cookie cookie : this.owner.getCookies()) {
                    String cookieText = this.owner.writeCookie(cookie);
                    ((OutputStream)o).write(cookieText.getBytes("8859_1"));
                    ((OutputStream)o).write(CR_LF);
                    Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneOutputStream.Header", cookieText);
                }
            }
            ((OutputStream)o).write(CR_LF);
            ((OutputStream)o).flush();
        }
        byte[] content = this.buffer.toByteArray();
        int commitLength = content.length;
        String contentLengthHeader = this.owner.getHeader("Content-Length");
        if (contentLengthHeader != null) {
            commitLength = Math.min(Integer.parseInt(contentLengthHeader) - this.bytesCommitted, content.length);
        }
        if (commitLength > 0) {
            this.outStream.write(content, 0, commitLength);
        }
        this.outStream.flush();
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneOutputStream.CommittedBytes", "" + (this.bytesCommitted + commitLength));
        this.bytesCommitted += commitLength;
        this.buffer.reset();
        this.bufferPosition = 0;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException(Launcher.RESOURCES.getString("WinstoneOutputStream.AlreadyCommitted"));
        }
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneOutputStream.ResetBuffer", this.bufferPosition + "");
        this.buffer.reset();
        this.bufferPosition = 0;
        this.bytesCommitted = 0;
    }

    public void finishResponse() throws IOException {
        this.outStream.flush();
        this.outStream = null;
    }

    public void flush() throws IOException {
        if (this.disregardMode) {
            return;
        }
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneOutputStream.Flushing");
        this.buffer.flush();
        this.commit();
    }

    public void close() throws IOException {
        if (!(this.isCommitted() || this.disregardMode || this.closed || this.owner.getHeader("Content-Length") != null || this.owner == null || this.bodyOnly)) {
            this.owner.setContentLength(this.getOutputStreamLength());
        }
        this.flush();
    }

    public boolean isIncluding() {
        return this.includeByteStreams != null && !this.includeByteStreams.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIncludeBuffer() {
        ByteArrayOutputStream byteArrayOutputStream = this.buffer;
        synchronized (byteArrayOutputStream) {
            if (this.includeByteStreams == null) {
                this.includeByteStreams = new Stack();
            }
        }
        this.includeByteStreams.push(new ByteArrayOutputStream());
    }

    public void finishIncludeBuffer() throws IOException {
        if (this.isIncluding()) {
            byte[] bodyArr;
            ByteArrayOutputStream body = (ByteArrayOutputStream)this.includeByteStreams.pop();
            OutputStream topStream = this.outStream;
            if (!this.includeByteStreams.isEmpty()) {
                topStream = (OutputStream)this.includeByteStreams.peek();
            }
            if ((bodyArr = body.toByteArray()).length > 0) {
                topStream.write(bodyArr);
            }
            body.close();
        }
    }

    public void clearIncludeStackForForward() throws IOException {
        if (this.isIncluding()) {
            Iterator i = this.includeByteStreams.iterator();
            while (i.hasNext()) {
                ((ByteArrayOutputStream)i.next()).close();
            }
            this.includeByteStreams.clear();
        }
    }
}

