/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import winstone.AccessLogger;
import winstone.AuthenticationHandler;
import winstone.AuthenticationRealm;
import winstone.Cluster;
import winstone.FilterConfiguration;
import winstone.HostConfiguration;
import winstone.JNDIManager;
import winstone.Launcher;
import winstone.Logger;
import winstone.Mapping;
import winstone.ObjectPool;
import winstone.RequestDispatcher;
import winstone.ServletConfiguration;
import winstone.URIUtil;
import winstone.WinstoneException;
import winstone.WinstoneRequest;
import winstone.WinstoneResourceBundle;
import winstone.WinstoneResponse;
import winstone.WinstoneSession;

public class WebAppConfiguration
implements ServletContext,
Comparator {
    private static final String ELEM_DISPLAY_NAME = "display-name";
    private static final String ELEM_SERVLET = "servlet";
    private static final String ELEM_SERVLET_MAPPING = "servlet-mapping";
    private static final String ELEM_SERVLET_NAME = "servlet-name";
    private static final String ELEM_FILTER = "filter";
    private static final String ELEM_FILTER_MAPPING = "filter-mapping";
    private static final String ELEM_FILTER_NAME = "filter-name";
    private static final String ELEM_DISPATCHER = "dispatcher";
    private static final String ELEM_URL_PATTERN = "url-pattern";
    private static final String ELEM_WELCOME_FILES = "welcome-file-list";
    private static final String ELEM_WELCOME_FILE = "welcome-file";
    private static final String ELEM_SESSION_CONFIG = "session-config";
    private static final String ELEM_SESSION_TIMEOUT = "session-timeout";
    private static final String ELEM_MIME_MAPPING = "mime-mapping";
    private static final String ELEM_MIME_EXTENSION = "extension";
    private static final String ELEM_MIME_TYPE = "mime-type";
    private static final String ELEM_CONTEXT_PARAM = "context-param";
    private static final String ELEM_PARAM_NAME = "param-name";
    private static final String ELEM_PARAM_VALUE = "param-value";
    private static final String ELEM_LISTENER = "listener";
    private static final String ELEM_LISTENER_CLASS = "listener-class";
    private static final String ELEM_DISTRIBUTABLE = "distributable";
    private static final String ELEM_ERROR_PAGE = "error-page";
    private static final String ELEM_EXCEPTION_TYPE = "exception-type";
    private static final String ELEM_ERROR_CODE = "error-code";
    private static final String ELEM_ERROR_LOCATION = "location";
    private static final String ELEM_SECURITY_CONSTRAINT = "security-constraint";
    private static final String ELEM_LOGIN_CONFIG = "login-config";
    private static final String ELEM_SECURITY_ROLE = "security-role";
    private static final String ELEM_ROLE_NAME = "role-name";
    private static final String ELEM_ENV_ENTRY = "env-entry";
    private static final String ELEM_LOCALE_ENC_MAP_LIST = "locale-encoding-mapping-list";
    private static final String ELEM_LOCALE_ENC_MAPPING = "locale-encoding-mapping";
    private static final String ELEM_LOCALE = "locale";
    private static final String ELEM_ENCODING = "encoding";
    private static final String ELEM_JSP_CONFIG = "jsp-config";
    private static final String ELEM_JSP_PROPERTY_GROUP = "jsp-property-group";
    private static final String DISPATCHER_REQUEST = "REQUEST";
    private static final String DISPATCHER_FORWARD = "FORWARD";
    private static final String DISPATCHER_INCLUDE = "INCLUDE";
    private static final String DISPATCHER_ERROR = "ERROR";
    private static final String JSP_SERVLET_NAME = "JspServlet";
    private static final String JSP_SERVLET_MAPPING = "*.jsp";
    private static final String JSPX_SERVLET_MAPPING = "*.jspx";
    private static final String JSP_SERVLET_LOG_LEVEL = "WARNING";
    private static final String INVOKER_SERVLET_NAME = "invoker";
    private static final String INVOKER_SERVLET_CLASS = "winstone.invoker.InvokerServlet";
    private static final String DEFAULT_INVOKER_PREFIX = "/servlet/";
    private static final String DEFAULT_SERVLET_NAME = "default";
    private static final String DEFAULT_SERVLET_CLASS = "winstone.StaticResourceServlet";
    private static final String DEFAULT_REALM_CLASS = "winstone.realm.ArgumentsRealm";
    private static final String DEFAULT_JNDI_MGR_CLASS = "winstone.jndi.WebAppJNDIManager";
    private static final String RELOADING_CL_CLASS = "winstone.classLoader.ReloadingClassLoader";
    private static final String WEBAPP_CL_CLASS = "winstone.classLoader.WebappClassLoader";
    private static final String ERROR_SERVLET_NAME = "winstoneErrorServlet";
    private static final String ERROR_SERVLET_CLASS = "winstone.ErrorServlet";
    private static final String WEB_INF = "WEB-INF";
    private static final String CLASSES = "classes/";
    private static final String LIB = "lib";
    static final String JSP_SERVLET_CLASS = "org.apache.jasper.servlet.JspServlet";
    private HostConfiguration ownerHostConfig;
    private Cluster cluster;
    private String webRoot;
    private String prefix;
    private String contextName;
    private ClassLoader loader;
    private String displayName;
    private Map attributes;
    private Map initParameters;
    private Map sessions;
    private Map mimeTypes;
    private Map servletInstances;
    private Map filterInstances;
    private ServletContextAttributeListener[] contextAttributeListeners;
    private ServletContextListener[] contextListeners;
    private ServletRequestListener[] requestListeners;
    private ServletRequestAttributeListener[] requestAttributeListeners;
    private HttpSessionActivationListener[] sessionActivationListeners;
    private HttpSessionAttributeListener[] sessionAttributeListeners;
    private HttpSessionListener[] sessionListeners;
    private Throwable contextStartupError;
    private Map exactServletMatchMounts;
    private Mapping[] patternMatches;
    private Mapping[] filterPatternsRequest;
    private Mapping[] filterPatternsForward;
    private Mapping[] filterPatternsInclude;
    private Mapping[] filterPatternsError;
    private AuthenticationHandler authenticationHandler;
    private AuthenticationRealm authenticationRealm;
    private String[] welcomeFiles;
    private Integer sessionTimeout;
    private Class[] errorPagesByExceptionKeysSorted;
    private Map errorPagesByException;
    private Map errorPagesByCode;
    private Map localeEncodingMap;
    private String defaultServletName;
    private String errorServletName;
    private JNDIManager jndiManager;
    private AccessLogger accessLogger;
    private Map filterMatchCache;
    private boolean useSavedSessions;

    public static boolean booleanArg(Map args, String name, boolean defaultTrue) {
        String value = (String)args.get(name);
        if (defaultTrue) {
            return value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    public static String stringArg(Map args, String name, String defaultValue) {
        return args.get(name) == null ? defaultValue : args.get(name);
    }

    public static int intArg(Map args, String name, int defaultValue) {
        return Integer.parseInt(WebAppConfiguration.stringArg(args, name, "" + defaultValue));
    }

    public static String getTextFromNode(Node node) {
        if (node == null) {
            return null;
        }
        Node child = node.getFirstChild();
        if (child == null) {
            return "";
        }
        String textNode = child.getNodeValue();
        if (textNode == null) {
            return "";
        }
        return textNode.trim();
    }

    public static boolean useSavedSessions(Map args) {
        return WebAppConfiguration.booleanArg(args, "useSavedSessions", false);
    }

    public WebAppConfiguration(HostConfiguration ownerHostConfig, Cluster cluster, String webRoot, String prefix, ObjectPool objectPool, Map startupArgs, Node elm, ClassLoader parentClassLoader, File[] parentClassPaths, String contextName) {
        String loggerClassName;
        if (!prefix.equals("") && !prefix.startsWith("/")) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.AddingLeadingSlash", prefix);
            prefix = "/" + prefix;
        }
        this.ownerHostConfig = ownerHostConfig;
        this.webRoot = webRoot;
        this.prefix = prefix;
        this.contextName = contextName;
        ArrayList localLoaderClassPathFiles = new ArrayList();
        this.loader = this.buildWebAppClassLoader(startupArgs, parentClassLoader, webRoot, localLoaderClassPathFiles);
        boolean useJasper = WebAppConfiguration.booleanArg(startupArgs, "useJasper", true);
        boolean useInvoker = WebAppConfiguration.booleanArg(startupArgs, "useInvoker", false);
        boolean useJNDI = WebAppConfiguration.booleanArg(startupArgs, "useJNDI", false);
        this.useSavedSessions = WebAppConfiguration.useSavedSessions(startupArgs);
        if (useJasper) {
            try {
                Class.forName("javax.servlet.jsp.JspFactory", true, parentClassLoader);
                Class.forName(JSP_SERVLET_CLASS, true, this.loader);
            }
            catch (Throwable err) {
                if (WebAppConfiguration.booleanArg(startupArgs, "useJasper", false)) {
                    Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.JasperNotFound");
                    Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.JasperLoadException", err);
                }
                useJasper = false;
            }
        }
        if (useInvoker) {
            try {
                Class.forName(INVOKER_SERVLET_CLASS, false, this.loader);
            }
            catch (Throwable err) {
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.InvokerNotFound");
                useInvoker = false;
            }
        }
        this.attributes = new Hashtable();
        this.initParameters = new HashMap();
        this.sessions = new Hashtable();
        this.servletInstances = new HashMap();
        this.filterInstances = new HashMap();
        this.filterMatchCache = new HashMap();
        ArrayList contextAttributeListeners = new ArrayList();
        ArrayList contextListeners = new ArrayList();
        ArrayList requestListeners = new ArrayList();
        ArrayList requestAttributeListeners = new ArrayList();
        ArrayList sessionActivationListeners = new ArrayList();
        ArrayList sessionAttributeListeners = new ArrayList();
        ArrayList sessionListeners = new ArrayList();
        this.errorPagesByException = new HashMap();
        this.errorPagesByCode = new HashMap();
        boolean distributable = false;
        this.exactServletMatchMounts = new Hashtable();
        ArrayList localFolderPatterns = new ArrayList();
        ArrayList localExtensionPatterns = new ArrayList();
        ArrayList<Mapping> lfpRequest = new ArrayList<Mapping>();
        ArrayList<Mapping> lfpForward = new ArrayList<Mapping>();
        ArrayList<Mapping> lfpInclude = new ArrayList<Mapping>();
        ArrayList<Mapping> lfpError = new ArrayList<Mapping>();
        ArrayList<String> localWelcomeFiles = new ArrayList<String>();
        ArrayList<ServletConfiguration> startupServlets = new ArrayList<ServletConfiguration>();
        HashSet<String> rolesAllowed = new HashSet<String>();
        ArrayList<Node> constraintNodes = new ArrayList<Node>();
        ArrayList<Node> envEntryNodes = new ArrayList<Node>();
        ArrayList localErrorPagesByExceptionList = new ArrayList();
        Node loginConfigNode = null;
        this.addListenerInstance(this.loader, contextAttributeListeners, contextListeners, requestAttributeListeners, requestListeners, sessionActivationListeners, sessionAttributeListeners, sessionListeners);
        this.mimeTypes = new Hashtable();
        String[] typeList = new String[]{Launcher.RESOURCES.getString("WebAppConfig.DefaultMimeTypes"), WebAppConfiguration.stringArg(startupArgs, "mimeTypes", null)};
        for (int i = 0; i < typeList.length; ++i) {
            String allTypes = typeList[i];
            if (allTypes == null) continue;
            StringTokenizer mappingST = new StringTokenizer(allTypes, ":", false);
            while (mappingST.hasMoreTokens()) {
                String mapping = mappingST.nextToken();
                int delimPos = mapping.indexOf(61);
                if (delimPos == -1) continue;
                String extension = mapping.substring(0, delimPos);
                String mimeType = mapping.substring(delimPos + 1);
                this.mimeTypes.put(extension.toLowerCase(), mimeType);
            }
        }
        this.localeEncodingMap = new HashMap();
        String encodingMapSet = Launcher.RESOURCES.getString("WebAppConfig.EncodingMap");
        StringTokenizer st = new StringTokenizer(encodingMapSet, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int delimPos = token.indexOf("=");
            if (delimPos == -1) continue;
            this.localeEncodingMap.put(token.substring(0, delimPos), token.substring(delimPos + 1));
        }
        ArrayList<String> jspMappings = new ArrayList<String>();
        jspMappings.add(JSP_SERVLET_MAPPING);
        jspMappings.add(JSPX_SERVLET_MAPPING);
        File tmpDir = new File(new File(new File(System.getProperty("java.io.tmpdir"), "winstone.tmp"), ownerHostConfig.getHostname()), contextName);
        tmpDir.mkdirs();
        this.attributes.put("javax.servlet.context.tempdir", tmpDir);
        if (elm != null) {
            NodeList children = elm.getChildNodes();
            for (int n = 0; n < children.getLength(); ++n) {
                Node child = children.item(n);
                if (child.getNodeType() != 1) continue;
                String nodeName = child.getNodeName();
                if (nodeName.equals(ELEM_DISPLAY_NAME)) {
                    this.displayName = WebAppConfiguration.getTextFromNode(child);
                    continue;
                }
                if (nodeName.equals(ELEM_DISTRIBUTABLE)) {
                    distributable = true;
                    continue;
                }
                if (nodeName.equals(ELEM_SECURITY_CONSTRAINT)) {
                    constraintNodes.add(child);
                    continue;
                }
                if (nodeName.equals(ELEM_ENV_ENTRY)) {
                    envEntryNodes.add(child);
                    continue;
                }
                if (nodeName.equals(ELEM_LOGIN_CONFIG)) {
                    loginConfigNode = child;
                    continue;
                }
                if (nodeName.equals(ELEM_SESSION_CONFIG)) {
                    for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                        String timeoutStr;
                        Node timeoutElm = child.getChildNodes().item(m);
                        if (timeoutElm.getNodeType() != 1 || !timeoutElm.getNodeName().equals(ELEM_SESSION_TIMEOUT) || (timeoutStr = WebAppConfiguration.getTextFromNode(timeoutElm)).equals("")) continue;
                        this.sessionTimeout = Integer.valueOf(timeoutStr);
                    }
                    continue;
                }
                if (child.getNodeName().equals(ELEM_SECURITY_ROLE)) {
                    for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                        Node roleElm = child.getChildNodes().item(m);
                        if (roleElm.getNodeType() != 1 || !roleElm.getNodeName().equals(ELEM_ROLE_NAME)) continue;
                        rolesAllowed.add(WebAppConfiguration.getTextFromNode(roleElm));
                    }
                    continue;
                }
                if (nodeName.equals(ELEM_SERVLET)) {
                    ServletConfiguration instance = new ServletConfiguration(this, child);
                    this.servletInstances.put(instance.getServletName(), instance);
                    if (instance.getLoadOnStartup() < 0) continue;
                    startupServlets.add(instance);
                    continue;
                }
                if (nodeName.equals(ELEM_FILTER)) {
                    FilterConfiguration instance = new FilterConfiguration(this, this.loader, child);
                    this.filterInstances.put(instance.getFilterName(), instance);
                    continue;
                }
                if (nodeName.equals(ELEM_LISTENER)) {
                    String listenerClass = null;
                    for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                        Node listenerElm = child.getChildNodes().item(m);
                        if (listenerElm.getNodeType() != 1 || !listenerElm.getNodeName().equals(ELEM_LISTENER_CLASS)) continue;
                        listenerClass = WebAppConfiguration.getTextFromNode(listenerElm);
                    }
                    if (listenerClass == null) continue;
                    try {
                        Class<?> listener = Class.forName(listenerClass, true, this.loader);
                        Object listenerInstance = listener.newInstance();
                        this.addListenerInstance(listenerInstance, contextAttributeListeners, contextListeners, requestAttributeListeners, requestListeners, sessionActivationListeners, sessionAttributeListeners, sessionListeners);
                        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.AddListener", listenerClass);
                    }
                    catch (Throwable err) {
                        Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.InvalidListener", listenerClass);
                    }
                    continue;
                }
                if (nodeName.equals(ELEM_SERVLET_MAPPING)) {
                    String name = null;
                    ArrayList<String> mappings = new ArrayList<String>();
                    NodeList mappingChildren = child.getChildNodes();
                    for (int k = 0; k < mappingChildren.getLength(); ++k) {
                        Node mapChild = mappingChildren.item(k);
                        if (mapChild.getNodeType() != 1) continue;
                        String mapNodeName = mapChild.getNodeName();
                        if (mapNodeName.equals(ELEM_SERVLET_NAME)) {
                            name = WebAppConfiguration.getTextFromNode(mapChild);
                            continue;
                        }
                        if (!mapNodeName.equals(ELEM_URL_PATTERN)) continue;
                        mappings.add(WebAppConfiguration.getTextFromNode(mapChild));
                    }
                    Iterator i = mappings.iterator();
                    while (i.hasNext()) {
                        this.processMapping(name, (String)i.next(), this.exactServletMatchMounts, localFolderPatterns, localExtensionPatterns);
                    }
                    continue;
                }
                if (nodeName.equals(ELEM_FILTER_MAPPING)) {
                    String filterName = null;
                    ArrayList<String> mappings = new ArrayList<String>();
                    boolean onRequest = false;
                    boolean onForward = false;
                    boolean onInclude = false;
                    boolean onError = false;
                    for (int k = 0; k < child.getChildNodes().getLength(); ++k) {
                        Node mapChild = child.getChildNodes().item(k);
                        if (mapChild.getNodeType() != 1) continue;
                        String mapNodeName = mapChild.getNodeName();
                        if (mapNodeName.equals(ELEM_FILTER_NAME)) {
                            filterName = WebAppConfiguration.getTextFromNode(mapChild);
                            continue;
                        }
                        if (mapNodeName.equals(ELEM_SERVLET_NAME)) {
                            mappings.add("srv:" + WebAppConfiguration.getTextFromNode(mapChild));
                            continue;
                        }
                        if (mapNodeName.equals(ELEM_URL_PATTERN)) {
                            mappings.add("url:" + WebAppConfiguration.getTextFromNode(mapChild));
                            continue;
                        }
                        if (!mapNodeName.equals(ELEM_DISPATCHER)) continue;
                        String dispatcherValue = WebAppConfiguration.getTextFromNode(mapChild);
                        if (dispatcherValue.equals(DISPATCHER_REQUEST)) {
                            onRequest = true;
                            continue;
                        }
                        if (dispatcherValue.equals(DISPATCHER_FORWARD)) {
                            onForward = true;
                            continue;
                        }
                        if (dispatcherValue.equals(DISPATCHER_INCLUDE)) {
                            onInclude = true;
                            continue;
                        }
                        if (!dispatcherValue.equals(DISPATCHER_ERROR)) continue;
                        onError = true;
                    }
                    if (!(onRequest || onInclude || onForward || onError)) {
                        onRequest = true;
                    }
                    if (mappings.isEmpty()) {
                        throw new WinstoneException(Launcher.RESOURCES.getString("WebAppConfig.BadFilterMapping", filterName));
                    }
                    for (String item : mappings) {
                        Mapping mapping = null;
                        try {
                            mapping = item.startsWith("srv:") ? Mapping.createFromLink(filterName, item.substring(4)) : Mapping.createFromURL(filterName, item.substring(4));
                            if (onRequest) {
                                lfpRequest.add(mapping);
                            }
                            if (onForward) {
                                lfpForward.add(mapping);
                            }
                            if (onInclude) {
                                lfpInclude.add(mapping);
                            }
                            if (!onError) continue;
                            lfpError.add(mapping);
                        }
                        catch (WinstoneException err) {
                            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.ErrorMapURL", err.getMessage());
                        }
                    }
                    continue;
                }
                if (nodeName.equals(ELEM_WELCOME_FILES)) {
                    for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                        String welcomeStr;
                        Node welcomeFile = child.getChildNodes().item(m);
                        if (welcomeFile.getNodeType() != 1 || !welcomeFile.getNodeName().equals(ELEM_WELCOME_FILE) || (welcomeStr = WebAppConfiguration.getTextFromNode(welcomeFile)).equals("")) continue;
                        localWelcomeFiles.add(welcomeStr);
                    }
                    continue;
                }
                if (nodeName.equals(ELEM_ERROR_PAGE)) {
                    String code = null;
                    String exception = null;
                    String location = null;
                    for (int k = 0; k < child.getChildNodes().getLength(); ++k) {
                        Node errorChild = child.getChildNodes().item(k);
                        if (errorChild.getNodeType() != 1) continue;
                        String errorChildName = errorChild.getNodeName();
                        if (errorChildName.equals(ELEM_ERROR_CODE)) {
                            code = WebAppConfiguration.getTextFromNode(errorChild);
                            continue;
                        }
                        if (errorChildName.equals(ELEM_EXCEPTION_TYPE)) {
                            exception = WebAppConfiguration.getTextFromNode(errorChild);
                            continue;
                        }
                        if (!errorChildName.equals(ELEM_ERROR_LOCATION)) continue;
                        location = WebAppConfiguration.getTextFromNode(errorChild);
                    }
                    if (code != null && location != null) {
                        this.errorPagesByCode.put(code.trim(), location.trim());
                    }
                    if (exception == null || location == null) continue;
                    try {
                        Class<?> exceptionClass = Class.forName(exception.trim(), false, this.loader);
                        localErrorPagesByExceptionList.add(exceptionClass);
                        this.errorPagesByException.put(exceptionClass, location.trim());
                    }
                    catch (ClassNotFoundException err) {
                        Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.ExceptionNotFound", exception);
                    }
                    continue;
                }
                if (nodeName.equals(ELEM_MIME_MAPPING)) {
                    String extension = null;
                    String mimeType = null;
                    for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                        Node mimeTypeNode = child.getChildNodes().item(m);
                        if (mimeTypeNode.getNodeType() != 1) continue;
                        if (mimeTypeNode.getNodeName().equals(ELEM_MIME_EXTENSION)) {
                            extension = WebAppConfiguration.getTextFromNode(mimeTypeNode);
                            continue;
                        }
                        if (!mimeTypeNode.getNodeName().equals(ELEM_MIME_TYPE)) continue;
                        mimeType = WebAppConfiguration.getTextFromNode(mimeTypeNode);
                    }
                    if (extension != null && mimeType != null) {
                        this.mimeTypes.put(extension.toLowerCase(), mimeType);
                        continue;
                    }
                    Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.InvalidMimeMapping", new String[]{extension, mimeType});
                    continue;
                }
                if (nodeName.equals(ELEM_CONTEXT_PARAM)) {
                    String name = null;
                    String value = null;
                    for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                        Node contextParamNode = child.getChildNodes().item(m);
                        if (contextParamNode.getNodeType() != 1) continue;
                        if (contextParamNode.getNodeName().equals(ELEM_PARAM_NAME)) {
                            name = WebAppConfiguration.getTextFromNode(contextParamNode);
                            continue;
                        }
                        if (!contextParamNode.getNodeName().equals(ELEM_PARAM_VALUE)) continue;
                        value = WebAppConfiguration.getTextFromNode(contextParamNode);
                    }
                    if (name != null && value != null) {
                        this.initParameters.put(name, value);
                        continue;
                    }
                    Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.InvalidInitParam", new String[]{name, value});
                    continue;
                }
                if (nodeName.equals(ELEM_LOCALE_ENC_MAP_LIST)) {
                    for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                        Node mappingNode = child.getChildNodes().item(m);
                        if (mappingNode.getNodeType() != 1 || !mappingNode.getNodeName().equals(ELEM_LOCALE_ENC_MAPPING)) continue;
                        String localeName = "";
                        String encoding = "";
                        for (int l = 0; l < mappingNode.getChildNodes().getLength(); ++l) {
                            Node mappingChildNode = mappingNode.getChildNodes().item(l);
                            if (mappingChildNode.getNodeType() != 1) continue;
                            if (mappingChildNode.getNodeName().equals(ELEM_LOCALE)) {
                                localeName = WebAppConfiguration.getTextFromNode(mappingChildNode);
                                continue;
                            }
                            if (!mappingChildNode.getNodeName().equals(ELEM_ENCODING)) continue;
                            encoding = WebAppConfiguration.getTextFromNode(mappingChildNode);
                        }
                        if (encoding.equals("") || localeName.equals("")) continue;
                        this.localeEncodingMap.put(localeName, encoding);
                    }
                    continue;
                }
                if (!nodeName.equals(ELEM_JSP_CONFIG)) continue;
                for (int m = 0; m < child.getChildNodes().getLength(); ++m) {
                    Node propertyGroupNode = child.getChildNodes().item(m);
                    if (propertyGroupNode.getNodeType() != 1 || !propertyGroupNode.getNodeName().equals(ELEM_JSP_PROPERTY_GROUP)) continue;
                    for (int l = 0; l < propertyGroupNode.getChildNodes().getLength(); ++l) {
                        String jm;
                        Node urlPatternNode = propertyGroupNode.getChildNodes().item(l);
                        if (urlPatternNode.getNodeType() != 1 || !urlPatternNode.getNodeName().equals(ELEM_URL_PATTERN) || (jm = WebAppConfiguration.getTextFromNode(urlPatternNode)).equals("")) continue;
                        jspMappings.add(jm);
                    }
                }
            }
        }
        if (!distributable && cluster != null) {
            Logger.log(Logger.INFO, Launcher.RESOURCES, "WebAppConfig.ClusterOffNotDistributable", this.contextName);
        } else {
            this.cluster = cluster;
        }
        if (!constraintNodes.isEmpty() && loginConfigNode != null) {
            String authMethod = null;
            for (int n = 0; n < loginConfigNode.getChildNodes().getLength(); ++n) {
                if (!loginConfigNode.getChildNodes().item(n).getNodeName().equals("auth-method")) continue;
                authMethod = WebAppConfiguration.getTextFromNode(loginConfigNode.getChildNodes().item(n));
            }
            authMethod = authMethod == null ? "BASIC" : WinstoneResourceBundle.globalReplace(authMethod, "-", "");
            String realmClassName = WebAppConfiguration.stringArg(startupArgs, "realmClassName", DEFAULT_REALM_CLASS).trim();
            String authClassName = "winstone.auth." + authMethod.substring(0, 1).toUpperCase() + authMethod.substring(1).toLowerCase() + "AuthenticationHandler";
            try {
                Class<?> realmClass = Class.forName(realmClassName, true, parentClassLoader);
                Constructor<?> realmConstr = realmClass.getConstructor(Set.class, Map.class);
                this.authenticationRealm = (AuthenticationRealm)realmConstr.newInstance(rolesAllowed, startupArgs);
                Class<?> authClass = Class.forName(authClassName);
                Constructor<?> authConstr = authClass.getConstructor(Node.class, List.class, Set.class, AuthenticationRealm.class);
                this.authenticationHandler = (AuthenticationHandler)authConstr.newInstance(loginConfigNode, constraintNodes, rolesAllowed, this.authenticationRealm);
            }
            catch (ClassNotFoundException err) {
                Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.AuthDisabled", authMethod);
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.AuthError", new String[]{authClassName, realmClassName}, err);
            }
        } else if (!WebAppConfiguration.stringArg(startupArgs, "realmClassName", "").trim().equals("")) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.NoWebXMLSecurityDefs");
        }
        String jndiMgrClassName = WebAppConfiguration.stringArg(startupArgs, "webappJndiClassName", DEFAULT_JNDI_MGR_CLASS).trim();
        if (useJNDI) {
            try {
                Class<?> jndiMgrClass = Class.forName(jndiMgrClassName, true, parentClassLoader);
                Constructor<?> jndiMgrConstr = jndiMgrClass.getConstructor(Map.class, List.class, ClassLoader.class);
                this.jndiManager = (JNDIManager)jndiMgrConstr.newInstance(null, envEntryNodes, this.loader);
                if (this.jndiManager != null) {
                    this.jndiManager.setup();
                }
            }
            catch (ClassNotFoundException err) {
                Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.JNDIDisabled");
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.JNDIError", jndiMgrClassName, err);
            }
        }
        if (!(loggerClassName = WebAppConfiguration.stringArg(startupArgs, "accessLoggerClassName", "").trim()).equals("")) {
            try {
                Class<?> loggerClass = Class.forName(loggerClassName, true, parentClassLoader);
                Constructor<?> loggerConstr = loggerClass.getConstructor(WebAppConfiguration.class, Map.class);
                this.accessLogger = (AccessLogger)loggerConstr.newInstance(this, startupArgs);
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.LoggerError", loggerClassName, err);
            }
        } else {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.LoggerDisabled");
        }
        if (localWelcomeFiles.isEmpty()) {
            if (useJasper) {
                localWelcomeFiles.add("index.jsp");
            }
            localWelcomeFiles.add("index.html");
        }
        this.filterPatternsRequest = lfpRequest.toArray(new Mapping[0]);
        this.filterPatternsForward = lfpForward.toArray(new Mapping[0]);
        this.filterPatternsInclude = lfpInclude.toArray(new Mapping[0]);
        this.filterPatternsError = lfpError.toArray(new Mapping[0]);
        if (this.filterPatternsRequest.length > 0) {
            Arrays.sort(this.filterPatternsRequest, this.filterPatternsRequest[0]);
        }
        if (this.filterPatternsForward.length > 0) {
            Arrays.sort(this.filterPatternsForward, this.filterPatternsForward[0]);
        }
        if (this.filterPatternsInclude.length > 0) {
            Arrays.sort(this.filterPatternsInclude, this.filterPatternsInclude[0]);
        }
        if (this.filterPatternsError.length > 0) {
            Arrays.sort(this.filterPatternsError, this.filterPatternsError[0]);
        }
        this.welcomeFiles = localWelcomeFiles.toArray(new String[0]);
        this.errorPagesByExceptionKeysSorted = localErrorPagesByExceptionList.toArray(new Class[0]);
        Arrays.sort(this.errorPagesByExceptionKeysSorted, this);
        this.contextAttributeListeners = contextAttributeListeners.toArray(new ServletContextAttributeListener[0]);
        this.contextListeners = contextListeners.toArray(new ServletContextListener[0]);
        this.requestListeners = requestListeners.toArray(new ServletRequestListener[0]);
        this.requestAttributeListeners = requestAttributeListeners.toArray(new ServletRequestAttributeListener[0]);
        this.sessionActivationListeners = sessionActivationListeners.toArray(new HttpSessionActivationListener[0]);
        this.sessionAttributeListeners = sessionAttributeListeners.toArray(new HttpSessionAttributeListener[0]);
        this.sessionListeners = sessionListeners.toArray(new HttpSessionListener[0]);
        if (this.defaultServletName == null) {
            this.defaultServletName = DEFAULT_SERVLET_NAME;
        }
        if (this.errorServletName == null) {
            this.errorServletName = ERROR_SERVLET_NAME;
        }
        if (this.servletInstances.get(this.defaultServletName) == null) {
            boolean useDirLists = WebAppConfiguration.booleanArg(startupArgs, "directoryListings", true);
            Hashtable<String, String> staticParams = new Hashtable<String, String>();
            staticParams.put("webRoot", webRoot);
            staticParams.put("prefix", this.prefix);
            staticParams.put("directoryList", "" + useDirLists);
            ServletConfiguration defaultServlet = new ServletConfiguration(this, this.defaultServletName, DEFAULT_SERVLET_CLASS, staticParams, 0);
            this.servletInstances.put(this.defaultServletName, defaultServlet);
            startupServlets.add(defaultServlet);
        }
        if (this.servletInstances.get(this.errorServletName) == null) {
            ServletConfiguration errorServlet = new ServletConfiguration(this, this.errorServletName, ERROR_SERVLET_CLASS, new HashMap(), 0);
            this.servletInstances.put(this.errorServletName, errorServlet);
            startupServlets.add(errorServlet);
        }
        if (useJasper) {
            this.setAttribute("org.apache.catalina.classloader", this.loader);
            try {
                StringBuffer cp = new StringBuffer();
                Iterator i = localLoaderClassPathFiles.iterator();
                while (i.hasNext()) {
                    cp.append(((File)i.next()).getCanonicalPath()).append(File.pathSeparatorChar);
                }
                for (int n = 0; n < parentClassPaths.length; ++n) {
                    cp.append(parentClassPaths[n].getCanonicalPath()).append(File.pathSeparatorChar);
                }
                this.setAttribute("org.apache.catalina.jsp_classpath", cp.length() > 0 ? cp.substring(0, cp.length() - 1) : "");
            }
            catch (IOException err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.ErrorSettingJSPPaths", err);
            }
            HashMap jspParams = new HashMap();
            WebAppConfiguration.addJspServletParams(jspParams);
            ServletConfiguration sc = new ServletConfiguration(this, JSP_SERVLET_NAME, JSP_SERVLET_CLASS, jspParams, 3);
            this.servletInstances.put(JSP_SERVLET_NAME, sc);
            startupServlets.add(sc);
            Iterator mapIt = jspMappings.iterator();
            while (mapIt.hasNext()) {
                this.processMapping(JSP_SERVLET_NAME, (String)mapIt.next(), this.exactServletMatchMounts, localFolderPatterns, localExtensionPatterns);
            }
        }
        if (useInvoker) {
            String invokerPrefix = WebAppConfiguration.stringArg(startupArgs, "invokerPrefix", DEFAULT_INVOKER_PREFIX);
            HashMap<String, String> invokerParams = new HashMap<String, String>();
            invokerParams.put("prefix", this.prefix);
            invokerParams.put("invokerPrefix", invokerPrefix);
            ServletConfiguration sc = new ServletConfiguration(this, INVOKER_SERVLET_NAME, INVOKER_SERVLET_CLASS, invokerParams, 3);
            this.servletInstances.put(INVOKER_SERVLET_NAME, sc);
            this.processMapping(INVOKER_SERVLET_NAME, invokerPrefix + "*", this.exactServletMatchMounts, localFolderPatterns, localExtensionPatterns);
        }
        localFolderPatterns.addAll(localExtensionPatterns);
        this.patternMatches = localFolderPatterns.toArray(new Mapping[0]);
        if (this.patternMatches.length > 0) {
            Arrays.sort(this.patternMatches, this.patternMatches[0]);
        }
        try {
            for (int n = 0; n < this.contextListeners.length; ++n) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.loader);
                this.contextListeners[n].contextInitialized(new ServletContextEvent(this));
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.ContextStartupError", this.contextName, err);
            this.contextStartupError = err;
        }
        if (this.contextStartupError == null) {
            if (this.useSavedSessions) {
                WinstoneSession.loadSessions(this);
            }
            for (FilterConfiguration config : this.filterInstances.values()) {
                try {
                    config.getFilter();
                }
                catch (ServletException err) {
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.FilterStartupError", config.getFilterName(), (Throwable)err);
                }
            }
            Object[] autoStarters = startupServlets.toArray();
            Arrays.sort(autoStarters);
            for (int n = 0; n < autoStarters.length; ++n) {
                ((ServletConfiguration)autoStarters[n]).ensureInitialization();
            }
        }
    }

    private ClassLoader buildWebAppClassLoader(Map startupArgs, ClassLoader parentClassLoader, String webRoot, List classPathFileList) {
        Object outputCL;
        URL[] jarURLs;
        block13: {
            ArrayList<URL> urlList = new ArrayList<URL>();
            try {
                File webInfFolder = new File(webRoot, WEB_INF);
                File classesFolder = new File(webInfFolder, CLASSES);
                if (classesFolder.exists()) {
                    Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.WebAppClasses");
                    String classesFolderURL = classesFolder.getCanonicalFile().toURL().toString();
                    urlList.add(new URL(classesFolderURL.endsWith("/") ? classesFolderURL : classesFolderURL + "/"));
                    classPathFileList.add(classesFolder);
                } else {
                    Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.NoWebAppClasses", classesFolder.toString());
                }
                File libFolder = new File(webInfFolder, LIB);
                if (libFolder.exists()) {
                    File[] jars = libFolder.listFiles();
                    for (int n = 0; n < jars.length; ++n) {
                        String jarName = jars[n].getName().toLowerCase();
                        if (!jarName.endsWith(".jar") && !jarName.endsWith(".zip")) continue;
                        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.WebAppLib", jars[n].getName());
                        urlList.add(jars[n].toURL());
                        classPathFileList.add(jars[n]);
                    }
                } else {
                    Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.NoWebAppLib", libFolder.toString());
                }
            }
            catch (MalformedURLException err) {
                throw new WinstoneException(Launcher.RESOURCES.getString("WebAppConfig.BadURL"), err);
            }
            catch (IOException err) {
                throw new WinstoneException(Launcher.RESOURCES.getString("WebAppConfig.IOException"), err);
            }
            jarURLs = urlList.toArray(new URL[urlList.size()]);
            String preferredClassLoader = WebAppConfiguration.stringArg(startupArgs, "preferredClassLoader", WEBAPP_CL_CLASS);
            if (WebAppConfiguration.booleanArg(startupArgs, "useServletReloading", false) && WebAppConfiguration.stringArg(startupArgs, "preferredClassLoader", "").equals("")) {
                preferredClassLoader = RELOADING_CL_CLASS;
            }
            outputCL = null;
            if (!preferredClassLoader.equals("")) {
                try {
                    Class<?> preferredCL = Class.forName(preferredClassLoader, true, parentClassLoader);
                    Constructor<?> reloadConstr = preferredCL.getConstructor(URL[].class, ClassLoader.class);
                    outputCL = (ClassLoader)reloadConstr.newInstance(jarURLs, parentClassLoader);
                }
                catch (Throwable err) {
                    if (WebAppConfiguration.stringArg(startupArgs, "preferredClassLoader", "").equals("") && preferredClassLoader.equals(WEBAPP_CL_CLASS)) break block13;
                    Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.CLError", err);
                }
            }
        }
        if (outputCL == null) {
            outputCL = new URLClassLoader(jarURLs, parentClassLoader);
        }
        Logger.log(Logger.MAX, Launcher.RESOURCES, "WebAppConfig.WebInfClassLoader", outputCL.toString());
        return outputCL;
    }

    private void addListenerInstance(Object listenerInstance, List contextAttributeListeners, List contextListeners, List requestAttributeListeners, List requestListeners, List sessionActivationListeners, List sessionAttributeListeners, List sessionListeners) {
        if (listenerInstance instanceof ServletContextAttributeListener) {
            contextAttributeListeners.add(listenerInstance);
        }
        if (listenerInstance instanceof ServletContextListener) {
            contextListeners.add(listenerInstance);
        }
        if (listenerInstance instanceof ServletRequestAttributeListener) {
            requestAttributeListeners.add(listenerInstance);
        }
        if (listenerInstance instanceof ServletRequestListener) {
            requestListeners.add(listenerInstance);
        }
        if (listenerInstance instanceof HttpSessionActivationListener) {
            sessionActivationListeners.add(listenerInstance);
        }
        if (listenerInstance instanceof HttpSessionAttributeListener) {
            sessionAttributeListeners.add(listenerInstance);
        }
        if (listenerInstance instanceof HttpSessionListener) {
            sessionListeners.add(listenerInstance);
        }
    }

    public String getContextPath() {
        return this.prefix;
    }

    public String getWebroot() {
        return this.webRoot;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public AccessLogger getAccessLogger() {
        return this.accessLogger;
    }

    public Map getFilters() {
        return this.filterInstances;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Class[] getErrorPageExceptions() {
        return this.errorPagesByExceptionKeysSorted;
    }

    public Map getErrorPagesByException() {
        return this.errorPagesByException;
    }

    public Map getErrorPagesByCode() {
        return this.errorPagesByCode;
    }

    public Map getLocaleEncodingMap() {
        return this.localeEncodingMap;
    }

    public String[] getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public boolean isDistributable() {
        return this.cluster != null;
    }

    public Map getFilterMatchCache() {
        return this.filterMatchCache;
    }

    public String getOwnerHostname() {
        return this.ownerHostConfig.getHostname();
    }

    public ServletRequestListener[] getRequestListeners() {
        return this.requestListeners;
    }

    public ServletRequestAttributeListener[] getRequestAttributeListeners() {
        return this.requestAttributeListeners;
    }

    public static void addJspServletParams(Map jspParams) {
        jspParams.put("logVerbosityLevel", JSP_SERVLET_LOG_LEVEL);
        jspParams.put("fork", "false");
    }

    public int compare(Object one, Object two) {
        if (!(one instanceof Class) || !(two instanceof Class)) {
            throw new IllegalArgumentException("This comparator is only for sorting classes");
        }
        Class classOne = (Class)one;
        Class classTwo = (Class)two;
        if (classOne.isAssignableFrom(classTwo)) {
            return 1;
        }
        if (classTwo.isAssignableFrom(classOne)) {
            return -1;
        }
        return 0;
    }

    public String getServletURIFromRequestURI(String requestURI) {
        if (this.prefix.equals("")) {
            return requestURI;
        }
        if (requestURI.startsWith(this.prefix)) {
            return requestURI.substring(this.prefix.length());
        }
        throw new WinstoneException("This shouldn't happen, since we aborted earlier if we didn't match");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map map = this.filterMatchCache;
        synchronized (map) {
            this.filterMatchCache.clear();
        }
        ArrayList filterInstances = new ArrayList(this.filterInstances.values());
        Iterator i = filterInstances.iterator();
        while (i.hasNext()) {
            try {
                ((FilterConfiguration)i.next()).destroy();
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.ShutdownError", err);
            }
        }
        this.filterInstances.clear();
        ArrayList servletInstances = new ArrayList(this.servletInstances.values());
        Iterator i2 = servletInstances.iterator();
        while (i2.hasNext()) {
            try {
                ((ServletConfiguration)i2.next()).destroy();
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.ShutdownError", err);
            }
        }
        this.servletInstances.clear();
        ArrayList sessions = new ArrayList(this.sessions.values());
        for (WinstoneSession session : sessions) {
            try {
                if (this.useSavedSessions) {
                    session.saveToTemp();
                    continue;
                }
                session.invalidate();
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.ShutdownError", err);
            }
        }
        this.sessions.clear();
        for (int n = this.contextListeners.length - 1; n >= 0; --n) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.loader);
                this.contextListeners[n].contextDestroyed(new ServletContextEvent(this));
                this.contextListeners[n] = null;
                Thread.currentThread().setContextClassLoader(cl);
                continue;
            }
            catch (Throwable err) {
                Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.ShutdownError", err);
            }
        }
        this.contextListeners = null;
        if (this.loader != null) {
            this.loader = null;
        }
        if (this.jndiManager != null) {
            this.jndiManager.tearDown();
            this.jndiManager = null;
        }
        if (this.accessLogger != null) {
            this.accessLogger.destroy();
            this.accessLogger = null;
        }
    }

    public void resetClassLoader() throws IOException {
        this.ownerHostConfig.reloadWebApp(this.getContextPath());
    }

    private void processMapping(String name, String pattern, Map exactPatterns, List folderPatterns, List extensionPatterns) {
        Mapping urlPattern = null;
        try {
            urlPattern = Mapping.createFromURL(name, pattern);
        }
        catch (WinstoneException err) {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.ErrorMapURL", err.getMessage());
            return;
        }
        if (urlPattern.getPatternType() == 1) {
            exactPatterns.put(urlPattern.getUrlPattern(), name);
        } else if (urlPattern.getPatternType() == 2) {
            folderPatterns.add(urlPattern);
        } else if (urlPattern.getPatternType() == 3) {
            extensionPatterns.add(urlPattern);
        } else if (urlPattern.getPatternType() == 4) {
            this.defaultServletName = name;
        } else {
            Logger.log(Logger.WARNING, Launcher.RESOURCES, "WebAppConfig.InvalidMount", new String[]{name, pattern});
        }
    }

    private ServletConfiguration urlMatch(String path, StringBuffer servletPath, StringBuffer pathInfo) {
        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WebAppConfig.URLMatch", path);
        String exact = (String)this.exactServletMatchMounts.get(path);
        if (exact != null && this.servletInstances.get(exact) != null) {
            servletPath.append(WinstoneRequest.decodeURLToken(path, false));
            return (ServletConfiguration)this.servletInstances.get(exact);
        }
        for (int n = 0; n < this.patternMatches.length; ++n) {
            Mapping urlPattern = this.patternMatches[n];
            if (!urlPattern.match(path, servletPath, pathInfo) || this.servletInstances.get(urlPattern.getMappedTo()) == null) continue;
            return (ServletConfiguration)this.servletInstances.get(urlPattern.getMappedTo());
        }
        if (this.servletInstances.get(this.defaultServletName) == null) {
            throw new WinstoneException(Launcher.RESOURCES.getString("WebAppConfig.MatchedNonExistServlet", this.defaultServletName));
        }
        servletPath.append(WinstoneRequest.decodeURLToken(path, false));
        return (ServletConfiguration)this.servletInstances.get(this.defaultServletName);
    }

    public WinstoneSession makeNewSession(String sessionId) {
        WinstoneSession ws = new WinstoneSession(sessionId);
        ws.setWebAppConfiguration(this);
        this.setSessionListeners(ws);
        if (this.sessionTimeout == null) {
            ws.setMaxInactiveInterval(3600);
        } else if (this.sessionTimeout > 0) {
            ws.setMaxInactiveInterval(this.sessionTimeout * 60);
        } else {
            ws.setMaxInactiveInterval(-1);
        }
        ws.setLastAccessedDate(System.currentTimeMillis());
        ws.sendCreatedNotifies();
        this.sessions.put(sessionId, ws);
        return ws;
    }

    public WinstoneSession getSessionById(String sessionId, boolean localOnly) {
        if (sessionId == null) {
            return null;
        }
        WinstoneSession session = (WinstoneSession)this.sessions.get(sessionId);
        if (session != null) {
            return session;
        }
        if (this.cluster != null && !localOnly) {
            session = this.cluster.askClusterForSession(sessionId, this);
            if (session != null) {
                this.sessions.put(sessionId, session);
            }
            return session;
        }
        return null;
    }

    void removeSessionById(String sessionId) {
        this.sessions.remove(sessionId);
    }

    void addSession(String sessionId, WinstoneSession session) {
        this.sessions.put(sessionId, session);
    }

    public void invalidateExpiredSessions() {
        Object[] allSessions = this.sessions.values().toArray();
        int expiredCount = 0;
        for (int n = 0; n < allSessions.length; ++n) {
            WinstoneSession session = (WinstoneSession)allSessions[n];
            if (!session.isUnusedByRequests() || !session.isExpired()) continue;
            session.invalidate();
            ++expiredCount;
        }
        if (expiredCount > 0) {
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "WebAppConfig.InvalidatedSessions", expiredCount + "");
        }
    }

    public void setSessionListeners(WinstoneSession session) {
        session.setSessionActivationListeners(this.sessionActivationListeners);
        session.setSessionAttributeListeners(this.sessionAttributeListeners);
        session.setSessionListeners(this.sessionListeners);
    }

    public void removeServletConfigurationAndMappings(ServletConfiguration config) {
        this.servletInstances.remove(config.getServletName());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void removeAttribute(String name) {
        Object me = this.attributes.get(name);
        this.attributes.remove(name);
        if (me != null) {
            for (int n = 0; n < this.contextAttributeListeners.length; ++n) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getLoader());
                this.contextAttributeListeners[n].attributeRemoved(new ServletContextAttributeEvent(this, name, me));
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    public void setAttribute(String name, Object object) {
        if (object == null) {
            this.removeAttribute(name);
        } else {
            Object me = this.attributes.get(name);
            this.attributes.put(name, object);
            if (me != null) {
                for (int n = 0; n < this.contextAttributeListeners.length; ++n) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getLoader());
                    this.contextAttributeListeners[n].attributeReplaced(new ServletContextAttributeEvent(this, name, me));
                    Thread.currentThread().setContextClassLoader(cl);
                }
            } else {
                for (int n = 0; n < this.contextAttributeListeners.length; ++n) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getLoader());
                    this.contextAttributeListeners[n].attributeAdded(new ServletContextAttributeEvent(this, name, object));
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        }
    }

    public String getInitParameter(String name) {
        return (String)this.initParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public String getServerInfo() {
        return Launcher.RESOURCES.getString("ServerVersion");
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 5;
    }

    public ServletContext getContext(String uri) {
        return this.ownerHostConfig.getWebAppByURI(uri);
    }

    public String getServletContextName() {
        return this.displayName;
    }

    public String getMimeType(String fileName) {
        int dotPos = fileName.lastIndexOf(46);
        if (dotPos != -1 && dotPos != fileName.length() - 1) {
            String extension = fileName.substring(dotPos + 1).toLowerCase();
            String mimeType = (String)this.mimeTypes.get(extension);
            return mimeType;
        }
        return null;
    }

    public void log(String message) {
        Logger.logDirectMessage(Logger.INFO, this.contextName, message, null);
    }

    public void log(String message, Throwable throwable) {
        Logger.logDirectMessage(Logger.ERROR, this.contextName, message, throwable);
    }

    public javax.servlet.RequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcher rd;
        ServletConfiguration servlet = (ServletConfiguration)this.servletInstances.get(name);
        if (servlet != null && (rd = new RequestDispatcher(this, servlet)) != null) {
            rd.setForNamedDispatcher(this.filterPatternsForward, this.filterPatternsInclude);
            return rd;
        }
        return null;
    }

    public javax.servlet.RequestDispatcher getRequestDispatcher(String uriInsideWebapp) {
        RequestDispatcher rd;
        StringBuffer pathInfo;
        StringBuffer servletPath;
        ServletConfiguration servlet;
        if (uriInsideWebapp == null) {
            return null;
        }
        if (!uriInsideWebapp.startsWith("/")) {
            return null;
        }
        String queryString = "";
        int questionPos = uriInsideWebapp.indexOf(63);
        if (questionPos != -1) {
            if (questionPos != uriInsideWebapp.length() - 1) {
                queryString = uriInsideWebapp.substring(questionPos + 1);
            }
            uriInsideWebapp = uriInsideWebapp.substring(0, questionPos);
        }
        if ((servlet = this.urlMatch(uriInsideWebapp, servletPath = new StringBuffer(), pathInfo = new StringBuffer())) != null && (rd = new RequestDispatcher(this, servlet)) != null) {
            rd.setForURLDispatcher(servletPath.toString(), pathInfo.toString().equals("") ? null : pathInfo.toString(), queryString, uriInsideWebapp, this.filterPatternsForward, this.filterPatternsInclude);
            return rd;
        }
        return null;
    }

    public RequestDispatcher getInitialDispatcher(String uriInsideWebapp, WinstoneRequest request, WinstoneResponse response) throws IOException {
        StringBuffer pathInfo;
        StringBuffer servletPath;
        ServletConfiguration servlet;
        if (!uriInsideWebapp.equals("") && !uriInsideWebapp.startsWith("/")) {
            return this.getErrorDispatcherByCode(uriInsideWebapp, 400, Launcher.RESOURCES.getString("WebAppConfig.InvalidURI", uriInsideWebapp), null);
        }
        if (this.contextStartupError != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            this.contextStartupError.printStackTrace(pw);
            return this.getErrorDispatcherByCode(uriInsideWebapp, 500, Launcher.RESOURCES.getString("WebAppConfig.ErrorDuringStartup", sw.toString()), this.contextStartupError);
        }
        String queryString = "";
        int questionPos = uriInsideWebapp.indexOf(63);
        if (questionPos != -1) {
            if (questionPos != uriInsideWebapp.length() - 1) {
                queryString = uriInsideWebapp.substring(questionPos + 1);
            }
            uriInsideWebapp = uriInsideWebapp.substring(0, questionPos);
        }
        if ((servlet = this.urlMatch(uriInsideWebapp, servletPath = new StringBuffer(), pathInfo = new StringBuffer())) != null) {
            if (servlet.getServletName().equals(this.defaultServletName)) {
                File res;
                String directoryPath = servletPath.toString();
                if (directoryPath.endsWith("/")) {
                    directoryPath = directoryPath.substring(0, directoryPath.length() - 1);
                }
                if (directoryPath.startsWith("/")) {
                    directoryPath = directoryPath.substring(1);
                }
                if ((res = new File(this.webRoot, directoryPath)).exists() && res.isDirectory() && (request.getMethod().equals("GET") || request.getMethod().equals("HEAD"))) {
                    if (!servletPath.toString().endsWith("/")) {
                        Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WebAppConfig.FoundNonSlashDirectory", servletPath.toString());
                        response.sendRedirect(this.prefix + servletPath.toString() + pathInfo.toString() + "/" + (queryString.equals("") ? "" : "?" + queryString));
                        return null;
                    }
                    Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WebAppConfig.CheckWelcomeFile", servletPath.toString() + pathInfo.toString());
                    String welcomeFile = this.matchWelcomeFiles(servletPath.toString() + pathInfo.toString(), request, queryString);
                    if (welcomeFile != null) {
                        response.sendRedirect(this.prefix + welcomeFile);
                        return null;
                    }
                }
            }
            RequestDispatcher rd = new RequestDispatcher(this, servlet);
            rd.setForInitialDispatcher(servletPath.toString(), pathInfo.toString().equals("") ? null : pathInfo.toString(), queryString, uriInsideWebapp, this.filterPatternsRequest, this.authenticationHandler);
            return rd;
        }
        return this.getErrorDispatcherByCode(uriInsideWebapp, 404, Launcher.RESOURCES.getString("StaticResourceServlet.PathNotFound", uriInsideWebapp), null);
    }

    public RequestDispatcher getErrorDispatcherByClass(Throwable exception) {
        Class[] exceptionClasses = this.errorPagesByExceptionKeysSorted;
        Throwable errWrapper = new ServletException(exception);
        while (errWrapper instanceof ServletException && (errWrapper = ((ServletException)errWrapper).getRootCause()) != null) {
            for (int n = 0; n < exceptionClasses.length; ++n) {
                Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "WinstoneResponse.TestingException", new String[]{this.errorPagesByExceptionKeysSorted[n].getName(), errWrapper.getClass().getName()});
                if (exceptionClasses[n].isInstance(errWrapper)) {
                    String errorURI = (String)this.errorPagesByException.get(exceptionClasses[n]);
                    if (errorURI != null) {
                        RequestDispatcher rd = this.buildErrorDispatcher(errorURI, 500, null, errWrapper);
                        if (rd == null) continue;
                        return rd;
                    }
                    Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneResponse.SkippingException", new String[]{exceptionClasses[n].getName(), (String)this.errorPagesByException.get(exceptionClasses[n])});
                    continue;
                }
                Logger.log(Logger.WARNING, Launcher.RESOURCES, "WinstoneResponse.ExceptionNotMatched", exceptionClasses[n].getName());
            }
        }
        Throwable errPassDown = exception;
        while (errPassDown instanceof ServletException && ((ServletException)errPassDown).getRootCause() != null) {
            errPassDown = ((ServletException)errPassDown).getRootCause();
        }
        return this.getErrorDispatcherByCode(null, 500, null, errPassDown);
    }

    public RequestDispatcher getErrorDispatcherByCode(String requestURI, int statusCode, String summaryMessage, Throwable exception) {
        RequestDispatcher rd;
        RequestDispatcher rd2;
        String errorURI = (String)this.getErrorPagesByCode().get("" + statusCode);
        if (errorURI != null && (rd2 = this.buildErrorDispatcher(errorURI, statusCode, summaryMessage, exception)) != null) {
            return rd2;
        }
        ServletConfiguration errorServlet = (ServletConfiguration)this.servletInstances.get(this.errorServletName);
        if (errorServlet != null && (rd = new RequestDispatcher(this, errorServlet)) != null) {
            rd.setForErrorDispatcher(null, null, null, statusCode, summaryMessage, exception, requestURI, this.filterPatternsError);
            return rd;
        }
        Logger.log(Logger.ERROR, Launcher.RESOURCES, "WebAppConfig.NoErrorServlet", "" + statusCode, exception);
        return null;
    }

    private RequestDispatcher buildErrorDispatcher(String errorURI, int statusCode, String summaryMessage, Throwable exception) {
        RequestDispatcher rd;
        String queryString = "";
        int questionPos = errorURI.indexOf(63);
        if (questionPos != -1) {
            if (questionPos != errorURI.length() - 1) {
                queryString = errorURI.substring(questionPos + 1);
            }
            errorURI = errorURI.substring(0, questionPos);
        }
        ServletException errIterator = new ServletException(exception);
        while (summaryMessage == null && errIterator != null) {
            summaryMessage = errIterator.getMessage();
            if (errIterator.getRootCause() instanceof ServletException) {
                errIterator = (ServletException)errIterator.getRootCause();
                continue;
            }
            if (summaryMessage == null) {
                summaryMessage = errIterator.getRootCause().getMessage();
            }
            errIterator = null;
        }
        StringBuffer servletPath = new StringBuffer();
        StringBuffer pathInfo = new StringBuffer();
        ServletConfiguration servlet = this.urlMatch(errorURI, servletPath, pathInfo);
        if (servlet != null && (rd = new RequestDispatcher(this, servlet)) != null) {
            rd.setForErrorDispatcher(servletPath.toString(), pathInfo.toString().equals("") ? null : pathInfo.toString(), queryString, statusCode, summaryMessage, exception, errorURI, this.filterPatternsError);
            return rd;
        }
        return null;
    }

    private String matchWelcomeFiles(String path, WinstoneRequest request, String queryString) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String qs = queryString.equals("") ? "" : "?" + queryString;
        for (int n = 0; n < this.welcomeFiles.length; ++n) {
            String welcomeFile = this.welcomeFiles[n];
            while (welcomeFile.startsWith("/")) {
                welcomeFile = welcomeFile.substring(1);
            }
            welcomeFile = path + welcomeFile;
            String exact = (String)this.exactServletMatchMounts.get(welcomeFile);
            if (exact != null) {
                return welcomeFile + qs;
            }
            for (int j = 0; j < this.patternMatches.length; ++j) {
                Mapping urlPattern = this.patternMatches[j];
                if (urlPattern.getPatternType() != 2 || !urlPattern.match(welcomeFile, null, null)) continue;
                return welcomeFile + qs;
            }
            try {
                if (this.getResource(welcomeFile) == null) continue;
                return welcomeFile + qs;
            }
            catch (MalformedURLException err) {
                // empty catch block
            }
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        File res;
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new MalformedURLException(Launcher.RESOURCES.getString("WebAppConfig.BadResourcePath", path));
        }
        if (!path.equals("/") && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (res = new File(this.webRoot, URIUtil.canonicalPath(path))).exists() ? res.toURL() : null;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            URL res = this.getResource(path);
            return res == null ? null : res.openStream();
        }
        catch (IOException err) {
            throw new WinstoneException(Launcher.RESOURCES.getString("WebAppConfig.ErrorOpeningStream"), err);
        }
    }

    public String getRealPath(String path) {
        if (path == null) {
            return null;
        }
        try {
            File res = new File(this.webRoot, path);
            if (res.isDirectory()) {
                return res.getCanonicalPath() + "/";
            }
            return res.getCanonicalPath();
        }
        catch (IOException err) {
            return null;
        }
    }

    public Set getResourcePaths(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new WinstoneException(Launcher.RESOURCES.getString("WebAppConfig.BadResourcePath", path));
        }
        String workingPath = null;
        if (path.equals("/")) {
            workingPath = "";
        } else {
            boolean lastCharIsSlash = path.charAt(path.length() - 1) == '/';
            workingPath = path.substring(1, path.length() - (lastCharIsSlash ? 1 : 0));
        }
        File inPath = new File(this.webRoot, workingPath.equals("") ? "." : workingPath).getAbsoluteFile();
        if (!inPath.exists()) {
            return null;
        }
        if (!inPath.isDirectory()) {
            return null;
        }
        File[] children = inPath.listFiles();
        HashSet<String> out = new HashSet<String>();
        for (int n = 0; n < children.length; ++n) {
            String entry = "/" + (workingPath.length() != 0 ? workingPath + "/" : "") + children[n].getName() + (children[n].isDirectory() ? "/" : "");
            out.add(entry);
        }
        return out;
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServletNames() {
        return Collections.enumeration(new ArrayList());
    }

    public Enumeration getServlets() {
        return Collections.enumeration(new ArrayList());
    }

    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }
}

