/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import winstone.Launcher;
import winstone.Logger;
import winstone.WinstoneRequest;

public class StaticResourceServlet
extends HttpServlet {
    static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    static final String CACHED_RESOURCE_DATE_HEADER = "If-Modified-Since";
    static final String LAST_MODIFIED_DATE_HEADER = "Last-Modified";
    static final String RANGE_HEADER = "Range";
    static final String ACCEPT_RANGES_HEADER = "Accept-Ranges";
    static final String CONTENT_RANGE_HEADER = "Content-Range";
    static final String RESOURCE_FILE = "winstone.LocalStrings";
    private DateFormat sdfFileDate = new SimpleDateFormat("dd-MM-yyyy HH:mm");
    private File webRoot;
    private String prefix;
    private boolean directoryList;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.webRoot = new File(config.getInitParameter("webRoot"));
        this.prefix = config.getInitParameter("prefix");
        String dirList = config.getInitParameter("directoryList");
        this.directoryList = dirList == null || dirList.equalsIgnoreCase("true") || dirList.equalsIgnoreCase("yes");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File res;
        boolean isInclude = request.getAttribute(INCLUDE_SERVLET_PATH) != null;
        boolean isForward = request.getAttribute(FORWARD_SERVLET_PATH) != null;
        String path = null;
        path = isInclude ? (String)request.getAttribute(INCLUDE_SERVLET_PATH) : request.getServletPath();
        path = WinstoneRequest.decodeURLToken(path);
        long cachedResDate = request.getDateHeader(CACHED_RESOURCE_DATE_HEADER);
        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "StaticResourceServlet.PathRequested", new String[]{this.getServletConfig().getServletName(), path});
        File file = res = path.equals("") ? this.webRoot : new File(this.webRoot, path);
        if (!res.exists()) {
            response.sendError(404, Launcher.RESOURCES.getString("StaticResourceServlet.PathNotFound", path));
        } else if (!StaticResourceServlet.isDescendant(this.webRoot, res, this.webRoot)) {
            Logger.log(Logger.FULL_DEBUG, Launcher.RESOURCES, "StaticResourceServlet.OutsideWebroot", new String[]{res.getCanonicalPath(), this.webRoot.toString()});
            response.sendError(403, Launcher.RESOURCES.getString("StaticResourceServlet.PathInvalid", path));
        } else if (!isInclude && !isForward && StaticResourceServlet.isDescendant(new File(this.webRoot, "WEB-INF"), res, this.webRoot)) {
            response.sendError(404, Launcher.RESOURCES.getString("StaticResourceServlet.PathInvalid", path));
        } else if (!isInclude && !isForward && StaticResourceServlet.isDescendant(new File(this.webRoot, "META-INF"), res, this.webRoot)) {
            response.sendError(404, Launcher.RESOURCES.getString("StaticResourceServlet.PathInvalid", path));
        } else if (res.isDirectory()) {
            if (path.endsWith("/")) {
                if (this.directoryList) {
                    this.generateDirectoryList(request, response, path);
                } else {
                    response.sendError(403, Launcher.RESOURCES.getString("StaticResourceServlet.AccessDenied"));
                }
            } else {
                response.sendRedirect(this.prefix + path + "/");
            }
        } else if (!isInclude && cachedResDate != -1L && cachedResDate < System.currentTimeMillis() / 1000L * 1000L && cachedResDate >= res.lastModified() / 1000L * 1000L) {
            String mimeType = this.getServletContext().getMimeType(res.getName().toLowerCase());
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            response.setStatus(304);
            response.setContentLength(0);
            response.flushBuffer();
        } else if (request.getHeader(RANGE_HEADER) == null || isInclude) {
            String mimeType = this.getServletContext().getMimeType(res.getName().toLowerCase());
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            FileInputStream resStream = new FileInputStream(res);
            response.setStatus(200);
            response.setContentLength((int)res.length());
            response.addDateHeader(LAST_MODIFIED_DATE_HEADER, res.lastModified());
            ServletOutputStream out = null;
            PrintWriter outWriter = null;
            try {
                out = response.getOutputStream();
            }
            catch (IllegalStateException err) {
                outWriter = response.getWriter();
            }
            catch (IllegalArgumentException err) {
                outWriter = response.getWriter();
            }
            byte[] buffer = new byte[4096];
            int read = ((InputStream)resStream).read(buffer);
            while (read > 0) {
                if (out != null) {
                    out.write(buffer, 0, read);
                } else {
                    ((Writer)outWriter).write(new String(buffer, 0, read, response.getCharacterEncoding()));
                }
                read = ((InputStream)resStream).read(buffer);
            }
            ((InputStream)resStream).close();
        } else if (request.getHeader(RANGE_HEADER).startsWith("bytes=")) {
            String mimeType = this.getServletContext().getMimeType(res.getName().toLowerCase());
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            FileInputStream resStream = new FileInputStream(res);
            ArrayList<String> ranges = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(request.getHeader(RANGE_HEADER).substring(6).trim(), ",", false);
            int totalSent = 0;
            String rangeText = "";
            while (st.hasMoreTokens()) {
                String rangeBlock = st.nextToken();
                int start = 0;
                int end = (int)res.length();
                int delim = rangeBlock.indexOf(45);
                if (delim != 0) {
                    start = Integer.parseInt(rangeBlock.substring(0, delim).trim());
                }
                if (delim != rangeBlock.length() - 1) {
                    end = Integer.parseInt(rangeBlock.substring(delim + 1).trim());
                }
                totalSent += end - start;
                rangeText = rangeText + "," + start + "-" + end;
                ranges.add(start + "-" + end);
            }
            response.setStatus(206);
            response.addHeader(CONTENT_RANGE_HEADER, "bytes " + rangeText.substring(1) + "/" + res.length());
            response.setContentLength(totalSent);
            response.addHeader(ACCEPT_RANGES_HEADER, "bytes");
            response.addDateHeader(LAST_MODIFIED_DATE_HEADER, res.lastModified());
            ServletOutputStream out = response.getOutputStream();
            int bytesRead = 0;
            for (String rangeBlock : ranges) {
                int delim = rangeBlock.indexOf(45);
                int start = Integer.parseInt(rangeBlock.substring(0, delim));
                int end = Integer.parseInt(rangeBlock.substring(delim + 1));
                int read = 0;
                while (read != -1 && (long)bytesRead <= res.length()) {
                    read = ((InputStream)resStream).read();
                    if (bytesRead >= start && bytesRead < end) {
                        out.write(read);
                    }
                    ++bytesRead;
                }
            }
            ((InputStream)resStream).close();
        } else {
            response.sendError(416);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDirectoryList(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        File dir = path.equals("") ? this.webRoot : new File(this.webRoot, path);
        Object[] children = dir.listFiles();
        Arrays.sort(children);
        StringWriter rowString = new StringWriter();
        String oddColour = Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.OddColour");
        String evenColour = Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.EvenColour");
        String rowTextColour = Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.RowTextColour");
        String directoryLabel = Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.DirectoryLabel");
        String parentDirLabel = Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.ParentDirectoryLabel");
        String noDateLabel = Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.NoDateLabel");
        int rowCount = 0;
        if (!path.equals("") && !path.equals("/")) {
            rowString.write(Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.Row", new String[]{rowTextColour, evenColour, parentDirLabel, "..", noDateLabel, directoryLabel}));
            ++rowCount;
        }
        for (int n = 0; n < children.length; ++n) {
            if (((File)children[n]).getName().equalsIgnoreCase("web-inf") || ((File)children[n]).getName().equalsIgnoreCase("meta-inf")) continue;
            Object file = children[n];
            String date = noDateLabel;
            String size = directoryLabel;
            if (!((File)file).isDirectory()) {
                size = "" + ((File)file).length();
                DateFormat dateFormat = this.sdfFileDate;
                synchronized (dateFormat) {
                    date = this.sdfFileDate.format(new Date(((File)file).lastModified()));
                }
            }
            rowString.write(Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.Row", new String[]{rowTextColour, rowCount % 2 == 0 ? evenColour : oddColour, ((File)file).getName() + (((File)file).isDirectory() ? "/" : ""), "./" + ((File)file).getName() + (((File)file).isDirectory() ? "/" : ""), date, size}));
            ++rowCount;
        }
        String out = Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.Body", new String[]{Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.HeaderColour"), Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.HeaderTextColour"), Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.LabelColour"), Launcher.RESOURCES.getString("StaticResourceServlet.DirectoryList.LabelTextColour"), new Date() + "", Launcher.RESOURCES.getString("ServerVersion"), path.equals("") ? "/" : path, rowString.toString()});
        response.setContentLength(out.getBytes().length);
        response.setContentType("text/html");
        PrintWriter w = response.getWriter();
        ((Writer)w).write(out);
        ((Writer)w).close();
    }

    public static boolean isDescendant(File parent, File child, File commonBase) throws IOException {
        if (child.equals(parent)) {
            return true;
        }
        String canonicalParent = parent.getAbsoluteFile().getCanonicalPath();
        String canonicalChild = child.getAbsoluteFile().getCanonicalPath();
        if (canonicalChild.startsWith(canonicalParent)) {
            return true;
        }
        String childOCValue = StaticResourceServlet.constructOurCanonicalVersion(child, commonBase);
        String parentOCValue = StaticResourceServlet.constructOurCanonicalVersion(parent, commonBase);
        return childOCValue.startsWith(parentOCValue);
    }

    public static String constructOurCanonicalVersion(File current, File stopPoint) {
        int backOnes = 0;
        StringBuffer ourCanonicalVersion = new StringBuffer();
        while (current != null && !current.equals(stopPoint)) {
            if (current.getName().equals("..")) {
                ++backOnes;
            } else if (!current.getName().equals(".")) {
                if (backOnes > 0) {
                    --backOnes;
                } else {
                    ourCanonicalVersion.insert(0, "/" + current.getName());
                }
            }
            current = current.getParentFile();
        }
        return ourCanonicalVersion.toString();
    }
}

