/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import winstone.Cluster;
import winstone.HostConfiguration;
import winstone.Launcher;
import winstone.Logger;
import winstone.ObjectPool;
import winstone.WinstoneException;

public class HostGroup {
    private static final String DEFAULT_HOSTNAME = "default";
    private Map hostConfigs = new Hashtable();
    private String defaultHostName;

    public HostGroup(Cluster cluster, ObjectPool objectPool, ClassLoader commonLibCL, File[] commonLibCLPaths, Map args) throws IOException {
        String hostDirName = (String)args.get("hostsDir");
        String webappsDirName = (String)args.get("webappsDir");
        if (hostDirName == null) {
            this.initHost(webappsDirName, DEFAULT_HOSTNAME, cluster, objectPool, commonLibCL, commonLibCLPaths, args);
            this.defaultHostName = DEFAULT_HOSTNAME;
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostGroup.InitSingleComplete", new String[]{this.hostConfigs.size() + "", this.hostConfigs.keySet() + ""});
        } else {
            this.initMultiHostDir(hostDirName, cluster, objectPool, commonLibCL, commonLibCLPaths, args);
            Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostGroup.InitMultiComplete", new String[]{this.hostConfigs.size() + "", this.hostConfigs.keySet() + ""});
        }
    }

    public HostConfiguration getHostByName(String hostname) {
        HostConfiguration host;
        if (hostname != null && this.hostConfigs.size() > 1 && (host = (HostConfiguration)this.hostConfigs.get(hostname)) != null) {
            return host;
        }
        return (HostConfiguration)this.hostConfigs.get(this.defaultHostName);
    }

    public void destroy() {
        HashSet hostnames = new HashSet(this.hostConfigs.keySet());
        for (String hostname : hostnames) {
            HostConfiguration host = (HostConfiguration)this.hostConfigs.get(hostname);
            host.destroy();
            this.hostConfigs.remove(hostname);
        }
        this.hostConfigs.clear();
    }

    protected void initHost(String webappsDirName, String hostname, Cluster cluster, ObjectPool objectPool, ClassLoader commonLibCL, File[] commonLibCLPaths, Map args) throws IOException {
        Logger.log(Logger.DEBUG, Launcher.RESOURCES, "HostGroup.DeployingHost", hostname);
        HostConfiguration config = new HostConfiguration(hostname, cluster, objectPool, commonLibCL, commonLibCLPaths, args, webappsDirName);
        this.hostConfigs.put(hostname, config);
    }

    protected void initMultiHostDir(String hostsDirName, Cluster cluster, ObjectPool objectPool, ClassLoader commonLibCL, File[] commonLibCLPaths, Map args) throws IOException {
        File hostsDir;
        if (hostsDirName == null) {
            hostsDirName = "hosts";
        }
        if (!(hostsDir = new File(hostsDirName)).exists()) {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostGroup.HostsDirNotFound", hostsDirName));
        }
        if (!hostsDir.isDirectory()) {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostGroup.HostsDirIsNotDirectory", hostsDirName));
        }
        File[] children = hostsDir.listFiles();
        if (children == null || children.length == 0) {
            throw new WinstoneException(Launcher.RESOURCES.getString("HostGroup.HostsDirIsEmpty", hostsDirName));
        }
        for (int n = 0; n < children.length; ++n) {
            String childName = children[n].getName();
            if (children[n].isDirectory() && !this.hostConfigs.containsKey(childName)) {
                this.initHost(children[n].getCanonicalPath(), childName, cluster, objectPool, commonLibCL, commonLibCLPaths, args);
            }
            if (this.defaultHostName != null && !childName.equals(DEFAULT_HOSTNAME)) continue;
            this.defaultHostName = childName;
        }
    }
}

