/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeoutService {
    private ScheduledFuture<?> scheduledFuture;
    private final String hostname;
    private final ThreadFactory threadFactory = new ThreadFactory(){
        private AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            int threadNumber = this.count.incrementAndGet();
            String threadName = "Trilead_TimeoutService_" + TimeoutService.this.hostname + "-" + threadNumber;
            Thread thread = new Thread(r, threadName);
            thread.setDaemon(true);
            return thread;
        }
    };
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(this.threadFactory);

    public TimeoutService(String hostname) {
        this.hostname = hostname;
    }

    public TimeoutToken addTimeoutHandler(long runTime, Runnable handler) {
        TimeoutToken token = new TimeoutToken();
        token.handler = handler;
        long delay = runTime - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        this.scheduledFuture = this.scheduler.schedule(token, delay, TimeUnit.MILLISECONDS);
        return token;
    }

    public void cancelTimeoutHandler(TimeoutToken token) {
        token.cancelled = true;
        this.scheduledFuture.cancel(true);
        this.scheduler.shutdownNow();
    }

    public class TimeoutToken
    implements Runnable {
        private Runnable handler;
        private volatile boolean cancelled = false;

        @Override
        public void run() {
            if (!this.cancelled) {
                this.handler.run();
            }
        }
    }
}

