/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto;

import com.trilead.ssh2.crypto.CertificateDecoder;
import com.trilead.ssh2.crypto.PEMStructure;
import com.trilead.ssh2.crypto.SimpleDERReader;
import com.trilead.ssh2.signature.DSAPrivateKey;
import com.trilead.ssh2.signature.KeyAlgorithm;
import com.trilead.ssh2.signature.KeyAlgorithmManager;
import com.trilead.ssh2.signature.RSAPrivateKey;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PEMDecoder {
    private static final Logger LOGGER = Logger.getLogger(PEMDecoder.class.getName());
    private static final int PEM_RSA_PRIVATE_KEY = 1;
    private static final int PEM_DSA_PRIVATE_KEY = 2;

    private static int hexToInt(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException("Need hex char");
    }

    public static byte[] hexToByteArray(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Uneven string length in hex encoding.");
        }
        byte[] decoded = new byte[hex.length() / 2];
        for (int i = 0; i < decoded.length; ++i) {
            int hi = PEMDecoder.hexToInt(hex.charAt(i * 2));
            int lo = PEMDecoder.hexToInt(hex.charAt(i * 2 + 1));
            decoded[i] = (byte)(hi * 16 + lo);
        }
        return decoded;
    }

    public static PEMStructure parsePEM(char[] pem) throws IOException {
        String endLine;
        BufferedReader br;
        PEMStructure ps;
        block3: {
            String line;
            ps = new PEMStructure();
            br = new BufferedReader(new CharArrayReader(pem));
            do {
                if ((line = br.readLine()) == null) {
                    throw new IOException("Invalid PEM structure, '-----BEGIN...' missing");
                }
                if (!(line = line.trim()).startsWith("-----BEGIN DSA PRIVATE KEY-----")) continue;
                endLine = "-----END DSA PRIVATE KEY-----";
                ps.pemType = 2;
                break block3;
            } while (!line.startsWith("-----BEGIN RSA PRIVATE KEY-----"));
            endLine = "-----END RSA PRIVATE KEY-----";
            ps.pemType = 1;
        }
        PEMDecoder.parsePEMContent(ps, br, endLine);
        if (ps.data.length == 0) {
            throw new IOException("Invalid PEM structure, no data available");
        }
        return ps;
    }

    private static PEMStructure parsePEM(char[] pem, CertificateDecoder certificateDecoder) throws IOException {
        String line;
        PEMStructure ps = new PEMStructure();
        BufferedReader br = new BufferedReader(new CharArrayReader(pem));
        do {
            if ((line = br.readLine()) != null) continue;
            throw new IOException("Invalid PEM structure, '-----BEGIN...' missing");
        } while (!(line = line.trim()).startsWith(certificateDecoder.getStartLine()));
        String endLine = certificateDecoder.getEndLine();
        PEMDecoder.parsePEMContent(ps, br, endLine);
        if (ps.data.length == 0) {
            throw new IOException("Invalid PEM structure, no data available");
        }
        return ps;
    }

    private static void parsePEMContent(PEMStructure ps, BufferedReader br, String endLine) throws IOException {
        String line;
        while (true) {
            if ((line = br.readLine()) == null) {
                throw new IOException("Invalid PEM structure, " + endLine + " missing");
            }
            int sem_idx = (line = line.trim()).indexOf(58);
            if (sem_idx == -1) break;
            String name = line.substring(0, sem_idx + 1);
            String value = line.substring(sem_idx + 1);
            String[] values = value.split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
            if ("Proc-Type:".equals(name)) {
                ps.procType = values;
                continue;
            }
            if (!"DEK-Info:".equals(name)) continue;
            ps.dekInfo = values;
        }
        StringBuilder keyData = new StringBuilder();
        while (true) {
            if (line == null) {
                throw new IOException("Invalid PEM structure, " + endLine + " missing");
            }
            if ((line = line.trim()).startsWith(endLine)) break;
            keyData.append(line);
            line = br.readLine();
        }
        ps.data = Base64.getDecoder().decode(keyData.toString().replaceAll("\\s", ""));
    }

    public static void decryptPEM(PEMStructure ps, String password) throws IOException {
        String transformation;
        if (ps.dekInfo == null) {
            throw new IOException("Broken PEM, no mode and salt given, but encryption enabled");
        }
        if (ps.dekInfo.length != 2) {
            throw new IOException("Broken PEM, DEK-Info is incomplete!");
        }
        byte[] pw = password.getBytes(StandardCharsets.UTF_8);
        String encryptionAlgorithm = ps.dekInfo[0];
        byte[] iv = PEMDecoder.hexToByteArray(ps.dekInfo[1]);
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        digest.update(pw);
        digest.update(iv, 0, 8);
        byte[] round1Digest = digest.digest();
        digest.update(round1Digest);
        digest.update(pw);
        digest.update(iv, 0, 8);
        byte[] round2Digest = digest.digest();
        SecretKeySpec secretKey = switch (encryptionAlgorithm) {
            case "DES-EDE3-CBC" -> {
                transformation = "DESede/CBC/PKCS5Padding";
                byte[] key = new byte[24];
                System.arraycopy(round1Digest, 0, key, 0, 16);
                System.arraycopy(round2Digest, 0, key, 16, 8);
                yield new SecretKeySpec(key, "DESede");
            }
            case "DES-CBC" -> {
                transformation = "DES/CBC/PKCS5Padding";
                byte[] key = new byte[8];
                System.arraycopy(round1Digest, 0, key, 0, 8);
                yield new SecretKeySpec(key, "DES");
            }
            case "AES-128-CBC" -> {
                transformation = "AES/CBC/PKCS5Padding";
                byte[] key = new byte[16];
                System.arraycopy(round1Digest, 0, key, 0, 16);
                yield new SecretKeySpec(key, "AES");
            }
            case "AES-192-CBC" -> {
                transformation = "AES/CBC/PKCS5Padding";
                byte[] key = new byte[24];
                System.arraycopy(round1Digest, 0, key, 0, 16);
                System.arraycopy(round2Digest, 0, key, 16, 8);
                yield new SecretKeySpec(key, "AES");
            }
            case "AES-256-CBC" -> {
                transformation = "AES/CBC/PKCS5Padding";
                byte[] key = new byte[32];
                System.arraycopy(round1Digest, 0, key, 0, 16);
                System.arraycopy(round2Digest, 0, key, 16, 16);
                yield new SecretKeySpec(key, "AES");
            }
            default -> throw new IOException("Cannot decrypt PEM structure, unknown cipher " + encryptionAlgorithm);
        };
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            ps.data = cipher.doFinal(ps.data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            new IOException(e);
        }
        ps.dekInfo = null;
        ps.procType = null;
    }

    public static boolean isPEMEncrypted(PEMStructure ps) throws IOException {
        if (ps.procType == null) {
            return false;
        }
        if (ps.procType.length != 2) {
            throw new IOException("Unknown Proc-Type field.");
        }
        if (!"4".equals(ps.procType[0])) {
            throw new IOException("Unknown Proc-Type field (" + ps.procType[0] + ")");
        }
        return "ENCRYPTED".equals(ps.procType[1]);
    }

    @Deprecated
    public static Object decode(char[] pem, String password) throws IOException {
        LOGGER.warning("com.trilead.ssh2.cryptoPEMDecoder.decode method is deprecated, use com.trilead.ssh2.cryptoPEMDecoder.decodeKeyPair instead.");
        PEMStructure ps = PEMDecoder.parsePEM(pem);
        if (PEMDecoder.isPEMEncrypted(ps)) {
            if (password == null) {
                throw new IOException("PEM is encrypted, but no password was specified");
            }
            PEMDecoder.decryptPEM(ps, password);
        }
        if (ps.pemType == 2) {
            SimpleDERReader dr = new SimpleDERReader(ps.data);
            byte[] seq = dr.readSequenceAsByteArray();
            if (dr.available() != 0) {
                throw new IOException("Padding in DSA PRIVATE KEY DER stream.");
            }
            dr.resetInput(seq);
            BigInteger version = dr.readInt();
            if (version.compareTo(BigInteger.ZERO) != 0) {
                throw new IOException("Wrong version (" + String.valueOf(version) + ") in DSA PRIVATE KEY DER stream.");
            }
            BigInteger p = dr.readInt();
            BigInteger q = dr.readInt();
            BigInteger g = dr.readInt();
            BigInteger y = dr.readInt();
            BigInteger x = dr.readInt();
            if (dr.available() != 0) {
                throw new IOException("Padding in DSA PRIVATE KEY DER stream.");
            }
            return new DSAPrivateKey(p, q, g, y, x);
        }
        if (ps.pemType == 1) {
            SimpleDERReader dr = new SimpleDERReader(ps.data);
            byte[] seq = dr.readSequenceAsByteArray();
            if (dr.available() != 0) {
                throw new IOException("Padding in RSA PRIVATE KEY DER stream.");
            }
            dr.resetInput(seq);
            BigInteger version = dr.readInt();
            if (version.compareTo(BigInteger.ZERO) != 0 && version.compareTo(BigInteger.ONE) != 0) {
                throw new IOException("Wrong version (" + String.valueOf(version) + ") in RSA PRIVATE KEY DER stream.");
            }
            BigInteger n = dr.readInt();
            BigInteger e = dr.readInt();
            BigInteger d = dr.readInt();
            return new RSAPrivateKey(d, e, n);
        }
        throw new IOException("PEM problem: it is of unknown type");
    }

    public static KeyPair decodeKeyPair(char[] pem, String password) throws IOException {
        for (KeyAlgorithm<PublicKey, PrivateKey> algorithm : KeyAlgorithmManager.getSupportedAlgorithms()) {
            for (CertificateDecoder decoder : algorithm.getCertificateDecoders()) {
                try {
                    PEMStructure ps = PEMDecoder.parsePEM(pem, decoder);
                    if (PEMDecoder.isPEMEncrypted(ps)) {
                        if (password == null) {
                            throw new IOException("PEM is encrypted, but no password was specified");
                        }
                        PEMDecoder.decryptPEM(ps, password);
                    }
                    return decoder.createKeyPair(ps, password);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "Could not decode PEM Key using current decoder: " + decoder.getClass().getName(), ex);
                }
            }
        }
        throw new IOException("PEM problem: it is of unknown type. Supported algorithms are :" + KeyAlgorithmManager.getSupportedAlgorithms().stream().map(c -> c.getKeyFormat()).collect(Collectors.toList()).toString());
    }
}

